<?php

namespace RecruitCrm\LogicMelon\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAPIAdvertValue ArrayType
 * @subpackage Arrays
 */
class ArrayOfAPIAdvertValue extends AbstractStructArrayBase
{
    /**
     * The APIAdvertValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \RecruitCrm\LogicMelon\StructType\APIAdvertValue[]
     */
    public $APIAdvertValue;
    /**
     * Constructor method for ArrayOfAPIAdvertValue
     * @uses ArrayOfAPIAdvertValue::setAPIAdvertValue()
     * @param \RecruitCrm\LogicMelon\StructType\APIAdvertValue[] $aPIAdvertValue
     */
    public function __construct(array $aPIAdvertValue = array())
    {
        $this
            ->setAPIAdvertValue($aPIAdvertValue);
    }
    /**
     * Get APIAdvertValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertValue[]|null
     */
    public function getAPIAdvertValue()
    {
        return isset($this->APIAdvertValue) ? $this->APIAdvertValue : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAPIAdvertValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAPIAdvertValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAPIAdvertValueForArrayConstraintsFromSetAPIAdvertValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAPIAdvertValueAPIAdvertValueItem) {
            // validation for constraint: itemType
            if (!$arrayOfAPIAdvertValueAPIAdvertValueItem instanceof \RecruitCrm\LogicMelon\StructType\APIAdvertValue) {
                $invalidValues[] = is_object($arrayOfAPIAdvertValueAPIAdvertValueItem) ? get_class($arrayOfAPIAdvertValueAPIAdvertValueItem) : sprintf('%s(%s)', gettype($arrayOfAPIAdvertValueAPIAdvertValueItem), var_export($arrayOfAPIAdvertValueAPIAdvertValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The APIAdvertValue property can only contain items of type \RecruitCrm\LogicMelon\StructType\APIAdvertValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set APIAdvertValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \RecruitCrm\LogicMelon\StructType\APIAdvertValue[] $aPIAdvertValue
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvertValue
     */
    public function setAPIAdvertValue(array $aPIAdvertValue = array())
    {
        // validation for constraint: array
        if ('' !== ($aPIAdvertValueArrayErrorMessage = self::validateAPIAdvertValueForArrayConstraintsFromSetAPIAdvertValue($aPIAdvertValue))) {
            throw new \InvalidArgumentException($aPIAdvertValueArrayErrorMessage, __LINE__);
        }
        if (is_null($aPIAdvertValue) || (is_array($aPIAdvertValue) && empty($aPIAdvertValue))) {
            unset($this->APIAdvertValue);
        } else {
            $this->APIAdvertValue = $aPIAdvertValue;
        }
        return $this;
    }
    /**
     * Add item to APIAdvertValue value
     * @throws \InvalidArgumentException
     * @param \RecruitCrm\LogicMelon\StructType\APIAdvertValue $item
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvertValue
     */
    public function addToAPIAdvertValue(\RecruitCrm\LogicMelon\StructType\APIAdvertValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RecruitCrm\LogicMelon\StructType\APIAdvertValue) {
            throw new \InvalidArgumentException(sprintf('The APIAdvertValue property can only contain items of type \RecruitCrm\LogicMelon\StructType\APIAdvertValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->APIAdvertValue[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertValue|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertValue|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertValue|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertValue|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertValue|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string APIAdvertValue
     */
    public function getAttributeName()
    {
        return 'APIAdvertValue';
    }
}
