<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APIPosting StructType
 * @subpackage Structs
 */
class APIPosting extends Mpats_PostJob_TrackResult
{
    /**
     * The sPostDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sPostDate;
    /**
     * The sEstimatedExpireDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sEstimatedExpireDate;
    /**
     * The sCorrectDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sCorrectDate;
    /**
     * Constructor method for APIPosting
     * @uses APIPosting::setSPostDate()
     * @uses APIPosting::setSEstimatedExpireDate()
     * @uses APIPosting::setSCorrectDate()
     * @param string $sPostDate
     * @param string $sEstimatedExpireDate
     * @param string $sCorrectDate
     */
    public function __construct($sPostDate = null, $sEstimatedExpireDate = null, $sCorrectDate = null)
    {
        $this
            ->setSPostDate($sPostDate)
            ->setSEstimatedExpireDate($sEstimatedExpireDate)
            ->setSCorrectDate($sCorrectDate);
    }
    /**
     * Get sPostDate value
     * @return string|null
     */
    public function getSPostDate()
    {
        return $this->sPostDate;
    }
    /**
     * Set sPostDate value
     * @param string $sPostDate
     * @return \RecruitCrm\LogicMelon\StructType\APIPosting
     */
    public function setSPostDate($sPostDate = null)
    {
        // validation for constraint: string
        if (!is_null($sPostDate) && !is_string($sPostDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sPostDate, true), gettype($sPostDate)), __LINE__);
        }
        $this->sPostDate = $sPostDate;
        return $this;
    }
    /**
     * Get sEstimatedExpireDate value
     * @return string|null
     */
    public function getSEstimatedExpireDate()
    {
        return $this->sEstimatedExpireDate;
    }
    /**
     * Set sEstimatedExpireDate value
     * @param string $sEstimatedExpireDate
     * @return \RecruitCrm\LogicMelon\StructType\APIPosting
     */
    public function setSEstimatedExpireDate($sEstimatedExpireDate = null)
    {
        // validation for constraint: string
        if (!is_null($sEstimatedExpireDate) && !is_string($sEstimatedExpireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sEstimatedExpireDate, true), gettype($sEstimatedExpireDate)), __LINE__);
        }
        $this->sEstimatedExpireDate = $sEstimatedExpireDate;
        return $this;
    }
    /**
     * Get sCorrectDate value
     * @return string|null
     */
    public function getSCorrectDate()
    {
        return $this->sCorrectDate;
    }
    /**
     * Set sCorrectDate value
     * @param string $sCorrectDate
     * @return \RecruitCrm\LogicMelon\StructType\APIPosting
     */
    public function setSCorrectDate($sCorrectDate = null)
    {
        // validation for constraint: string
        if (!is_null($sCorrectDate) && !is_string($sCorrectDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sCorrectDate, true), gettype($sCorrectDate)), __LINE__);
        }
        $this->sCorrectDate = $sCorrectDate;
        return $this;
    }
}
