<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CandidateTagResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CandidateTagResult
 * @subpackage Structs
 */
class CandidateTagResult extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The CandidateID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CandidateID;
    /**
     * The CandidateEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CandidateEmail;
    /**
     * The CandidateFirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CandidateFirstName;
    /**
     * The CandidateLastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CandidateLastName;
    /**
     * The Tag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tag;
    /**
     * The OrganisationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt
     */
    public $OrganisationID;
    /**
     * Constructor method for CandidateTagResult
     * @uses CandidateTagResult::setSuccess()
     * @uses CandidateTagResult::setCandidateID()
     * @uses CandidateTagResult::setCandidateEmail()
     * @uses CandidateTagResult::setCandidateFirstName()
     * @uses CandidateTagResult::setCandidateLastName()
     * @uses CandidateTagResult::setTag()
     * @uses CandidateTagResult::setOrganisationID()
     * @param bool $success
     * @param int $candidateID
     * @param string $candidateEmail
     * @param string $candidateFirstName
     * @param string $candidateLastName
     * @param string $tag
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt $organisationID
     */
    public function __construct($success = null, $candidateID = null, $candidateEmail = null, $candidateFirstName = null, $candidateLastName = null, $tag = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt $organisationID = null)
    {
        $this
            ->setSuccess($success)
            ->setCandidateID($candidateID)
            ->setCandidateEmail($candidateEmail)
            ->setCandidateFirstName($candidateFirstName)
            ->setCandidateLastName($candidateLastName)
            ->setTag($tag)
            ->setOrganisationID($organisationID);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \RecruitCrm\LogicMelon\StructType\CandidateTagResult
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get CandidateID value
     * @return int
     */
    public function getCandidateID()
    {
        return $this->CandidateID;
    }
    /**
     * Set CandidateID value
     * @param int $candidateID
     * @return \RecruitCrm\LogicMelon\StructType\CandidateTagResult
     */
    public function setCandidateID($candidateID = null)
    {
        // validation for constraint: int
        if (!is_null($candidateID) && !(is_int($candidateID) || ctype_digit($candidateID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($candidateID, true), gettype($candidateID)), __LINE__);
        }
        $this->CandidateID = $candidateID;
        return $this;
    }
    /**
     * Get CandidateEmail value
     * @return string|null
     */
    public function getCandidateEmail()
    {
        return $this->CandidateEmail;
    }
    /**
     * Set CandidateEmail value
     * @param string $candidateEmail
     * @return \RecruitCrm\LogicMelon\StructType\CandidateTagResult
     */
    public function setCandidateEmail($candidateEmail = null)
    {
        // validation for constraint: string
        if (!is_null($candidateEmail) && !is_string($candidateEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($candidateEmail, true), gettype($candidateEmail)), __LINE__);
        }
        $this->CandidateEmail = $candidateEmail;
        return $this;
    }
    /**
     * Get CandidateFirstName value
     * @return string|null
     */
    public function getCandidateFirstName()
    {
        return $this->CandidateFirstName;
    }
    /**
     * Set CandidateFirstName value
     * @param string $candidateFirstName
     * @return \RecruitCrm\LogicMelon\StructType\CandidateTagResult
     */
    public function setCandidateFirstName($candidateFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($candidateFirstName) && !is_string($candidateFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($candidateFirstName, true), gettype($candidateFirstName)), __LINE__);
        }
        $this->CandidateFirstName = $candidateFirstName;
        return $this;
    }
    /**
     * Get CandidateLastName value
     * @return string|null
     */
    public function getCandidateLastName()
    {
        return $this->CandidateLastName;
    }
    /**
     * Set CandidateLastName value
     * @param string $candidateLastName
     * @return \RecruitCrm\LogicMelon\StructType\CandidateTagResult
     */
    public function setCandidateLastName($candidateLastName = null)
    {
        // validation for constraint: string
        if (!is_null($candidateLastName) && !is_string($candidateLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($candidateLastName, true), gettype($candidateLastName)), __LINE__);
        }
        $this->CandidateLastName = $candidateLastName;
        return $this;
    }
    /**
     * Get Tag value
     * @return string|null
     */
    public function getTag()
    {
        return $this->Tag;
    }
    /**
     * Set Tag value
     * @param string $tag
     * @return \RecruitCrm\LogicMelon\StructType\CandidateTagResult
     */
    public function setTag($tag = null)
    {
        // validation for constraint: string
        if (!is_null($tag) && !is_string($tag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tag, true), gettype($tag)), __LINE__);
        }
        $this->Tag = $tag;
        return $this;
    }
    /**
     * Get OrganisationID value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt|null
     */
    public function getOrganisationID()
    {
        return $this->OrganisationID;
    }
    /**
     * Set OrganisationID value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfInt $organisationID
     * @return \RecruitCrm\LogicMelon\StructType\CandidateTagResult
     */
    public function setOrganisationID(\RecruitCrm\LogicMelon\ArrayType\ArrayOfInt $organisationID = null)
    {
        $this->OrganisationID = $organisationID;
        return $this;
    }
}
