<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CandidateTagPeoplEd StructType
 * @subpackage Structs
 */
class CandidateTagPeoplEd extends AbstractStructBase
{
    /**
     * The PeoplEdTag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PeoplEdTag;
    /**
     * The sAPIKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAPIKey;
    /**
     * The sCandidateEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sCandidateEmail;
    /**
     * The sCandidateFirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sCandidateFirstName;
    /**
     * The sCandidateLastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sCandidateLastName;
    /**
     * Constructor method for CandidateTagPeoplEd
     * @uses CandidateTagPeoplEd::setPeoplEdTag()
     * @uses CandidateTagPeoplEd::setSAPIKey()
     * @uses CandidateTagPeoplEd::setSCandidateEmail()
     * @uses CandidateTagPeoplEd::setSCandidateFirstName()
     * @uses CandidateTagPeoplEd::setSCandidateLastName()
     * @param string $peoplEdTag
     * @param string $sAPIKey
     * @param string $sCandidateEmail
     * @param string $sCandidateFirstName
     * @param string $sCandidateLastName
     */
    public function __construct($peoplEdTag = null, $sAPIKey = null, $sCandidateEmail = null, $sCandidateFirstName = null, $sCandidateLastName = null)
    {
        $this
            ->setPeoplEdTag($peoplEdTag)
            ->setSAPIKey($sAPIKey)
            ->setSCandidateEmail($sCandidateEmail)
            ->setSCandidateFirstName($sCandidateFirstName)
            ->setSCandidateLastName($sCandidateLastName);
    }
    /**
     * Get PeoplEdTag value
     * @return string
     */
    public function getPeoplEdTag()
    {
        return $this->PeoplEdTag;
    }
    /**
     * Set PeoplEdTag value
     * @uses \RecruitCrm\LogicMelon\EnumType\PeoplEdTag::valueIsValid()
     * @uses \RecruitCrm\LogicMelon\EnumType\PeoplEdTag::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $peoplEdTag
     * @return \RecruitCrm\LogicMelon\StructType\CandidateTagPeoplEd
     */
    public function setPeoplEdTag($peoplEdTag = null)
    {
        // validation for constraint: enumeration
        if (!\RecruitCrm\LogicMelon\EnumType\PeoplEdTag::valueIsValid($peoplEdTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \RecruitCrm\LogicMelon\EnumType\PeoplEdTag', is_array($peoplEdTag) ? implode(', ', $peoplEdTag) : var_export($peoplEdTag, true), implode(', ', \RecruitCrm\LogicMelon\EnumType\PeoplEdTag::getValidValues())), __LINE__);
        }
        $this->PeoplEdTag = $peoplEdTag;
        return $this;
    }
    /**
     * Get sAPIKey value
     * @return string|null
     */
    public function getSAPIKey()
    {
        return $this->sAPIKey;
    }
    /**
     * Set sAPIKey value
     * @param string $sAPIKey
     * @return \RecruitCrm\LogicMelon\StructType\CandidateTagPeoplEd
     */
    public function setSAPIKey($sAPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($sAPIKey) && !is_string($sAPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAPIKey, true), gettype($sAPIKey)), __LINE__);
        }
        $this->sAPIKey = $sAPIKey;
        return $this;
    }
    /**
     * Get sCandidateEmail value
     * @return string|null
     */
    public function getSCandidateEmail()
    {
        return $this->sCandidateEmail;
    }
    /**
     * Set sCandidateEmail value
     * @param string $sCandidateEmail
     * @return \RecruitCrm\LogicMelon\StructType\CandidateTagPeoplEd
     */
    public function setSCandidateEmail($sCandidateEmail = null)
    {
        // validation for constraint: string
        if (!is_null($sCandidateEmail) && !is_string($sCandidateEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sCandidateEmail, true), gettype($sCandidateEmail)), __LINE__);
        }
        $this->sCandidateEmail = $sCandidateEmail;
        return $this;
    }
    /**
     * Get sCandidateFirstName value
     * @return string|null
     */
    public function getSCandidateFirstName()
    {
        return $this->sCandidateFirstName;
    }
    /**
     * Set sCandidateFirstName value
     * @param string $sCandidateFirstName
     * @return \RecruitCrm\LogicMelon\StructType\CandidateTagPeoplEd
     */
    public function setSCandidateFirstName($sCandidateFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($sCandidateFirstName) && !is_string($sCandidateFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sCandidateFirstName, true), gettype($sCandidateFirstName)), __LINE__);
        }
        $this->sCandidateFirstName = $sCandidateFirstName;
        return $this;
    }
    /**
     * Get sCandidateLastName value
     * @return string|null
     */
    public function getSCandidateLastName()
    {
        return $this->sCandidateLastName;
    }
    /**
     * Set sCandidateLastName value
     * @param string $sCandidateLastName
     * @return \RecruitCrm\LogicMelon\StructType\CandidateTagPeoplEd
     */
    public function setSCandidateLastName($sCandidateLastName = null)
    {
        // validation for constraint: string
        if (!is_null($sCandidateLastName) && !is_string($sCandidateLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sCandidateLastName, true), gettype($sCandidateLastName)), __LINE__);
        }
        $this->sCandidateLastName = $sCandidateLastName;
        return $this;
    }
}
