<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NameValue StructType
 * @subpackage Structs
 */
class NameValue extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * The Values
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1
     */
    public $Values;
    /**
     * Constructor method for NameValue
     * @uses NameValue::setName()
     * @uses NameValue::setValue()
     * @uses NameValue::setValues()
     * @param string $name
     * @param string $value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $values
     */
    public function __construct($name = null, $value = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $values = null)
    {
        $this
            ->setName($name)
            ->setValue($value)
            ->setValues($values);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \RecruitCrm\LogicMelon\StructType\NameValue
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \RecruitCrm\LogicMelon\StructType\NameValue
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Values value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1|null
     */
    public function getValues()
    {
        return $this->Values;
    }
    /**
     * Set Values value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $values
     * @return \RecruitCrm\LogicMelon\StructType\NameValue
     */
    public function setValues(\RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $values = null)
    {
        $this->Values = $values;
        return $this;
    }
}
