<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mpats_PostJob_TrackResult StructType
 * @subpackage Structs
 */
class Mpats_PostJob_TrackResult extends AbstractStructBase
{
    /**
     * The PostingID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PostingID;
    /**
     * The AdvertID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AdvertID;
    /**
     * The FeedID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FeedID;
    /**
     * The PostDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PostDate;
    /**
     * The PostingStatusID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PostingStatusID;
    /**
     * The ResponseClassID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ResponseClassID;
    /**
     * The CorrectDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CorrectDate;
    /**
     * The CorrectStatusID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CorrectStatusID;
    /**
     * The CorrectClassID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CorrectClassID;
    /**
     * The EstimatedExpireDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EstimatedExpireDate;
    /**
     * The ApplicationsCache
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ApplicationsCache;
    /**
     * The SuitableCache
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SuitableCache;
    /**
     * The MaybeSuitableCache
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaybeSuitableCache;
    /**
     * The UnsuitableCache
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UnsuitableCache;
    /**
     * The SchemaIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SchemaIdentifier;
    /**
     * The FeedIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeedIdentifier;
    /**
     * The FeedName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeedName;
    /**
     * The ResponseSummary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResponseSummary;
    /**
     * The PostingStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostingStatus;
    /**
     * The PostingClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostingClass;
    /**
     * The PostingStatusDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostingStatusDescription;
    /**
     * The PostingClassDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostingClassDescription;
    /**
     * The CorrectSummary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CorrectSummary;
    /**
     * The CorrectStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CorrectStatus;
    /**
     * The CorrectClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CorrectClass;
    /**
     * The CorrectStatusDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CorrectStatusDescription;
    /**
     * The JobBoardURL
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $JobBoardURL;
    /**
     * The JobBoardIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $JobBoardIdentifier;
    /**
     * Constructor method for mpats_PostJob_TrackResult
     * @uses Mpats_PostJob_TrackResult::setPostingID()
     * @uses Mpats_PostJob_TrackResult::setAdvertID()
     * @uses Mpats_PostJob_TrackResult::setFeedID()
     * @uses Mpats_PostJob_TrackResult::setPostDate()
     * @uses Mpats_PostJob_TrackResult::setPostingStatusID()
     * @uses Mpats_PostJob_TrackResult::setResponseClassID()
     * @uses Mpats_PostJob_TrackResult::setCorrectDate()
     * @uses Mpats_PostJob_TrackResult::setCorrectStatusID()
     * @uses Mpats_PostJob_TrackResult::setCorrectClassID()
     * @uses Mpats_PostJob_TrackResult::setEstimatedExpireDate()
     * @uses Mpats_PostJob_TrackResult::setApplicationsCache()
     * @uses Mpats_PostJob_TrackResult::setSuitableCache()
     * @uses Mpats_PostJob_TrackResult::setMaybeSuitableCache()
     * @uses Mpats_PostJob_TrackResult::setUnsuitableCache()
     * @uses Mpats_PostJob_TrackResult::setSchemaIdentifier()
     * @uses Mpats_PostJob_TrackResult::setFeedIdentifier()
     * @uses Mpats_PostJob_TrackResult::setFeedName()
     * @uses Mpats_PostJob_TrackResult::setResponseSummary()
     * @uses Mpats_PostJob_TrackResult::setPostingStatus()
     * @uses Mpats_PostJob_TrackResult::setPostingClass()
     * @uses Mpats_PostJob_TrackResult::setPostingStatusDescription()
     * @uses Mpats_PostJob_TrackResult::setPostingClassDescription()
     * @uses Mpats_PostJob_TrackResult::setCorrectSummary()
     * @uses Mpats_PostJob_TrackResult::setCorrectStatus()
     * @uses Mpats_PostJob_TrackResult::setCorrectClass()
     * @uses Mpats_PostJob_TrackResult::setCorrectStatusDescription()
     * @uses Mpats_PostJob_TrackResult::setJobBoardURL()
     * @uses Mpats_PostJob_TrackResult::setJobBoardIdentifier()
     * @param int $postingID
     * @param int $advertID
     * @param int $feedID
     * @param string $postDate
     * @param int $postingStatusID
     * @param int $responseClassID
     * @param string $correctDate
     * @param int $correctStatusID
     * @param int $correctClassID
     * @param string $estimatedExpireDate
     * @param int $applicationsCache
     * @param int $suitableCache
     * @param int $maybeSuitableCache
     * @param int $unsuitableCache
     * @param string $schemaIdentifier
     * @param string $feedIdentifier
     * @param string $feedName
     * @param string $responseSummary
     * @param string $postingStatus
     * @param string $postingClass
     * @param string $postingStatusDescription
     * @param string $postingClassDescription
     * @param string $correctSummary
     * @param string $correctStatus
     * @param string $correctClass
     * @param string $correctStatusDescription
     * @param string $jobBoardURL
     * @param string $jobBoardIdentifier
     */
    public function __construct($postingID = null, $advertID = null, $feedID = null, $postDate = null, $postingStatusID = null, $responseClassID = null, $correctDate = null, $correctStatusID = null, $correctClassID = null, $estimatedExpireDate = null, $applicationsCache = null, $suitableCache = null, $maybeSuitableCache = null, $unsuitableCache = null, $schemaIdentifier = null, $feedIdentifier = null, $feedName = null, $responseSummary = null, $postingStatus = null, $postingClass = null, $postingStatusDescription = null, $postingClassDescription = null, $correctSummary = null, $correctStatus = null, $correctClass = null, $correctStatusDescription = null, $jobBoardURL = null, $jobBoardIdentifier = null)
    {
        $this
            ->setPostingID($postingID)
            ->setAdvertID($advertID)
            ->setFeedID($feedID)
            ->setPostDate($postDate)
            ->setPostingStatusID($postingStatusID)
            ->setResponseClassID($responseClassID)
            ->setCorrectDate($correctDate)
            ->setCorrectStatusID($correctStatusID)
            ->setCorrectClassID($correctClassID)
            ->setEstimatedExpireDate($estimatedExpireDate)
            ->setApplicationsCache($applicationsCache)
            ->setSuitableCache($suitableCache)
            ->setMaybeSuitableCache($maybeSuitableCache)
            ->setUnsuitableCache($unsuitableCache)
            ->setSchemaIdentifier($schemaIdentifier)
            ->setFeedIdentifier($feedIdentifier)
            ->setFeedName($feedName)
            ->setResponseSummary($responseSummary)
            ->setPostingStatus($postingStatus)
            ->setPostingClass($postingClass)
            ->setPostingStatusDescription($postingStatusDescription)
            ->setPostingClassDescription($postingClassDescription)
            ->setCorrectSummary($correctSummary)
            ->setCorrectStatus($correctStatus)
            ->setCorrectClass($correctClass)
            ->setCorrectStatusDescription($correctStatusDescription)
            ->setJobBoardURL($jobBoardURL)
            ->setJobBoardIdentifier($jobBoardIdentifier);
    }
    /**
     * Get PostingID value
     * @return int
     */
    public function getPostingID()
    {
        return $this->PostingID;
    }
    /**
     * Set PostingID value
     * @param int $postingID
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setPostingID($postingID = null)
    {
        // validation for constraint: int
        if (!is_null($postingID) && !(is_int($postingID) || ctype_digit($postingID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($postingID, true), gettype($postingID)), __LINE__);
        }
        $this->PostingID = $postingID;
        return $this;
    }
    /**
     * Get AdvertID value
     * @return int
     */
    public function getAdvertID()
    {
        return $this->AdvertID;
    }
    /**
     * Set AdvertID value
     * @param int $advertID
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setAdvertID($advertID = null)
    {
        // validation for constraint: int
        if (!is_null($advertID) && !(is_int($advertID) || ctype_digit($advertID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($advertID, true), gettype($advertID)), __LINE__);
        }
        $this->AdvertID = $advertID;
        return $this;
    }
    /**
     * Get FeedID value
     * @return int
     */
    public function getFeedID()
    {
        return $this->FeedID;
    }
    /**
     * Set FeedID value
     * @param int $feedID
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setFeedID($feedID = null)
    {
        // validation for constraint: int
        if (!is_null($feedID) && !(is_int($feedID) || ctype_digit($feedID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($feedID, true), gettype($feedID)), __LINE__);
        }
        $this->FeedID = $feedID;
        return $this;
    }
    /**
     * Get PostDate value
     * @return string
     */
    public function getPostDate()
    {
        return $this->PostDate;
    }
    /**
     * Set PostDate value
     * @param string $postDate
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setPostDate($postDate = null)
    {
        // validation for constraint: string
        if (!is_null($postDate) && !is_string($postDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postDate, true), gettype($postDate)), __LINE__);
        }
        $this->PostDate = $postDate;
        return $this;
    }
    /**
     * Get PostingStatusID value
     * @return int
     */
    public function getPostingStatusID()
    {
        return $this->PostingStatusID;
    }
    /**
     * Set PostingStatusID value
     * @param int $postingStatusID
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setPostingStatusID($postingStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($postingStatusID) && !(is_int($postingStatusID) || ctype_digit($postingStatusID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($postingStatusID, true), gettype($postingStatusID)), __LINE__);
        }
        $this->PostingStatusID = $postingStatusID;
        return $this;
    }
    /**
     * Get ResponseClassID value
     * @return int
     */
    public function getResponseClassID()
    {
        return $this->ResponseClassID;
    }
    /**
     * Set ResponseClassID value
     * @param int $responseClassID
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setResponseClassID($responseClassID = null)
    {
        // validation for constraint: int
        if (!is_null($responseClassID) && !(is_int($responseClassID) || ctype_digit($responseClassID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($responseClassID, true), gettype($responseClassID)), __LINE__);
        }
        $this->ResponseClassID = $responseClassID;
        return $this;
    }
    /**
     * Get CorrectDate value
     * @return string
     */
    public function getCorrectDate()
    {
        return $this->CorrectDate;
    }
    /**
     * Set CorrectDate value
     * @param string $correctDate
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setCorrectDate($correctDate = null)
    {
        // validation for constraint: string
        if (!is_null($correctDate) && !is_string($correctDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correctDate, true), gettype($correctDate)), __LINE__);
        }
        $this->CorrectDate = $correctDate;
        return $this;
    }
    /**
     * Get CorrectStatusID value
     * @return int
     */
    public function getCorrectStatusID()
    {
        return $this->CorrectStatusID;
    }
    /**
     * Set CorrectStatusID value
     * @param int $correctStatusID
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setCorrectStatusID($correctStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($correctStatusID) && !(is_int($correctStatusID) || ctype_digit($correctStatusID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($correctStatusID, true), gettype($correctStatusID)), __LINE__);
        }
        $this->CorrectStatusID = $correctStatusID;
        return $this;
    }
    /**
     * Get CorrectClassID value
     * @return int
     */
    public function getCorrectClassID()
    {
        return $this->CorrectClassID;
    }
    /**
     * Set CorrectClassID value
     * @param int $correctClassID
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setCorrectClassID($correctClassID = null)
    {
        // validation for constraint: int
        if (!is_null($correctClassID) && !(is_int($correctClassID) || ctype_digit($correctClassID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($correctClassID, true), gettype($correctClassID)), __LINE__);
        }
        $this->CorrectClassID = $correctClassID;
        return $this;
    }
    /**
     * Get EstimatedExpireDate value
     * @return string
     */
    public function getEstimatedExpireDate()
    {
        return $this->EstimatedExpireDate;
    }
    /**
     * Set EstimatedExpireDate value
     * @param string $estimatedExpireDate
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setEstimatedExpireDate($estimatedExpireDate = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedExpireDate) && !is_string($estimatedExpireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estimatedExpireDate, true), gettype($estimatedExpireDate)), __LINE__);
        }
        $this->EstimatedExpireDate = $estimatedExpireDate;
        return $this;
    }
    /**
     * Get ApplicationsCache value
     * @return int
     */
    public function getApplicationsCache()
    {
        return $this->ApplicationsCache;
    }
    /**
     * Set ApplicationsCache value
     * @param int $applicationsCache
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setApplicationsCache($applicationsCache = null)
    {
        // validation for constraint: int
        if (!is_null($applicationsCache) && !(is_int($applicationsCache) || ctype_digit($applicationsCache))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($applicationsCache, true), gettype($applicationsCache)), __LINE__);
        }
        $this->ApplicationsCache = $applicationsCache;
        return $this;
    }
    /**
     * Get SuitableCache value
     * @return int
     */
    public function getSuitableCache()
    {
        return $this->SuitableCache;
    }
    /**
     * Set SuitableCache value
     * @param int $suitableCache
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setSuitableCache($suitableCache = null)
    {
        // validation for constraint: int
        if (!is_null($suitableCache) && !(is_int($suitableCache) || ctype_digit($suitableCache))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($suitableCache, true), gettype($suitableCache)), __LINE__);
        }
        $this->SuitableCache = $suitableCache;
        return $this;
    }
    /**
     * Get MaybeSuitableCache value
     * @return int
     */
    public function getMaybeSuitableCache()
    {
        return $this->MaybeSuitableCache;
    }
    /**
     * Set MaybeSuitableCache value
     * @param int $maybeSuitableCache
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setMaybeSuitableCache($maybeSuitableCache = null)
    {
        // validation for constraint: int
        if (!is_null($maybeSuitableCache) && !(is_int($maybeSuitableCache) || ctype_digit($maybeSuitableCache))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maybeSuitableCache, true), gettype($maybeSuitableCache)), __LINE__);
        }
        $this->MaybeSuitableCache = $maybeSuitableCache;
        return $this;
    }
    /**
     * Get UnsuitableCache value
     * @return int
     */
    public function getUnsuitableCache()
    {
        return $this->UnsuitableCache;
    }
    /**
     * Set UnsuitableCache value
     * @param int $unsuitableCache
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setUnsuitableCache($unsuitableCache = null)
    {
        // validation for constraint: int
        if (!is_null($unsuitableCache) && !(is_int($unsuitableCache) || ctype_digit($unsuitableCache))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unsuitableCache, true), gettype($unsuitableCache)), __LINE__);
        }
        $this->UnsuitableCache = $unsuitableCache;
        return $this;
    }
    /**
     * Get SchemaIdentifier value
     * @return string|null
     */
    public function getSchemaIdentifier()
    {
        return $this->SchemaIdentifier;
    }
    /**
     * Set SchemaIdentifier value
     * @param string $schemaIdentifier
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setSchemaIdentifier($schemaIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($schemaIdentifier) && !is_string($schemaIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemaIdentifier, true), gettype($schemaIdentifier)), __LINE__);
        }
        $this->SchemaIdentifier = $schemaIdentifier;
        return $this;
    }
    /**
     * Get FeedIdentifier value
     * @return string|null
     */
    public function getFeedIdentifier()
    {
        return $this->FeedIdentifier;
    }
    /**
     * Set FeedIdentifier value
     * @param string $feedIdentifier
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setFeedIdentifier($feedIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($feedIdentifier) && !is_string($feedIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feedIdentifier, true), gettype($feedIdentifier)), __LINE__);
        }
        $this->FeedIdentifier = $feedIdentifier;
        return $this;
    }
    /**
     * Get FeedName value
     * @return string|null
     */
    public function getFeedName()
    {
        return $this->FeedName;
    }
    /**
     * Set FeedName value
     * @param string $feedName
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setFeedName($feedName = null)
    {
        // validation for constraint: string
        if (!is_null($feedName) && !is_string($feedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feedName, true), gettype($feedName)), __LINE__);
        }
        $this->FeedName = $feedName;
        return $this;
    }
    /**
     * Get ResponseSummary value
     * @return string|null
     */
    public function getResponseSummary()
    {
        return $this->ResponseSummary;
    }
    /**
     * Set ResponseSummary value
     * @param string $responseSummary
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setResponseSummary($responseSummary = null)
    {
        // validation for constraint: string
        if (!is_null($responseSummary) && !is_string($responseSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseSummary, true), gettype($responseSummary)), __LINE__);
        }
        $this->ResponseSummary = $responseSummary;
        return $this;
    }
    /**
     * Get PostingStatus value
     * @return string|null
     */
    public function getPostingStatus()
    {
        return $this->PostingStatus;
    }
    /**
     * Set PostingStatus value
     * @param string $postingStatus
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setPostingStatus($postingStatus = null)
    {
        // validation for constraint: string
        if (!is_null($postingStatus) && !is_string($postingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postingStatus, true), gettype($postingStatus)), __LINE__);
        }
        $this->PostingStatus = $postingStatus;
        return $this;
    }
    /**
     * Get PostingClass value
     * @return string|null
     */
    public function getPostingClass()
    {
        return $this->PostingClass;
    }
    /**
     * Set PostingClass value
     * @param string $postingClass
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setPostingClass($postingClass = null)
    {
        // validation for constraint: string
        if (!is_null($postingClass) && !is_string($postingClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postingClass, true), gettype($postingClass)), __LINE__);
        }
        $this->PostingClass = $postingClass;
        return $this;
    }
    /**
     * Get PostingStatusDescription value
     * @return string|null
     */
    public function getPostingStatusDescription()
    {
        return $this->PostingStatusDescription;
    }
    /**
     * Set PostingStatusDescription value
     * @param string $postingStatusDescription
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setPostingStatusDescription($postingStatusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($postingStatusDescription) && !is_string($postingStatusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postingStatusDescription, true), gettype($postingStatusDescription)), __LINE__);
        }
        $this->PostingStatusDescription = $postingStatusDescription;
        return $this;
    }
    /**
     * Get PostingClassDescription value
     * @return string|null
     */
    public function getPostingClassDescription()
    {
        return $this->PostingClassDescription;
    }
    /**
     * Set PostingClassDescription value
     * @param string $postingClassDescription
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setPostingClassDescription($postingClassDescription = null)
    {
        // validation for constraint: string
        if (!is_null($postingClassDescription) && !is_string($postingClassDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postingClassDescription, true), gettype($postingClassDescription)), __LINE__);
        }
        $this->PostingClassDescription = $postingClassDescription;
        return $this;
    }
    /**
     * Get CorrectSummary value
     * @return string|null
     */
    public function getCorrectSummary()
    {
        return $this->CorrectSummary;
    }
    /**
     * Set CorrectSummary value
     * @param string $correctSummary
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setCorrectSummary($correctSummary = null)
    {
        // validation for constraint: string
        if (!is_null($correctSummary) && !is_string($correctSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correctSummary, true), gettype($correctSummary)), __LINE__);
        }
        $this->CorrectSummary = $correctSummary;
        return $this;
    }
    /**
     * Get CorrectStatus value
     * @return string|null
     */
    public function getCorrectStatus()
    {
        return $this->CorrectStatus;
    }
    /**
     * Set CorrectStatus value
     * @param string $correctStatus
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setCorrectStatus($correctStatus = null)
    {
        // validation for constraint: string
        if (!is_null($correctStatus) && !is_string($correctStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correctStatus, true), gettype($correctStatus)), __LINE__);
        }
        $this->CorrectStatus = $correctStatus;
        return $this;
    }
    /**
     * Get CorrectClass value
     * @return string|null
     */
    public function getCorrectClass()
    {
        return $this->CorrectClass;
    }
    /**
     * Set CorrectClass value
     * @param string $correctClass
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setCorrectClass($correctClass = null)
    {
        // validation for constraint: string
        if (!is_null($correctClass) && !is_string($correctClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correctClass, true), gettype($correctClass)), __LINE__);
        }
        $this->CorrectClass = $correctClass;
        return $this;
    }
    /**
     * Get CorrectStatusDescription value
     * @return string|null
     */
    public function getCorrectStatusDescription()
    {
        return $this->CorrectStatusDescription;
    }
    /**
     * Set CorrectStatusDescription value
     * @param string $correctStatusDescription
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setCorrectStatusDescription($correctStatusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($correctStatusDescription) && !is_string($correctStatusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correctStatusDescription, true), gettype($correctStatusDescription)), __LINE__);
        }
        $this->CorrectStatusDescription = $correctStatusDescription;
        return $this;
    }
    /**
     * Get JobBoardURL value
     * @return string|null
     */
    public function getJobBoardURL()
    {
        return $this->JobBoardURL;
    }
    /**
     * Set JobBoardURL value
     * @param string $jobBoardURL
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setJobBoardURL($jobBoardURL = null)
    {
        // validation for constraint: string
        if (!is_null($jobBoardURL) && !is_string($jobBoardURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobBoardURL, true), gettype($jobBoardURL)), __LINE__);
        }
        $this->JobBoardURL = $jobBoardURL;
        return $this;
    }
    /**
     * Get JobBoardIdentifier value
     * @return string|null
     */
    public function getJobBoardIdentifier()
    {
        return $this->JobBoardIdentifier;
    }
    /**
     * Set JobBoardIdentifier value
     * @param string $jobBoardIdentifier
     * @return \RecruitCrm\LogicMelon\StructType\Mpats_PostJob_TrackResult
     */
    public function setJobBoardIdentifier($jobBoardIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($jobBoardIdentifier) && !is_string($jobBoardIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobBoardIdentifier, true), gettype($jobBoardIdentifier)), __LINE__);
        }
        $this->JobBoardIdentifier = $jobBoardIdentifier;
        return $this;
    }
}
