<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APIApplicationAttachment StructType
 * @subpackage Structs
 */
class APIApplicationAttachment extends AbstractStructBase
{
    /**
     * The Document
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Document;
    /**
     * The DocumentBytes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentBytes;
    /**
     * The FileName
     * @var string
     */
    public $FileName;
    /**
     * The DocumentType
     * @var string
     */
    public $DocumentType;
    /**
     * The EncodingType
     * @var string
     */
    public $EncodingType;
    /**
     * The DocumentSource
     * @var string
     */
    public $DocumentSource;
    /**
     * The DocumentFormat
     * @var string
     */
    public $DocumentFormat;
    /**
     * Constructor method for APIApplicationAttachment
     * @uses APIApplicationAttachment::setDocument()
     * @uses APIApplicationAttachment::setDocumentBytes()
     * @uses APIApplicationAttachment::setFileName()
     * @uses APIApplicationAttachment::setDocumentType()
     * @uses APIApplicationAttachment::setEncodingType()
     * @uses APIApplicationAttachment::setDocumentSource()
     * @uses APIApplicationAttachment::setDocumentFormat()
     * @param string $document
     * @param string $documentBytes
     * @param string $fileName
     * @param string $documentType
     * @param string $encodingType
     * @param string $documentSource
     * @param string $documentFormat
     */
    public function __construct($document = null, $documentBytes = null, $fileName = null, $documentType = null, $encodingType = null, $documentSource = null, $documentFormat = null)
    {
        $this
            ->setDocument($document)
            ->setDocumentBytes($documentBytes)
            ->setFileName($fileName)
            ->setDocumentType($documentType)
            ->setEncodingType($encodingType)
            ->setDocumentSource($documentSource)
            ->setDocumentFormat($documentFormat);
    }
    /**
     * Get Document value
     * @return string|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @param string $document
     * @return \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment
     */
    public function setDocument($document = null)
    {
        // validation for constraint: string
        if (!is_null($document) && !is_string($document)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document, true), gettype($document)), __LINE__);
        }
        $this->Document = $document;
        return $this;
    }
    /**
     * Get DocumentBytes value
     * @return string|null
     */
    public function getDocumentBytes()
    {
        return $this->DocumentBytes;
    }
    /**
     * Set DocumentBytes value
     * @param string $documentBytes
     * @return \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment
     */
    public function setDocumentBytes($documentBytes = null)
    {
        // validation for constraint: string
        if (!is_null($documentBytes) && !is_string($documentBytes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentBytes, true), gettype($documentBytes)), __LINE__);
        }
        $this->DocumentBytes = $documentBytes;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get DocumentType value
     * @return string|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @param string $documentType
     * @return \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: string
        if (!is_null($documentType) && !is_string($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentType, true), gettype($documentType)), __LINE__);
        }
        $this->DocumentType = $documentType;
        return $this;
    }
    /**
     * Get EncodingType value
     * @return string|null
     */
    public function getEncodingType()
    {
        return $this->EncodingType;
    }
    /**
     * Set EncodingType value
     * @param string $encodingType
     * @return \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment
     */
    public function setEncodingType($encodingType = null)
    {
        // validation for constraint: string
        if (!is_null($encodingType) && !is_string($encodingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encodingType, true), gettype($encodingType)), __LINE__);
        }
        $this->EncodingType = $encodingType;
        return $this;
    }
    /**
     * Get DocumentSource value
     * @return string|null
     */
    public function getDocumentSource()
    {
        return $this->DocumentSource;
    }
    /**
     * Set DocumentSource value
     * @param string $documentSource
     * @return \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment
     */
    public function setDocumentSource($documentSource = null)
    {
        // validation for constraint: string
        if (!is_null($documentSource) && !is_string($documentSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentSource, true), gettype($documentSource)), __LINE__);
        }
        $this->DocumentSource = $documentSource;
        return $this;
    }
    /**
     * Get DocumentFormat value
     * @return string|null
     */
    public function getDocumentFormat()
    {
        return $this->DocumentFormat;
    }
    /**
     * Set DocumentFormat value
     * @param string $documentFormat
     * @return \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment
     */
    public function setDocumentFormat($documentFormat = null)
    {
        // validation for constraint: string
        if (!is_null($documentFormat) && !is_string($documentFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentFormat, true), gettype($documentFormat)), __LINE__);
        }
        $this->DocumentFormat = $documentFormat;
        return $this;
    }
}
