<?php

namespace RecruitCrm\LogicMelon\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Unarchive ServiceType
 * @subpackage Services
 */
class Unarchive extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UnarchiveAdvert
     * Meta information extracted from the WSDL
     * - documentation: <a name='UnarchiveAdvert'></a><p>Provides a mechanism to restore (make visible) an advert on the system.</p><p>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier)
     * or specific portion of the tree (sStartOrganisation).</p> | <a name='UnarchiveAdvert'></a><p>Provides a mechanism to restore (make visible) an advert on the system.</p><p>Optionally specify a sUsername or sStartOrganisation to limit the search to a
     * specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</p> | <a name='UnarchiveAdvert'></a><p>Provides a mechanism to restore (make visible) an advert on the system.</p><p>Optionally specify a sUsername or
     * sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</p>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\UnarchiveAdvert $parameters
     * @return \RecruitCrm\LogicMelon\StructType\UnarchiveAdvertResponse|bool
     */
    public function UnarchiveAdvert(\RecruitCrm\LogicMelon\StructType\UnarchiveAdvert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UnarchiveAdvert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnarchiveAdvertWithFilters
     * Meta information extracted from the WSDL
     * - documentation: <a name='UnarchiveAdvertWithFilters'></a><p>Provides a mechanism to restore (make visible) an advert on the system.</p><p>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or
     * sUserIdentifier) or specific portion of the tree (sStartOrganisation).</p>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\UnarchiveAdvertWithFilters $parameters
     * @return \RecruitCrm\LogicMelon\StructType\UnarchiveAdvertWithFiltersResponse|bool
     */
    public function UnarchiveAdvertWithFilters(\RecruitCrm\LogicMelon\StructType\UnarchiveAdvertWithFilters $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UnarchiveAdvertWithFilters($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \RecruitCrm\LogicMelon\StructType\UnarchiveAdvertResponse|\RecruitCrm\LogicMelon\StructType\UnarchiveAdvertWithFiltersResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
