<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APIApplication StructType
 * @subpackage Structs
 */
class APIApplication extends AbstractStructBase
{
    /**
     * The AdvertCandidateID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AdvertCandidateID;
    /**
     * The AdvertID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AdvertID;
    /**
     * The CandidateID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CandidateID;
    /**
     * The PostingID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PostingID;
    /**
     * The FeedID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FeedID;
    /**
     * The ApplicationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ApplicationDate;
    /**
     * The Viewed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Viewed;
    /**
     * The Score
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Score;
    /**
     * The ProgressID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProgressID;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The OrganisationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrganisationID;
    /**
     * The Archived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Archived;
    /**
     * The Favourite
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Favourite;
    /**
     * The LastScoreDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastScoreDate;
    /**
     * The LastProgressDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastProgressDate;
    /**
     * The LastNoteDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastNoteDate;
    /**
     * The SchemaIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SchemaIdentifier;
    /**
     * The FeedName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeedName;
    /**
     * The EmailAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The HomePhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HomePhone;
    /**
     * The WorkPhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WorkPhone;
    /**
     * The MobilePhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MobilePhone;
    /**
     * The Ranking
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ranking;
    /**
     * The Progress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Progress;
    /**
     * The AdvertIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdvertIdentifier;
    /**
     * The AdvertReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdvertReference;
    /**
     * The AdvertTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdvertTitle;
    /**
     * The OrganisationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrganisationName;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The EmailBody
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment
     */
    public $EmailBody;
    /**
     * The EmailFirstAttachment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment
     */
    public $EmailFirstAttachment;
    /**
     * The Parsed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment
     */
    public $Parsed;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment
     */
    public $Email;
    /**
     * The APIProcessingMessages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $APIProcessingMessages;
    /**
     * The sApplicationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sApplicationDate;
    /**
     * The sLastNoteDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLastNoteDate;
    /**
     * The sLastScoreDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLastScoreDate;
    /**
     * The sLastProgressDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLastProgressDate;
    /**
     * Constructor method for APIApplication
     * @uses APIApplication::setAdvertCandidateID()
     * @uses APIApplication::setAdvertID()
     * @uses APIApplication::setCandidateID()
     * @uses APIApplication::setPostingID()
     * @uses APIApplication::setFeedID()
     * @uses APIApplication::setApplicationDate()
     * @uses APIApplication::setViewed()
     * @uses APIApplication::setScore()
     * @uses APIApplication::setProgressID()
     * @uses APIApplication::setUserID()
     * @uses APIApplication::setOrganisationID()
     * @uses APIApplication::setArchived()
     * @uses APIApplication::setFavourite()
     * @uses APIApplication::setLastScoreDate()
     * @uses APIApplication::setLastProgressDate()
     * @uses APIApplication::setLastNoteDate()
     * @uses APIApplication::setSchemaIdentifier()
     * @uses APIApplication::setFeedName()
     * @uses APIApplication::setEmailAddress()
     * @uses APIApplication::setLastName()
     * @uses APIApplication::setFirstName()
     * @uses APIApplication::setHomePhone()
     * @uses APIApplication::setWorkPhone()
     * @uses APIApplication::setMobilePhone()
     * @uses APIApplication::setRanking()
     * @uses APIApplication::setProgress()
     * @uses APIApplication::setAdvertIdentifier()
     * @uses APIApplication::setAdvertReference()
     * @uses APIApplication::setAdvertTitle()
     * @uses APIApplication::setOrganisationName()
     * @uses APIApplication::setAddress()
     * @uses APIApplication::setEmailBody()
     * @uses APIApplication::setEmailFirstAttachment()
     * @uses APIApplication::setParsed()
     * @uses APIApplication::setEmail()
     * @uses APIApplication::setAPIProcessingMessages()
     * @uses APIApplication::setSApplicationDate()
     * @uses APIApplication::setSLastNoteDate()
     * @uses APIApplication::setSLastScoreDate()
     * @uses APIApplication::setSLastProgressDate()
     * @param int $advertCandidateID
     * @param int $advertID
     * @param int $candidateID
     * @param int $postingID
     * @param int $feedID
     * @param string $applicationDate
     * @param bool $viewed
     * @param int $score
     * @param int $progressID
     * @param int $userID
     * @param int $organisationID
     * @param bool $archived
     * @param bool $favourite
     * @param string $lastScoreDate
     * @param string $lastProgressDate
     * @param string $lastNoteDate
     * @param string $schemaIdentifier
     * @param string $feedName
     * @param string $emailAddress
     * @param string $lastName
     * @param string $firstName
     * @param string $homePhone
     * @param string $workPhone
     * @param string $mobilePhone
     * @param string $ranking
     * @param string $progress
     * @param string $advertIdentifier
     * @param string $advertReference
     * @param string $advertTitle
     * @param string $organisationName
     * @param string $address
     * @param \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment $emailBody
     * @param \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment $emailFirstAttachment
     * @param \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment $parsed
     * @param \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment $email
     * @param string $aPIProcessingMessages
     * @param string $sApplicationDate
     * @param string $sLastNoteDate
     * @param string $sLastScoreDate
     * @param string $sLastProgressDate
     */
    public function __construct($advertCandidateID = null, $advertID = null, $candidateID = null, $postingID = null, $feedID = null, $applicationDate = null, $viewed = null, $score = null, $progressID = null, $userID = null, $organisationID = null, $archived = null, $favourite = null, $lastScoreDate = null, $lastProgressDate = null, $lastNoteDate = null, $schemaIdentifier = null, $feedName = null, $emailAddress = null, $lastName = null, $firstName = null, $homePhone = null, $workPhone = null, $mobilePhone = null, $ranking = null, $progress = null, $advertIdentifier = null, $advertReference = null, $advertTitle = null, $organisationName = null, $address = null, \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment $emailBody = null, \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment $emailFirstAttachment = null, \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment $parsed = null, \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment $email = null, $aPIProcessingMessages = null, $sApplicationDate = null, $sLastNoteDate = null, $sLastScoreDate = null, $sLastProgressDate = null)
    {
        $this
            ->setAdvertCandidateID($advertCandidateID)
            ->setAdvertID($advertID)
            ->setCandidateID($candidateID)
            ->setPostingID($postingID)
            ->setFeedID($feedID)
            ->setApplicationDate($applicationDate)
            ->setViewed($viewed)
            ->setScore($score)
            ->setProgressID($progressID)
            ->setUserID($userID)
            ->setOrganisationID($organisationID)
            ->setArchived($archived)
            ->setFavourite($favourite)
            ->setLastScoreDate($lastScoreDate)
            ->setLastProgressDate($lastProgressDate)
            ->setLastNoteDate($lastNoteDate)
            ->setSchemaIdentifier($schemaIdentifier)
            ->setFeedName($feedName)
            ->setEmailAddress($emailAddress)
            ->setLastName($lastName)
            ->setFirstName($firstName)
            ->setHomePhone($homePhone)
            ->setWorkPhone($workPhone)
            ->setMobilePhone($mobilePhone)
            ->setRanking($ranking)
            ->setProgress($progress)
            ->setAdvertIdentifier($advertIdentifier)
            ->setAdvertReference($advertReference)
            ->setAdvertTitle($advertTitle)
            ->setOrganisationName($organisationName)
            ->setAddress($address)
            ->setEmailBody($emailBody)
            ->setEmailFirstAttachment($emailFirstAttachment)
            ->setParsed($parsed)
            ->setEmail($email)
            ->setAPIProcessingMessages($aPIProcessingMessages)
            ->setSApplicationDate($sApplicationDate)
            ->setSLastNoteDate($sLastNoteDate)
            ->setSLastScoreDate($sLastScoreDate)
            ->setSLastProgressDate($sLastProgressDate);
    }
    /**
     * Get AdvertCandidateID value
     * @return int
     */
    public function getAdvertCandidateID()
    {
        return $this->AdvertCandidateID;
    }
    /**
     * Set AdvertCandidateID value
     * @param int $advertCandidateID
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setAdvertCandidateID($advertCandidateID = null)
    {
        // validation for constraint: int
        if (!is_null($advertCandidateID) && !(is_int($advertCandidateID) || ctype_digit($advertCandidateID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($advertCandidateID, true), gettype($advertCandidateID)), __LINE__);
        }
        $this->AdvertCandidateID = $advertCandidateID;
        return $this;
    }
    /**
     * Get AdvertID value
     * @return int
     */
    public function getAdvertID()
    {
        return $this->AdvertID;
    }
    /**
     * Set AdvertID value
     * @param int $advertID
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setAdvertID($advertID = null)
    {
        // validation for constraint: int
        if (!is_null($advertID) && !(is_int($advertID) || ctype_digit($advertID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($advertID, true), gettype($advertID)), __LINE__);
        }
        $this->AdvertID = $advertID;
        return $this;
    }
    /**
     * Get CandidateID value
     * @return int
     */
    public function getCandidateID()
    {
        return $this->CandidateID;
    }
    /**
     * Set CandidateID value
     * @param int $candidateID
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setCandidateID($candidateID = null)
    {
        // validation for constraint: int
        if (!is_null($candidateID) && !(is_int($candidateID) || ctype_digit($candidateID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($candidateID, true), gettype($candidateID)), __LINE__);
        }
        $this->CandidateID = $candidateID;
        return $this;
    }
    /**
     * Get PostingID value
     * @return int
     */
    public function getPostingID()
    {
        return $this->PostingID;
    }
    /**
     * Set PostingID value
     * @param int $postingID
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setPostingID($postingID = null)
    {
        // validation for constraint: int
        if (!is_null($postingID) && !(is_int($postingID) || ctype_digit($postingID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($postingID, true), gettype($postingID)), __LINE__);
        }
        $this->PostingID = $postingID;
        return $this;
    }
    /**
     * Get FeedID value
     * @return int
     */
    public function getFeedID()
    {
        return $this->FeedID;
    }
    /**
     * Set FeedID value
     * @param int $feedID
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setFeedID($feedID = null)
    {
        // validation for constraint: int
        if (!is_null($feedID) && !(is_int($feedID) || ctype_digit($feedID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($feedID, true), gettype($feedID)), __LINE__);
        }
        $this->FeedID = $feedID;
        return $this;
    }
    /**
     * Get ApplicationDate value
     * @return string
     */
    public function getApplicationDate()
    {
        return $this->ApplicationDate;
    }
    /**
     * Set ApplicationDate value
     * @param string $applicationDate
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setApplicationDate($applicationDate = null)
    {
        // validation for constraint: string
        if (!is_null($applicationDate) && !is_string($applicationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationDate, true), gettype($applicationDate)), __LINE__);
        }
        $this->ApplicationDate = $applicationDate;
        return $this;
    }
    /**
     * Get Viewed value
     * @return bool
     */
    public function getViewed()
    {
        return $this->Viewed;
    }
    /**
     * Set Viewed value
     * @param bool $viewed
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setViewed($viewed = null)
    {
        // validation for constraint: boolean
        if (!is_null($viewed) && !is_bool($viewed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($viewed, true), gettype($viewed)), __LINE__);
        }
        $this->Viewed = $viewed;
        return $this;
    }
    /**
     * Get Score value
     * @return int
     */
    public function getScore()
    {
        return $this->Score;
    }
    /**
     * Set Score value
     * @param int $score
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setScore($score = null)
    {
        // validation for constraint: int
        if (!is_null($score) && !(is_int($score) || ctype_digit($score))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($score, true), gettype($score)), __LINE__);
        }
        $this->Score = $score;
        return $this;
    }
    /**
     * Get ProgressID value
     * @return int
     */
    public function getProgressID()
    {
        return $this->ProgressID;
    }
    /**
     * Set ProgressID value
     * @param int $progressID
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setProgressID($progressID = null)
    {
        // validation for constraint: int
        if (!is_null($progressID) && !(is_int($progressID) || ctype_digit($progressID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($progressID, true), gettype($progressID)), __LINE__);
        }
        $this->ProgressID = $progressID;
        return $this;
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !(is_int($userID) || ctype_digit($userID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get OrganisationID value
     * @return int
     */
    public function getOrganisationID()
    {
        return $this->OrganisationID;
    }
    /**
     * Set OrganisationID value
     * @param int $organisationID
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setOrganisationID($organisationID = null)
    {
        // validation for constraint: int
        if (!is_null($organisationID) && !(is_int($organisationID) || ctype_digit($organisationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($organisationID, true), gettype($organisationID)), __LINE__);
        }
        $this->OrganisationID = $organisationID;
        return $this;
    }
    /**
     * Get Archived value
     * @return bool
     */
    public function getArchived()
    {
        return $this->Archived;
    }
    /**
     * Set Archived value
     * @param bool $archived
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setArchived($archived = null)
    {
        // validation for constraint: boolean
        if (!is_null($archived) && !is_bool($archived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($archived, true), gettype($archived)), __LINE__);
        }
        $this->Archived = $archived;
        return $this;
    }
    /**
     * Get Favourite value
     * @return bool
     */
    public function getFavourite()
    {
        return $this->Favourite;
    }
    /**
     * Set Favourite value
     * @param bool $favourite
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setFavourite($favourite = null)
    {
        // validation for constraint: boolean
        if (!is_null($favourite) && !is_bool($favourite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($favourite, true), gettype($favourite)), __LINE__);
        }
        $this->Favourite = $favourite;
        return $this;
    }
    /**
     * Get LastScoreDate value
     * @return string
     */
    public function getLastScoreDate()
    {
        return $this->LastScoreDate;
    }
    /**
     * Set LastScoreDate value
     * @param string $lastScoreDate
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setLastScoreDate($lastScoreDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastScoreDate) && !is_string($lastScoreDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastScoreDate, true), gettype($lastScoreDate)), __LINE__);
        }
        $this->LastScoreDate = $lastScoreDate;
        return $this;
    }
    /**
     * Get LastProgressDate value
     * @return string
     */
    public function getLastProgressDate()
    {
        return $this->LastProgressDate;
    }
    /**
     * Set LastProgressDate value
     * @param string $lastProgressDate
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setLastProgressDate($lastProgressDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastProgressDate) && !is_string($lastProgressDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastProgressDate, true), gettype($lastProgressDate)), __LINE__);
        }
        $this->LastProgressDate = $lastProgressDate;
        return $this;
    }
    /**
     * Get LastNoteDate value
     * @return string
     */
    public function getLastNoteDate()
    {
        return $this->LastNoteDate;
    }
    /**
     * Set LastNoteDate value
     * @param string $lastNoteDate
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setLastNoteDate($lastNoteDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastNoteDate) && !is_string($lastNoteDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastNoteDate, true), gettype($lastNoteDate)), __LINE__);
        }
        $this->LastNoteDate = $lastNoteDate;
        return $this;
    }
    /**
     * Get SchemaIdentifier value
     * @return string|null
     */
    public function getSchemaIdentifier()
    {
        return $this->SchemaIdentifier;
    }
    /**
     * Set SchemaIdentifier value
     * @param string $schemaIdentifier
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setSchemaIdentifier($schemaIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($schemaIdentifier) && !is_string($schemaIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemaIdentifier, true), gettype($schemaIdentifier)), __LINE__);
        }
        $this->SchemaIdentifier = $schemaIdentifier;
        return $this;
    }
    /**
     * Get FeedName value
     * @return string|null
     */
    public function getFeedName()
    {
        return $this->FeedName;
    }
    /**
     * Set FeedName value
     * @param string $feedName
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setFeedName($feedName = null)
    {
        // validation for constraint: string
        if (!is_null($feedName) && !is_string($feedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feedName, true), gettype($feedName)), __LINE__);
        }
        $this->FeedName = $feedName;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get HomePhone value
     * @return string|null
     */
    public function getHomePhone()
    {
        return $this->HomePhone;
    }
    /**
     * Set HomePhone value
     * @param string $homePhone
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setHomePhone($homePhone = null)
    {
        // validation for constraint: string
        if (!is_null($homePhone) && !is_string($homePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homePhone, true), gettype($homePhone)), __LINE__);
        }
        $this->HomePhone = $homePhone;
        return $this;
    }
    /**
     * Get WorkPhone value
     * @return string|null
     */
    public function getWorkPhone()
    {
        return $this->WorkPhone;
    }
    /**
     * Set WorkPhone value
     * @param string $workPhone
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setWorkPhone($workPhone = null)
    {
        // validation for constraint: string
        if (!is_null($workPhone) && !is_string($workPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workPhone, true), gettype($workPhone)), __LINE__);
        }
        $this->WorkPhone = $workPhone;
        return $this;
    }
    /**
     * Get MobilePhone value
     * @return string|null
     */
    public function getMobilePhone()
    {
        return $this->MobilePhone;
    }
    /**
     * Set MobilePhone value
     * @param string $mobilePhone
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePhone, true), gettype($mobilePhone)), __LINE__);
        }
        $this->MobilePhone = $mobilePhone;
        return $this;
    }
    /**
     * Get Ranking value
     * @return string|null
     */
    public function getRanking()
    {
        return $this->Ranking;
    }
    /**
     * Set Ranking value
     * @param string $ranking
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setRanking($ranking = null)
    {
        // validation for constraint: string
        if (!is_null($ranking) && !is_string($ranking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ranking, true), gettype($ranking)), __LINE__);
        }
        $this->Ranking = $ranking;
        return $this;
    }
    /**
     * Get Progress value
     * @return string|null
     */
    public function getProgress()
    {
        return $this->Progress;
    }
    /**
     * Set Progress value
     * @param string $progress
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setProgress($progress = null)
    {
        // validation for constraint: string
        if (!is_null($progress) && !is_string($progress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($progress, true), gettype($progress)), __LINE__);
        }
        $this->Progress = $progress;
        return $this;
    }
    /**
     * Get AdvertIdentifier value
     * @return string|null
     */
    public function getAdvertIdentifier()
    {
        return $this->AdvertIdentifier;
    }
    /**
     * Set AdvertIdentifier value
     * @param string $advertIdentifier
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setAdvertIdentifier($advertIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($advertIdentifier) && !is_string($advertIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advertIdentifier, true), gettype($advertIdentifier)), __LINE__);
        }
        $this->AdvertIdentifier = $advertIdentifier;
        return $this;
    }
    /**
     * Get AdvertReference value
     * @return string|null
     */
    public function getAdvertReference()
    {
        return $this->AdvertReference;
    }
    /**
     * Set AdvertReference value
     * @param string $advertReference
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setAdvertReference($advertReference = null)
    {
        // validation for constraint: string
        if (!is_null($advertReference) && !is_string($advertReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advertReference, true), gettype($advertReference)), __LINE__);
        }
        $this->AdvertReference = $advertReference;
        return $this;
    }
    /**
     * Get AdvertTitle value
     * @return string|null
     */
    public function getAdvertTitle()
    {
        return $this->AdvertTitle;
    }
    /**
     * Set AdvertTitle value
     * @param string $advertTitle
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setAdvertTitle($advertTitle = null)
    {
        // validation for constraint: string
        if (!is_null($advertTitle) && !is_string($advertTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advertTitle, true), gettype($advertTitle)), __LINE__);
        }
        $this->AdvertTitle = $advertTitle;
        return $this;
    }
    /**
     * Get OrganisationName value
     * @return string|null
     */
    public function getOrganisationName()
    {
        return $this->OrganisationName;
    }
    /**
     * Set OrganisationName value
     * @param string $organisationName
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setOrganisationName($organisationName = null)
    {
        // validation for constraint: string
        if (!is_null($organisationName) && !is_string($organisationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organisationName, true), gettype($organisationName)), __LINE__);
        }
        $this->OrganisationName = $organisationName;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get EmailBody value
     * @return \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment|null
     */
    public function getEmailBody()
    {
        return $this->EmailBody;
    }
    /**
     * Set EmailBody value
     * @param \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment $emailBody
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setEmailBody(\RecruitCrm\LogicMelon\StructType\APIApplicationAttachment $emailBody = null)
    {
        $this->EmailBody = $emailBody;
        return $this;
    }
    /**
     * Get EmailFirstAttachment value
     * @return \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment|null
     */
    public function getEmailFirstAttachment()
    {
        return $this->EmailFirstAttachment;
    }
    /**
     * Set EmailFirstAttachment value
     * @param \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment $emailFirstAttachment
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setEmailFirstAttachment(\RecruitCrm\LogicMelon\StructType\APIApplicationAttachment $emailFirstAttachment = null)
    {
        $this->EmailFirstAttachment = $emailFirstAttachment;
        return $this;
    }
    /**
     * Get Parsed value
     * @return \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment|null
     */
    public function getParsed()
    {
        return $this->Parsed;
    }
    /**
     * Set Parsed value
     * @param \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment $parsed
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setParsed(\RecruitCrm\LogicMelon\StructType\APIApplicationAttachment $parsed = null)
    {
        $this->Parsed = $parsed;
        return $this;
    }
    /**
     * Get Email value
     * @return \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param \RecruitCrm\LogicMelon\StructType\APIApplicationAttachment $email
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setEmail(\RecruitCrm\LogicMelon\StructType\APIApplicationAttachment $email = null)
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Get APIProcessingMessages value
     * @return string|null
     */
    public function getAPIProcessingMessages()
    {
        return $this->APIProcessingMessages;
    }
    /**
     * Set APIProcessingMessages value
     * @param string $aPIProcessingMessages
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setAPIProcessingMessages($aPIProcessingMessages = null)
    {
        // validation for constraint: string
        if (!is_null($aPIProcessingMessages) && !is_string($aPIProcessingMessages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aPIProcessingMessages, true), gettype($aPIProcessingMessages)), __LINE__);
        }
        $this->APIProcessingMessages = $aPIProcessingMessages;
        return $this;
    }
    /**
     * Get sApplicationDate value
     * @return string|null
     */
    public function getSApplicationDate()
    {
        return $this->sApplicationDate;
    }
    /**
     * Set sApplicationDate value
     * @param string $sApplicationDate
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setSApplicationDate($sApplicationDate = null)
    {
        // validation for constraint: string
        if (!is_null($sApplicationDate) && !is_string($sApplicationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sApplicationDate, true), gettype($sApplicationDate)), __LINE__);
        }
        $this->sApplicationDate = $sApplicationDate;
        return $this;
    }
    /**
     * Get sLastNoteDate value
     * @return string|null
     */
    public function getSLastNoteDate()
    {
        return $this->sLastNoteDate;
    }
    /**
     * Set sLastNoteDate value
     * @param string $sLastNoteDate
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setSLastNoteDate($sLastNoteDate = null)
    {
        // validation for constraint: string
        if (!is_null($sLastNoteDate) && !is_string($sLastNoteDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLastNoteDate, true), gettype($sLastNoteDate)), __LINE__);
        }
        $this->sLastNoteDate = $sLastNoteDate;
        return $this;
    }
    /**
     * Get sLastScoreDate value
     * @return string|null
     */
    public function getSLastScoreDate()
    {
        return $this->sLastScoreDate;
    }
    /**
     * Set sLastScoreDate value
     * @param string $sLastScoreDate
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setSLastScoreDate($sLastScoreDate = null)
    {
        // validation for constraint: string
        if (!is_null($sLastScoreDate) && !is_string($sLastScoreDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLastScoreDate, true), gettype($sLastScoreDate)), __LINE__);
        }
        $this->sLastScoreDate = $sLastScoreDate;
        return $this;
    }
    /**
     * Get sLastProgressDate value
     * @return string|null
     */
    public function getSLastProgressDate()
    {
        return $this->sLastProgressDate;
    }
    /**
     * Set sLastProgressDate value
     * @param string $sLastProgressDate
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication
     */
    public function setSLastProgressDate($sLastProgressDate = null)
    {
        // validation for constraint: string
        if (!is_null($sLastProgressDate) && !is_string($sLastProgressDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLastProgressDate, true), gettype($sLastProgressDate)), __LINE__);
        }
        $this->sLastProgressDate = $sLastProgressDate;
        return $this;
    }
}
