<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackAdvertWithFiltersPaged StructType
 * @subpackage Structs
 */
class TrackAdvertWithFiltersPaged extends AbstractStructBase
{
    /**
     * The CurrentPage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CurrentPage;
    /**
     * The RowsPerPage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RowsPerPage;
    /**
     * The sCultureID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sCultureID;
    /**
     * The sAPIKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAPIKey;
    /**
     * The sUsername
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sUsername;
    /**
     * The sUserIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sUserIdentifier;
    /**
     * The sStartOrganisation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sStartOrganisation;
    /**
     * The sAdvertIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAdvertIdentifier;
    /**
     * The sAdvertReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAdvertReference;
    /**
     * The sAdvertID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAdvertID;
    /**
     * The sSearchDays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sSearchDays;
    /**
     * The Destinations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1
     */
    public $Destinations;
    /**
     * The Filters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValueFilter
     */
    public $Filters;
    /**
     * The OrderBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderBy;
    /**
     * Constructor method for TrackAdvertWithFiltersPaged
     * @uses TrackAdvertWithFiltersPaged::setCurrentPage()
     * @uses TrackAdvertWithFiltersPaged::setRowsPerPage()
     * @uses TrackAdvertWithFiltersPaged::setSCultureID()
     * @uses TrackAdvertWithFiltersPaged::setSAPIKey()
     * @uses TrackAdvertWithFiltersPaged::setSUsername()
     * @uses TrackAdvertWithFiltersPaged::setSUserIdentifier()
     * @uses TrackAdvertWithFiltersPaged::setSStartOrganisation()
     * @uses TrackAdvertWithFiltersPaged::setSAdvertIdentifier()
     * @uses TrackAdvertWithFiltersPaged::setSAdvertReference()
     * @uses TrackAdvertWithFiltersPaged::setSAdvertID()
     * @uses TrackAdvertWithFiltersPaged::setSSearchDays()
     * @uses TrackAdvertWithFiltersPaged::setDestinations()
     * @uses TrackAdvertWithFiltersPaged::setFilters()
     * @uses TrackAdvertWithFiltersPaged::setOrderBy()
     * @param int $currentPage
     * @param int $rowsPerPage
     * @param string $sCultureID
     * @param string $sAPIKey
     * @param string $sUsername
     * @param string $sUserIdentifier
     * @param string $sStartOrganisation
     * @param string $sAdvertIdentifier
     * @param string $sAdvertReference
     * @param string $sAdvertID
     * @param string $sSearchDays
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $destinations
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValueFilter $filters
     * @param string $orderBy
     */
    public function __construct($currentPage = null, $rowsPerPage = null, $sCultureID = null, $sAPIKey = null, $sUsername = null, $sUserIdentifier = null, $sStartOrganisation = null, $sAdvertIdentifier = null, $sAdvertReference = null, $sAdvertID = null, $sSearchDays = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $destinations = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValueFilter $filters = null, $orderBy = null)
    {
        $this
            ->setCurrentPage($currentPage)
            ->setRowsPerPage($rowsPerPage)
            ->setSCultureID($sCultureID)
            ->setSAPIKey($sAPIKey)
            ->setSUsername($sUsername)
            ->setSUserIdentifier($sUserIdentifier)
            ->setSStartOrganisation($sStartOrganisation)
            ->setSAdvertIdentifier($sAdvertIdentifier)
            ->setSAdvertReference($sAdvertReference)
            ->setSAdvertID($sAdvertID)
            ->setSSearchDays($sSearchDays)
            ->setDestinations($destinations)
            ->setFilters($filters)
            ->setOrderBy($orderBy);
    }
    /**
     * Get CurrentPage value
     * @return int
     */
    public function getCurrentPage()
    {
        return $this->CurrentPage;
    }
    /**
     * Set CurrentPage value
     * @param int $currentPage
     * @return \RecruitCrm\LogicMelon\StructType\TrackAdvertWithFiltersPaged
     */
    public function setCurrentPage($currentPage = null)
    {
        // validation for constraint: int
        if (!is_null($currentPage) && !(is_int($currentPage) || ctype_digit($currentPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentPage, true), gettype($currentPage)), __LINE__);
        }
        $this->CurrentPage = $currentPage;
        return $this;
    }
    /**
     * Get RowsPerPage value
     * @return int
     */
    public function getRowsPerPage()
    {
        return $this->RowsPerPage;
    }
    /**
     * Set RowsPerPage value
     * @param int $rowsPerPage
     * @return \RecruitCrm\LogicMelon\StructType\TrackAdvertWithFiltersPaged
     */
    public function setRowsPerPage($rowsPerPage = null)
    {
        // validation for constraint: int
        if (!is_null($rowsPerPage) && !(is_int($rowsPerPage) || ctype_digit($rowsPerPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowsPerPage, true), gettype($rowsPerPage)), __LINE__);
        }
        $this->RowsPerPage = $rowsPerPage;
        return $this;
    }
    /**
     * Get sCultureID value
     * @return string|null
     */
    public function getSCultureID()
    {
        return $this->sCultureID;
    }
    /**
     * Set sCultureID value
     * @param string $sCultureID
     * @return \RecruitCrm\LogicMelon\StructType\TrackAdvertWithFiltersPaged
     */
    public function setSCultureID($sCultureID = null)
    {
        // validation for constraint: string
        if (!is_null($sCultureID) && !is_string($sCultureID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sCultureID, true), gettype($sCultureID)), __LINE__);
        }
        $this->sCultureID = $sCultureID;
        return $this;
    }
    /**
     * Get sAPIKey value
     * @return string|null
     */
    public function getSAPIKey()
    {
        return $this->sAPIKey;
    }
    /**
     * Set sAPIKey value
     * @param string $sAPIKey
     * @return \RecruitCrm\LogicMelon\StructType\TrackAdvertWithFiltersPaged
     */
    public function setSAPIKey($sAPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($sAPIKey) && !is_string($sAPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAPIKey, true), gettype($sAPIKey)), __LINE__);
        }
        $this->sAPIKey = $sAPIKey;
        return $this;
    }
    /**
     * Get sUsername value
     * @return string|null
     */
    public function getSUsername()
    {
        return $this->sUsername;
    }
    /**
     * Set sUsername value
     * @param string $sUsername
     * @return \RecruitCrm\LogicMelon\StructType\TrackAdvertWithFiltersPaged
     */
    public function setSUsername($sUsername = null)
    {
        // validation for constraint: string
        if (!is_null($sUsername) && !is_string($sUsername)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUsername, true), gettype($sUsername)), __LINE__);
        }
        $this->sUsername = $sUsername;
        return $this;
    }
    /**
     * Get sUserIdentifier value
     * @return string|null
     */
    public function getSUserIdentifier()
    {
        return $this->sUserIdentifier;
    }
    /**
     * Set sUserIdentifier value
     * @param string $sUserIdentifier
     * @return \RecruitCrm\LogicMelon\StructType\TrackAdvertWithFiltersPaged
     */
    public function setSUserIdentifier($sUserIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($sUserIdentifier) && !is_string($sUserIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUserIdentifier, true), gettype($sUserIdentifier)), __LINE__);
        }
        $this->sUserIdentifier = $sUserIdentifier;
        return $this;
    }
    /**
     * Get sStartOrganisation value
     * @return string|null
     */
    public function getSStartOrganisation()
    {
        return $this->sStartOrganisation;
    }
    /**
     * Set sStartOrganisation value
     * @param string $sStartOrganisation
     * @return \RecruitCrm\LogicMelon\StructType\TrackAdvertWithFiltersPaged
     */
    public function setSStartOrganisation($sStartOrganisation = null)
    {
        // validation for constraint: string
        if (!is_null($sStartOrganisation) && !is_string($sStartOrganisation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sStartOrganisation, true), gettype($sStartOrganisation)), __LINE__);
        }
        $this->sStartOrganisation = $sStartOrganisation;
        return $this;
    }
    /**
     * Get sAdvertIdentifier value
     * @return string|null
     */
    public function getSAdvertIdentifier()
    {
        return $this->sAdvertIdentifier;
    }
    /**
     * Set sAdvertIdentifier value
     * @param string $sAdvertIdentifier
     * @return \RecruitCrm\LogicMelon\StructType\TrackAdvertWithFiltersPaged
     */
    public function setSAdvertIdentifier($sAdvertIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($sAdvertIdentifier) && !is_string($sAdvertIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAdvertIdentifier, true), gettype($sAdvertIdentifier)), __LINE__);
        }
        $this->sAdvertIdentifier = $sAdvertIdentifier;
        return $this;
    }
    /**
     * Get sAdvertReference value
     * @return string|null
     */
    public function getSAdvertReference()
    {
        return $this->sAdvertReference;
    }
    /**
     * Set sAdvertReference value
     * @param string $sAdvertReference
     * @return \RecruitCrm\LogicMelon\StructType\TrackAdvertWithFiltersPaged
     */
    public function setSAdvertReference($sAdvertReference = null)
    {
        // validation for constraint: string
        if (!is_null($sAdvertReference) && !is_string($sAdvertReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAdvertReference, true), gettype($sAdvertReference)), __LINE__);
        }
        $this->sAdvertReference = $sAdvertReference;
        return $this;
    }
    /**
     * Get sAdvertID value
     * @return string|null
     */
    public function getSAdvertID()
    {
        return $this->sAdvertID;
    }
    /**
     * Set sAdvertID value
     * @param string $sAdvertID
     * @return \RecruitCrm\LogicMelon\StructType\TrackAdvertWithFiltersPaged
     */
    public function setSAdvertID($sAdvertID = null)
    {
        // validation for constraint: string
        if (!is_null($sAdvertID) && !is_string($sAdvertID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAdvertID, true), gettype($sAdvertID)), __LINE__);
        }
        $this->sAdvertID = $sAdvertID;
        return $this;
    }
    /**
     * Get sSearchDays value
     * @return string|null
     */
    public function getSSearchDays()
    {
        return $this->sSearchDays;
    }
    /**
     * Set sSearchDays value
     * @param string $sSearchDays
     * @return \RecruitCrm\LogicMelon\StructType\TrackAdvertWithFiltersPaged
     */
    public function setSSearchDays($sSearchDays = null)
    {
        // validation for constraint: string
        if (!is_null($sSearchDays) && !is_string($sSearchDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSearchDays, true), gettype($sSearchDays)), __LINE__);
        }
        $this->sSearchDays = $sSearchDays;
        return $this;
    }
    /**
     * Get Destinations value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1|null
     */
    public function getDestinations()
    {
        return $this->Destinations;
    }
    /**
     * Set Destinations value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $destinations
     * @return \RecruitCrm\LogicMelon\StructType\TrackAdvertWithFiltersPaged
     */
    public function setDestinations(\RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $destinations = null)
    {
        $this->Destinations = $destinations;
        return $this;
    }
    /**
     * Get Filters value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValueFilter|null
     */
    public function getFilters()
    {
        return $this->Filters;
    }
    /**
     * Set Filters value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValueFilter $filters
     * @return \RecruitCrm\LogicMelon\StructType\TrackAdvertWithFiltersPaged
     */
    public function setFilters(\RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValueFilter $filters = null)
    {
        $this->Filters = $filters;
        return $this;
    }
    /**
     * Get OrderBy value
     * @return string|null
     */
    public function getOrderBy()
    {
        return $this->OrderBy;
    }
    /**
     * Set OrderBy value
     * @param string $orderBy
     * @return \RecruitCrm\LogicMelon\StructType\TrackAdvertWithFiltersPaged
     */
    public function setOrderBy($orderBy = null)
    {
        // validation for constraint: string
        if (!is_null($orderBy) && !is_string($orderBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderBy, true), gettype($orderBy)), __LINE__);
        }
        $this->OrderBy = $orderBy;
        return $this;
    }
}
