<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLiveAdvertPostingsPaged StructType
 * @subpackage Structs
 */
class GetLiveAdvertPostingsPaged extends AbstractStructBase
{
    /**
     * The CurrentPage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CurrentPage;
    /**
     * The RowsPerPage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RowsPerPage;
    /**
     * The sCultureID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sCultureID;
    /**
     * The sAPIKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAPIKey;
    /**
     * The Destinations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1
     */
    public $Destinations;
    /**
     * The OrderBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderBy;
    /**
     * Constructor method for GetLiveAdvertPostingsPaged
     * @uses GetLiveAdvertPostingsPaged::setCurrentPage()
     * @uses GetLiveAdvertPostingsPaged::setRowsPerPage()
     * @uses GetLiveAdvertPostingsPaged::setSCultureID()
     * @uses GetLiveAdvertPostingsPaged::setSAPIKey()
     * @uses GetLiveAdvertPostingsPaged::setDestinations()
     * @uses GetLiveAdvertPostingsPaged::setOrderBy()
     * @param int $currentPage
     * @param int $rowsPerPage
     * @param string $sCultureID
     * @param string $sAPIKey
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $destinations
     * @param string $orderBy
     */
    public function __construct($currentPage = null, $rowsPerPage = null, $sCultureID = null, $sAPIKey = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $destinations = null, $orderBy = null)
    {
        $this
            ->setCurrentPage($currentPage)
            ->setRowsPerPage($rowsPerPage)
            ->setSCultureID($sCultureID)
            ->setSAPIKey($sAPIKey)
            ->setDestinations($destinations)
            ->setOrderBy($orderBy);
    }
    /**
     * Get CurrentPage value
     * @return int
     */
    public function getCurrentPage()
    {
        return $this->CurrentPage;
    }
    /**
     * Set CurrentPage value
     * @param int $currentPage
     * @return \RecruitCrm\LogicMelon\StructType\GetLiveAdvertPostingsPaged
     */
    public function setCurrentPage($currentPage = null)
    {
        // validation for constraint: int
        if (!is_null($currentPage) && !(is_int($currentPage) || ctype_digit($currentPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentPage, true), gettype($currentPage)), __LINE__);
        }
        $this->CurrentPage = $currentPage;
        return $this;
    }
    /**
     * Get RowsPerPage value
     * @return int
     */
    public function getRowsPerPage()
    {
        return $this->RowsPerPage;
    }
    /**
     * Set RowsPerPage value
     * @param int $rowsPerPage
     * @return \RecruitCrm\LogicMelon\StructType\GetLiveAdvertPostingsPaged
     */
    public function setRowsPerPage($rowsPerPage = null)
    {
        // validation for constraint: int
        if (!is_null($rowsPerPage) && !(is_int($rowsPerPage) || ctype_digit($rowsPerPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowsPerPage, true), gettype($rowsPerPage)), __LINE__);
        }
        $this->RowsPerPage = $rowsPerPage;
        return $this;
    }
    /**
     * Get sCultureID value
     * @return string|null
     */
    public function getSCultureID()
    {
        return $this->sCultureID;
    }
    /**
     * Set sCultureID value
     * @param string $sCultureID
     * @return \RecruitCrm\LogicMelon\StructType\GetLiveAdvertPostingsPaged
     */
    public function setSCultureID($sCultureID = null)
    {
        // validation for constraint: string
        if (!is_null($sCultureID) && !is_string($sCultureID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sCultureID, true), gettype($sCultureID)), __LINE__);
        }
        $this->sCultureID = $sCultureID;
        return $this;
    }
    /**
     * Get sAPIKey value
     * @return string|null
     */
    public function getSAPIKey()
    {
        return $this->sAPIKey;
    }
    /**
     * Set sAPIKey value
     * @param string $sAPIKey
     * @return \RecruitCrm\LogicMelon\StructType\GetLiveAdvertPostingsPaged
     */
    public function setSAPIKey($sAPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($sAPIKey) && !is_string($sAPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAPIKey, true), gettype($sAPIKey)), __LINE__);
        }
        $this->sAPIKey = $sAPIKey;
        return $this;
    }
    /**
     * Get Destinations value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1|null
     */
    public function getDestinations()
    {
        return $this->Destinations;
    }
    /**
     * Set Destinations value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $destinations
     * @return \RecruitCrm\LogicMelon\StructType\GetLiveAdvertPostingsPaged
     */
    public function setDestinations(\RecruitCrm\LogicMelon\ArrayType\ArrayOfString_1 $destinations = null)
    {
        $this->Destinations = $destinations;
        return $this;
    }
    /**
     * Get OrderBy value
     * @return string|null
     */
    public function getOrderBy()
    {
        return $this->OrderBy;
    }
    /**
     * Set OrderBy value
     * @param string $orderBy
     * @return \RecruitCrm\LogicMelon\StructType\GetLiveAdvertPostingsPaged
     */
    public function setOrderBy($orderBy = null)
    {
        // validation for constraint: string
        if (!is_null($orderBy) && !is_string($orderBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderBy, true), gettype($orderBy)), __LINE__);
        }
        $this->OrderBy = $orderBy;
        return $this;
    }
}
