<?php

namespace RecruitCrm\LogicMelon\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Query ServiceType
 * @subpackage Services
 */
class Query extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named QueryLocations
     * Meta information extracted from the WSDL
     * - documentation: <a name='QueryLocations'></a><p>Perform a location query. For a specific location specify LocationValue, or to search specify q (minimum 2 characters) along with a priority or prefix</p><ul><li><strong>q</strong> free text query
     * (e.g. Cam)</li><li><strong>prefix</strong> Results only in a specific country (e.g. US) or county (e.g. GB.EEEC for Cambridgeshire).</li><li><strong>priority</strong> Give higher scores by country (e.g. US) or county (e.g. GB.EEEC for
     * Cambridgeshire).</li><li><em>LocationValue</em> Return the data for a specific known location e.g. GB.EEEC.0460 for Cambridge in Cambridgeshire.</li></ul><meta name='viewport' content='width=device-width, initial-scale=1.0' /><style
     * type='text/css'>/* 30 Sep 2019, PJM, api.logicmelon.com css styles*[:slash:]html { font-size: 1em; }@media (max-width: 770px) { html, table {font-size: 150%;margin-left: 0px;}body {margin: 0px;}body div,p,h1,h2,h3,li,ul, table td{margin-left: 0px
     * !important;}html, h1, h2, h3, p {padding: 0px 5px 0px 5px;}h2 {word-break: break-all;}table {width:100%;}table td {display: block;}input[type=text],select,textarea {width:100%;}pre { white-space: pre-wrap; word-wrap: break-word; text-align: left;
     * font-size:120%; }.heading1 {width: 100%;padding: 5px 0px;text-indent: 15px;}#wrap,#header,#navi,#main-top,#col-centre, #col-centre-wide, #col-left, #col-left-wide,.module-left {width:100%;}#main-top{margin-left:5px !important;
     * background:none;}.module-left li { width: 95%; margin: 1px 0px 0px 0px; padding: 0 0 0 10px; }#main-bottom {background:none;}.box-head { background-position-x: 4px; } #content a {display:block;}}</style> | <a name='QueryLocations'></a><p>Perform a
     * location query. For a specific location specify LocationValue, or to search specify q (minimum 2 characters) along with a priority or prefix</p><ul><li><strong>q</strong> free text query (e.g. Cam)</li><li><strong>prefix</strong> Results only in a
     * specific country (e.g. US) or county (e.g. GB.EEEC for Cambridgeshire).</li><li><strong>priority</strong> Give higher scores by country (e.g. US) or county (e.g. GB.EEEC for Cambridgeshire).</li><li><em>LocationValue</em> Return the data for a
     * specific known location e.g. GB.EEEC.0460 for Cambridge in Cambridgeshire.</li></ul><meta name='viewport' content='width=device-width, initial-scale=1.0' /><style type='text/css'>/* 30 Sep 2019, PJM, api.logicmelon.com css styles*[:slash:]html {
     * font-size: 1em; }@media (max-width: 770px) { html, table {font-size: 150%;margin-left: 0px;}body {margin: 0px;}body div,p,h1,h2,h3,li,ul, table td{margin-left: 0px !important;}html, h1, h2, h3, p {padding: 0px 5px 0px 5px;}h2 {word-break:
     * break-all;}table {width:100%;}table td {display: block;}input[type=text],select,textarea {width:100%;}pre { white-space: pre-wrap; word-wrap: break-word; text-align: left; font-size:120%; }.heading1 {width: 100%;padding: 5px 0px;text-indent:
     * 15px;}#wrap,#header,#navi,#main-top,#col-centre, #col-centre-wide, #col-left, #col-left-wide,.module-left {width:100%;}#main-top{margin-left:5px !important; background:none;}.module-left li { width: 95%; margin: 1px 0px 0px 0px; padding: 0 0 0 10px;
     * }#main-bottom {background:none;}.box-head { background-position-x: 4px; } #content a {display:block;}}</style> | <a name='QueryLocations'></a><p>Perform a location query. For a specific location specify LocationValue, or to search specify q (minimum
     * 2 characters) along with a priority or prefix</p><ul><li><strong>q</strong> free text query (e.g. Cam)</li><li><strong>prefix</strong> Results only in a specific country (e.g. US) or county (e.g. GB.EEEC for
     * Cambridgeshire).</li><li><strong>priority</strong> Give higher scores by country (e.g. US) or county (e.g. GB.EEEC for Cambridgeshire).</li><li><em>LocationValue</em> Return the data for a specific known location e.g. GB.EEEC.0460 for Cambridge in
     * Cambridgeshire.</li></ul><meta name='viewport' content='width=device-width, initial-scale=1.0' /><style type='text/css'>/* 30 Sep 2019, PJM, api.logicmelon.com css styles*[:slash:]html { font-size: 1em; }@media (max-width: 770px) { html, table
     * {font-size: 150%;margin-left: 0px;}body {margin: 0px;}body div,p,h1,h2,h3,li,ul, table td{margin-left: 0px !important;}html, h1, h2, h3, p {padding: 0px 5px 0px 5px;}h2 {word-break: break-all;}table {width:100%;}table td {display:
     * block;}input[type=text],select,textarea {width:100%;}pre { white-space: pre-wrap; word-wrap: break-word; text-align: left; font-size:120%; }.heading1 {width: 100%;padding: 5px 0px;text-indent: 15px;}#wrap,#header,#navi,#main-top,#col-centre,
     * #col-centre-wide, #col-left, #col-left-wide,.module-left {width:100%;}#main-top{margin-left:5px !important; background:none;}.module-left li { width: 95%; margin: 1px 0px 0px 0px; padding: 0 0 0 10px; }#main-bottom {background:none;}.box-head {
     * background-position-x: 4px; } #content a {display:block;}}</style>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\QueryLocations $parameters
     * @return \RecruitCrm\LogicMelon\StructType\QueryLocationsResponse|bool
     */
    public function QueryLocations(\RecruitCrm\LogicMelon\StructType\QueryLocations $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryLocations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QueryJobTitle
     * Meta information extracted from the WSDL
     * - documentation: <a name='QueryJobTitle'></a><p>Perform a job title query. For a specific location specify LocationValue, or to search specify q (minimum 2 characters) along with a priority or prefix</p><ul><li><strong>q</strong> free text query
     * (e.g. Project)</li><li><em>Industry</em> Return job titles in a specific industry.</li></ul><meta name='viewport' content='width=device-width, initial-scale=1.0' /><style type='text/css'>/* 30 Sep 2019, PJM, api.logicmelon.com css
     * styles*[:slash:]html { font-size: 1em; }@media (max-width: 770px) { html, table {font-size: 150%;margin-left: 0px;}body {margin: 0px;}body div,p,h1,h2,h3,li,ul, table td{margin-left: 0px !important;}html, h1, h2, h3, p {padding: 0px 5px 0px 5px;}h2
     * {word-break: break-all;}table {width:100%;}table td {display: block;}input[type=text],select,textarea {width:100%;}pre { white-space: pre-wrap; word-wrap: break-word; text-align: left; font-size:120%; }.heading1 {width: 100%;padding: 5px
     * 0px;text-indent: 15px;}#wrap,#header,#navi,#main-top,#col-centre, #col-centre-wide, #col-left, #col-left-wide,.module-left {width:100%;}#main-top{margin-left:5px !important; background:none;}.module-left li { width: 95%; margin: 1px 0px 0px 0px;
     * padding: 0 0 0 10px; }#main-bottom {background:none;}.box-head { background-position-x: 4px; } #content a {display:block;}}</style> | <a name='QueryJobTitle'></a><p>Perform a job title query. For a specific location specify LocationValue, or to
     * search specify q (minimum 2 characters) along with a priority or prefix</p><ul><li><strong>q</strong> free text query (e.g. Project)</li><li><em>Industry</em> Return job titles in a specific industry.</li></ul><meta name='viewport'
     * content='width=device-width, initial-scale=1.0' /><style type='text/css'>/* 30 Sep 2019, PJM, api.logicmelon.com css styles*[:slash:]html { font-size: 1em; }@media (max-width: 770px) { html, table {font-size: 150%;margin-left: 0px;}body {margin:
     * 0px;}body div,p,h1,h2,h3,li,ul, table td{margin-left: 0px !important;}html, h1, h2, h3, p {padding: 0px 5px 0px 5px;}h2 {word-break: break-all;}table {width:100%;}table td {display: block;}input[type=text],select,textarea {width:100%;}pre {
     * white-space: pre-wrap; word-wrap: break-word; text-align: left; font-size:120%; }.heading1 {width: 100%;padding: 5px 0px;text-indent: 15px;}#wrap,#header,#navi,#main-top,#col-centre, #col-centre-wide, #col-left, #col-left-wide,.module-left
     * {width:100%;}#main-top{margin-left:5px !important; background:none;}.module-left li { width: 95%; margin: 1px 0px 0px 0px; padding: 0 0 0 10px; }#main-bottom {background:none;}.box-head { background-position-x: 4px; } #content a
     * {display:block;}}</style> | <a name='QueryJobTitle'></a><p>Perform a job title query. For a specific location specify LocationValue, or to search specify q (minimum 2 characters) along with a priority or prefix</p><ul><li><strong>q</strong> free text
     * query (e.g. Project)</li><li><em>Industry</em> Return job titles in a specific industry.</li></ul><meta name='viewport' content='width=device-width, initial-scale=1.0' /><style type='text/css'>/* 30 Sep 2019, PJM, api.logicmelon.com css
     * styles*[:slash:]html { font-size: 1em; }@media (max-width: 770px) { html, table {font-size: 150%;margin-left: 0px;}body {margin: 0px;}body div,p,h1,h2,h3,li,ul, table td{margin-left: 0px !important;}html, h1, h2, h3, p {padding: 0px 5px 0px 5px;}h2
     * {word-break: break-all;}table {width:100%;}table td {display: block;}input[type=text],select,textarea {width:100%;}pre { white-space: pre-wrap; word-wrap: break-word; text-align: left; font-size:120%; }.heading1 {width: 100%;padding: 5px
     * 0px;text-indent: 15px;}#wrap,#header,#navi,#main-top,#col-centre, #col-centre-wide, #col-left, #col-left-wide,.module-left {width:100%;}#main-top{margin-left:5px !important; background:none;}.module-left li { width: 95%; margin: 1px 0px 0px 0px;
     * padding: 0 0 0 10px; }#main-bottom {background:none;}.box-head { background-position-x: 4px; } #content a {display:block;}}</style>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\QueryJobTitle $parameters
     * @return \RecruitCrm\LogicMelon\StructType\QueryJobTitleResponse|bool
     */
    public function QueryJobTitle(\RecruitCrm\LogicMelon\StructType\QueryJobTitle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryJobTitle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \RecruitCrm\LogicMelon\StructType\QueryJobTitleResponse|\RecruitCrm\LogicMelon\StructType\QueryLocationsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
