<?php

namespace RecruitCrm\LogicMelon\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAPIApplication ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAPIApplication
 * @subpackage Arrays
 */
class ArrayOfAPIApplication extends AbstractStructArrayBase
{
    /**
     * The APIApplication
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \RecruitCrm\LogicMelon\StructType\APIApplication[]
     */
    public $APIApplication;
    /**
     * Constructor method for ArrayOfAPIApplication
     * @uses ArrayOfAPIApplication::setAPIApplication()
     * @param \RecruitCrm\LogicMelon\StructType\APIApplication[] $aPIApplication
     */
    public function __construct(array $aPIApplication = array())
    {
        $this
            ->setAPIApplication($aPIApplication);
    }
    /**
     * Get APIApplication value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication[]|null
     */
    public function getAPIApplication()
    {
        return isset($this->APIApplication) ? $this->APIApplication : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAPIApplication method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAPIApplication method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAPIApplicationForArrayConstraintsFromSetAPIApplication(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAPIApplicationAPIApplicationItem) {
            // validation for constraint: itemType
            if (!$arrayOfAPIApplicationAPIApplicationItem instanceof \RecruitCrm\LogicMelon\StructType\APIApplication) {
                $invalidValues[] = is_object($arrayOfAPIApplicationAPIApplicationItem) ? get_class($arrayOfAPIApplicationAPIApplicationItem) : sprintf('%s(%s)', gettype($arrayOfAPIApplicationAPIApplicationItem), var_export($arrayOfAPIApplicationAPIApplicationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The APIApplication property can only contain items of type \RecruitCrm\LogicMelon\StructType\APIApplication, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set APIApplication value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \RecruitCrm\LogicMelon\StructType\APIApplication[] $aPIApplication
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIApplication
     */
    public function setAPIApplication(array $aPIApplication = array())
    {
        // validation for constraint: array
        if ('' !== ($aPIApplicationArrayErrorMessage = self::validateAPIApplicationForArrayConstraintsFromSetAPIApplication($aPIApplication))) {
            throw new \InvalidArgumentException($aPIApplicationArrayErrorMessage, __LINE__);
        }
        if (is_null($aPIApplication) || (is_array($aPIApplication) && empty($aPIApplication))) {
            unset($this->APIApplication);
        } else {
            $this->APIApplication = $aPIApplication;
        }
        return $this;
    }
    /**
     * Add item to APIApplication value
     * @throws \InvalidArgumentException
     * @param \RecruitCrm\LogicMelon\StructType\APIApplication $item
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIApplication
     */
    public function addToAPIApplication(\RecruitCrm\LogicMelon\StructType\APIApplication $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RecruitCrm\LogicMelon\StructType\APIApplication) {
            throw new \InvalidArgumentException(sprintf('The APIApplication property can only contain items of type \RecruitCrm\LogicMelon\StructType\APIApplication, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->APIApplication[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \RecruitCrm\LogicMelon\StructType\APIApplication|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string APIApplication
     */
    public function getAttributeName()
    {
        return 'APIApplication';
    }
}
