<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APIAdvertPaged StructType
 * @subpackage Structs
 */
class APIAdvertPaged extends AbstractStructBase
{
    /**
     * The PageCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageCount;
    /**
     * The PageIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageIndex;
    /**
     * The TotalItemCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TotalItemCount;
    /**
     * The Adverts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvert
     */
    public $Adverts;
    /**
     * Constructor method for APIAdvertPaged
     * @uses APIAdvertPaged::setPageCount()
     * @uses APIAdvertPaged::setPageIndex()
     * @uses APIAdvertPaged::setTotalItemCount()
     * @uses APIAdvertPaged::setAdverts()
     * @param int $pageCount
     * @param int $pageIndex
     * @param int $totalItemCount
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvert $adverts
     */
    public function __construct($pageCount = null, $pageIndex = null, $totalItemCount = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvert $adverts = null)
    {
        $this
            ->setPageCount($pageCount)
            ->setPageIndex($pageIndex)
            ->setTotalItemCount($totalItemCount)
            ->setAdverts($adverts);
    }
    /**
     * Get PageCount value
     * @return int
     */
    public function getPageCount()
    {
        return $this->PageCount;
    }
    /**
     * Set PageCount value
     * @param int $pageCount
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertPaged
     */
    public function setPageCount($pageCount = null)
    {
        // validation for constraint: int
        if (!is_null($pageCount) && !(is_int($pageCount) || ctype_digit($pageCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageCount, true), gettype($pageCount)), __LINE__);
        }
        $this->PageCount = $pageCount;
        return $this;
    }
    /**
     * Get PageIndex value
     * @return int
     */
    public function getPageIndex()
    {
        return $this->PageIndex;
    }
    /**
     * Set PageIndex value
     * @param int $pageIndex
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertPaged
     */
    public function setPageIndex($pageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($pageIndex) && !(is_int($pageIndex) || ctype_digit($pageIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageIndex, true), gettype($pageIndex)), __LINE__);
        }
        $this->PageIndex = $pageIndex;
        return $this;
    }
    /**
     * Get TotalItemCount value
     * @return int
     */
    public function getTotalItemCount()
    {
        return $this->TotalItemCount;
    }
    /**
     * Set TotalItemCount value
     * @param int $totalItemCount
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertPaged
     */
    public function setTotalItemCount($totalItemCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalItemCount) && !(is_int($totalItemCount) || ctype_digit($totalItemCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalItemCount, true), gettype($totalItemCount)), __LINE__);
        }
        $this->TotalItemCount = $totalItemCount;
        return $this;
    }
    /**
     * Get Adverts value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvert|null
     */
    public function getAdverts()
    {
        return $this->Adverts;
    }
    /**
     * Set Adverts value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvert $adverts
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertPaged
     */
    public function setAdverts(\RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvert $adverts = null)
    {
        $this->Adverts = $adverts;
        return $this;
    }
}
