<?php

namespace RecruitCrm\LogicMelon\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetApplicationsPaged
     * Meta information extracted from the WSDL
     * - documentation: <a name='GetApplicationsPaged'></a><p>Paged version of GetApplications. Provides a mechanism to search for applications by job, job board or time on the database and return some basic information along with the ability to include
     * source documents and parsed data.</p><ul><li>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</li><li>At a minimum 1
     * search filter must be specified to find (1) either a job or (2) an application time period.</li><li><strong>Destinations</strong> are either numeric (FeedID) or string (FeedIdentifier)</li><li><strong>ApplicationDateTime</strong> A variety of date
     * formats are supported but the safest may be yyyy-MM-d HH:mm:ss (24 hour clock UTC).</li><li><strong>Ranking</strong> can be string or numeric Unranked (0), Unsuitable (1), MaybeSuitable (2), Suitable (4)</li><li><strong>ProgressID</strong> must be
     * numeric and values can be requested from support or determined from the main recruiter interface</li> <li>Default <strong>SortOrder</strong>: ScorePreSort asc, Score desc, ScoreExtra desc, Favourite desc, ApplicationDate desc, AdvertCandidateID
     * desc</li><li><strong>CurrentPage</strong> and <strong>RowsPerPage</strong> must always be supplied</li><li><strong>IncludeParsed</strong> You can choose to include parsed data (if you have parsing activated on your account) which is generally in an
     * HRXML format</li><li><strong>IncludeEmailBody, IncludeAttachment, IncludeEmail</strong> You can choose to include parts of the actual application email. From the full email (IncludeEmail) to just the body content (IncludeEmailBody) and the probable
     * most appropriate attachment (IncludeAttachment).</li><li>Extra documents are either returned in the string Document property (email body) or the byte array (byte[]) DocumentBytes (email, parsed, attachment) as
     * appropriate.</li><li><strong>AdvertCandidateIDAsCSV</strong> You may want to select which applications to import and then re-request the data using <strong>AdvertCandidateIDAsCSV</strong> to retrieve the exact parsed data, attachments or emails for
     * the specific applications you need.</li><li><strong>LastScoreDate, LastProgressDate</strong> The date and time (UTC) and action was last performed on an application (score is flagging and progress is replying/progressing).</li></ul> | <a
     * name='GetApplicationsPaged'></a><p>Paged version of GetApplications. Provides a mechanism to search for applications by job, job board or time on the database and return some basic information along with the ability to include source documents and
     * parsed data.</p><ul><li>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</li><li>At a minimum 1 search filter must be
     * specified to find (1) either a job or (2) an application time period.</li><li><strong>Destinations</strong> are either numeric (FeedID) or string (FeedIdentifier)</li><li><strong>ApplicationDateTime</strong> A variety of date formats are supported
     * but the safest may be yyyy-MM-d HH:mm:ss (24 hour clock UTC).</li><li><strong>Ranking</strong> can be string or numeric Unranked (0), Unsuitable (1), MaybeSuitable (2), Suitable (4)</li><li><strong>ProgressID</strong> must be numeric and values can
     * be requested from support or determined from the main recruiter interface</li> <li>Default <strong>SortOrder</strong>: ScorePreSort asc, Score desc, ScoreExtra desc, Favourite desc, ApplicationDate desc, AdvertCandidateID
     * desc</li><li><strong>CurrentPage</strong> and <strong>RowsPerPage</strong> must always be supplied</li><li><strong>IncludeParsed</strong> You can choose to include parsed data (if you have parsing activated on your account) which is generally in an
     * HRXML format</li><li><strong>IncludeEmailBody, IncludeAttachment, IncludeEmail</strong> You can choose to include parts of the actual application email. From the full email (IncludeEmail) to just the body content (IncludeEmailBody) and the probable
     * most appropriate attachment (IncludeAttachment).</li><li>Extra documents are either returned in the string Document property (email body) or the byte array (byte[]) DocumentBytes (email, parsed, attachment) as
     * appropriate.</li><li><strong>AdvertCandidateIDAsCSV</strong> You may want to select which applications to import and then re-request the data using <strong>AdvertCandidateIDAsCSV</strong> to retrieve the exact parsed data, attachments or emails for
     * the specific applications you need.</li><li><strong>LastScoreDate, LastProgressDate</strong> The date and time (UTC) and action was last performed on an application (score is flagging and progress is replying/progressing).</li></ul> | <a
     * name='GetApplicationsPaged'></a><p>Paged version of GetApplications. Provides a mechanism to search for applications by job, job board or time on the database and return some basic information along with the ability to include source documents and
     * parsed data.</p><ul><li>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</li><li>At a minimum 1 search filter must be
     * specified to find (1) either a job or (2) an application time period.</li><li><strong>Destinations</strong> are either numeric (FeedID) or string (FeedIdentifier)</li><li><strong>ApplicationDateTime</strong> A variety of date formats are supported
     * but the safest may be yyyy-MM-d HH:mm:ss (24 hour clock UTC).</li><li><strong>Ranking</strong> can be string or numeric Unranked (0), Unsuitable (1), MaybeSuitable (2), Suitable (4)</li><li><strong>ProgressID</strong> must be numeric and values can
     * be requested from support or determined from the main recruiter interface</li> <li>Default <strong>SortOrder</strong>: ScorePreSort asc, Score desc, ScoreExtra desc, Favourite desc, ApplicationDate desc, AdvertCandidateID
     * desc</li><li><strong>CurrentPage</strong> and <strong>RowsPerPage</strong> must always be supplied</li><li><strong>IncludeParsed</strong> You can choose to include parsed data (if you have parsing activated on your account) which is generally in an
     * HRXML format</li><li><strong>IncludeEmailBody, IncludeAttachment, IncludeEmail</strong> You can choose to include parts of the actual application email. From the full email (IncludeEmail) to just the body content (IncludeEmailBody) and the probable
     * most appropriate attachment (IncludeAttachment).</li><li>Extra documents are either returned in the string Document property (email body) or the byte array (byte[]) DocumentBytes (email, parsed, attachment) as
     * appropriate.</li><li><strong>AdvertCandidateIDAsCSV</strong> You may want to select which applications to import and then re-request the data using <strong>AdvertCandidateIDAsCSV</strong> to retrieve the exact parsed data, attachments or emails for
     * the specific applications you need.</li><li><strong>LastScoreDate, LastProgressDate</strong> The date and time (UTC) and action was last performed on an application (score is flagging and progress is replying/progressing).</li></ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged $parameters
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPagedResponse|bool
     */
    public function GetApplicationsPaged(\RecruitCrm\LogicMelon\StructType\GetApplicationsPaged $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetApplicationsPaged($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetApplications
     * Meta information extracted from the WSDL
     * - documentation: <a name='GetApplications'></a><p>Provides a mechanism to search for applications by job, job board or time on the database and return some basic information along with the ability to include source documents and parsed
     * data.</p><ul><li>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</li><li>At a minimum 1 search filter must be specified
     * to find (1) either a job or (2) an application time period.</li><li><strong>Destinations</strong> are either numeric (FeedID) or string (FeedIdentifier)</li><li><strong>ApplicationDateTime</strong> A variety of date formats are supported but the
     * safest may be yyyy-MM-d HH:mm:ss (24 hour clock UTC).</li><li><strong>Ranking</strong> can be string or numeric Unranked (0), Unsuitable (1), MaybeSuitable (2), Suitable (4)</li><li><strong>ProgressID</strong> must be numeric and values can be
     * requested from support or determined from the main recruiter interface</li> <li>Default <strong>SortOrder</strong>: ApplicationDate asc, AdvertCandidateID asc</li><li><strong>IncludeParsed</strong> You can choose to include parsed data (if you have
     * parsing activated on your account) which is generally in an HRXML format</li><li><strong>IncludeEmailBody, IncludeAttachment, IncludeEmail</strong> You can choose to include parts of the actual application email. From the full email (IncludeEmail) to
     * just the body content (IncludeEmailBody) and the probable most appropriate attachment (IncludeAttachment).</li><li>Extra documents are either returned in the string Document property (email body) or the byte array (byte[]) DocumentBytes (email,
     * parsed, attachment) as appropriate.</li><li><strong>AdvertCandidateIDAsCSV</strong> You may want to select which applications to import and then re-request the data using <strong>AdvertCandidateIDAsCSV</strong> to retrieve the exact parsed data,
     * attachments or emails for the specific applications you need.</li><li><strong>LastScoreDate, LastProgressDate</strong> The date and time (UTC) and action was last performed on an application (score is flagging and progress is
     * replying/progressing).</li></ul> | <a name='GetApplications'></a><p>Provides a mechanism to search for applications by job, job board or time on the database and return some basic information along with the ability to include source documents and
     * parsed data.</p><ul><li>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</li><li>At a minimum 1 search filter must be
     * specified to find (1) either a job or (2) an application time period.</li><li><strong>Destinations</strong> are either numeric (FeedID) or string (FeedIdentifier)</li><li><strong>ApplicationDateTime</strong> A variety of date formats are supported
     * but the safest may be yyyy-MM-d HH:mm:ss (24 hour clock UTC).</li><li><strong>Ranking</strong> can be string or numeric Unranked (0), Unsuitable (1), MaybeSuitable (2), Suitable (4)</li><li><strong>ProgressID</strong> must be numeric and values can
     * be requested from support or determined from the main recruiter interface</li> <li>Default <strong>SortOrder</strong>: ApplicationDate asc, AdvertCandidateID asc</li><li><strong>IncludeParsed</strong> You can choose to include parsed data (if you
     * have parsing activated on your account) which is generally in an HRXML format</li><li><strong>IncludeEmailBody, IncludeAttachment, IncludeEmail</strong> You can choose to include parts of the actual application email. From the full email
     * (IncludeEmail) to just the body content (IncludeEmailBody) and the probable most appropriate attachment (IncludeAttachment).</li><li>Extra documents are either returned in the string Document property (email body) or the byte array (byte[])
     * DocumentBytes (email, parsed, attachment) as appropriate.</li><li><strong>AdvertCandidateIDAsCSV</strong> You may want to select which applications to import and then re-request the data using <strong>AdvertCandidateIDAsCSV</strong> to retrieve the
     * exact parsed data, attachments or emails for the specific applications you need.</li><li><strong>LastScoreDate, LastProgressDate</strong> The date and time (UTC) and action was last performed on an application (score is flagging and progress is
     * replying/progressing).</li></ul> | <a name='GetApplications'></a><p>Provides a mechanism to search for applications by job, job board or time on the database and return some basic information along with the ability to include source documents and
     * parsed data.</p><ul><li>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</li><li>At a minimum 1 search filter must be
     * specified to find (1) either a job or (2) an application time period.</li><li><strong>Destinations</strong> are either numeric (FeedID) or string (FeedIdentifier)</li><li><strong>ApplicationDateTime</strong> A variety of date formats are supported
     * but the safest may be yyyy-MM-d HH:mm:ss (24 hour clock UTC).</li><li><strong>Ranking</strong> can be string or numeric Unranked (0), Unsuitable (1), MaybeSuitable (2), Suitable (4)</li><li><strong>ProgressID</strong> must be numeric and values can
     * be requested from support or determined from the main recruiter interface</li> <li>Default <strong>SortOrder</strong>: ApplicationDate asc, AdvertCandidateID asc</li><li><strong>IncludeParsed</strong> You can choose to include parsed data (if you
     * have parsing activated on your account) which is generally in an HRXML format</li><li><strong>IncludeEmailBody, IncludeAttachment, IncludeEmail</strong> You can choose to include parts of the actual application email. From the full email
     * (IncludeEmail) to just the body content (IncludeEmailBody) and the probable most appropriate attachment (IncludeAttachment).</li><li>Extra documents are either returned in the string Document property (email body) or the byte array (byte[])
     * DocumentBytes (email, parsed, attachment) as appropriate.</li><li><strong>AdvertCandidateIDAsCSV</strong> You may want to select which applications to import and then re-request the data using <strong>AdvertCandidateIDAsCSV</strong> to retrieve the
     * exact parsed data, attachments or emails for the specific applications you need.</li><li><strong>LastScoreDate, LastProgressDate</strong> The date and time (UTC) and action was last performed on an application (score is flagging and progress is
     * replying/progressing).</li></ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\GetApplications $parameters
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsResponse|bool
     */
    public function GetApplications(\RecruitCrm\LogicMelon\StructType\GetApplications $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetApplications($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetApplicationsWithFiltersPaged
     * Meta information extracted from the WSDL
     * - documentation: <a name='GetApplicationsWithFiltersPaged'></a><p>Paged version of GetApplications. Provides a mechanism to search for applications by job, job board or time on the database and return some basic information along with the ability to
     * include source documents and parsed data.</p><ul><li>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</li><li>At a minimum
     * 1 search filter must be specified to find (1) either a job or (2) an application time period.</li><li><strong>Destinations</strong> are either numeric (FeedID) or string (FeedIdentifier)</li><li><strong>ApplicationDateTime</strong> A variety of date
     * formats are supported but the safest may be yyyy-MM-d HH:mm:ss (24 hour clock UTC).</li><li><strong>Ranking</strong> can be string or numeric Unranked (0), Unsuitable (1), MaybeSuitable (2), Suitable (4)</li><li><strong>ProgressID</strong> must be
     * numeric and values can be requested from support or determined from the main recruiter interface</li> <li>Default <strong>SortOrder</strong>: ScorePreSort asc, Score desc, ScoreExtra desc, Favourite desc, ApplicationDate desc, AdvertCandidateID
     * desc</li><li><strong>CurrentPage</strong> and <strong>RowsPerPage</strong> must always be supplied</li><li><strong>IncludeParsed</strong> You can choose to include parsed data (if you have parsing activated on your account) which is generally in an
     * HRXML format</li><li><strong>IncludeEmailBody, IncludeAttachment, IncludeEmail</strong> You can choose to include parts of the actual application email. From the full email (IncludeEmail) to just the body content (IncludeEmailBody) and the probable
     * most appropriate attachment (IncludeAttachment).</li><li>Extra documents are either returned in the string Document property (email body) or the byte array (byte[]) DocumentBytes (email, parsed, attachment) as
     * appropriate.</li><li><strong>AdvertCandidateIDAsCSV</strong> You may want to select which applications to import and then re-request the data using <strong>AdvertCandidateIDAsCSV</strong> to retrieve the exact parsed data, attachments or emails for
     * the specific applications you need.</li><li><strong>LastScoreDate, LastProgressDate</strong> The date and time (UTC) and action was last performed on an application (score is flagging and progress is replying/progressing).</li></ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged $parameters
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPagedResponse|bool
     */
    public function GetApplicationsWithFiltersPaged(\RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPaged $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetApplicationsWithFiltersPaged($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetApplicationsWithFilters
     * Meta information extracted from the WSDL
     * - documentation: <a name='GetApplicationsWithFilters'></a><p>Provides a mechanism to search for applications by job, job board or time on the database and return some basic information along with the ability to include source documents and parsed
     * data.</p><ul><li>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</li><li>At a minimum 1 search filter must be specified
     * to find (1) either a job or (2) an application time period.</li><li><strong>Destinations</strong> are either numeric (FeedID) or string (FeedIdentifier)</li><li><strong>ApplicationDateTime</strong> A variety of date formats are supported but the
     * safest may be yyyy-MM-d HH:mm:ss (24 hour clock UTC).</li><li><strong>Ranking</strong> can be string or numeric Unranked (0), Unsuitable (1), MaybeSuitable (2), Suitable (4)</li><li><strong>ProgressID</strong> must be numeric and values can be
     * requested from support or determined from the main recruiter interface</li> <li>Default <strong>SortOrder</strong>: ApplicationDate asc, AdvertCandidateID asc</li><li><strong>IncludeParsed</strong> You can choose to include parsed data (if you have
     * parsing activated on your account) which is generally in an HRXML format</li><li><strong>IncludeEmailBody, IncludeAttachment, IncludeEmail</strong> You can choose to include parts of the actual application email. From the full email (IncludeEmail) to
     * just the body content (IncludeEmailBody) and the probable most appropriate attachment (IncludeAttachment).</li><li>Extra documents are either returned in the string Document property (email body) or the byte array (byte[]) DocumentBytes (email,
     * parsed, attachment) as appropriate.</li><li><strong>AdvertCandidateIDAsCSV</strong> You may want to select which applications to import and then re-request the data using <strong>AdvertCandidateIDAsCSV</strong> to retrieve the exact parsed data,
     * attachments or emails for the specific applications you need.</li><li><strong>LastScoreDate, LastProgressDate</strong> The date and time (UTC) and action was last performed on an application (score is flagging and progress is
     * replying/progressing).</li></ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFilters $parameters
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersResponse|bool
     */
    public function GetApplicationsWithFilters(\RecruitCrm\LogicMelon\StructType\GetApplicationsWithFilters $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetApplicationsWithFilters($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAdvertPaged
     * Meta information extracted from the WSDL
     * - documentation: <a name='GetAdvertPaged'></a><p>Paged version of GetAdvert. Provides a mechanism to search for a specific advert (with possibly multiple instances) on the database and return some basic information.</p><p>Optionally specify a
     * sUsername or sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</p> | <a name='GetAdvertPaged'></a><p>Paged version of GetAdvert. Provides a mechanism to
     * search for a specific advert (with possibly multiple instances) on the database and return some basic information.</p><p>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or
     * specific portion of the tree (sStartOrganisation).</p> | <a name='GetAdvertPaged'></a><p>Paged version of GetAdvert. Provides a mechanism to search for a specific advert (with possibly multiple instances) on the database and return some basic
     * information.</p><p>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</p>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\GetAdvertPaged $parameters
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertPagedResponse|bool
     */
    public function GetAdvertPaged(\RecruitCrm\LogicMelon\StructType\GetAdvertPaged $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAdvertPaged($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAdvert
     * Meta information extracted from the WSDL
     * - documentation: <a name='GetAdvert'></a><p>Provides a mechanism to search for a specific advert (with possibly multiple instances) on the database and return some basic information.</p><p>Optionally specify a sUsername or sStartOrganisation to limit
     * the search to a specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</p> | <a name='GetAdvert'></a><p>Provides a mechanism to search for a specific advert (with possibly multiple instances) on the
     * database and return some basic information.</p><p>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</p> | <a
     * name='GetAdvert'></a><p>Provides a mechanism to search for a specific advert (with possibly multiple instances) on the database and return some basic information.</p><p>Optionally specify a sUsername or sStartOrganisation to limit the search to a
     * specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</p>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\GetAdvert $parameters
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertResponse|bool
     */
    public function GetAdvert(\RecruitCrm\LogicMelon\StructType\GetAdvert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAdvert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAdvertWithFiltersPaged
     * Meta information extracted from the WSDL
     * - documentation: <a name='GetAdvertWithFiltersPaged'></a><p>Paged version of GetAdvert. Provides a mechanism to search for a specific advert (with possibly multiple instances) on the database and return some basic information.</p><p>Optionally
     * specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</p>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\GetAdvertWithFiltersPaged $parameters
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithFiltersPagedResponse|bool
     */
    public function GetAdvertWithFiltersPaged(\RecruitCrm\LogicMelon\StructType\GetAdvertWithFiltersPaged $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAdvertWithFiltersPaged($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAdvertWithFilters
     * Meta information extracted from the WSDL
     * - documentation: <a name='GetAdvertWithFilters'></a><p>Provides a mechanism to search for a specific advert (with possibly multiple instances) on the database and return some basic information.</p><p>Optionally specify a sUsername or
     * sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</p>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\GetAdvertWithFilters $parameters
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithFiltersResponse|bool
     */
    public function GetAdvertWithFilters(\RecruitCrm\LogicMelon\StructType\GetAdvertWithFilters $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAdvertWithFilters($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAdvertWithValues
     * Meta information extracted from the WSDL
     * - documentation: <a name='GetAdvertWithValues'></a><p>Provides a mechanism to search for a specific advert (with possibly multiple instances) on the database and return some basic information with extra field values included. The extra field values
     * can be filtered by a list of Field identifiers or for Feed specific values by Feed identifiers.</p><p>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or specific portion of
     * the tree (sStartOrganisation).</p> | <a name='GetAdvertWithValues'></a><p>Provides a mechanism to search for a specific advert (with possibly multiple instances) on the database and return some basic information with extra field values included. The
     * extra field values can be filtered by a list of Field identifiers or for Feed specific values by Feed identifiers.</p><p>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or
     * specific portion of the tree (sStartOrganisation).</p> | <a name='GetAdvertWithValues'></a><p>Provides a mechanism to search for a specific advert (with possibly multiple instances) on the database and return some basic information with extra field
     * values included. The extra field values can be filtered by a list of Field identifiers or for Feed specific values by Feed identifiers.</p><p>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or
     * sUserIdentifier) or specific portion of the tree (sStartOrganisation).</p>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\GetAdvertWithValues $parameters
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesResponse|bool
     */
    public function GetAdvertWithValues(\RecruitCrm\LogicMelon\StructType\GetAdvertWithValues $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAdvertWithValues($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAdvertWithValuesPaged
     * Meta information extracted from the WSDL
     * - documentation: <a name='GetAdvertWithValuesPaged'></a><p>Paged version of GetAdvert. Provides a mechanism to search for a specific advert (with possibly multiple instances) on the database and return some basic information with extra field values
     * included. The extra field values can be filtered by a list of Field identifiers or for Feed specific values by Feed identifiers.</p><p>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or
     * sUserIdentifier) or specific portion of the tree (sStartOrganisation).</p> | <a name='GetAdvertWithValuesPaged'></a><p>Paged version of GetAdvert. Provides a mechanism to search for a specific advert (with possibly multiple instances) on the database
     * and return some basic information with extra field values included. The extra field values can be filtered by a list of Field identifiers or for Feed specific values by Feed identifiers.</p><p>Optionally specify a sUsername or sStartOrganisation to
     * limit the search to a specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</p> | <a name='GetAdvertWithValuesPaged'></a><p>Paged version of GetAdvert. Provides a mechanism to search for a specific advert
     * (with possibly multiple instances) on the database and return some basic information with extra field values included. The extra field values can be filtered by a list of Field identifiers or for Feed specific values by Feed
     * identifiers.</p><p>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</p>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesPaged $parameters
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesPagedResponse|bool
     */
    public function GetAdvertWithValuesPaged(\RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesPaged $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAdvertWithValuesPaged($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAdvertWithValuesWithFilters
     * Meta information extracted from the WSDL
     * - documentation: <a name='GetAdvertWithValuesWithFilters'></a><p>Provides a mechanism to search for a specific advert (with possibly multiple instances) on the database and return some basic information with extra field values included. The extra
     * field values can be filtered by a list of Field identifiers or for Feed specific values by Feed identifiers.</p><p>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or specific
     * portion of the tree (sStartOrganisation).</p>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFilters $parameters
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersResponse|bool
     */
    public function GetAdvertWithValuesWithFilters(\RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFilters $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAdvertWithValuesWithFilters($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetAdvertWithValuesWithFiltersPaged
     * Meta information extracted from the WSDL
     * - documentation: <a name='GetAdvertWithValuesWithFiltersPaged'></a><p>Paged version of GetAdvert. Provides a mechanism to search for a specific advert (with possibly multiple instances) on the database and return some basic information with extra
     * field values included. The extra field values can be filtered by a list of Field identifiers or for Feed specific values by Feed identifiers.</p><p>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername
     * or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</p>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersPaged $parameters
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersPagedResponse|bool
     */
    public function GetAdvertWithValuesWithFiltersPaged(\RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersPaged $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAdvertWithValuesWithFiltersPaged($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLiveAdvertPostings
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\GetLiveAdvertPostings $parameters
     * @return \RecruitCrm\LogicMelon\StructType\GetLiveAdvertPostingsResponse|bool
     */
    public function GetLiveAdvertPostings(\RecruitCrm\LogicMelon\StructType\GetLiveAdvertPostings $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLiveAdvertPostings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLiveAdvertPostingsPaged
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\GetLiveAdvertPostingsPaged $parameters
     * @return \RecruitCrm\LogicMelon\StructType\GetLiveAdvertPostingsPagedResponse|bool
     */
    public function GetLiveAdvertPostingsPaged(\RecruitCrm\LogicMelon\StructType\GetLiveAdvertPostingsPaged $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLiveAdvertPostingsPaged($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetValues
     * Meta information extracted from the WSDL
     * - documentation: <a name='GetValues'></a><p>Retrieve lookup data for a specific drop down or radio button or check box</p><meta name='viewport' content='width=device-width, initial-scale=1.0' /><style type='text/css'>/* 30 Sep 2019, PJM,
     * api.logicmelon.com css styles*[:slash:]html { font-size: 1em; }@media (max-width: 770px) { html, table {font-size: 150%;margin-left: 0px;}body {margin: 0px;}body div,p,h1,h2,h3,li,ul, table td{margin-left: 0px !important;}html, h1, h2, h3, p
     * {padding: 0px 5px 0px 5px;}h2 {word-break: break-all;}table {width:100%;}table td {display: block;}input[type=text],select,textarea {width:100%;}pre { white-space: pre-wrap; word-wrap: break-word; text-align: left; font-size:120%; }.heading1 {width:
     * 100%;padding: 5px 0px;text-indent: 15px;}#wrap,#header,#navi,#main-top,#col-centre, #col-centre-wide, #col-left, #col-left-wide,.module-left {width:100%;}#main-top{margin-left:5px !important; background:none;}.module-left li { width: 95%; margin: 1px
     * 0px 0px 0px; padding: 0 0 0 10px; }#main-bottom {background:none;}.box-head { background-position-x: 4px; } #content a {display:block;}}</style> | <a name='GetValues'></a><p>Retrieve lookup data for a specific drop down or radio button or check
     * box</p><meta name='viewport' content='width=device-width, initial-scale=1.0' /><style type='text/css'>/* 30 Sep 2019, PJM, api.logicmelon.com css styles*[:slash:]html { font-size: 1em; }@media (max-width: 770px) { html, table {font-size:
     * 150%;margin-left: 0px;}body {margin: 0px;}body div,p,h1,h2,h3,li,ul, table td{margin-left: 0px !important;}html, h1, h2, h3, p {padding: 0px 5px 0px 5px;}h2 {word-break: break-all;}table {width:100%;}table td {display:
     * block;}input[type=text],select,textarea {width:100%;}pre { white-space: pre-wrap; word-wrap: break-word; text-align: left; font-size:120%; }.heading1 {width: 100%;padding: 5px 0px;text-indent: 15px;}#wrap,#header,#navi,#main-top,#col-centre,
     * #col-centre-wide, #col-left, #col-left-wide,.module-left {width:100%;}#main-top{margin-left:5px !important; background:none;}.module-left li { width: 95%; margin: 1px 0px 0px 0px; padding: 0 0 0 10px; }#main-bottom {background:none;}.box-head {
     * background-position-x: 4px; } #content a {display:block;}}</style> | <a name='GetValues'></a><p>Retrieve lookup data for a specific drop down or radio button or check box</p><meta name='viewport' content='width=device-width, initial-scale=1.0'
     * /><style type='text/css'>/* 30 Sep 2019, PJM, api.logicmelon.com css styles*[:slash:]html { font-size: 1em; }@media (max-width: 770px) { html, table {font-size: 150%;margin-left: 0px;}body {margin: 0px;}body div,p,h1,h2,h3,li,ul, table
     * td{margin-left: 0px !important;}html, h1, h2, h3, p {padding: 0px 5px 0px 5px;}h2 {word-break: break-all;}table {width:100%;}table td {display: block;}input[type=text],select,textarea {width:100%;}pre { white-space: pre-wrap; word-wrap: break-word;
     * text-align: left; font-size:120%; }.heading1 {width: 100%;padding: 5px 0px;text-indent: 15px;}#wrap,#header,#navi,#main-top,#col-centre, #col-centre-wide, #col-left, #col-left-wide,.module-left {width:100%;}#main-top{margin-left:5px !important;
     * background:none;}.module-left li { width: 95%; margin: 1px 0px 0px 0px; padding: 0 0 0 10px; }#main-bottom {background:none;}.box-head { background-position-x: 4px; } #content a {display:block;}}</style>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\GetValues $parameters
     * @return \RecruitCrm\LogicMelon\StructType\GetValuesResponse|bool
     */
    public function GetValues(\RecruitCrm\LogicMelon\StructType\GetValues $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetValues($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCurrency
     * Meta information extracted from the WSDL
     * - documentation: <a name='GetCurrency'></a><p>Retrieve lookup data for a specific drop down or radio button or check box</p><meta name='viewport' content='width=device-width, initial-scale=1.0' /><style type='text/css'>/* 30 Sep 2019, PJM,
     * api.logicmelon.com css styles*[:slash:]html { font-size: 1em; }@media (max-width: 770px) { html, table {font-size: 150%;margin-left: 0px;}body {margin: 0px;}body div,p,h1,h2,h3,li,ul, table td{margin-left: 0px !important;}html, h1, h2, h3, p
     * {padding: 0px 5px 0px 5px;}h2 {word-break: break-all;}table {width:100%;}table td {display: block;}input[type=text],select,textarea {width:100%;}pre { white-space: pre-wrap; word-wrap: break-word; text-align: left; font-size:120%; }.heading1 {width:
     * 100%;padding: 5px 0px;text-indent: 15px;}#wrap,#header,#navi,#main-top,#col-centre, #col-centre-wide, #col-left, #col-left-wide,.module-left {width:100%;}#main-top{margin-left:5px !important; background:none;}.module-left li { width: 95%; margin: 1px
     * 0px 0px 0px; padding: 0 0 0 10px; }#main-bottom {background:none;}.box-head { background-position-x: 4px; } #content a {display:block;}}</style> | <a name='GetCurrency'></a><p>Retrieve lookup data for a specific drop down or radio button or check
     * box</p><meta name='viewport' content='width=device-width, initial-scale=1.0' /><style type='text/css'>/* 30 Sep 2019, PJM, api.logicmelon.com css styles*[:slash:]html { font-size: 1em; }@media (max-width: 770px) { html, table {font-size:
     * 150%;margin-left: 0px;}body {margin: 0px;}body div,p,h1,h2,h3,li,ul, table td{margin-left: 0px !important;}html, h1, h2, h3, p {padding: 0px 5px 0px 5px;}h2 {word-break: break-all;}table {width:100%;}table td {display:
     * block;}input[type=text],select,textarea {width:100%;}pre { white-space: pre-wrap; word-wrap: break-word; text-align: left; font-size:120%; }.heading1 {width: 100%;padding: 5px 0px;text-indent: 15px;}#wrap,#header,#navi,#main-top,#col-centre,
     * #col-centre-wide, #col-left, #col-left-wide,.module-left {width:100%;}#main-top{margin-left:5px !important; background:none;}.module-left li { width: 95%; margin: 1px 0px 0px 0px; padding: 0 0 0 10px; }#main-bottom {background:none;}.box-head {
     * background-position-x: 4px; } #content a {display:block;}}</style> | <a name='GetCurrency'></a><p>Retrieve lookup data for a specific drop down or radio button or check box</p><meta name='viewport' content='width=device-width, initial-scale=1.0'
     * /><style type='text/css'>/* 30 Sep 2019, PJM, api.logicmelon.com css styles*[:slash:]html { font-size: 1em; }@media (max-width: 770px) { html, table {font-size: 150%;margin-left: 0px;}body {margin: 0px;}body div,p,h1,h2,h3,li,ul, table
     * td{margin-left: 0px !important;}html, h1, h2, h3, p {padding: 0px 5px 0px 5px;}h2 {word-break: break-all;}table {width:100%;}table td {display: block;}input[type=text],select,textarea {width:100%;}pre { white-space: pre-wrap; word-wrap: break-word;
     * text-align: left; font-size:120%; }.heading1 {width: 100%;padding: 5px 0px;text-indent: 15px;}#wrap,#header,#navi,#main-top,#col-centre, #col-centre-wide, #col-left, #col-left-wide,.module-left {width:100%;}#main-top{margin-left:5px !important;
     * background:none;}.module-left li { width: 95%; margin: 1px 0px 0px 0px; padding: 0 0 0 10px; }#main-bottom {background:none;}.box-head { background-position-x: 4px; } #content a {display:block;}}</style>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\GetCurrency $parameters
     * @return \RecruitCrm\LogicMelon\StructType\GetCurrencyResponse|bool
     */
    public function GetCurrency(\RecruitCrm\LogicMelon\StructType\GetCurrency $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCurrency($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLoginURL
     * Meta information extracted from the WSDL
     * - documentation: <a name='GetLoginURLResult'></a><p>Provides a mechanism to convert a global password for a user login to a url to authentication and log the user into LogicMelon.</p><p>sRedirectDomain is optional (unless you are targetting specific
     * branding) and the sRedirectURL can be used to include a redirect to the specific landing functionality.</p><meta name='viewport' content='width=device-width, initial-scale=1.0' /><style type='text/css'>/* 30 Sep 2019, PJM, api.logicmelon.com css
     * styles*[:slash:]html { font-size: 1em; }@media (max-width: 770px) { html, table {font-size: 150%;margin-left: 0px;}body {margin: 0px;}body div,p,h1,h2,h3,li,ul, table td{margin-left: 0px !important;}html, h1, h2, h3, p {padding: 0px 5px 0px 5px;}h2
     * {word-break: break-all;}table {width:100%;}table td {display: block;}input[type=text],select,textarea {width:100%;}pre { white-space: pre-wrap; word-wrap: break-word; text-align: left; font-size:120%; }.heading1 {width: 100%;padding: 5px
     * 0px;text-indent: 15px;}#wrap,#header,#navi,#main-top,#col-centre, #col-centre-wide, #col-left, #col-left-wide,.module-left {width:100%;}#main-top{margin-left:5px !important; background:none;}.module-left li { width: 95%; margin: 1px 0px 0px 0px;
     * padding: 0 0 0 10px; }#main-bottom {background:none;}.box-head { background-position-x: 4px; } #content a {display:block;}}</style> | <a name='GetLoginURLResult'></a><p>Provides a mechanism to convert a global password for a user login to a url to
     * authentication and log the user into LogicMelon.</p><p>sRedirectDomain is optional (unless you are targetting specific branding) and the sRedirectURL can be used to include a redirect to the specific landing functionality.</p><meta name='viewport'
     * content='width=device-width, initial-scale=1.0' /><style type='text/css'>/* 30 Sep 2019, PJM, api.logicmelon.com css styles*[:slash:]html { font-size: 1em; }@media (max-width: 770px) { html, table {font-size: 150%;margin-left: 0px;}body {margin:
     * 0px;}body div,p,h1,h2,h3,li,ul, table td{margin-left: 0px !important;}html, h1, h2, h3, p {padding: 0px 5px 0px 5px;}h2 {word-break: break-all;}table {width:100%;}table td {display: block;}input[type=text],select,textarea {width:100%;}pre {
     * white-space: pre-wrap; word-wrap: break-word; text-align: left; font-size:120%; }.heading1 {width: 100%;padding: 5px 0px;text-indent: 15px;}#wrap,#header,#navi,#main-top,#col-centre, #col-centre-wide, #col-left, #col-left-wide,.module-left
     * {width:100%;}#main-top{margin-left:5px !important; background:none;}.module-left li { width: 95%; margin: 1px 0px 0px 0px; padding: 0 0 0 10px; }#main-bottom {background:none;}.box-head { background-position-x: 4px; } #content a
     * {display:block;}}</style> | <a name='GetLoginURLResult'></a><p>Provides a mechanism to convert a global password for a user login to a url to authentication and log the user into LogicMelon.</p><p>sRedirectDomain is optional (unless you are
     * targetting specific branding) and the sRedirectURL can be used to include a redirect to the specific landing functionality.</p><meta name='viewport' content='width=device-width, initial-scale=1.0' /><style type='text/css'>/* 30 Sep 2019, PJM,
     * api.logicmelon.com css styles*[:slash:]html { font-size: 1em; }@media (max-width: 770px) { html, table {font-size: 150%;margin-left: 0px;}body {margin: 0px;}body div,p,h1,h2,h3,li,ul, table td{margin-left: 0px !important;}html, h1, h2, h3, p
     * {padding: 0px 5px 0px 5px;}h2 {word-break: break-all;}table {width:100%;}table td {display: block;}input[type=text],select,textarea {width:100%;}pre { white-space: pre-wrap; word-wrap: break-word; text-align: left; font-size:120%; }.heading1 {width:
     * 100%;padding: 5px 0px;text-indent: 15px;}#wrap,#header,#navi,#main-top,#col-centre, #col-centre-wide, #col-left, #col-left-wide,.module-left {width:100%;}#main-top{margin-left:5px !important; background:none;}.module-left li { width: 95%; margin: 1px
     * 0px 0px 0px; padding: 0 0 0 10px; }#main-bottom {background:none;}.box-head { background-position-x: 4px; } #content a {display:block;}}</style>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\GetLoginURL $parameters
     * @return \RecruitCrm\LogicMelon\StructType\GetLoginURLResponse|bool
     */
    public function GetLoginURL(\RecruitCrm\LogicMelon\StructType\GetLoginURL $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLoginURL($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \RecruitCrm\LogicMelon\StructType\GetAdvertPagedResponse|\RecruitCrm\LogicMelon\StructType\GetAdvertResponse|\RecruitCrm\LogicMelon\StructType\GetAdvertWithFiltersPagedResponse|\RecruitCrm\LogicMelon\StructType\GetAdvertWithFiltersResponse|\RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesPagedResponse|\RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesResponse|\RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersPagedResponse|\RecruitCrm\LogicMelon\StructType\GetAdvertWithValuesWithFiltersResponse|\RecruitCrm\LogicMelon\StructType\GetApplicationsPagedResponse|\RecruitCrm\LogicMelon\StructType\GetApplicationsResponse|\RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersPagedResponse|\RecruitCrm\LogicMelon\StructType\GetApplicationsWithFiltersResponse|\RecruitCrm\LogicMelon\StructType\GetCurrencyResponse|\RecruitCrm\LogicMelon\StructType\GetLiveAdvertPostingsPagedResponse|\RecruitCrm\LogicMelon\StructType\GetLiveAdvertPostingsResponse|\RecruitCrm\LogicMelon\StructType\GetLoginURLResponse|\RecruitCrm\LogicMelon\StructType\GetValuesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
