<?php

namespace RecruitCrm\LogicMelon\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AddAdvert
     * Meta information extracted from the WSDL
     * - documentation: <a name='AddAdvert'></a><p>Create an advert on the system and return a redirect url for the user to complete the posting process.</p><ul><li><strong>eOnDuplicate</strong> What action to perform if this advert is already found under
     * this user (duplicate/ignore/update/error) (create a duplicate / ignore and return the access url / update the advert with these values / throw an exception about a duplicate)</li><li><strong>sJobTitle</strong> The title of the
     * job</li><li><strong>sJobType</strong> The job type (P)ermanent, (C)ontract, (T)emporary</li><li><strong>sJobHours</strong> The job hours (F)ull time, (P)art time</li><li><strong>sPrimaryLocation</strong> The primary
     * location</li><li><strong>sIndustry</strong> The specific industry</li><li><strong>sSalaryFrom</strong> The minimum salary. Must be numeric.</li><li><strong>sSalaryTo</strong> The maximum salary. Must be
     * numeric.</li><li><strong>sSalaryCurrency</strong> The salary currency in 3 letter ISO e.g. GBP, EUR, USD</li><li><strong>sSalaryPer</strong> The salary period (H)our, (D)ay, (W)eek, (M)onth, (Y)ear</li><li><strong>sSalaryBenefits</strong> and salary
     * benefits</li><li><strong>sContactName</strong> Optionally a specific contact name (default to use the user the vacancy is stored under)</li><li><strong>sContactEmail</strong> Optionally a specific contact email (default to use the user the vacancy is
     * stored under)</li><li><strong>sJobDescription</strong> The job description in plain text or HTML</li><li><strong>sApplicationURL</strong> Optionally an application URL to pass to the different media. Contact support for
     * details.</li><li><strong>Destinations</strong> A list of job board destinations as either numeric id's or string identifiers</li><li><strong>sFuturePostDateTimeInUtc</strong> Future date for advert and posting data. Must parse to a date using
     * </li><li><strong>sRedirectDomain</strong> The domain to redirect the user to on completion. Defaults to a system configured domain.</li><li><strong>AdvertValues</strong> Extra values keyed on numeric field id or field string identifier and the
     * associated value</li><li><strong>sAdvertStatusID</strong> Adverts by default are marked as Created (0). The may also be marked as ToAuthorise (16) or Deleted (1)</li><li><strong>sAdvertID</strong> 12 May 2016 optionally if you know the existing
     * AdvertID supply it here</li><li><strong>sApplicationCallbackURL</strong> 4 March 2021 optionally if you have an endpoint we can call with our applicationID, when an application is made</li></ul><meta name='viewport' content='width=device-width,
     * initial-scale=1.0' /><style type='text/css'>/* 30 Sep 2019, PJM, api.logicmelon.com css styles*[:slash:]html { font-size: 1em; }@media (max-width: 770px) { html, table {font-size: 150%;margin-left: 0px;}body {margin: 0px;}body div,p,h1,h2,h3,li,ul,
     * table td{margin-left: 0px !important;}html, h1, h2, h3, p {padding: 0px 5px 0px 5px;}h2 {word-break: break-all;}table {width:100%;}table td {display: block;}input[type=text],select,textarea {width:100%;}pre { white-space: pre-wrap; word-wrap:
     * break-word; text-align: left; font-size:120%; }.heading1 {width: 100%;padding: 5px 0px;text-indent: 15px;}#wrap,#header,#navi,#main-top,#col-centre, #col-centre-wide, #col-left, #col-left-wide,.module-left {width:100%;}#main-top{margin-left:5px
     * !important; background:none;}.module-left li { width: 95%; margin: 1px 0px 0px 0px; padding: 0 0 0 10px; }#main-bottom {background:none;}.box-head { background-position-x: 4px; } #content a {display:block;}}</style> | <a
     * name='AddAdvert'></a><p>Create an advert on the system and return a redirect url for the user to complete the posting process.</p><ul><li><strong>eOnDuplicate</strong> What action to perform if this advert is already found under this user
     * (duplicate/ignore/update/error) (create a duplicate / ignore and return the access url / update the advert with these values / throw an exception about a duplicate)</li><li><strong>sJobTitle</strong> The title of the
     * job</li><li><strong>sJobType</strong> The job type (P)ermanent, (C)ontract, (T)emporary</li><li><strong>sJobHours</strong> The job hours (F)ull time, (P)art time</li><li><strong>sPrimaryLocation</strong> The primary
     * location</li><li><strong>sIndustry</strong> The specific industry</li><li><strong>sSalaryFrom</strong> The minimum salary. Must be numeric.</li><li><strong>sSalaryTo</strong> The maximum salary. Must be
     * numeric.</li><li><strong>sSalaryCurrency</strong> The salary currency in 3 letter ISO e.g. GBP, EUR, USD</li><li><strong>sSalaryPer</strong> The salary period (H)our, (D)ay, (W)eek, (M)onth, (Y)ear</li><li><strong>sSalaryBenefits</strong> and salary
     * benefits</li><li><strong>sContactName</strong> Optionally a specific contact name (default to use the user the vacancy is stored under)</li><li><strong>sContactEmail</strong> Optionally a specific contact email (default to use the user the vacancy is
     * stored under)</li><li><strong>sJobDescription</strong> The job description in plain text or HTML</li><li><strong>sApplicationURL</strong> Optionally an application URL to pass to the different media. Contact support for
     * details.</li><li><strong>Destinations</strong> A list of job board destinations as either numeric id's or string identifiers</li><li><strong>sFuturePostDateTimeInUtc</strong> Future date for advert and posting data. Must parse to a date using
     * </li><li><strong>sRedirectDomain</strong> The domain to redirect the user to on completion. Defaults to a system configured domain.</li><li><strong>AdvertValues</strong> Extra values keyed on numeric field id or field string identifier and the
     * associated value</li><li><strong>sAdvertStatusID</strong> Adverts by default are marked as Created (0). The may also be marked as ToAuthorise (16) or Deleted (1)</li><li><strong>sAdvertID</strong> 12 May 2016 optionally if you know the existing
     * AdvertID supply it here</li><li><strong>sApplicationCallbackURL</strong> 4 March 2021 optionally if you have an endpoint we can call with our applicationID, when an application is made</li></ul><meta name='viewport' content='width=device-width,
     * initial-scale=1.0' /><style type='text/css'>/* 30 Sep 2019, PJM, api.logicmelon.com css styles*[:slash:]html { font-size: 1em; }@media (max-width: 770px) { html, table {font-size: 150%;margin-left: 0px;}body {margin: 0px;}body div,p,h1,h2,h3,li,ul,
     * table td{margin-left: 0px !important;}html, h1, h2, h3, p {padding: 0px 5px 0px 5px;}h2 {word-break: break-all;}table {width:100%;}table td {display: block;}input[type=text],select,textarea {width:100%;}pre { white-space: pre-wrap; word-wrap:
     * break-word; text-align: left; font-size:120%; }.heading1 {width: 100%;padding: 5px 0px;text-indent: 15px;}#wrap,#header,#navi,#main-top,#col-centre, #col-centre-wide, #col-left, #col-left-wide,.module-left {width:100%;}#main-top{margin-left:5px
     * !important; background:none;}.module-left li { width: 95%; margin: 1px 0px 0px 0px; padding: 0 0 0 10px; }#main-bottom {background:none;}.box-head { background-position-x: 4px; } #content a {display:block;}}</style> | <a
     * name='AddAdvert'></a><p>Create an advert on the system and return a redirect url for the user to complete the posting process.</p><ul><li><strong>eOnDuplicate</strong> What action to perform if this advert is already found under this user
     * (duplicate/ignore/update/error) (create a duplicate / ignore and return the access url / update the advert with these values / throw an exception about a duplicate)</li><li><strong>sJobTitle</strong> The title of the
     * job</li><li><strong>sJobType</strong> The job type (P)ermanent, (C)ontract, (T)emporary</li><li><strong>sJobHours</strong> The job hours (F)ull time, (P)art time</li><li><strong>sPrimaryLocation</strong> The primary
     * location</li><li><strong>sIndustry</strong> The specific industry</li><li><strong>sSalaryFrom</strong> The minimum salary. Must be numeric.</li><li><strong>sSalaryTo</strong> The maximum salary. Must be
     * numeric.</li><li><strong>sSalaryCurrency</strong> The salary currency in 3 letter ISO e.g. GBP, EUR, USD</li><li><strong>sSalaryPer</strong> The salary period (H)our, (D)ay, (W)eek, (M)onth, (Y)ear</li><li><strong>sSalaryBenefits</strong> and salary
     * benefits</li><li><strong>sContactName</strong> Optionally a specific contact name (default to use the user the vacancy is stored under)</li><li><strong>sContactEmail</strong> Optionally a specific contact email (default to use the user the vacancy is
     * stored under)</li><li><strong>sJobDescription</strong> The job description in plain text or HTML</li><li><strong>sApplicationURL</strong> Optionally an application URL to pass to the different media. Contact support for
     * details.</li><li><strong>Destinations</strong> A list of job board destinations as either numeric id's or string identifiers</li><li><strong>sFuturePostDateTimeInUtc</strong> Future date for advert and posting data. Must parse to a date using
     * </li><li><strong>sRedirectDomain</strong> The domain to redirect the user to on completion. Defaults to a system configured domain.</li><li><strong>AdvertValues</strong> Extra values keyed on numeric field id or field string identifier and the
     * associated value</li><li><strong>sAdvertStatusID</strong> Adverts by default are marked as Created (0). The may also be marked as ToAuthorise (16) or Deleted (1)</li><li><strong>sAdvertID</strong> 12 May 2016 optionally if you know the existing
     * AdvertID supply it here</li><li><strong>sApplicationCallbackURL</strong> 4 March 2021 optionally if you have an endpoint we can call with our applicationID, when an application is made</li></ul><meta name='viewport' content='width=device-width,
     * initial-scale=1.0' /><style type='text/css'>/* 30 Sep 2019, PJM, api.logicmelon.com css styles*[:slash:]html { font-size: 1em; }@media (max-width: 770px) { html, table {font-size: 150%;margin-left: 0px;}body {margin: 0px;}body div,p,h1,h2,h3,li,ul,
     * table td{margin-left: 0px !important;}html, h1, h2, h3, p {padding: 0px 5px 0px 5px;}h2 {word-break: break-all;}table {width:100%;}table td {display: block;}input[type=text],select,textarea {width:100%;}pre { white-space: pre-wrap; word-wrap:
     * break-word; text-align: left; font-size:120%; }.heading1 {width: 100%;padding: 5px 0px;text-indent: 15px;}#wrap,#header,#navi,#main-top,#col-centre, #col-centre-wide, #col-left, #col-left-wide,.module-left {width:100%;}#main-top{margin-left:5px
     * !important; background:none;}.module-left li { width: 95%; margin: 1px 0px 0px 0px; padding: 0 0 0 10px; }#main-bottom {background:none;}.box-head { background-position-x: 4px; } #content a {display:block;}}</style>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\AddAdvert $parameters
     * @return \RecruitCrm\LogicMelon\StructType\AddAdvertResponse|bool
     */
    public function AddAdvert(\RecruitCrm\LogicMelon\StructType\AddAdvert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddAdvert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddAdvertWithValues
     * Meta information extracted from the WSDL
     * - documentation: <a name='AddAdvertWithValues'></a><p>Create an advert on the system and return a redirect url for the user to complete the posting process.</p><meta name='viewport' content='width=device-width, initial-scale=1.0' /><style
     * type='text/css'>/* 30 Sep 2019, PJM, api.logicmelon.com css styles*[:slash:]html { font-size: 1em; }@media (max-width: 770px) { html, table {font-size: 150%;margin-left: 0px;}body {margin: 0px;}body div,p,h1,h2,h3,li,ul, table td{margin-left: 0px
     * !important;}html, h1, h2, h3, p {padding: 0px 5px 0px 5px;}h2 {word-break: break-all;}table {width:100%;}table td {display: block;}input[type=text],select,textarea {width:100%;}pre { white-space: pre-wrap; word-wrap: break-word; text-align: left;
     * font-size:120%; }.heading1 {width: 100%;padding: 5px 0px;text-indent: 15px;}#wrap,#header,#navi,#main-top,#col-centre, #col-centre-wide, #col-left, #col-left-wide,.module-left {width:100%;}#main-top{margin-left:5px !important;
     * background:none;}.module-left li { width: 95%; margin: 1px 0px 0px 0px; padding: 0 0 0 10px; }#main-bottom {background:none;}.box-head { background-position-x: 4px; } #content a {display:block;}}</style>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\AddAdvertWithValues $parameters
     * @return \RecruitCrm\LogicMelon\StructType\AddAdvertWithValuesResponse|bool
     */
    public function AddAdvertWithValues(\RecruitCrm\LogicMelon\StructType\AddAdvertWithValues $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddAdvertWithValues($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddAdvertValues
     * Meta information extracted from the WSDL
     * - documentation: <a name='AddAdvertValues'></a><p>Update field values against a current advert.</p><meta name='viewport' content='width=device-width, initial-scale=1.0' /><style type='text/css'>/* 30 Sep 2019, PJM, api.logicmelon.com css
     * styles*[:slash:]html { font-size: 1em; }@media (max-width: 770px) { html, table {font-size: 150%;margin-left: 0px;}body {margin: 0px;}body div,p,h1,h2,h3,li,ul, table td{margin-left: 0px !important;}html, h1, h2, h3, p {padding: 0px 5px 0px 5px;}h2
     * {word-break: break-all;}table {width:100%;}table td {display: block;}input[type=text],select,textarea {width:100%;}pre { white-space: pre-wrap; word-wrap: break-word; text-align: left; font-size:120%; }.heading1 {width: 100%;padding: 5px
     * 0px;text-indent: 15px;}#wrap,#header,#navi,#main-top,#col-centre, #col-centre-wide, #col-left, #col-left-wide,.module-left {width:100%;}#main-top{margin-left:5px !important; background:none;}.module-left li { width: 95%; margin: 1px 0px 0px 0px;
     * padding: 0 0 0 10px; }#main-bottom {background:none;}.box-head { background-position-x: 4px; } #content a {display:block;}}</style>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\AddAdvertValues $parameters
     * @return \RecruitCrm\LogicMelon\StructType\AddAdvertValuesResponse|bool
     */
    public function AddAdvertValues(\RecruitCrm\LogicMelon\StructType\AddAdvertValues $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddAdvertValues($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddAdvertCandidate
     * Meta information extracted from the WSDL
     * - documentation: <a name='AddAdvertCandidate'></a><p>Attaches a candidate to the application pipeline using their email address, information to locate and advert, and a specific feed identifier or feed id.</p><p>Optionally specify a username to limit
     * the search</p><ul><li><strong>sFeedID</strong> If known our internal database key for the source. e.g. 108<li><strong>sFeedIdentifier</strong> If known our internal string identifier for the source. e.g Totaljobs<li><strong>sCandidateEmail</strong>
     * The candidates email address (required)<li><strong>sCandidateFirstName</strong> The candidates first name (optional)<li><strong>sCandidateLastName</strong> The candidates last name (optional)<li><strong>sCandidateHomePhone</strong> The candidates
     * home phone (optional)<li><strong>sCandidateWorkPhone</strong> The candidates work phone (optional)<li><strong>sCandidateMobilePhone</strong> The candidates mobile phone (optional)<li><strong>CandidateDetails</strong> Extra candidate details (contact
     * support for details)</ul><meta name='viewport' content='width=device-width, initial-scale=1.0' /><style type='text/css'>/* 30 Sep 2019, PJM, api.logicmelon.com css styles*[:slash:]html { font-size: 1em; }@media (max-width: 770px) { html, table
     * {font-size: 150%;margin-left: 0px;}body {margin: 0px;}body div,p,h1,h2,h3,li,ul, table td{margin-left: 0px !important;}html, h1, h2, h3, p {padding: 0px 5px 0px 5px;}h2 {word-break: break-all;}table {width:100%;}table td {display:
     * block;}input[type=text],select,textarea {width:100%;}pre { white-space: pre-wrap; word-wrap: break-word; text-align: left; font-size:120%; }.heading1 {width: 100%;padding: 5px 0px;text-indent: 15px;}#wrap,#header,#navi,#main-top,#col-centre,
     * #col-centre-wide, #col-left, #col-left-wide,.module-left {width:100%;}#main-top{margin-left:5px !important; background:none;}.module-left li { width: 95%; margin: 1px 0px 0px 0px; padding: 0 0 0 10px; }#main-bottom {background:none;}.box-head {
     * background-position-x: 4px; } #content a {display:block;}}</style>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\AddAdvertCandidate $parameters
     * @return \RecruitCrm\LogicMelon\StructType\AddAdvertCandidateResponse|bool
     */
    public function AddAdvertCandidate(\RecruitCrm\LogicMelon\StructType\AddAdvertCandidate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddAdvertCandidate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddAdvertCandidateWithDocument
     * Meta information extracted from the WSDL
     * - documentation: <a name='AddAdvertCandidateWithDocument'></a><p>Attaches a candidate to the application pipeline using their email address, and a base64 encoded document to attach to the candidate.</p>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\AddAdvertCandidateWithDocument $parameters
     * @return \RecruitCrm\LogicMelon\StructType\AddAdvertCandidateWithDocumentResponse|bool
     */
    public function AddAdvertCandidateWithDocument(\RecruitCrm\LogicMelon\StructType\AddAdvertCandidateWithDocument $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddAdvertCandidateWithDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddAdvertCandidateWithFilters
     * Meta information extracted from the WSDL
     * - documentation: <a name='AddAdvertCandidateWithFilters'></a><p>Attach a candidate to the application pipeline using their email address, information to locate an advert, and a specific feed identifier or feed id are required.</p><p>Optionally
     * specify a username to limit the search</p><meta name='viewport' content='width=device-width, initial-scale=1.0' /><style type='text/css'>/* 30 Sep 2019, PJM, api.logicmelon.com css styles*[:slash:]html { font-size: 1em; }@media (max-width: 770px) {
     * html, table {font-size: 150%;margin-left: 0px;}body {margin: 0px;}body div,p,h1,h2,h3,li,ul, table td{margin-left: 0px !important;}html, h1, h2, h3, p {padding: 0px 5px 0px 5px;}h2 {word-break: break-all;}table {width:100%;}table td {display:
     * block;}input[type=text],select,textarea {width:100%;}pre { white-space: pre-wrap; word-wrap: break-word; text-align: left; font-size:120%; }.heading1 {width: 100%;padding: 5px 0px;text-indent: 15px;}#wrap,#header,#navi,#main-top,#col-centre,
     * #col-centre-wide, #col-left, #col-left-wide,.module-left {width:100%;}#main-top{margin-left:5px !important; background:none;}.module-left li { width: 95%; margin: 1px 0px 0px 0px; padding: 0 0 0 10px; }#main-bottom {background:none;}.box-head {
     * background-position-x: 4px; } #content a {display:block;}}</style>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\AddAdvertCandidateWithFilters $parameters
     * @return \RecruitCrm\LogicMelon\StructType\AddAdvertCandidateWithFiltersResponse|bool
     */
    public function AddAdvertCandidateWithFilters(\RecruitCrm\LogicMelon\StructType\AddAdvertCandidateWithFilters $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddAdvertCandidateWithFilters($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \RecruitCrm\LogicMelon\StructType\AddAdvertCandidateResponse|\RecruitCrm\LogicMelon\StructType\AddAdvertCandidateWithDocumentResponse|\RecruitCrm\LogicMelon\StructType\AddAdvertCandidateWithFiltersResponse|\RecruitCrm\LogicMelon\StructType\AddAdvertResponse|\RecruitCrm\LogicMelon\StructType\AddAdvertValuesResponse|\RecruitCrm\LogicMelon\StructType\AddAdvertWithValuesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
