<?php

namespace RecruitCrm\LogicMelon\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNameValue ArrayType
 * @subpackage Arrays
 */
class ArrayOfNameValue extends AbstractStructArrayBase
{
    /**
     * The NameValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \RecruitCrm\LogicMelon\StructType\NameValue[]
     */
    public $NameValue;
    /**
     * Constructor method for ArrayOfNameValue
     * @uses ArrayOfNameValue::setNameValue()
     * @param \RecruitCrm\LogicMelon\StructType\NameValue[] $nameValue
     */
    public function __construct(array $nameValue = array())
    {
        $this
            ->setNameValue($nameValue);
    }
    /**
     * Get NameValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RecruitCrm\LogicMelon\StructType\NameValue[]|null
     */
    public function getNameValue()
    {
        return isset($this->NameValue) ? $this->NameValue : null;
    }
    /**
     * This method is responsible for validating the values passed to the setNameValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNameValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameValueForArrayConstraintsFromSetNameValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfNameValueNameValueItem) {
            // validation for constraint: itemType
            if (!$arrayOfNameValueNameValueItem instanceof \RecruitCrm\LogicMelon\StructType\NameValue) {
                $invalidValues[] = is_object($arrayOfNameValueNameValueItem) ? get_class($arrayOfNameValueNameValueItem) : sprintf('%s(%s)', gettype($arrayOfNameValueNameValueItem), var_export($arrayOfNameValueNameValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NameValue property can only contain items of type \RecruitCrm\LogicMelon\StructType\NameValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NameValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \RecruitCrm\LogicMelon\StructType\NameValue[] $nameValue
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValue
     */
    public function setNameValue(array $nameValue = array())
    {
        // validation for constraint: array
        if ('' !== ($nameValueArrayErrorMessage = self::validateNameValueForArrayConstraintsFromSetNameValue($nameValue))) {
            throw new \InvalidArgumentException($nameValueArrayErrorMessage, __LINE__);
        }
        if (is_null($nameValue) || (is_array($nameValue) && empty($nameValue))) {
            unset($this->NameValue);
        } else {
            $this->NameValue = $nameValue;
        }
        return $this;
    }
    /**
     * Add item to NameValue value
     * @throws \InvalidArgumentException
     * @param \RecruitCrm\LogicMelon\StructType\NameValue $item
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValue
     */
    public function addToNameValue(\RecruitCrm\LogicMelon\StructType\NameValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RecruitCrm\LogicMelon\StructType\NameValue) {
            throw new \InvalidArgumentException(sprintf('The NameValue property can only contain items of type \RecruitCrm\LogicMelon\StructType\NameValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NameValue[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \RecruitCrm\LogicMelon\StructType\NameValue|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \RecruitCrm\LogicMelon\StructType\NameValue|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \RecruitCrm\LogicMelon\StructType\NameValue|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \RecruitCrm\LogicMelon\StructType\NameValue|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \RecruitCrm\LogicMelon\StructType\NameValue|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NameValue
     */
    public function getAttributeName()
    {
        return 'NameValue';
    }
}
