<?php

namespace RecruitCrm\LogicMelon\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Application ServiceType
 * @subpackage Services
 */
class Application extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ApplicationScore
     * Meta information extracted from the WSDL
     * - documentation: <a name='ApplicationScore'></a><p>Score a specific application from a 3rd party RMS.</p><ul><li><strong>sUsername</strong> This action will be performed in the context of the authenticated user. If you want to score as the job owner
     * then please indicate boolScoreAsJobOwner = true.</li><li><strong>sAdvertID</strong> Our AdvertID of the job </li><li><strong>sAdvertCandidateID</strong> Our ApplicationID of the applicant. sAdvertID and sAdvertCandidateID must line up to be able to
     * score.</li><li><strong>sScore</strong> The score to apply (S)uitable (green flag/4), (M)aybe suitable (blue/yellow flag/2), (U)nsuitable (red flag/1), (F)avourite (favourite star/64), (N)one (no flag/0)</li><li><strong>sScoreAsJobOwner</strong> Score
     * as the job owner instead of the authenticated user. Boolean defaults to false.</li></ul> | <a name='ApplicationScore'></a><p>Score a specific application from a 3rd party RMS.</p><ul><li><strong>sUsername</strong> This action will be performed in the
     * context of the authenticated user. If you want to score as the job owner then please indicate boolScoreAsJobOwner = true.</li><li><strong>sAdvertID</strong> Our AdvertID of the job </li><li><strong>sAdvertCandidateID</strong> Our ApplicationID of the
     * applicant. sAdvertID and sAdvertCandidateID must line up to be able to score.</li><li><strong>sScore</strong> The score to apply (S)uitable (green flag/4), (M)aybe suitable (blue/yellow flag/2), (U)nsuitable (red flag/1), (F)avourite (favourite
     * star/64), (N)one (no flag/0)</li><li><strong>sScoreAsJobOwner</strong> Score as the job owner instead of the authenticated user. Boolean defaults to false.</li></ul> | <a name='ApplicationScore'></a><p>Score a specific application from a 3rd party
     * RMS.</p><ul><li><strong>sUsername</strong> This action will be performed in the context of the authenticated user. If you want to score as the job owner then please indicate boolScoreAsJobOwner = true.</li><li><strong>sAdvertID</strong> Our AdvertID
     * of the job </li><li><strong>sAdvertCandidateID</strong> Our ApplicationID of the applicant. sAdvertID and sAdvertCandidateID must line up to be able to score.</li><li><strong>sScore</strong> The score to apply (S)uitable (green flag/4), (M)aybe
     * suitable (blue/yellow flag/2), (U)nsuitable (red flag/1), (F)avourite (favourite star/64), (N)one (no flag/0)</li><li><strong>sScoreAsJobOwner</strong> Score as the job owner instead of the authenticated user. Boolean defaults to false.</li></ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\ApplicationScore $parameters
     * @return \RecruitCrm\LogicMelon\StructType\ApplicationScoreResponse|bool
     */
    public function ApplicationScore(\RecruitCrm\LogicMelon\StructType\ApplicationScore $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ApplicationScore($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ApplicationProgress
     * Meta information extracted from the WSDL
     * - documentation: <a name='ApplicationScore'></a><p>Progress a specific application from a 3rd party RMS.</p><ul><li><strong>sUsername</strong> This action will be performed in the context of the authenticated user. If you want to score as the job
     * owner then please indicate boolScoreAsJobOwner = true.</li><li><strong>sAdvertID</strong> Our AdvertID of the job </li><li><strong>sAdvertCandidateID</strong> Our ApplicationID of the applicant. sAdvertID and sAdvertCandidateID must line up to be
     * able to score.</li><li><strong>sProgressID</strong> The specific progressID. Contact us for id's applicable to your account. A list of commons ones are listed below:<ul><li>100 Reject</li><li>200 General</li><li>201 Apply with CV</li><li>204 Applied
     * already</li><li>220 Blank</li><li>300 Consider</li><li>351 Forwarded to manager</li><li>380 Suitable - Application form requested</li><li>750 Shortlist</li><li>850 Request for More Information</li><li>900 Questions</li><li>1210 General e-mail to
     * candidates</li><li>1360 Request to get in touch</li><li>1361 Job Application To Ourselves</li><li>3000 Testing</li><li>4900 Interview request</li><li>5000 1st interview</li><li>5100 2nd interview</li><li>5200 3rd interview</li><li>5300 4th
     * interview</li><li>6000 Not offered</li><li>6002 Regret after interview</li><li>8000 Offered</li><li>10000 Placement</li><li>11000 Vacancy closed</li><li>11002 Candidate Withdrawn</li></ul></li><li><strong>sProgressAsJobOwner</strong> Progress as the
     * job owner instead of the authenticated user. Boolean defaults to false.</li></ul> | <a name='ApplicationScore'></a><p>Progress a specific application from a 3rd party RMS.</p><ul><li><strong>sUsername</strong> This action will be performed in the
     * context of the authenticated user. If you want to score as the job owner then please indicate boolScoreAsJobOwner = true.</li><li><strong>sAdvertID</strong> Our AdvertID of the job </li><li><strong>sAdvertCandidateID</strong> Our ApplicationID of the
     * applicant. sAdvertID and sAdvertCandidateID must line up to be able to score.</li><li><strong>sProgressID</strong> The specific progressID. Contact us for id's applicable to your account. A list of commons ones are listed below:<ul><li>100
     * Reject</li><li>200 General</li><li>201 Apply with CV</li><li>204 Applied already</li><li>220 Blank</li><li>300 Consider</li><li>351 Forwarded to manager</li><li>380 Suitable - Application form requested</li><li>750 Shortlist</li><li>850 Request for
     * More Information</li><li>900 Questions</li><li>1210 General e-mail to candidates</li><li>1360 Request to get in touch</li><li>1361 Job Application To Ourselves</li><li>3000 Testing</li><li>4900 Interview request</li><li>5000 1st
     * interview</li><li>5100 2nd interview</li><li>5200 3rd interview</li><li>5300 4th interview</li><li>6000 Not offered</li><li>6002 Regret after interview</li><li>8000 Offered</li><li>10000 Placement</li><li>11000 Vacancy closed</li><li>11002 Candidate
     * Withdrawn</li></ul></li><li><strong>sProgressAsJobOwner</strong> Progress as the job owner instead of the authenticated user. Boolean defaults to false.</li></ul> | <a name='ApplicationScore'></a><p>Progress a specific application from a 3rd party
     * RMS.</p><ul><li><strong>sUsername</strong> This action will be performed in the context of the authenticated user. If you want to score as the job owner then please indicate boolScoreAsJobOwner = true.</li><li><strong>sAdvertID</strong> Our AdvertID
     * of the job </li><li><strong>sAdvertCandidateID</strong> Our ApplicationID of the applicant. sAdvertID and sAdvertCandidateID must line up to be able to score.</li><li><strong>sProgressID</strong> The specific progressID. Contact us for id's
     * applicable to your account. A list of commons ones are listed below:<ul><li>100 Reject</li><li>200 General</li><li>201 Apply with CV</li><li>204 Applied already</li><li>220 Blank</li><li>300 Consider</li><li>351 Forwarded to manager</li><li>380
     * Suitable - Application form requested</li><li>750 Shortlist</li><li>850 Request for More Information</li><li>900 Questions</li><li>1210 General e-mail to candidates</li><li>1360 Request to get in touch</li><li>1361 Job Application To
     * Ourselves</li><li>3000 Testing</li><li>4900 Interview request</li><li>5000 1st interview</li><li>5100 2nd interview</li><li>5200 3rd interview</li><li>5300 4th interview</li><li>6000 Not offered</li><li>6002 Regret after interview</li><li>8000
     * Offered</li><li>10000 Placement</li><li>11000 Vacancy closed</li><li>11002 Candidate Withdrawn</li></ul></li><li><strong>sProgressAsJobOwner</strong> Progress as the job owner instead of the authenticated user. Boolean defaults to false.</li></ul>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\ApplicationProgress $parameters
     * @return \RecruitCrm\LogicMelon\StructType\ApplicationProgressResponse|bool
     */
    public function ApplicationProgress(\RecruitCrm\LogicMelon\StructType\ApplicationProgress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ApplicationProgress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \RecruitCrm\LogicMelon\StructType\ApplicationProgressResponse|\RecruitCrm\LogicMelon\StructType\ApplicationScoreResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
