<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetApplicationsPaged StructType
 * @subpackage Structs
 */
class GetApplicationsPaged extends AbstractStructBase
{
    /**
     * The CurrentPage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CurrentPage;
    /**
     * The RowsPerPage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RowsPerPage;
    /**
     * The sCultureID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sCultureID;
    /**
     * The sAPIKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAPIKey;
    /**
     * The sUsername
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sUsername;
    /**
     * The sUserIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sUserIdentifier;
    /**
     * The sStartOrganisation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sStartOrganisation;
    /**
     * The sAdvertIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAdvertIdentifier;
    /**
     * The sAdvertReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAdvertReference;
    /**
     * The sAdvertID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAdvertID;
    /**
     * The DestinationsAsCSV
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DestinationsAsCSV;
    /**
     * The sApplicationStartDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sApplicationStartDateTime;
    /**
     * The sApplicationEndDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sApplicationEndDateTime;
    /**
     * The RankingAsCSV
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RankingAsCSV;
    /**
     * The ProgressIDAsCSV
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProgressIDAsCSV;
    /**
     * The AdvertCandidateIDAsCSV
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdvertCandidateIDAsCSV;
    /**
     * The boolIncludeEmailBody
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $boolIncludeEmailBody;
    /**
     * The boolIncludeAttachment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $boolIncludeAttachment;
    /**
     * The boolIncludeParsed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $boolIncludeParsed;
    /**
     * The boolIncludeEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $boolIncludeEmail;
    /**
     * The sLastScoreDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLastScoreDate;
    /**
     * The sLastProgressDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLastProgressDate;
    /**
     * The OrderBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderBy;
    /**
     * Constructor method for GetApplicationsPaged
     * @uses GetApplicationsPaged::setCurrentPage()
     * @uses GetApplicationsPaged::setRowsPerPage()
     * @uses GetApplicationsPaged::setSCultureID()
     * @uses GetApplicationsPaged::setSAPIKey()
     * @uses GetApplicationsPaged::setSUsername()
     * @uses GetApplicationsPaged::setSUserIdentifier()
     * @uses GetApplicationsPaged::setSStartOrganisation()
     * @uses GetApplicationsPaged::setSAdvertIdentifier()
     * @uses GetApplicationsPaged::setSAdvertReference()
     * @uses GetApplicationsPaged::setSAdvertID()
     * @uses GetApplicationsPaged::setDestinationsAsCSV()
     * @uses GetApplicationsPaged::setSApplicationStartDateTime()
     * @uses GetApplicationsPaged::setSApplicationEndDateTime()
     * @uses GetApplicationsPaged::setRankingAsCSV()
     * @uses GetApplicationsPaged::setProgressIDAsCSV()
     * @uses GetApplicationsPaged::setAdvertCandidateIDAsCSV()
     * @uses GetApplicationsPaged::setBoolIncludeEmailBody()
     * @uses GetApplicationsPaged::setBoolIncludeAttachment()
     * @uses GetApplicationsPaged::setBoolIncludeParsed()
     * @uses GetApplicationsPaged::setBoolIncludeEmail()
     * @uses GetApplicationsPaged::setSLastScoreDate()
     * @uses GetApplicationsPaged::setSLastProgressDate()
     * @uses GetApplicationsPaged::setOrderBy()
     * @param int $currentPage
     * @param int $rowsPerPage
     * @param string $sCultureID
     * @param string $sAPIKey
     * @param string $sUsername
     * @param string $sUserIdentifier
     * @param string $sStartOrganisation
     * @param string $sAdvertIdentifier
     * @param string $sAdvertReference
     * @param string $sAdvertID
     * @param string $destinationsAsCSV
     * @param string $sApplicationStartDateTime
     * @param string $sApplicationEndDateTime
     * @param string $rankingAsCSV
     * @param string $progressIDAsCSV
     * @param string $advertCandidateIDAsCSV
     * @param string $boolIncludeEmailBody
     * @param string $boolIncludeAttachment
     * @param string $boolIncludeParsed
     * @param string $boolIncludeEmail
     * @param string $sLastScoreDate
     * @param string $sLastProgressDate
     * @param string $orderBy
     */
    public function __construct($currentPage = null, $rowsPerPage = null, $sCultureID = null, $sAPIKey = null, $sUsername = null, $sUserIdentifier = null, $sStartOrganisation = null, $sAdvertIdentifier = null, $sAdvertReference = null, $sAdvertID = null, $destinationsAsCSV = null, $sApplicationStartDateTime = null, $sApplicationEndDateTime = null, $rankingAsCSV = null, $progressIDAsCSV = null, $advertCandidateIDAsCSV = null, $boolIncludeEmailBody = null, $boolIncludeAttachment = null, $boolIncludeParsed = null, $boolIncludeEmail = null, $sLastScoreDate = null, $sLastProgressDate = null, $orderBy = null)
    {
        $this
            ->setCurrentPage($currentPage)
            ->setRowsPerPage($rowsPerPage)
            ->setSCultureID($sCultureID)
            ->setSAPIKey($sAPIKey)
            ->setSUsername($sUsername)
            ->setSUserIdentifier($sUserIdentifier)
            ->setSStartOrganisation($sStartOrganisation)
            ->setSAdvertIdentifier($sAdvertIdentifier)
            ->setSAdvertReference($sAdvertReference)
            ->setSAdvertID($sAdvertID)
            ->setDestinationsAsCSV($destinationsAsCSV)
            ->setSApplicationStartDateTime($sApplicationStartDateTime)
            ->setSApplicationEndDateTime($sApplicationEndDateTime)
            ->setRankingAsCSV($rankingAsCSV)
            ->setProgressIDAsCSV($progressIDAsCSV)
            ->setAdvertCandidateIDAsCSV($advertCandidateIDAsCSV)
            ->setBoolIncludeEmailBody($boolIncludeEmailBody)
            ->setBoolIncludeAttachment($boolIncludeAttachment)
            ->setBoolIncludeParsed($boolIncludeParsed)
            ->setBoolIncludeEmail($boolIncludeEmail)
            ->setSLastScoreDate($sLastScoreDate)
            ->setSLastProgressDate($sLastProgressDate)
            ->setOrderBy($orderBy);
    }
    /**
     * Get CurrentPage value
     * @return int
     */
    public function getCurrentPage()
    {
        return $this->CurrentPage;
    }
    /**
     * Set CurrentPage value
     * @param int $currentPage
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged
     */
    public function setCurrentPage($currentPage = null)
    {
        // validation for constraint: int
        if (!is_null($currentPage) && !(is_int($currentPage) || ctype_digit($currentPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentPage, true), gettype($currentPage)), __LINE__);
        }
        $this->CurrentPage = $currentPage;
        return $this;
    }
    /**
     * Get RowsPerPage value
     * @return int
     */
    public function getRowsPerPage()
    {
        return $this->RowsPerPage;
    }
    /**
     * Set RowsPerPage value
     * @param int $rowsPerPage
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged
     */
    public function setRowsPerPage($rowsPerPage = null)
    {
        // validation for constraint: int
        if (!is_null($rowsPerPage) && !(is_int($rowsPerPage) || ctype_digit($rowsPerPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowsPerPage, true), gettype($rowsPerPage)), __LINE__);
        }
        $this->RowsPerPage = $rowsPerPage;
        return $this;
    }
    /**
     * Get sCultureID value
     * @return string|null
     */
    public function getSCultureID()
    {
        return $this->sCultureID;
    }
    /**
     * Set sCultureID value
     * @param string $sCultureID
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged
     */
    public function setSCultureID($sCultureID = null)
    {
        // validation for constraint: string
        if (!is_null($sCultureID) && !is_string($sCultureID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sCultureID, true), gettype($sCultureID)), __LINE__);
        }
        $this->sCultureID = $sCultureID;
        return $this;
    }
    /**
     * Get sAPIKey value
     * @return string|null
     */
    public function getSAPIKey()
    {
        return $this->sAPIKey;
    }
    /**
     * Set sAPIKey value
     * @param string $sAPIKey
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged
     */
    public function setSAPIKey($sAPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($sAPIKey) && !is_string($sAPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAPIKey, true), gettype($sAPIKey)), __LINE__);
        }
        $this->sAPIKey = $sAPIKey;
        return $this;
    }
    /**
     * Get sUsername value
     * @return string|null
     */
    public function getSUsername()
    {
        return $this->sUsername;
    }
    /**
     * Set sUsername value
     * @param string $sUsername
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged
     */
    public function setSUsername($sUsername = null)
    {
        // validation for constraint: string
        if (!is_null($sUsername) && !is_string($sUsername)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUsername, true), gettype($sUsername)), __LINE__);
        }
        $this->sUsername = $sUsername;
        return $this;
    }
    /**
     * Get sUserIdentifier value
     * @return string|null
     */
    public function getSUserIdentifier()
    {
        return $this->sUserIdentifier;
    }
    /**
     * Set sUserIdentifier value
     * @param string $sUserIdentifier
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged
     */
    public function setSUserIdentifier($sUserIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($sUserIdentifier) && !is_string($sUserIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUserIdentifier, true), gettype($sUserIdentifier)), __LINE__);
        }
        $this->sUserIdentifier = $sUserIdentifier;
        return $this;
    }
    /**
     * Get sStartOrganisation value
     * @return string|null
     */
    public function getSStartOrganisation()
    {
        return $this->sStartOrganisation;
    }
    /**
     * Set sStartOrganisation value
     * @param string $sStartOrganisation
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged
     */
    public function setSStartOrganisation($sStartOrganisation = null)
    {
        // validation for constraint: string
        if (!is_null($sStartOrganisation) && !is_string($sStartOrganisation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sStartOrganisation, true), gettype($sStartOrganisation)), __LINE__);
        }
        $this->sStartOrganisation = $sStartOrganisation;
        return $this;
    }
    /**
     * Get sAdvertIdentifier value
     * @return string|null
     */
    public function getSAdvertIdentifier()
    {
        return $this->sAdvertIdentifier;
    }
    /**
     * Set sAdvertIdentifier value
     * @param string $sAdvertIdentifier
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged
     */
    public function setSAdvertIdentifier($sAdvertIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($sAdvertIdentifier) && !is_string($sAdvertIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAdvertIdentifier, true), gettype($sAdvertIdentifier)), __LINE__);
        }
        $this->sAdvertIdentifier = $sAdvertIdentifier;
        return $this;
    }
    /**
     * Get sAdvertReference value
     * @return string|null
     */
    public function getSAdvertReference()
    {
        return $this->sAdvertReference;
    }
    /**
     * Set sAdvertReference value
     * @param string $sAdvertReference
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged
     */
    public function setSAdvertReference($sAdvertReference = null)
    {
        // validation for constraint: string
        if (!is_null($sAdvertReference) && !is_string($sAdvertReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAdvertReference, true), gettype($sAdvertReference)), __LINE__);
        }
        $this->sAdvertReference = $sAdvertReference;
        return $this;
    }
    /**
     * Get sAdvertID value
     * @return string|null
     */
    public function getSAdvertID()
    {
        return $this->sAdvertID;
    }
    /**
     * Set sAdvertID value
     * @param string $sAdvertID
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged
     */
    public function setSAdvertID($sAdvertID = null)
    {
        // validation for constraint: string
        if (!is_null($sAdvertID) && !is_string($sAdvertID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAdvertID, true), gettype($sAdvertID)), __LINE__);
        }
        $this->sAdvertID = $sAdvertID;
        return $this;
    }
    /**
     * Get DestinationsAsCSV value
     * @return string|null
     */
    public function getDestinationsAsCSV()
    {
        return $this->DestinationsAsCSV;
    }
    /**
     * Set DestinationsAsCSV value
     * @param string $destinationsAsCSV
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged
     */
    public function setDestinationsAsCSV($destinationsAsCSV = null)
    {
        // validation for constraint: string
        if (!is_null($destinationsAsCSV) && !is_string($destinationsAsCSV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationsAsCSV, true), gettype($destinationsAsCSV)), __LINE__);
        }
        $this->DestinationsAsCSV = $destinationsAsCSV;
        return $this;
    }
    /**
     * Get sApplicationStartDateTime value
     * @return string|null
     */
    public function getSApplicationStartDateTime()
    {
        return $this->sApplicationStartDateTime;
    }
    /**
     * Set sApplicationStartDateTime value
     * @param string $sApplicationStartDateTime
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged
     */
    public function setSApplicationStartDateTime($sApplicationStartDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($sApplicationStartDateTime) && !is_string($sApplicationStartDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sApplicationStartDateTime, true), gettype($sApplicationStartDateTime)), __LINE__);
        }
        $this->sApplicationStartDateTime = $sApplicationStartDateTime;
        return $this;
    }
    /**
     * Get sApplicationEndDateTime value
     * @return string|null
     */
    public function getSApplicationEndDateTime()
    {
        return $this->sApplicationEndDateTime;
    }
    /**
     * Set sApplicationEndDateTime value
     * @param string $sApplicationEndDateTime
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged
     */
    public function setSApplicationEndDateTime($sApplicationEndDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($sApplicationEndDateTime) && !is_string($sApplicationEndDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sApplicationEndDateTime, true), gettype($sApplicationEndDateTime)), __LINE__);
        }
        $this->sApplicationEndDateTime = $sApplicationEndDateTime;
        return $this;
    }
    /**
     * Get RankingAsCSV value
     * @return string|null
     */
    public function getRankingAsCSV()
    {
        return $this->RankingAsCSV;
    }
    /**
     * Set RankingAsCSV value
     * @param string $rankingAsCSV
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged
     */
    public function setRankingAsCSV($rankingAsCSV = null)
    {
        // validation for constraint: string
        if (!is_null($rankingAsCSV) && !is_string($rankingAsCSV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rankingAsCSV, true), gettype($rankingAsCSV)), __LINE__);
        }
        $this->RankingAsCSV = $rankingAsCSV;
        return $this;
    }
    /**
     * Get ProgressIDAsCSV value
     * @return string|null
     */
    public function getProgressIDAsCSV()
    {
        return $this->ProgressIDAsCSV;
    }
    /**
     * Set ProgressIDAsCSV value
     * @param string $progressIDAsCSV
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged
     */
    public function setProgressIDAsCSV($progressIDAsCSV = null)
    {
        // validation for constraint: string
        if (!is_null($progressIDAsCSV) && !is_string($progressIDAsCSV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($progressIDAsCSV, true), gettype($progressIDAsCSV)), __LINE__);
        }
        $this->ProgressIDAsCSV = $progressIDAsCSV;
        return $this;
    }
    /**
     * Get AdvertCandidateIDAsCSV value
     * @return string|null
     */
    public function getAdvertCandidateIDAsCSV()
    {
        return $this->AdvertCandidateIDAsCSV;
    }
    /**
     * Set AdvertCandidateIDAsCSV value
     * @param string $advertCandidateIDAsCSV
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged
     */
    public function setAdvertCandidateIDAsCSV($advertCandidateIDAsCSV = null)
    {
        // validation for constraint: string
        if (!is_null($advertCandidateIDAsCSV) && !is_string($advertCandidateIDAsCSV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advertCandidateIDAsCSV, true), gettype($advertCandidateIDAsCSV)), __LINE__);
        }
        $this->AdvertCandidateIDAsCSV = $advertCandidateIDAsCSV;
        return $this;
    }
    /**
     * Get boolIncludeEmailBody value
     * @return string|null
     */
    public function getBoolIncludeEmailBody()
    {
        return $this->boolIncludeEmailBody;
    }
    /**
     * Set boolIncludeEmailBody value
     * @param string $boolIncludeEmailBody
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged
     */
    public function setBoolIncludeEmailBody($boolIncludeEmailBody = null)
    {
        // validation for constraint: string
        if (!is_null($boolIncludeEmailBody) && !is_string($boolIncludeEmailBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boolIncludeEmailBody, true), gettype($boolIncludeEmailBody)), __LINE__);
        }
        $this->boolIncludeEmailBody = $boolIncludeEmailBody;
        return $this;
    }
    /**
     * Get boolIncludeAttachment value
     * @return string|null
     */
    public function getBoolIncludeAttachment()
    {
        return $this->boolIncludeAttachment;
    }
    /**
     * Set boolIncludeAttachment value
     * @param string $boolIncludeAttachment
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged
     */
    public function setBoolIncludeAttachment($boolIncludeAttachment = null)
    {
        // validation for constraint: string
        if (!is_null($boolIncludeAttachment) && !is_string($boolIncludeAttachment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boolIncludeAttachment, true), gettype($boolIncludeAttachment)), __LINE__);
        }
        $this->boolIncludeAttachment = $boolIncludeAttachment;
        return $this;
    }
    /**
     * Get boolIncludeParsed value
     * @return string|null
     */
    public function getBoolIncludeParsed()
    {
        return $this->boolIncludeParsed;
    }
    /**
     * Set boolIncludeParsed value
     * @param string $boolIncludeParsed
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged
     */
    public function setBoolIncludeParsed($boolIncludeParsed = null)
    {
        // validation for constraint: string
        if (!is_null($boolIncludeParsed) && !is_string($boolIncludeParsed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boolIncludeParsed, true), gettype($boolIncludeParsed)), __LINE__);
        }
        $this->boolIncludeParsed = $boolIncludeParsed;
        return $this;
    }
    /**
     * Get boolIncludeEmail value
     * @return string|null
     */
    public function getBoolIncludeEmail()
    {
        return $this->boolIncludeEmail;
    }
    /**
     * Set boolIncludeEmail value
     * @param string $boolIncludeEmail
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged
     */
    public function setBoolIncludeEmail($boolIncludeEmail = null)
    {
        // validation for constraint: string
        if (!is_null($boolIncludeEmail) && !is_string($boolIncludeEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boolIncludeEmail, true), gettype($boolIncludeEmail)), __LINE__);
        }
        $this->boolIncludeEmail = $boolIncludeEmail;
        return $this;
    }
    /**
     * Get sLastScoreDate value
     * @return string|null
     */
    public function getSLastScoreDate()
    {
        return $this->sLastScoreDate;
    }
    /**
     * Set sLastScoreDate value
     * @param string $sLastScoreDate
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged
     */
    public function setSLastScoreDate($sLastScoreDate = null)
    {
        // validation for constraint: string
        if (!is_null($sLastScoreDate) && !is_string($sLastScoreDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLastScoreDate, true), gettype($sLastScoreDate)), __LINE__);
        }
        $this->sLastScoreDate = $sLastScoreDate;
        return $this;
    }
    /**
     * Get sLastProgressDate value
     * @return string|null
     */
    public function getSLastProgressDate()
    {
        return $this->sLastProgressDate;
    }
    /**
     * Set sLastProgressDate value
     * @param string $sLastProgressDate
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged
     */
    public function setSLastProgressDate($sLastProgressDate = null)
    {
        // validation for constraint: string
        if (!is_null($sLastProgressDate) && !is_string($sLastProgressDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLastProgressDate, true), gettype($sLastProgressDate)), __LINE__);
        }
        $this->sLastProgressDate = $sLastProgressDate;
        return $this;
    }
    /**
     * Get OrderBy value
     * @return string|null
     */
    public function getOrderBy()
    {
        return $this->OrderBy;
    }
    /**
     * Set OrderBy value
     * @param string $orderBy
     * @return \RecruitCrm\LogicMelon\StructType\GetApplicationsPaged
     */
    public function setOrderBy($orderBy = null)
    {
        // validation for constraint: string
        if (!is_null($orderBy) && !is_string($orderBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderBy, true), gettype($orderBy)), __LINE__);
        }
        $this->OrderBy = $orderBy;
        return $this;
    }
}
