<?php

namespace RecruitCrm\LogicMelon\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Archive ServiceType
 * @subpackage Services
 */
class Archive extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ArchiveAdvert
     * Meta information extracted from the WSDL
     * - documentation: <a name='ArchiveAdvert'></a><p>Provides a mechanism to archive an advert and abort future postings. If you want to close an advert on portals and other media that support this please use the CloseAdvert method.</p><p>Optionally
     * specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</p> | <a name='ArchiveAdvert'></a><p>Provides a mechanism to archive an advert and
     * abort future postings. If you want to close an advert on portals and other media that support this please use the CloseAdvert method.</p><p>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or
     * sUserIdentifier) or specific portion of the tree (sStartOrganisation).</p> | <a name='ArchiveAdvert'></a><p>Provides a mechanism to archive an advert and abort future postings. If you want to close an advert on portals and other media that support
     * this please use the CloseAdvert method.</p><p>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</p>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\ArchiveAdvert $parameters
     * @return \RecruitCrm\LogicMelon\StructType\ArchiveAdvertResponse|bool
     */
    public function ArchiveAdvert(\RecruitCrm\LogicMelon\StructType\ArchiveAdvert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ArchiveAdvert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ArchiveAdvertWithFilters
     * Meta information extracted from the WSDL
     * - documentation: <a name='ArchiveAdvertWithFilters'></a><p>Provides a mechanism to archive an advert and abort future postings. If you want to close an advert on portals and other media that support this please use the CloseAdvert
     * method.</p><p>Optionally specify a sUsername or sStartOrganisation to limit the search to a specific user (sUsername or sUserIdentifier) or specific portion of the tree (sStartOrganisation).</p>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RecruitCrm\LogicMelon\StructType\ArchiveAdvertWithFilters $parameters
     * @return \RecruitCrm\LogicMelon\StructType\ArchiveAdvertWithFiltersResponse|bool
     */
    public function ArchiveAdvertWithFilters(\RecruitCrm\LogicMelon\StructType\ArchiveAdvertWithFilters $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ArchiveAdvertWithFilters($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \RecruitCrm\LogicMelon\StructType\ArchiveAdvertResponse|\RecruitCrm\LogicMelon\StructType\ArchiveAdvertWithFiltersResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
