<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetValue StructType
 * @subpackage Structs
 */
class GetValue extends AbstractStructBase
{
    /**
     * The FieldID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FieldID;
    /**
     * The OrganisationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrganisationID;
    /**
     * The SortOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SortOrder;
    /**
     * The CultureID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CultureID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * Constructor method for GetValue
     * @uses GetValue::setFieldID()
     * @uses GetValue::setOrganisationID()
     * @uses GetValue::setSortOrder()
     * @uses GetValue::setCultureID()
     * @uses GetValue::setDescription()
     * @uses GetValue::setValue()
     * @param int $fieldID
     * @param int $organisationID
     * @param int $sortOrder
     * @param string $cultureID
     * @param string $description
     * @param string $value
     */
    public function __construct($fieldID = null, $organisationID = null, $sortOrder = null, $cultureID = null, $description = null, $value = null)
    {
        $this
            ->setFieldID($fieldID)
            ->setOrganisationID($organisationID)
            ->setSortOrder($sortOrder)
            ->setCultureID($cultureID)
            ->setDescription($description)
            ->setValue($value);
    }
    /**
     * Get FieldID value
     * @return int
     */
    public function getFieldID()
    {
        return $this->FieldID;
    }
    /**
     * Set FieldID value
     * @param int $fieldID
     * @return \RecruitCrm\LogicMelon\StructType\GetValue
     */
    public function setFieldID($fieldID = null)
    {
        // validation for constraint: int
        if (!is_null($fieldID) && !(is_int($fieldID) || ctype_digit($fieldID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fieldID, true), gettype($fieldID)), __LINE__);
        }
        $this->FieldID = $fieldID;
        return $this;
    }
    /**
     * Get OrganisationID value
     * @return int
     */
    public function getOrganisationID()
    {
        return $this->OrganisationID;
    }
    /**
     * Set OrganisationID value
     * @param int $organisationID
     * @return \RecruitCrm\LogicMelon\StructType\GetValue
     */
    public function setOrganisationID($organisationID = null)
    {
        // validation for constraint: int
        if (!is_null($organisationID) && !(is_int($organisationID) || ctype_digit($organisationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($organisationID, true), gettype($organisationID)), __LINE__);
        }
        $this->OrganisationID = $organisationID;
        return $this;
    }
    /**
     * Get SortOrder value
     * @return int
     */
    public function getSortOrder()
    {
        return $this->SortOrder;
    }
    /**
     * Set SortOrder value
     * @param int $sortOrder
     * @return \RecruitCrm\LogicMelon\StructType\GetValue
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: int
        if (!is_null($sortOrder) && !(is_int($sortOrder) || ctype_digit($sortOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sortOrder, true), gettype($sortOrder)), __LINE__);
        }
        $this->SortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get CultureID value
     * @return string|null
     */
    public function getCultureID()
    {
        return $this->CultureID;
    }
    /**
     * Set CultureID value
     * @param string $cultureID
     * @return \RecruitCrm\LogicMelon\StructType\GetValue
     */
    public function setCultureID($cultureID = null)
    {
        // validation for constraint: string
        if (!is_null($cultureID) && !is_string($cultureID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cultureID, true), gettype($cultureID)), __LINE__);
        }
        $this->CultureID = $cultureID;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \RecruitCrm\LogicMelon\StructType\GetValue
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \RecruitCrm\LogicMelon\StructType\GetValue
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
