<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CQueryLocation StructType
 * @subpackage Structs
 */
class CQueryLocation extends AbstractStructBase
{
    /**
     * The LocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LocationID;
    /**
     * The Score
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Score;
    /**
     * The Latitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Longitude;
    /**
     * The Display
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Display;
    /**
     * The LocationDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationDescription;
    /**
     * The LocationIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationIdentifier;
    /**
     * The LocationValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationValue;
    /**
     * Constructor method for CQueryLocation
     * @uses CQueryLocation::setLocationID()
     * @uses CQueryLocation::setScore()
     * @uses CQueryLocation::setLatitude()
     * @uses CQueryLocation::setLongitude()
     * @uses CQueryLocation::setDisplay()
     * @uses CQueryLocation::setLocationDescription()
     * @uses CQueryLocation::setLocationIdentifier()
     * @uses CQueryLocation::setLocationValue()
     * @param int $locationID
     * @param int $score
     * @param float $latitude
     * @param float $longitude
     * @param string $display
     * @param string $locationDescription
     * @param string $locationIdentifier
     * @param string $locationValue
     */
    public function __construct($locationID = null, $score = null, $latitude = null, $longitude = null, $display = null, $locationDescription = null, $locationIdentifier = null, $locationValue = null)
    {
        $this
            ->setLocationID($locationID)
            ->setScore($score)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setDisplay($display)
            ->setLocationDescription($locationDescription)
            ->setLocationIdentifier($locationIdentifier)
            ->setLocationValue($locationValue);
    }
    /**
     * Get LocationID value
     * @return int
     */
    public function getLocationID()
    {
        return $this->LocationID;
    }
    /**
     * Set LocationID value
     * @param int $locationID
     * @return \RecruitCrm\LogicMelon\StructType\CQueryLocation
     */
    public function setLocationID($locationID = null)
    {
        // validation for constraint: int
        if (!is_null($locationID) && !(is_int($locationID) || ctype_digit($locationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($locationID, true), gettype($locationID)), __LINE__);
        }
        $this->LocationID = $locationID;
        return $this;
    }
    /**
     * Get Score value
     * @return int
     */
    public function getScore()
    {
        return $this->Score;
    }
    /**
     * Set Score value
     * @param int $score
     * @return \RecruitCrm\LogicMelon\StructType\CQueryLocation
     */
    public function setScore($score = null)
    {
        // validation for constraint: int
        if (!is_null($score) && !(is_int($score) || ctype_digit($score))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($score, true), gettype($score)), __LINE__);
        }
        $this->Score = $score;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \RecruitCrm\LogicMelon\StructType\CQueryLocation
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \RecruitCrm\LogicMelon\StructType\CQueryLocation
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Display value
     * @return string|null
     */
    public function getDisplay()
    {
        return $this->Display;
    }
    /**
     * Set Display value
     * @param string $display
     * @return \RecruitCrm\LogicMelon\StructType\CQueryLocation
     */
    public function setDisplay($display = null)
    {
        // validation for constraint: string
        if (!is_null($display) && !is_string($display)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($display, true), gettype($display)), __LINE__);
        }
        $this->Display = $display;
        return $this;
    }
    /**
     * Get LocationDescription value
     * @return string|null
     */
    public function getLocationDescription()
    {
        return $this->LocationDescription;
    }
    /**
     * Set LocationDescription value
     * @param string $locationDescription
     * @return \RecruitCrm\LogicMelon\StructType\CQueryLocation
     */
    public function setLocationDescription($locationDescription = null)
    {
        // validation for constraint: string
        if (!is_null($locationDescription) && !is_string($locationDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationDescription, true), gettype($locationDescription)), __LINE__);
        }
        $this->LocationDescription = $locationDescription;
        return $this;
    }
    /**
     * Get LocationIdentifier value
     * @return string|null
     */
    public function getLocationIdentifier()
    {
        return $this->LocationIdentifier;
    }
    /**
     * Set LocationIdentifier value
     * @param string $locationIdentifier
     * @return \RecruitCrm\LogicMelon\StructType\CQueryLocation
     */
    public function setLocationIdentifier($locationIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($locationIdentifier) && !is_string($locationIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationIdentifier, true), gettype($locationIdentifier)), __LINE__);
        }
        $this->LocationIdentifier = $locationIdentifier;
        return $this;
    }
    /**
     * Get LocationValue value
     * @return string|null
     */
    public function getLocationValue()
    {
        return $this->LocationValue;
    }
    /**
     * Set LocationValue value
     * @param string $locationValue
     * @return \RecruitCrm\LogicMelon\StructType\CQueryLocation
     */
    public function setLocationValue($locationValue = null)
    {
        // validation for constraint: string
        if (!is_null($locationValue) && !is_string($locationValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationValue, true), gettype($locationValue)), __LINE__);
        }
        $this->LocationValue = $locationValue;
        return $this;
    }
}
