<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddAdvertValues StructType
 * @subpackage Structs
 */
class AddAdvertValues extends AbstractStructBase
{
    /**
     * The sCultureID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sCultureID;
    /**
     * The sAPIKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAPIKey;
    /**
     * The sUsername
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sUsername;
    /**
     * The sPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sPassword;
    /**
     * The sAdvertIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAdvertIdentifier;
    /**
     * The sAdvertReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAdvertReference;
    /**
     * The sAdvertID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAdvertID;
    /**
     * The sSearchDays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sSearchDays;
    /**
     * The AdvertValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValue
     */
    public $AdvertValues;
    /**
     * The sRedirectDomain
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sRedirectDomain;
    /**
     * Constructor method for AddAdvertValues
     * @uses AddAdvertValues::setSCultureID()
     * @uses AddAdvertValues::setSAPIKey()
     * @uses AddAdvertValues::setSUsername()
     * @uses AddAdvertValues::setSPassword()
     * @uses AddAdvertValues::setSAdvertIdentifier()
     * @uses AddAdvertValues::setSAdvertReference()
     * @uses AddAdvertValues::setSAdvertID()
     * @uses AddAdvertValues::setSSearchDays()
     * @uses AddAdvertValues::setAdvertValues()
     * @uses AddAdvertValues::setSRedirectDomain()
     * @param string $sCultureID
     * @param string $sAPIKey
     * @param string $sUsername
     * @param string $sPassword
     * @param string $sAdvertIdentifier
     * @param string $sAdvertReference
     * @param string $sAdvertID
     * @param string $sSearchDays
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValue $advertValues
     * @param string $sRedirectDomain
     */
    public function __construct($sCultureID = null, $sAPIKey = null, $sUsername = null, $sPassword = null, $sAdvertIdentifier = null, $sAdvertReference = null, $sAdvertID = null, $sSearchDays = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValue $advertValues = null, $sRedirectDomain = null)
    {
        $this
            ->setSCultureID($sCultureID)
            ->setSAPIKey($sAPIKey)
            ->setSUsername($sUsername)
            ->setSPassword($sPassword)
            ->setSAdvertIdentifier($sAdvertIdentifier)
            ->setSAdvertReference($sAdvertReference)
            ->setSAdvertID($sAdvertID)
            ->setSSearchDays($sSearchDays)
            ->setAdvertValues($advertValues)
            ->setSRedirectDomain($sRedirectDomain);
    }
    /**
     * Get sCultureID value
     * @return string|null
     */
    public function getSCultureID()
    {
        return $this->sCultureID;
    }
    /**
     * Set sCultureID value
     * @param string $sCultureID
     * @return \RecruitCrm\LogicMelon\StructType\AddAdvertValues
     */
    public function setSCultureID($sCultureID = null)
    {
        // validation for constraint: string
        if (!is_null($sCultureID) && !is_string($sCultureID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sCultureID, true), gettype($sCultureID)), __LINE__);
        }
        $this->sCultureID = $sCultureID;
        return $this;
    }
    /**
     * Get sAPIKey value
     * @return string|null
     */
    public function getSAPIKey()
    {
        return $this->sAPIKey;
    }
    /**
     * Set sAPIKey value
     * @param string $sAPIKey
     * @return \RecruitCrm\LogicMelon\StructType\AddAdvertValues
     */
    public function setSAPIKey($sAPIKey = null)
    {
        // validation for constraint: string
        if (!is_null($sAPIKey) && !is_string($sAPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAPIKey, true), gettype($sAPIKey)), __LINE__);
        }
        $this->sAPIKey = $sAPIKey;
        return $this;
    }
    /**
     * Get sUsername value
     * @return string|null
     */
    public function getSUsername()
    {
        return $this->sUsername;
    }
    /**
     * Set sUsername value
     * @param string $sUsername
     * @return \RecruitCrm\LogicMelon\StructType\AddAdvertValues
     */
    public function setSUsername($sUsername = null)
    {
        // validation for constraint: string
        if (!is_null($sUsername) && !is_string($sUsername)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUsername, true), gettype($sUsername)), __LINE__);
        }
        $this->sUsername = $sUsername;
        return $this;
    }
    /**
     * Get sPassword value
     * @return string|null
     */
    public function getSPassword()
    {
        return $this->sPassword;
    }
    /**
     * Set sPassword value
     * @param string $sPassword
     * @return \RecruitCrm\LogicMelon\StructType\AddAdvertValues
     */
    public function setSPassword($sPassword = null)
    {
        // validation for constraint: string
        if (!is_null($sPassword) && !is_string($sPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sPassword, true), gettype($sPassword)), __LINE__);
        }
        $this->sPassword = $sPassword;
        return $this;
    }
    /**
     * Get sAdvertIdentifier value
     * @return string|null
     */
    public function getSAdvertIdentifier()
    {
        return $this->sAdvertIdentifier;
    }
    /**
     * Set sAdvertIdentifier value
     * @param string $sAdvertIdentifier
     * @return \RecruitCrm\LogicMelon\StructType\AddAdvertValues
     */
    public function setSAdvertIdentifier($sAdvertIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($sAdvertIdentifier) && !is_string($sAdvertIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAdvertIdentifier, true), gettype($sAdvertIdentifier)), __LINE__);
        }
        $this->sAdvertIdentifier = $sAdvertIdentifier;
        return $this;
    }
    /**
     * Get sAdvertReference value
     * @return string|null
     */
    public function getSAdvertReference()
    {
        return $this->sAdvertReference;
    }
    /**
     * Set sAdvertReference value
     * @param string $sAdvertReference
     * @return \RecruitCrm\LogicMelon\StructType\AddAdvertValues
     */
    public function setSAdvertReference($sAdvertReference = null)
    {
        // validation for constraint: string
        if (!is_null($sAdvertReference) && !is_string($sAdvertReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAdvertReference, true), gettype($sAdvertReference)), __LINE__);
        }
        $this->sAdvertReference = $sAdvertReference;
        return $this;
    }
    /**
     * Get sAdvertID value
     * @return string|null
     */
    public function getSAdvertID()
    {
        return $this->sAdvertID;
    }
    /**
     * Set sAdvertID value
     * @param string $sAdvertID
     * @return \RecruitCrm\LogicMelon\StructType\AddAdvertValues
     */
    public function setSAdvertID($sAdvertID = null)
    {
        // validation for constraint: string
        if (!is_null($sAdvertID) && !is_string($sAdvertID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAdvertID, true), gettype($sAdvertID)), __LINE__);
        }
        $this->sAdvertID = $sAdvertID;
        return $this;
    }
    /**
     * Get sSearchDays value
     * @return string|null
     */
    public function getSSearchDays()
    {
        return $this->sSearchDays;
    }
    /**
     * Set sSearchDays value
     * @param string $sSearchDays
     * @return \RecruitCrm\LogicMelon\StructType\AddAdvertValues
     */
    public function setSSearchDays($sSearchDays = null)
    {
        // validation for constraint: string
        if (!is_null($sSearchDays) && !is_string($sSearchDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSearchDays, true), gettype($sSearchDays)), __LINE__);
        }
        $this->sSearchDays = $sSearchDays;
        return $this;
    }
    /**
     * Get AdvertValues value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValue|null
     */
    public function getAdvertValues()
    {
        return $this->AdvertValues;
    }
    /**
     * Set AdvertValues value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValue $advertValues
     * @return \RecruitCrm\LogicMelon\StructType\AddAdvertValues
     */
    public function setAdvertValues(\RecruitCrm\LogicMelon\ArrayType\ArrayOfNameValue $advertValues = null)
    {
        $this->AdvertValues = $advertValues;
        return $this;
    }
    /**
     * Get sRedirectDomain value
     * @return string|null
     */
    public function getSRedirectDomain()
    {
        return $this->sRedirectDomain;
    }
    /**
     * Set sRedirectDomain value
     * @param string $sRedirectDomain
     * @return \RecruitCrm\LogicMelon\StructType\AddAdvertValues
     */
    public function setSRedirectDomain($sRedirectDomain = null)
    {
        // validation for constraint: string
        if (!is_null($sRedirectDomain) && !is_string($sRedirectDomain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sRedirectDomain, true), gettype($sRedirectDomain)), __LINE__);
        }
        $this->sRedirectDomain = $sRedirectDomain;
        return $this;
    }
}
