<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APIAdvertWithValues StructType
 * @subpackage Structs
 */
class APIAdvertWithValues extends AbstractStructBase
{
    /**
     * The Advert
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public $Advert;
    /**
     * The AdvertValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvertValue
     */
    public $AdvertValues;
    /**
     * Constructor method for APIAdvertWithValues
     * @uses APIAdvertWithValues::setAdvert()
     * @uses APIAdvertWithValues::setAdvertValues()
     * @param \RecruitCrm\LogicMelon\StructType\APIAdvert $advert
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvertValue $advertValues
     */
    public function __construct(\RecruitCrm\LogicMelon\StructType\APIAdvert $advert = null, \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvertValue $advertValues = null)
    {
        $this
            ->setAdvert($advert)
            ->setAdvertValues($advertValues);
    }
    /**
     * Get Advert value
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert|null
     */
    public function getAdvert()
    {
        return $this->Advert;
    }
    /**
     * Set Advert value
     * @param \RecruitCrm\LogicMelon\StructType\APIAdvert $advert
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertWithValues
     */
    public function setAdvert(\RecruitCrm\LogicMelon\StructType\APIAdvert $advert = null)
    {
        $this->Advert = $advert;
        return $this;
    }
    /**
     * Get AdvertValues value
     * @return \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvertValue|null
     */
    public function getAdvertValues()
    {
        return $this->AdvertValues;
    }
    /**
     * Set AdvertValues value
     * @param \RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvertValue $advertValues
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvertWithValues
     */
    public function setAdvertValues(\RecruitCrm\LogicMelon\ArrayType\ArrayOfAPIAdvertValue $advertValues = null)
    {
        $this->AdvertValues = $advertValues;
        return $this;
    }
}
