<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APIAdvert StructType
 * @subpackage Structs
 */
class APIAdvert extends AbstractStructBase
{
    /**
     * The AdvertID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AdvertID;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The OrganisationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrganisationID;
    /**
     * The LastPostDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastPostDate;
    /**
     * The Applications
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Applications;
    /**
     * The Unsuitable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Unsuitable;
    /**
     * The MaybeSuitable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaybeSuitable;
    /**
     * The Suitable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Suitable;
    /**
     * The AdvertStatusID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AdvertStatusID;
    /**
     * The InterviewConfirmed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InterviewConfirmed;
    /**
     * The InterviewPending
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InterviewPending;
    /**
     * The WithStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WithStatus;
    /**
     * The WithStatusNew
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WithStatusNew;
    /**
     * The InterviewCannotAttend
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InterviewCannotAttend;
    /**
     * The InterviewDeclined
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InterviewDeclined;
    /**
     * The LastScoreDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastScoreDate;
    /**
     * The LastProgressDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastProgressDate;
    /**
     * The LastDeliveryStatusID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LastDeliveryStatusID;
    /**
     * The LastDeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastDeliveryDate;
    /**
     * The Viewed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Viewed;
    /**
     * The SalaryHide
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SalaryHide;
    /**
     * The latitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $latitude;
    /**
     * The longitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $longitude;
    /**
     * The SchemaIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SchemaIdentifier;
    /**
     * The AdvertIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdvertIdentifier;
    /**
     * The AdvertReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdvertReference;
    /**
     * The AdvertTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdvertTitle;
    /**
     * The AdvertType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdvertType;
    /**
     * The AdvertHours
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdvertHours;
    /**
     * The Industry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Industry;
    /**
     * The SalaryFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalaryFrom;
    /**
     * The SalaryTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalaryTo;
    /**
     * The SalaryCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalaryCurrency;
    /**
     * The SalaryPer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalaryPer;
    /**
     * The JobDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $JobDescription;
    /**
     * The PrimaryLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryLocation;
    /**
     * The SalaryBenefits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalaryBenefits;
    /**
     * The ContactName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactName;
    /**
     * The ContactEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactEmail;
    /**
     * The Source
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Source;
    /**
     * The sLastPostDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLastPostDate;
    /**
     * The sLastDeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLastDeliveryDate;
    /**
     * The sLastScoreDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLastScoreDate;
    /**
     * The sLastProgressDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLastProgressDate;
    /**
     * Constructor method for APIAdvert
     * @uses APIAdvert::setAdvertID()
     * @uses APIAdvert::setUserID()
     * @uses APIAdvert::setOrganisationID()
     * @uses APIAdvert::setLastPostDate()
     * @uses APIAdvert::setApplications()
     * @uses APIAdvert::setUnsuitable()
     * @uses APIAdvert::setMaybeSuitable()
     * @uses APIAdvert::setSuitable()
     * @uses APIAdvert::setAdvertStatusID()
     * @uses APIAdvert::setInterviewConfirmed()
     * @uses APIAdvert::setInterviewPending()
     * @uses APIAdvert::setWithStatus()
     * @uses APIAdvert::setWithStatusNew()
     * @uses APIAdvert::setInterviewCannotAttend()
     * @uses APIAdvert::setInterviewDeclined()
     * @uses APIAdvert::setLastScoreDate()
     * @uses APIAdvert::setLastProgressDate()
     * @uses APIAdvert::setLastDeliveryStatusID()
     * @uses APIAdvert::setLastDeliveryDate()
     * @uses APIAdvert::setViewed()
     * @uses APIAdvert::setSalaryHide()
     * @uses APIAdvert::setLatitude()
     * @uses APIAdvert::setLongitude()
     * @uses APIAdvert::setSchemaIdentifier()
     * @uses APIAdvert::setAdvertIdentifier()
     * @uses APIAdvert::setAdvertReference()
     * @uses APIAdvert::setAdvertTitle()
     * @uses APIAdvert::setAdvertType()
     * @uses APIAdvert::setAdvertHours()
     * @uses APIAdvert::setIndustry()
     * @uses APIAdvert::setSalaryFrom()
     * @uses APIAdvert::setSalaryTo()
     * @uses APIAdvert::setSalaryCurrency()
     * @uses APIAdvert::setSalaryPer()
     * @uses APIAdvert::setJobDescription()
     * @uses APIAdvert::setPrimaryLocation()
     * @uses APIAdvert::setSalaryBenefits()
     * @uses APIAdvert::setContactName()
     * @uses APIAdvert::setContactEmail()
     * @uses APIAdvert::setSource()
     * @uses APIAdvert::setSLastPostDate()
     * @uses APIAdvert::setSLastDeliveryDate()
     * @uses APIAdvert::setSLastScoreDate()
     * @uses APIAdvert::setSLastProgressDate()
     * @param int $advertID
     * @param int $userID
     * @param int $organisationID
     * @param string $lastPostDate
     * @param int $applications
     * @param int $unsuitable
     * @param int $maybeSuitable
     * @param int $suitable
     * @param int $advertStatusID
     * @param int $interviewConfirmed
     * @param int $interviewPending
     * @param int $withStatus
     * @param int $withStatusNew
     * @param int $interviewCannotAttend
     * @param int $interviewDeclined
     * @param string $lastScoreDate
     * @param string $lastProgressDate
     * @param int $lastDeliveryStatusID
     * @param string $lastDeliveryDate
     * @param int $viewed
     * @param bool $salaryHide
     * @param float $latitude
     * @param float $longitude
     * @param string $schemaIdentifier
     * @param string $advertIdentifier
     * @param string $advertReference
     * @param string $advertTitle
     * @param string $advertType
     * @param string $advertHours
     * @param string $industry
     * @param string $salaryFrom
     * @param string $salaryTo
     * @param string $salaryCurrency
     * @param string $salaryPer
     * @param string $jobDescription
     * @param string $primaryLocation
     * @param string $salaryBenefits
     * @param string $contactName
     * @param string $contactEmail
     * @param string $source
     * @param string $sLastPostDate
     * @param string $sLastDeliveryDate
     * @param string $sLastScoreDate
     * @param string $sLastProgressDate
     */
    public function __construct($advertID = null, $userID = null, $organisationID = null, $lastPostDate = null, $applications = null, $unsuitable = null, $maybeSuitable = null, $suitable = null, $advertStatusID = null, $interviewConfirmed = null, $interviewPending = null, $withStatus = null, $withStatusNew = null, $interviewCannotAttend = null, $interviewDeclined = null, $lastScoreDate = null, $lastProgressDate = null, $lastDeliveryStatusID = null, $lastDeliveryDate = null, $viewed = null, $salaryHide = null, $latitude = null, $longitude = null, $schemaIdentifier = null, $advertIdentifier = null, $advertReference = null, $advertTitle = null, $advertType = null, $advertHours = null, $industry = null, $salaryFrom = null, $salaryTo = null, $salaryCurrency = null, $salaryPer = null, $jobDescription = null, $primaryLocation = null, $salaryBenefits = null, $contactName = null, $contactEmail = null, $source = null, $sLastPostDate = null, $sLastDeliveryDate = null, $sLastScoreDate = null, $sLastProgressDate = null)
    {
        $this
            ->setAdvertID($advertID)
            ->setUserID($userID)
            ->setOrganisationID($organisationID)
            ->setLastPostDate($lastPostDate)
            ->setApplications($applications)
            ->setUnsuitable($unsuitable)
            ->setMaybeSuitable($maybeSuitable)
            ->setSuitable($suitable)
            ->setAdvertStatusID($advertStatusID)
            ->setInterviewConfirmed($interviewConfirmed)
            ->setInterviewPending($interviewPending)
            ->setWithStatus($withStatus)
            ->setWithStatusNew($withStatusNew)
            ->setInterviewCannotAttend($interviewCannotAttend)
            ->setInterviewDeclined($interviewDeclined)
            ->setLastScoreDate($lastScoreDate)
            ->setLastProgressDate($lastProgressDate)
            ->setLastDeliveryStatusID($lastDeliveryStatusID)
            ->setLastDeliveryDate($lastDeliveryDate)
            ->setViewed($viewed)
            ->setSalaryHide($salaryHide)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setSchemaIdentifier($schemaIdentifier)
            ->setAdvertIdentifier($advertIdentifier)
            ->setAdvertReference($advertReference)
            ->setAdvertTitle($advertTitle)
            ->setAdvertType($advertType)
            ->setAdvertHours($advertHours)
            ->setIndustry($industry)
            ->setSalaryFrom($salaryFrom)
            ->setSalaryTo($salaryTo)
            ->setSalaryCurrency($salaryCurrency)
            ->setSalaryPer($salaryPer)
            ->setJobDescription($jobDescription)
            ->setPrimaryLocation($primaryLocation)
            ->setSalaryBenefits($salaryBenefits)
            ->setContactName($contactName)
            ->setContactEmail($contactEmail)
            ->setSource($source)
            ->setSLastPostDate($sLastPostDate)
            ->setSLastDeliveryDate($sLastDeliveryDate)
            ->setSLastScoreDate($sLastScoreDate)
            ->setSLastProgressDate($sLastProgressDate);
    }
    /**
     * Get AdvertID value
     * @return int
     */
    public function getAdvertID()
    {
        return $this->AdvertID;
    }
    /**
     * Set AdvertID value
     * @param int $advertID
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setAdvertID($advertID = null)
    {
        // validation for constraint: int
        if (!is_null($advertID) && !(is_int($advertID) || ctype_digit($advertID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($advertID, true), gettype($advertID)), __LINE__);
        }
        $this->AdvertID = $advertID;
        return $this;
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !(is_int($userID) || ctype_digit($userID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get OrganisationID value
     * @return int
     */
    public function getOrganisationID()
    {
        return $this->OrganisationID;
    }
    /**
     * Set OrganisationID value
     * @param int $organisationID
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setOrganisationID($organisationID = null)
    {
        // validation for constraint: int
        if (!is_null($organisationID) && !(is_int($organisationID) || ctype_digit($organisationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($organisationID, true), gettype($organisationID)), __LINE__);
        }
        $this->OrganisationID = $organisationID;
        return $this;
    }
    /**
     * Get LastPostDate value
     * @return string
     */
    public function getLastPostDate()
    {
        return $this->LastPostDate;
    }
    /**
     * Set LastPostDate value
     * @param string $lastPostDate
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setLastPostDate($lastPostDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastPostDate) && !is_string($lastPostDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastPostDate, true), gettype($lastPostDate)), __LINE__);
        }
        $this->LastPostDate = $lastPostDate;
        return $this;
    }
    /**
     * Get Applications value
     * @return int
     */
    public function getApplications()
    {
        return $this->Applications;
    }
    /**
     * Set Applications value
     * @param int $applications
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setApplications($applications = null)
    {
        // validation for constraint: int
        if (!is_null($applications) && !(is_int($applications) || ctype_digit($applications))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($applications, true), gettype($applications)), __LINE__);
        }
        $this->Applications = $applications;
        return $this;
    }
    /**
     * Get Unsuitable value
     * @return int
     */
    public function getUnsuitable()
    {
        return $this->Unsuitable;
    }
    /**
     * Set Unsuitable value
     * @param int $unsuitable
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setUnsuitable($unsuitable = null)
    {
        // validation for constraint: int
        if (!is_null($unsuitable) && !(is_int($unsuitable) || ctype_digit($unsuitable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unsuitable, true), gettype($unsuitable)), __LINE__);
        }
        $this->Unsuitable = $unsuitable;
        return $this;
    }
    /**
     * Get MaybeSuitable value
     * @return int
     */
    public function getMaybeSuitable()
    {
        return $this->MaybeSuitable;
    }
    /**
     * Set MaybeSuitable value
     * @param int $maybeSuitable
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setMaybeSuitable($maybeSuitable = null)
    {
        // validation for constraint: int
        if (!is_null($maybeSuitable) && !(is_int($maybeSuitable) || ctype_digit($maybeSuitable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maybeSuitable, true), gettype($maybeSuitable)), __LINE__);
        }
        $this->MaybeSuitable = $maybeSuitable;
        return $this;
    }
    /**
     * Get Suitable value
     * @return int
     */
    public function getSuitable()
    {
        return $this->Suitable;
    }
    /**
     * Set Suitable value
     * @param int $suitable
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setSuitable($suitable = null)
    {
        // validation for constraint: int
        if (!is_null($suitable) && !(is_int($suitable) || ctype_digit($suitable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($suitable, true), gettype($suitable)), __LINE__);
        }
        $this->Suitable = $suitable;
        return $this;
    }
    /**
     * Get AdvertStatusID value
     * @return int
     */
    public function getAdvertStatusID()
    {
        return $this->AdvertStatusID;
    }
    /**
     * Set AdvertStatusID value
     * @param int $advertStatusID
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setAdvertStatusID($advertStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($advertStatusID) && !(is_int($advertStatusID) || ctype_digit($advertStatusID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($advertStatusID, true), gettype($advertStatusID)), __LINE__);
        }
        $this->AdvertStatusID = $advertStatusID;
        return $this;
    }
    /**
     * Get InterviewConfirmed value
     * @return int
     */
    public function getInterviewConfirmed()
    {
        return $this->InterviewConfirmed;
    }
    /**
     * Set InterviewConfirmed value
     * @param int $interviewConfirmed
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setInterviewConfirmed($interviewConfirmed = null)
    {
        // validation for constraint: int
        if (!is_null($interviewConfirmed) && !(is_int($interviewConfirmed) || ctype_digit($interviewConfirmed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($interviewConfirmed, true), gettype($interviewConfirmed)), __LINE__);
        }
        $this->InterviewConfirmed = $interviewConfirmed;
        return $this;
    }
    /**
     * Get InterviewPending value
     * @return int
     */
    public function getInterviewPending()
    {
        return $this->InterviewPending;
    }
    /**
     * Set InterviewPending value
     * @param int $interviewPending
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setInterviewPending($interviewPending = null)
    {
        // validation for constraint: int
        if (!is_null($interviewPending) && !(is_int($interviewPending) || ctype_digit($interviewPending))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($interviewPending, true), gettype($interviewPending)), __LINE__);
        }
        $this->InterviewPending = $interviewPending;
        return $this;
    }
    /**
     * Get WithStatus value
     * @return int
     */
    public function getWithStatus()
    {
        return $this->WithStatus;
    }
    /**
     * Set WithStatus value
     * @param int $withStatus
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setWithStatus($withStatus = null)
    {
        // validation for constraint: int
        if (!is_null($withStatus) && !(is_int($withStatus) || ctype_digit($withStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($withStatus, true), gettype($withStatus)), __LINE__);
        }
        $this->WithStatus = $withStatus;
        return $this;
    }
    /**
     * Get WithStatusNew value
     * @return int
     */
    public function getWithStatusNew()
    {
        return $this->WithStatusNew;
    }
    /**
     * Set WithStatusNew value
     * @param int $withStatusNew
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setWithStatusNew($withStatusNew = null)
    {
        // validation for constraint: int
        if (!is_null($withStatusNew) && !(is_int($withStatusNew) || ctype_digit($withStatusNew))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($withStatusNew, true), gettype($withStatusNew)), __LINE__);
        }
        $this->WithStatusNew = $withStatusNew;
        return $this;
    }
    /**
     * Get InterviewCannotAttend value
     * @return int
     */
    public function getInterviewCannotAttend()
    {
        return $this->InterviewCannotAttend;
    }
    /**
     * Set InterviewCannotAttend value
     * @param int $interviewCannotAttend
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setInterviewCannotAttend($interviewCannotAttend = null)
    {
        // validation for constraint: int
        if (!is_null($interviewCannotAttend) && !(is_int($interviewCannotAttend) || ctype_digit($interviewCannotAttend))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($interviewCannotAttend, true), gettype($interviewCannotAttend)), __LINE__);
        }
        $this->InterviewCannotAttend = $interviewCannotAttend;
        return $this;
    }
    /**
     * Get InterviewDeclined value
     * @return int
     */
    public function getInterviewDeclined()
    {
        return $this->InterviewDeclined;
    }
    /**
     * Set InterviewDeclined value
     * @param int $interviewDeclined
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setInterviewDeclined($interviewDeclined = null)
    {
        // validation for constraint: int
        if (!is_null($interviewDeclined) && !(is_int($interviewDeclined) || ctype_digit($interviewDeclined))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($interviewDeclined, true), gettype($interviewDeclined)), __LINE__);
        }
        $this->InterviewDeclined = $interviewDeclined;
        return $this;
    }
    /**
     * Get LastScoreDate value
     * @return string
     */
    public function getLastScoreDate()
    {
        return $this->LastScoreDate;
    }
    /**
     * Set LastScoreDate value
     * @param string $lastScoreDate
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setLastScoreDate($lastScoreDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastScoreDate) && !is_string($lastScoreDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastScoreDate, true), gettype($lastScoreDate)), __LINE__);
        }
        $this->LastScoreDate = $lastScoreDate;
        return $this;
    }
    /**
     * Get LastProgressDate value
     * @return string
     */
    public function getLastProgressDate()
    {
        return $this->LastProgressDate;
    }
    /**
     * Set LastProgressDate value
     * @param string $lastProgressDate
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setLastProgressDate($lastProgressDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastProgressDate) && !is_string($lastProgressDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastProgressDate, true), gettype($lastProgressDate)), __LINE__);
        }
        $this->LastProgressDate = $lastProgressDate;
        return $this;
    }
    /**
     * Get LastDeliveryStatusID value
     * @return int
     */
    public function getLastDeliveryStatusID()
    {
        return $this->LastDeliveryStatusID;
    }
    /**
     * Set LastDeliveryStatusID value
     * @param int $lastDeliveryStatusID
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setLastDeliveryStatusID($lastDeliveryStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($lastDeliveryStatusID) && !(is_int($lastDeliveryStatusID) || ctype_digit($lastDeliveryStatusID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastDeliveryStatusID, true), gettype($lastDeliveryStatusID)), __LINE__);
        }
        $this->LastDeliveryStatusID = $lastDeliveryStatusID;
        return $this;
    }
    /**
     * Get LastDeliveryDate value
     * @return string
     */
    public function getLastDeliveryDate()
    {
        return $this->LastDeliveryDate;
    }
    /**
     * Set LastDeliveryDate value
     * @param string $lastDeliveryDate
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setLastDeliveryDate($lastDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastDeliveryDate) && !is_string($lastDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastDeliveryDate, true), gettype($lastDeliveryDate)), __LINE__);
        }
        $this->LastDeliveryDate = $lastDeliveryDate;
        return $this;
    }
    /**
     * Get Viewed value
     * @return int
     */
    public function getViewed()
    {
        return $this->Viewed;
    }
    /**
     * Set Viewed value
     * @param int $viewed
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setViewed($viewed = null)
    {
        // validation for constraint: int
        if (!is_null($viewed) && !(is_int($viewed) || ctype_digit($viewed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($viewed, true), gettype($viewed)), __LINE__);
        }
        $this->Viewed = $viewed;
        return $this;
    }
    /**
     * Get SalaryHide value
     * @return bool
     */
    public function getSalaryHide()
    {
        return $this->SalaryHide;
    }
    /**
     * Set SalaryHide value
     * @param bool $salaryHide
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setSalaryHide($salaryHide = null)
    {
        // validation for constraint: boolean
        if (!is_null($salaryHide) && !is_bool($salaryHide)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($salaryHide, true), gettype($salaryHide)), __LINE__);
        }
        $this->SalaryHide = $salaryHide;
        return $this;
    }
    /**
     * Get latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * Set latitude value
     * @param float $latitude
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Get longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * Set longitude value
     * @param float $longitude
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->longitude = $longitude;
        return $this;
    }
    /**
     * Get SchemaIdentifier value
     * @return string|null
     */
    public function getSchemaIdentifier()
    {
        return $this->SchemaIdentifier;
    }
    /**
     * Set SchemaIdentifier value
     * @param string $schemaIdentifier
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setSchemaIdentifier($schemaIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($schemaIdentifier) && !is_string($schemaIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemaIdentifier, true), gettype($schemaIdentifier)), __LINE__);
        }
        $this->SchemaIdentifier = $schemaIdentifier;
        return $this;
    }
    /**
     * Get AdvertIdentifier value
     * @return string|null
     */
    public function getAdvertIdentifier()
    {
        return $this->AdvertIdentifier;
    }
    /**
     * Set AdvertIdentifier value
     * @param string $advertIdentifier
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setAdvertIdentifier($advertIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($advertIdentifier) && !is_string($advertIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advertIdentifier, true), gettype($advertIdentifier)), __LINE__);
        }
        $this->AdvertIdentifier = $advertIdentifier;
        return $this;
    }
    /**
     * Get AdvertReference value
     * @return string|null
     */
    public function getAdvertReference()
    {
        return $this->AdvertReference;
    }
    /**
     * Set AdvertReference value
     * @param string $advertReference
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setAdvertReference($advertReference = null)
    {
        // validation for constraint: string
        if (!is_null($advertReference) && !is_string($advertReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advertReference, true), gettype($advertReference)), __LINE__);
        }
        $this->AdvertReference = $advertReference;
        return $this;
    }
    /**
     * Get AdvertTitle value
     * @return string|null
     */
    public function getAdvertTitle()
    {
        return $this->AdvertTitle;
    }
    /**
     * Set AdvertTitle value
     * @param string $advertTitle
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setAdvertTitle($advertTitle = null)
    {
        // validation for constraint: string
        if (!is_null($advertTitle) && !is_string($advertTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advertTitle, true), gettype($advertTitle)), __LINE__);
        }
        $this->AdvertTitle = $advertTitle;
        return $this;
    }
    /**
     * Get AdvertType value
     * @return string|null
     */
    public function getAdvertType()
    {
        return $this->AdvertType;
    }
    /**
     * Set AdvertType value
     * @param string $advertType
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setAdvertType($advertType = null)
    {
        // validation for constraint: string
        if (!is_null($advertType) && !is_string($advertType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advertType, true), gettype($advertType)), __LINE__);
        }
        $this->AdvertType = $advertType;
        return $this;
    }
    /**
     * Get AdvertHours value
     * @return string|null
     */
    public function getAdvertHours()
    {
        return $this->AdvertHours;
    }
    /**
     * Set AdvertHours value
     * @param string $advertHours
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setAdvertHours($advertHours = null)
    {
        // validation for constraint: string
        if (!is_null($advertHours) && !is_string($advertHours)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advertHours, true), gettype($advertHours)), __LINE__);
        }
        $this->AdvertHours = $advertHours;
        return $this;
    }
    /**
     * Get Industry value
     * @return string|null
     */
    public function getIndustry()
    {
        return $this->Industry;
    }
    /**
     * Set Industry value
     * @param string $industry
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setIndustry($industry = null)
    {
        // validation for constraint: string
        if (!is_null($industry) && !is_string($industry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($industry, true), gettype($industry)), __LINE__);
        }
        $this->Industry = $industry;
        return $this;
    }
    /**
     * Get SalaryFrom value
     * @return string|null
     */
    public function getSalaryFrom()
    {
        return $this->SalaryFrom;
    }
    /**
     * Set SalaryFrom value
     * @param string $salaryFrom
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setSalaryFrom($salaryFrom = null)
    {
        // validation for constraint: string
        if (!is_null($salaryFrom) && !is_string($salaryFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salaryFrom, true), gettype($salaryFrom)), __LINE__);
        }
        $this->SalaryFrom = $salaryFrom;
        return $this;
    }
    /**
     * Get SalaryTo value
     * @return string|null
     */
    public function getSalaryTo()
    {
        return $this->SalaryTo;
    }
    /**
     * Set SalaryTo value
     * @param string $salaryTo
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setSalaryTo($salaryTo = null)
    {
        // validation for constraint: string
        if (!is_null($salaryTo) && !is_string($salaryTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salaryTo, true), gettype($salaryTo)), __LINE__);
        }
        $this->SalaryTo = $salaryTo;
        return $this;
    }
    /**
     * Get SalaryCurrency value
     * @return string|null
     */
    public function getSalaryCurrency()
    {
        return $this->SalaryCurrency;
    }
    /**
     * Set SalaryCurrency value
     * @param string $salaryCurrency
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setSalaryCurrency($salaryCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($salaryCurrency) && !is_string($salaryCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salaryCurrency, true), gettype($salaryCurrency)), __LINE__);
        }
        $this->SalaryCurrency = $salaryCurrency;
        return $this;
    }
    /**
     * Get SalaryPer value
     * @return string|null
     */
    public function getSalaryPer()
    {
        return $this->SalaryPer;
    }
    /**
     * Set SalaryPer value
     * @param string $salaryPer
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setSalaryPer($salaryPer = null)
    {
        // validation for constraint: string
        if (!is_null($salaryPer) && !is_string($salaryPer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salaryPer, true), gettype($salaryPer)), __LINE__);
        }
        $this->SalaryPer = $salaryPer;
        return $this;
    }
    /**
     * Get JobDescription value
     * @return string|null
     */
    public function getJobDescription()
    {
        return $this->JobDescription;
    }
    /**
     * Set JobDescription value
     * @param string $jobDescription
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setJobDescription($jobDescription = null)
    {
        // validation for constraint: string
        if (!is_null($jobDescription) && !is_string($jobDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobDescription, true), gettype($jobDescription)), __LINE__);
        }
        $this->JobDescription = $jobDescription;
        return $this;
    }
    /**
     * Get PrimaryLocation value
     * @return string|null
     */
    public function getPrimaryLocation()
    {
        return $this->PrimaryLocation;
    }
    /**
     * Set PrimaryLocation value
     * @param string $primaryLocation
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setPrimaryLocation($primaryLocation = null)
    {
        // validation for constraint: string
        if (!is_null($primaryLocation) && !is_string($primaryLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryLocation, true), gettype($primaryLocation)), __LINE__);
        }
        $this->PrimaryLocation = $primaryLocation;
        return $this;
    }
    /**
     * Get SalaryBenefits value
     * @return string|null
     */
    public function getSalaryBenefits()
    {
        return $this->SalaryBenefits;
    }
    /**
     * Set SalaryBenefits value
     * @param string $salaryBenefits
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setSalaryBenefits($salaryBenefits = null)
    {
        // validation for constraint: string
        if (!is_null($salaryBenefits) && !is_string($salaryBenefits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salaryBenefits, true), gettype($salaryBenefits)), __LINE__);
        }
        $this->SalaryBenefits = $salaryBenefits;
        return $this;
    }
    /**
     * Get ContactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param string $contactName
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactName, true), gettype($contactName)), __LINE__);
        }
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Get ContactEmail value
     * @return string|null
     */
    public function getContactEmail()
    {
        return $this->ContactEmail;
    }
    /**
     * Set ContactEmail value
     * @param string $contactEmail
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setContactEmail($contactEmail = null)
    {
        // validation for constraint: string
        if (!is_null($contactEmail) && !is_string($contactEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactEmail, true), gettype($contactEmail)), __LINE__);
        }
        $this->ContactEmail = $contactEmail;
        return $this;
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Get sLastPostDate value
     * @return string|null
     */
    public function getSLastPostDate()
    {
        return $this->sLastPostDate;
    }
    /**
     * Set sLastPostDate value
     * @param string $sLastPostDate
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setSLastPostDate($sLastPostDate = null)
    {
        // validation for constraint: string
        if (!is_null($sLastPostDate) && !is_string($sLastPostDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLastPostDate, true), gettype($sLastPostDate)), __LINE__);
        }
        $this->sLastPostDate = $sLastPostDate;
        return $this;
    }
    /**
     * Get sLastDeliveryDate value
     * @return string|null
     */
    public function getSLastDeliveryDate()
    {
        return $this->sLastDeliveryDate;
    }
    /**
     * Set sLastDeliveryDate value
     * @param string $sLastDeliveryDate
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setSLastDeliveryDate($sLastDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($sLastDeliveryDate) && !is_string($sLastDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLastDeliveryDate, true), gettype($sLastDeliveryDate)), __LINE__);
        }
        $this->sLastDeliveryDate = $sLastDeliveryDate;
        return $this;
    }
    /**
     * Get sLastScoreDate value
     * @return string|null
     */
    public function getSLastScoreDate()
    {
        return $this->sLastScoreDate;
    }
    /**
     * Set sLastScoreDate value
     * @param string $sLastScoreDate
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setSLastScoreDate($sLastScoreDate = null)
    {
        // validation for constraint: string
        if (!is_null($sLastScoreDate) && !is_string($sLastScoreDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLastScoreDate, true), gettype($sLastScoreDate)), __LINE__);
        }
        $this->sLastScoreDate = $sLastScoreDate;
        return $this;
    }
    /**
     * Get sLastProgressDate value
     * @return string|null
     */
    public function getSLastProgressDate()
    {
        return $this->sLastProgressDate;
    }
    /**
     * Set sLastProgressDate value
     * @param string $sLastProgressDate
     * @return \RecruitCrm\LogicMelon\StructType\APIAdvert
     */
    public function setSLastProgressDate($sLastProgressDate = null)
    {
        // validation for constraint: string
        if (!is_null($sLastProgressDate) && !is_string($sLastProgressDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLastProgressDate, true), gettype($sLastProgressDate)), __LINE__);
        }
        $this->sLastProgressDate = $sLastProgressDate;
        return $this;
    }
}
