<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APILiveAdvertPosting StructType
 * @subpackage Structs
 */
class APILiveAdvertPosting extends AbstractStructBase
{
    /**
     * The AdvertID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AdvertID;
    /**
     * The FeedID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FeedID;
    /**
     * The PostDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PostDate;
    /**
     * The EstimatedExpireDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EstimatedExpireDate;
    /**
     * The AdvertTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdvertTitle;
    /**
     * The AdvertReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdvertReference;
    /**
     * The JobBoardIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $JobBoardIdentifier;
    /**
     * Constructor method for APILiveAdvertPosting
     * @uses APILiveAdvertPosting::setAdvertID()
     * @uses APILiveAdvertPosting::setFeedID()
     * @uses APILiveAdvertPosting::setPostDate()
     * @uses APILiveAdvertPosting::setEstimatedExpireDate()
     * @uses APILiveAdvertPosting::setAdvertTitle()
     * @uses APILiveAdvertPosting::setAdvertReference()
     * @uses APILiveAdvertPosting::setJobBoardIdentifier()
     * @param int $advertID
     * @param int $feedID
     * @param string $postDate
     * @param string $estimatedExpireDate
     * @param string $advertTitle
     * @param string $advertReference
     * @param string $jobBoardIdentifier
     */
    public function __construct($advertID = null, $feedID = null, $postDate = null, $estimatedExpireDate = null, $advertTitle = null, $advertReference = null, $jobBoardIdentifier = null)
    {
        $this
            ->setAdvertID($advertID)
            ->setFeedID($feedID)
            ->setPostDate($postDate)
            ->setEstimatedExpireDate($estimatedExpireDate)
            ->setAdvertTitle($advertTitle)
            ->setAdvertReference($advertReference)
            ->setJobBoardIdentifier($jobBoardIdentifier);
    }
    /**
     * Get AdvertID value
     * @return int
     */
    public function getAdvertID()
    {
        return $this->AdvertID;
    }
    /**
     * Set AdvertID value
     * @param int $advertID
     * @return \RecruitCrm\LogicMelon\StructType\APILiveAdvertPosting
     */
    public function setAdvertID($advertID = null)
    {
        // validation for constraint: int
        if (!is_null($advertID) && !(is_int($advertID) || ctype_digit($advertID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($advertID, true), gettype($advertID)), __LINE__);
        }
        $this->AdvertID = $advertID;
        return $this;
    }
    /**
     * Get FeedID value
     * @return int
     */
    public function getFeedID()
    {
        return $this->FeedID;
    }
    /**
     * Set FeedID value
     * @param int $feedID
     * @return \RecruitCrm\LogicMelon\StructType\APILiveAdvertPosting
     */
    public function setFeedID($feedID = null)
    {
        // validation for constraint: int
        if (!is_null($feedID) && !(is_int($feedID) || ctype_digit($feedID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($feedID, true), gettype($feedID)), __LINE__);
        }
        $this->FeedID = $feedID;
        return $this;
    }
    /**
     * Get PostDate value
     * @return string
     */
    public function getPostDate()
    {
        return $this->PostDate;
    }
    /**
     * Set PostDate value
     * @param string $postDate
     * @return \RecruitCrm\LogicMelon\StructType\APILiveAdvertPosting
     */
    public function setPostDate($postDate = null)
    {
        // validation for constraint: string
        if (!is_null($postDate) && !is_string($postDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postDate, true), gettype($postDate)), __LINE__);
        }
        $this->PostDate = $postDate;
        return $this;
    }
    /**
     * Get EstimatedExpireDate value
     * @return string
     */
    public function getEstimatedExpireDate()
    {
        return $this->EstimatedExpireDate;
    }
    /**
     * Set EstimatedExpireDate value
     * @param string $estimatedExpireDate
     * @return \RecruitCrm\LogicMelon\StructType\APILiveAdvertPosting
     */
    public function setEstimatedExpireDate($estimatedExpireDate = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedExpireDate) && !is_string($estimatedExpireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estimatedExpireDate, true), gettype($estimatedExpireDate)), __LINE__);
        }
        $this->EstimatedExpireDate = $estimatedExpireDate;
        return $this;
    }
    /**
     * Get AdvertTitle value
     * @return string|null
     */
    public function getAdvertTitle()
    {
        return $this->AdvertTitle;
    }
    /**
     * Set AdvertTitle value
     * @param string $advertTitle
     * @return \RecruitCrm\LogicMelon\StructType\APILiveAdvertPosting
     */
    public function setAdvertTitle($advertTitle = null)
    {
        // validation for constraint: string
        if (!is_null($advertTitle) && !is_string($advertTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advertTitle, true), gettype($advertTitle)), __LINE__);
        }
        $this->AdvertTitle = $advertTitle;
        return $this;
    }
    /**
     * Get AdvertReference value
     * @return string|null
     */
    public function getAdvertReference()
    {
        return $this->AdvertReference;
    }
    /**
     * Set AdvertReference value
     * @param string $advertReference
     * @return \RecruitCrm\LogicMelon\StructType\APILiveAdvertPosting
     */
    public function setAdvertReference($advertReference = null)
    {
        // validation for constraint: string
        if (!is_null($advertReference) && !is_string($advertReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advertReference, true), gettype($advertReference)), __LINE__);
        }
        $this->AdvertReference = $advertReference;
        return $this;
    }
    /**
     * Get JobBoardIdentifier value
     * @return string|null
     */
    public function getJobBoardIdentifier()
    {
        return $this->JobBoardIdentifier;
    }
    /**
     * Set JobBoardIdentifier value
     * @param string $jobBoardIdentifier
     * @return \RecruitCrm\LogicMelon\StructType\APILiveAdvertPosting
     */
    public function setJobBoardIdentifier($jobBoardIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($jobBoardIdentifier) && !is_string($jobBoardIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobBoardIdentifier, true), gettype($jobBoardIdentifier)), __LINE__);
        }
        $this->JobBoardIdentifier = $jobBoardIdentifier;
        return $this;
    }
}
