<?php

namespace RecruitCrm\LogicMelon\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddAdvertResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddAdvertResult
 * @subpackage Structs
 */
class AddAdvertResult extends AbstractStructBase
{
    /**
     * The AdvertID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AdvertID;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The OrganisationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrganisationID;
    /**
     * The RedirectUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RedirectUrl;
    /**
     * The LocationLookupLogs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationLookupLogs;
    /**
     * Constructor method for AddAdvertResult
     * @uses AddAdvertResult::setAdvertID()
     * @uses AddAdvertResult::setUserID()
     * @uses AddAdvertResult::setOrganisationID()
     * @uses AddAdvertResult::setRedirectUrl()
     * @uses AddAdvertResult::setLocationLookupLogs()
     * @param int $advertID
     * @param int $userID
     * @param int $organisationID
     * @param string $redirectUrl
     * @param string $locationLookupLogs
     */
    public function __construct($advertID = null, $userID = null, $organisationID = null, $redirectUrl = null, $locationLookupLogs = null)
    {
        $this
            ->setAdvertID($advertID)
            ->setUserID($userID)
            ->setOrganisationID($organisationID)
            ->setRedirectUrl($redirectUrl)
            ->setLocationLookupLogs($locationLookupLogs);
    }
    /**
     * Get AdvertID value
     * @return int
     */
    public function getAdvertID()
    {
        return $this->AdvertID;
    }
    /**
     * Set AdvertID value
     * @param int $advertID
     * @return \RecruitCrm\LogicMelon\StructType\AddAdvertResult
     */
    public function setAdvertID($advertID = null)
    {
        // validation for constraint: int
        if (!is_null($advertID) && !(is_int($advertID) || ctype_digit($advertID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($advertID, true), gettype($advertID)), __LINE__);
        }
        $this->AdvertID = $advertID;
        return $this;
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \RecruitCrm\LogicMelon\StructType\AddAdvertResult
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !(is_int($userID) || ctype_digit($userID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get OrganisationID value
     * @return int
     */
    public function getOrganisationID()
    {
        return $this->OrganisationID;
    }
    /**
     * Set OrganisationID value
     * @param int $organisationID
     * @return \RecruitCrm\LogicMelon\StructType\AddAdvertResult
     */
    public function setOrganisationID($organisationID = null)
    {
        // validation for constraint: int
        if (!is_null($organisationID) && !(is_int($organisationID) || ctype_digit($organisationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($organisationID, true), gettype($organisationID)), __LINE__);
        }
        $this->OrganisationID = $organisationID;
        return $this;
    }
    /**
     * Get RedirectUrl value
     * @return string|null
     */
    public function getRedirectUrl()
    {
        return $this->RedirectUrl;
    }
    /**
     * Set RedirectUrl value
     * @param string $redirectUrl
     * @return \RecruitCrm\LogicMelon\StructType\AddAdvertResult
     */
    public function setRedirectUrl($redirectUrl = null)
    {
        // validation for constraint: string
        if (!is_null($redirectUrl) && !is_string($redirectUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redirectUrl, true), gettype($redirectUrl)), __LINE__);
        }
        $this->RedirectUrl = $redirectUrl;
        return $this;
    }
    /**
     * Get LocationLookupLogs value
     * @return string|null
     */
    public function getLocationLookupLogs()
    {
        return $this->LocationLookupLogs;
    }
    /**
     * Set LocationLookupLogs value
     * @param string $locationLookupLogs
     * @return \RecruitCrm\LogicMelon\StructType\AddAdvertResult
     */
    public function setLocationLookupLogs($locationLookupLogs = null)
    {
        // validation for constraint: string
        if (!is_null($locationLookupLogs) && !is_string($locationLookupLogs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationLookupLogs, true), gettype($locationLookupLogs)), __LINE__);
        }
        $this->LocationLookupLogs = $locationLookupLogs;
        return $this;
    }
}
