<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CorporateMemberEAppResponse StructType
 * @subpackage Structs
 */
class CorporateMemberEAppResponse extends AbstractStructBase
{
    /**
     * The Message
     * @var string
     */
    public $Message;
    /**
     * The Success
     * @var bool
     */
    public $Success;
    /**
     * The MemberNumber
     * @var string
     */
    public $MemberNumber;
    /**
     * The ApplicationNumber
     * @var string
     */
    public $ApplicationNumber;
    /**
     * The IdNumber
     * @var string
     */
    public $IdNumber;
    /**
     * The IndustryNumber
     * @var string
     */
    public $IndustryNumber;
    /**
     * The Activated
     * @var string
     */
    public $Activated;
    /**
     * The BenefitOption
     * @var string
     */
    public $BenefitOption;
    /**
     * Constructor method for CorporateMemberEAppResponse
     * @uses CorporateMemberEAppResponse::setMessage()
     * @uses CorporateMemberEAppResponse::setSuccess()
     * @uses CorporateMemberEAppResponse::setMemberNumber()
     * @uses CorporateMemberEAppResponse::setApplicationNumber()
     * @uses CorporateMemberEAppResponse::setIdNumber()
     * @uses CorporateMemberEAppResponse::setIndustryNumber()
     * @uses CorporateMemberEAppResponse::setActivated()
     * @uses CorporateMemberEAppResponse::setBenefitOption()
     * @param string $message
     * @param bool $success
     * @param string $memberNumber
     * @param string $applicationNumber
     * @param string $idNumber
     * @param string $industryNumber
     * @param string $activated
     * @param string $benefitOption
     */
    public function __construct($message = null, $success = null, $memberNumber = null, $applicationNumber = null, $idNumber = null, $industryNumber = null, $activated = null, $benefitOption = null)
    {
        $this
            ->setMessage($message)
            ->setSuccess($success)
            ->setMemberNumber($memberNumber)
            ->setApplicationNumber($applicationNumber)
            ->setIdNumber($idNumber)
            ->setIndustryNumber($industryNumber)
            ->setActivated($activated)
            ->setBenefitOption($benefitOption);
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\CorporateMemberEAppResponse
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get Success value
     * @return bool|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \StructType\CorporateMemberEAppResponse
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get MemberNumber value
     * @return string|null
     */
    public function getMemberNumber()
    {
        return $this->MemberNumber;
    }
    /**
     * Set MemberNumber value
     * @param string $memberNumber
     * @return \StructType\CorporateMemberEAppResponse
     */
    public function setMemberNumber($memberNumber = null)
    {
        // validation for constraint: string
        if (!is_null($memberNumber) && !is_string($memberNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memberNumber, true), gettype($memberNumber)), __LINE__);
        }
        $this->MemberNumber = $memberNumber;
        return $this;
    }
    /**
     * Get ApplicationNumber value
     * @return string|null
     */
    public function getApplicationNumber()
    {
        return $this->ApplicationNumber;
    }
    /**
     * Set ApplicationNumber value
     * @param string $applicationNumber
     * @return \StructType\CorporateMemberEAppResponse
     */
    public function setApplicationNumber($applicationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($applicationNumber) && !is_string($applicationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationNumber, true), gettype($applicationNumber)), __LINE__);
        }
        $this->ApplicationNumber = $applicationNumber;
        return $this;
    }
    /**
     * Get IdNumber value
     * @return string|null
     */
    public function getIdNumber()
    {
        return $this->IdNumber;
    }
    /**
     * Set IdNumber value
     * @param string $idNumber
     * @return \StructType\CorporateMemberEAppResponse
     */
    public function setIdNumber($idNumber = null)
    {
        // validation for constraint: string
        if (!is_null($idNumber) && !is_string($idNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idNumber, true), gettype($idNumber)), __LINE__);
        }
        $this->IdNumber = $idNumber;
        return $this;
    }
    /**
     * Get IndustryNumber value
     * @return string|null
     */
    public function getIndustryNumber()
    {
        return $this->IndustryNumber;
    }
    /**
     * Set IndustryNumber value
     * @param string $industryNumber
     * @return \StructType\CorporateMemberEAppResponse
     */
    public function setIndustryNumber($industryNumber = null)
    {
        // validation for constraint: string
        if (!is_null($industryNumber) && !is_string($industryNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($industryNumber, true), gettype($industryNumber)), __LINE__);
        }
        $this->IndustryNumber = $industryNumber;
        return $this;
    }
    /**
     * Get Activated value
     * @return string|null
     */
    public function getActivated()
    {
        return $this->Activated;
    }
    /**
     * Set Activated value
     * @param string $activated
     * @return \StructType\CorporateMemberEAppResponse
     */
    public function setActivated($activated = null)
    {
        // validation for constraint: string
        if (!is_null($activated) && !is_string($activated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activated, true), gettype($activated)), __LINE__);
        }
        $this->Activated = $activated;
        return $this;
    }
    /**
     * Get BenefitOption value
     * @return string|null
     */
    public function getBenefitOption()
    {
        return $this->BenefitOption;
    }
    /**
     * Set BenefitOption value
     * @param string $benefitOption
     * @return \StructType\CorporateMemberEAppResponse
     */
    public function setBenefitOption($benefitOption = null)
    {
        // validation for constraint: string
        if (!is_null($benefitOption) && !is_string($benefitOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($benefitOption, true), gettype($benefitOption)), __LINE__);
        }
        $this->BenefitOption = $benefitOption;
        return $this;
    }
}
