<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Disability StructType
 * @subpackage Structs
 */
class Disability extends AbstractStructBase
{
    /**
     * The DIBName
     * @var string
     */
    public $DIBName;
    /**
     * The DIBDateBirth
     * @var string
     */
    public $DIBDateBirth;
    /**
     * The DIBDiagnosisDate
     * @var string
     */
    public $DIBDiagnosisDate;
    /**
     * The DIBEndDate
     * @var string
     */
    public $DIBEndDate;
    /**
     * The DIBType
     * @var string
     */
    public $DIBType;
    /**
     * The DIBNature
     * @var string
     */
    public $DIBNature;
    /**
     * The DIBLimitation
     * @var string
     */
    public $DIBLimitation;
    /**
     * The DIBSuplNr
     * @var string
     */
    public $DIBSuplNr;
    /**
     * Constructor method for Disability
     * @uses Disability::setDIBName()
     * @uses Disability::setDIBDateBirth()
     * @uses Disability::setDIBDiagnosisDate()
     * @uses Disability::setDIBEndDate()
     * @uses Disability::setDIBType()
     * @uses Disability::setDIBNature()
     * @uses Disability::setDIBLimitation()
     * @uses Disability::setDIBSuplNr()
     * @param string $dIBName
     * @param string $dIBDateBirth
     * @param string $dIBDiagnosisDate
     * @param string $dIBEndDate
     * @param string $dIBType
     * @param string $dIBNature
     * @param string $dIBLimitation
     * @param string $dIBSuplNr
     */
    public function __construct($dIBName = null, $dIBDateBirth = null, $dIBDiagnosisDate = null, $dIBEndDate = null, $dIBType = null, $dIBNature = null, $dIBLimitation = null, $dIBSuplNr = null)
    {
        $this
            ->setDIBName($dIBName)
            ->setDIBDateBirth($dIBDateBirth)
            ->setDIBDiagnosisDate($dIBDiagnosisDate)
            ->setDIBEndDate($dIBEndDate)
            ->setDIBType($dIBType)
            ->setDIBNature($dIBNature)
            ->setDIBLimitation($dIBLimitation)
            ->setDIBSuplNr($dIBSuplNr);
    }
    /**
     * Get DIBName value
     * @return string|null
     */
    public function getDIBName()
    {
        return $this->DIBName;
    }
    /**
     * Set DIBName value
     * @param string $dIBName
     * @return \StructType\Disability
     */
    public function setDIBName($dIBName = null)
    {
        // validation for constraint: string
        if (!is_null($dIBName) && !is_string($dIBName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dIBName, true), gettype($dIBName)), __LINE__);
        }
        $this->DIBName = $dIBName;
        return $this;
    }
    /**
     * Get DIBDateBirth value
     * @return string|null
     */
    public function getDIBDateBirth()
    {
        return $this->DIBDateBirth;
    }
    /**
     * Set DIBDateBirth value
     * @param string $dIBDateBirth
     * @return \StructType\Disability
     */
    public function setDIBDateBirth($dIBDateBirth = null)
    {
        // validation for constraint: string
        if (!is_null($dIBDateBirth) && !is_string($dIBDateBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dIBDateBirth, true), gettype($dIBDateBirth)), __LINE__);
        }
        $this->DIBDateBirth = $dIBDateBirth;
        return $this;
    }
    /**
     * Get DIBDiagnosisDate value
     * @return string|null
     */
    public function getDIBDiagnosisDate()
    {
        return $this->DIBDiagnosisDate;
    }
    /**
     * Set DIBDiagnosisDate value
     * @param string $dIBDiagnosisDate
     * @return \StructType\Disability
     */
    public function setDIBDiagnosisDate($dIBDiagnosisDate = null)
    {
        // validation for constraint: string
        if (!is_null($dIBDiagnosisDate) && !is_string($dIBDiagnosisDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dIBDiagnosisDate, true), gettype($dIBDiagnosisDate)), __LINE__);
        }
        $this->DIBDiagnosisDate = $dIBDiagnosisDate;
        return $this;
    }
    /**
     * Get DIBEndDate value
     * @return string|null
     */
    public function getDIBEndDate()
    {
        return $this->DIBEndDate;
    }
    /**
     * Set DIBEndDate value
     * @param string $dIBEndDate
     * @return \StructType\Disability
     */
    public function setDIBEndDate($dIBEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($dIBEndDate) && !is_string($dIBEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dIBEndDate, true), gettype($dIBEndDate)), __LINE__);
        }
        $this->DIBEndDate = $dIBEndDate;
        return $this;
    }
    /**
     * Get DIBType value
     * @return string|null
     */
    public function getDIBType()
    {
        return $this->DIBType;
    }
    /**
     * Set DIBType value
     * @param string $dIBType
     * @return \StructType\Disability
     */
    public function setDIBType($dIBType = null)
    {
        // validation for constraint: string
        if (!is_null($dIBType) && !is_string($dIBType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dIBType, true), gettype($dIBType)), __LINE__);
        }
        $this->DIBType = $dIBType;
        return $this;
    }
    /**
     * Get DIBNature value
     * @return string|null
     */
    public function getDIBNature()
    {
        return $this->DIBNature;
    }
    /**
     * Set DIBNature value
     * @param string $dIBNature
     * @return \StructType\Disability
     */
    public function setDIBNature($dIBNature = null)
    {
        // validation for constraint: string
        if (!is_null($dIBNature) && !is_string($dIBNature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dIBNature, true), gettype($dIBNature)), __LINE__);
        }
        $this->DIBNature = $dIBNature;
        return $this;
    }
    /**
     * Get DIBLimitation value
     * @return string|null
     */
    public function getDIBLimitation()
    {
        return $this->DIBLimitation;
    }
    /**
     * Set DIBLimitation value
     * @param string $dIBLimitation
     * @return \StructType\Disability
     */
    public function setDIBLimitation($dIBLimitation = null)
    {
        // validation for constraint: string
        if (!is_null($dIBLimitation) && !is_string($dIBLimitation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dIBLimitation, true), gettype($dIBLimitation)), __LINE__);
        }
        $this->DIBLimitation = $dIBLimitation;
        return $this;
    }
    /**
     * Get DIBSuplNr value
     * @return string|null
     */
    public function getDIBSuplNr()
    {
        return $this->DIBSuplNr;
    }
    /**
     * Set DIBSuplNr value
     * @param string $dIBSuplNr
     * @return \StructType\Disability
     */
    public function setDIBSuplNr($dIBSuplNr = null)
    {
        // validation for constraint: string
        if (!is_null($dIBSuplNr) && !is_string($dIBSuplNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dIBSuplNr, true), gettype($dIBSuplNr)), __LINE__);
        }
        $this->DIBSuplNr = $dIBSuplNr;
        return $this;
    }
}
