<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SavingsChoice StructType
 * @subpackage Structs
 */
class SavingsChoice extends AbstractStructBase
{
    /**
     * The SavingsType
     * @var string
     */
    public $SavingsType;
    /**
     * The SavingsAnswer
     * @var string
     */
    public $SavingsAnswer;
    /**
     * Constructor method for SavingsChoice
     * @uses SavingsChoice::setSavingsType()
     * @uses SavingsChoice::setSavingsAnswer()
     * @param string $savingsType
     * @param string $savingsAnswer
     */
    public function __construct($savingsType = null, $savingsAnswer = null)
    {
        $this
            ->setSavingsType($savingsType)
            ->setSavingsAnswer($savingsAnswer);
    }
    /**
     * Get SavingsType value
     * @return string|null
     */
    public function getSavingsType()
    {
        return $this->SavingsType;
    }
    /**
     * Set SavingsType value
     * @param string $savingsType
     * @return \StructType\SavingsChoice
     */
    public function setSavingsType($savingsType = null)
    {
        // validation for constraint: string
        if (!is_null($savingsType) && !is_string($savingsType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($savingsType, true), gettype($savingsType)), __LINE__);
        }
        $this->SavingsType = $savingsType;
        return $this;
    }
    /**
     * Get SavingsAnswer value
     * @return string|null
     */
    public function getSavingsAnswer()
    {
        return $this->SavingsAnswer;
    }
    /**
     * Set SavingsAnswer value
     * @param string $savingsAnswer
     * @return \StructType\SavingsChoice
     */
    public function setSavingsAnswer($savingsAnswer = null)
    {
        // validation for constraint: string
        if (!is_null($savingsAnswer) && !is_string($savingsAnswer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($savingsAnswer, true), gettype($savingsAnswer)), __LINE__);
        }
        $this->SavingsAnswer = $savingsAnswer;
        return $this;
    }
}
