<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDisability ArrayType
 * @subpackage Arrays
 */
class ArrayOfDisability extends AbstractStructArrayBase
{
    /**
     * The Disability
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Disability[]
     */
    public $Disability;
    /**
     * Constructor method for ArrayOfDisability
     * @uses ArrayOfDisability::setDisability()
     * @param \StructType\Disability[] $disability
     */
    public function __construct(array $disability = array())
    {
        $this
            ->setDisability($disability);
    }
    /**
     * Get Disability value
     * @return \StructType\Disability[]|null
     */
    public function getDisability()
    {
        return $this->Disability;
    }
    /**
     * This method is responsible for validating the values passed to the setDisability method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDisability method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDisabilityForArrayConstraintsFromSetDisability(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDisabilityDisabilityItem) {
            // validation for constraint: itemType
            if (!$arrayOfDisabilityDisabilityItem instanceof \StructType\Disability) {
                $invalidValues[] = is_object($arrayOfDisabilityDisabilityItem) ? get_class($arrayOfDisabilityDisabilityItem) : sprintf('%s(%s)', gettype($arrayOfDisabilityDisabilityItem), var_export($arrayOfDisabilityDisabilityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Disability property can only contain items of type \StructType\Disability, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Disability value
     * @throws \InvalidArgumentException
     * @param \StructType\Disability[] $disability
     * @return \ArrayType\ArrayOfDisability
     */
    public function setDisability(array $disability = array())
    {
        // validation for constraint: array
        if ('' !== ($disabilityArrayErrorMessage = self::validateDisabilityForArrayConstraintsFromSetDisability($disability))) {
            throw new \InvalidArgumentException($disabilityArrayErrorMessage, __LINE__);
        }
        $this->Disability = $disability;
        return $this;
    }
    /**
     * Add item to Disability value
     * @throws \InvalidArgumentException
     * @param \StructType\Disability $item
     * @return \ArrayType\ArrayOfDisability
     */
    public function addToDisability(\StructType\Disability $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Disability) {
            throw new \InvalidArgumentException(sprintf('The Disability property can only contain items of type \StructType\Disability, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Disability[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Disability|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Disability|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Disability|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Disability|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Disability|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Disability
     */
    public function getAttributeName()
    {
        return 'Disability';
    }
}
