<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDependant ArrayType
 * @subpackage Arrays
 */
class ArrayOfDependant extends AbstractStructArrayBase
{
    /**
     * The Dependant
     * Meta information extracted from the WSDL
     * - maxOccurs: 20
     * - minOccurs: 0
     * @var \StructType\Dependant[]
     */
    public $Dependant;
    /**
     * Constructor method for ArrayOfDependant
     * @uses ArrayOfDependant::setDependant()
     * @param \StructType\Dependant[] $dependant
     */
    public function __construct(array $dependant = array())
    {
        $this
            ->setDependant($dependant);
    }
    /**
     * Get Dependant value
     * @return \StructType\Dependant[]|null
     */
    public function getDependant()
    {
        return $this->Dependant;
    }
    /**
     * This method is responsible for validating the values passed to the setDependant method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDependant method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDependantForArrayConstraintsFromSetDependant(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDependantDependantItem) {
            // validation for constraint: itemType
            if (!$arrayOfDependantDependantItem instanceof \StructType\Dependant) {
                $invalidValues[] = is_object($arrayOfDependantDependantItem) ? get_class($arrayOfDependantDependantItem) : sprintf('%s(%s)', gettype($arrayOfDependantDependantItem), var_export($arrayOfDependantDependantItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Dependant property can only contain items of type \StructType\Dependant, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Dependant value
     * @throws \InvalidArgumentException
     * @param \StructType\Dependant[] $dependant
     * @return \ArrayType\ArrayOfDependant
     */
    public function setDependant(array $dependant = array())
    {
        // validation for constraint: array
        if ('' !== ($dependantArrayErrorMessage = self::validateDependantForArrayConstraintsFromSetDependant($dependant))) {
            throw new \InvalidArgumentException($dependantArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($dependant) && count($dependant) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 20', count($dependant)), __LINE__);
        }
        $this->Dependant = $dependant;
        return $this;
    }
    /**
     * Add item to Dependant value
     * @throws \InvalidArgumentException
     * @param \StructType\Dependant $item
     * @return \ArrayType\ArrayOfDependant
     */
    public function addToDependant(\StructType\Dependant $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Dependant) {
            throw new \InvalidArgumentException(sprintf('The Dependant property can only contain items of type \StructType\Dependant, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($this->Dependant) && count($this->Dependant) >= 20) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 20', count($this->Dependant)), __LINE__);
        }
        $this->Dependant[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Dependant|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Dependant|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Dependant|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Dependant|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Dependant|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Dependant
     */
    public function getAttributeName()
    {
        return 'Dependant';
    }
}
