<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WaitingPeriod StructType
 * @subpackage Structs
 */
class WaitingPeriod extends AbstractStructBase
{
    /**
     * The DependantName
     * @var string
     */
    public $DependantName;
    /**
     * The Condition
     * @var string
     */
    public $Condition;
    /**
     * The DateEnd
     * @var string
     */
    public $DateEnd;
    /**
     * The DependantId
     * @var int
     */
    public $DependantId;
    /**
     * Constructor method for WaitingPeriod
     * @uses WaitingPeriod::setDependantName()
     * @uses WaitingPeriod::setCondition()
     * @uses WaitingPeriod::setDateEnd()
     * @uses WaitingPeriod::setDependantId()
     * @param string $dependantName
     * @param string $condition
     * @param string $dateEnd
     * @param int $dependantId
     */
    public function __construct($dependantName = null, $condition = null, $dateEnd = null, $dependantId = null)
    {
        $this
            ->setDependantName($dependantName)
            ->setCondition($condition)
            ->setDateEnd($dateEnd)
            ->setDependantId($dependantId);
    }
    /**
     * Get DependantName value
     * @return string|null
     */
    public function getDependantName()
    {
        return $this->DependantName;
    }
    /**
     * Set DependantName value
     * @param string $dependantName
     * @return \StructType\WaitingPeriod
     */
    public function setDependantName($dependantName = null)
    {
        // validation for constraint: string
        if (!is_null($dependantName) && !is_string($dependantName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dependantName, true), gettype($dependantName)), __LINE__);
        }
        $this->DependantName = $dependantName;
        return $this;
    }
    /**
     * Get Condition value
     * @return string|null
     */
    public function getCondition()
    {
        return $this->Condition;
    }
    /**
     * Set Condition value
     * @param string $condition
     * @return \StructType\WaitingPeriod
     */
    public function setCondition($condition = null)
    {
        // validation for constraint: string
        if (!is_null($condition) && !is_string($condition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($condition, true), gettype($condition)), __LINE__);
        }
        $this->Condition = $condition;
        return $this;
    }
    /**
     * Get DateEnd value
     * @return string|null
     */
    public function getDateEnd()
    {
        return $this->DateEnd;
    }
    /**
     * Set DateEnd value
     * @param string $dateEnd
     * @return \StructType\WaitingPeriod
     */
    public function setDateEnd($dateEnd = null)
    {
        // validation for constraint: string
        if (!is_null($dateEnd) && !is_string($dateEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateEnd, true), gettype($dateEnd)), __LINE__);
        }
        $this->DateEnd = $dateEnd;
        return $this;
    }
    /**
     * Get DependantId value
     * @return int|null
     */
    public function getDependantId()
    {
        return $this->DependantId;
    }
    /**
     * Set DependantId value
     * @param int $dependantId
     * @return \StructType\WaitingPeriod
     */
    public function setDependantId($dependantId = null)
    {
        // validation for constraint: int
        if (!is_null($dependantId) && !(is_int($dependantId) || ctype_digit($dependantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dependantId, true), gettype($dependantId)), __LINE__);
        }
        $this->DependantId = $dependantId;
        return $this;
    }
}
