<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LateJoinerPenalty StructType
 * @subpackage Structs
 */
class LateJoinerPenalty extends AbstractStructBase
{
    /**
     * The DependantName
     * @var string
     */
    public $DependantName;
    /**
     * The Percentage
     * @var string
     */
    public $Percentage;
    /**
     * The DependantId
     * @var int
     */
    public $DependantId;
    /**
     * Constructor method for LateJoinerPenalty
     * @uses LateJoinerPenalty::setDependantName()
     * @uses LateJoinerPenalty::setPercentage()
     * @uses LateJoinerPenalty::setDependantId()
     * @param string $dependantName
     * @param string $percentage
     * @param int $dependantId
     */
    public function __construct($dependantName = null, $percentage = null, $dependantId = null)
    {
        $this
            ->setDependantName($dependantName)
            ->setPercentage($percentage)
            ->setDependantId($dependantId);
    }
    /**
     * Get DependantName value
     * @return string|null
     */
    public function getDependantName()
    {
        return $this->DependantName;
    }
    /**
     * Set DependantName value
     * @param string $dependantName
     * @return \StructType\LateJoinerPenalty
     */
    public function setDependantName($dependantName = null)
    {
        // validation for constraint: string
        if (!is_null($dependantName) && !is_string($dependantName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dependantName, true), gettype($dependantName)), __LINE__);
        }
        $this->DependantName = $dependantName;
        return $this;
    }
    /**
     * Get Percentage value
     * @return string|null
     */
    public function getPercentage()
    {
        return $this->Percentage;
    }
    /**
     * Set Percentage value
     * @param string $percentage
     * @return \StructType\LateJoinerPenalty
     */
    public function setPercentage($percentage = null)
    {
        // validation for constraint: string
        if (!is_null($percentage) && !is_string($percentage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($percentage, true), gettype($percentage)), __LINE__);
        }
        $this->Percentage = $percentage;
        return $this;
    }
    /**
     * Get DependantId value
     * @return int|null
     */
    public function getDependantId()
    {
        return $this->DependantId;
    }
    /**
     * Set DependantId value
     * @param int $dependantId
     * @return \StructType\LateJoinerPenalty
     */
    public function setDependantId($dependantId = null)
    {
        // validation for constraint: int
        if (!is_null($dependantId) && !(is_int($dependantId) || ctype_digit($dependantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dependantId, true), gettype($dependantId)), __LINE__);
        }
        $this->DependantId = $dependantId;
        return $this;
    }
}
