<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PreviousMedicalScheme StructType
 * @subpackage Structs
 */
class PreviousMedicalScheme extends AbstractStructBase
{
    /**
     * The MedicalSchemeName
     * @var string
     */
    public $MedicalSchemeName;
    /**
     * The MedicalSchemeDependantNumber
     * @var string
     */
    public $MedicalSchemeDependantNumber;
    /**
     * The MedicalSchemeDateJoined
     * @var string
     */
    public $MedicalSchemeDateJoined;
    /**
     * The MedicalSchemeDateEnded
     * @var string
     */
    public $MedicalSchemeDateEnded;
    /**
     * The DependantId
     * @var int
     */
    public $DependantId;
    /**
     * Constructor method for PreviousMedicalScheme
     * @uses PreviousMedicalScheme::setMedicalSchemeName()
     * @uses PreviousMedicalScheme::setMedicalSchemeDependantNumber()
     * @uses PreviousMedicalScheme::setMedicalSchemeDateJoined()
     * @uses PreviousMedicalScheme::setMedicalSchemeDateEnded()
     * @uses PreviousMedicalScheme::setDependantId()
     * @param string $medicalSchemeName
     * @param string $medicalSchemeDependantNumber
     * @param string $medicalSchemeDateJoined
     * @param string $medicalSchemeDateEnded
     * @param int $dependantId
     */
    public function __construct($medicalSchemeName = null, $medicalSchemeDependantNumber = null, $medicalSchemeDateJoined = null, $medicalSchemeDateEnded = null, $dependantId = null)
    {
        $this
            ->setMedicalSchemeName($medicalSchemeName)
            ->setMedicalSchemeDependantNumber($medicalSchemeDependantNumber)
            ->setMedicalSchemeDateJoined($medicalSchemeDateJoined)
            ->setMedicalSchemeDateEnded($medicalSchemeDateEnded)
            ->setDependantId($dependantId);
    }
    /**
     * Get MedicalSchemeName value
     * @return string|null
     */
    public function getMedicalSchemeName()
    {
        return $this->MedicalSchemeName;
    }
    /**
     * Set MedicalSchemeName value
     * @param string $medicalSchemeName
     * @return \StructType\PreviousMedicalScheme
     */
    public function setMedicalSchemeName($medicalSchemeName = null)
    {
        // validation for constraint: string
        if (!is_null($medicalSchemeName) && !is_string($medicalSchemeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($medicalSchemeName, true), gettype($medicalSchemeName)), __LINE__);
        }
        $this->MedicalSchemeName = $medicalSchemeName;
        return $this;
    }
    /**
     * Get MedicalSchemeDependantNumber value
     * @return string|null
     */
    public function getMedicalSchemeDependantNumber()
    {
        return $this->MedicalSchemeDependantNumber;
    }
    /**
     * Set MedicalSchemeDependantNumber value
     * @param string $medicalSchemeDependantNumber
     * @return \StructType\PreviousMedicalScheme
     */
    public function setMedicalSchemeDependantNumber($medicalSchemeDependantNumber = null)
    {
        // validation for constraint: string
        if (!is_null($medicalSchemeDependantNumber) && !is_string($medicalSchemeDependantNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($medicalSchemeDependantNumber, true), gettype($medicalSchemeDependantNumber)), __LINE__);
        }
        $this->MedicalSchemeDependantNumber = $medicalSchemeDependantNumber;
        return $this;
    }
    /**
     * Get MedicalSchemeDateJoined value
     * @return string|null
     */
    public function getMedicalSchemeDateJoined()
    {
        return $this->MedicalSchemeDateJoined;
    }
    /**
     * Set MedicalSchemeDateJoined value
     * @param string $medicalSchemeDateJoined
     * @return \StructType\PreviousMedicalScheme
     */
    public function setMedicalSchemeDateJoined($medicalSchemeDateJoined = null)
    {
        // validation for constraint: string
        if (!is_null($medicalSchemeDateJoined) && !is_string($medicalSchemeDateJoined)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($medicalSchemeDateJoined, true), gettype($medicalSchemeDateJoined)), __LINE__);
        }
        $this->MedicalSchemeDateJoined = $medicalSchemeDateJoined;
        return $this;
    }
    /**
     * Get MedicalSchemeDateEnded value
     * @return string|null
     */
    public function getMedicalSchemeDateEnded()
    {
        return $this->MedicalSchemeDateEnded;
    }
    /**
     * Set MedicalSchemeDateEnded value
     * @param string $medicalSchemeDateEnded
     * @return \StructType\PreviousMedicalScheme
     */
    public function setMedicalSchemeDateEnded($medicalSchemeDateEnded = null)
    {
        // validation for constraint: string
        if (!is_null($medicalSchemeDateEnded) && !is_string($medicalSchemeDateEnded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($medicalSchemeDateEnded, true), gettype($medicalSchemeDateEnded)), __LINE__);
        }
        $this->MedicalSchemeDateEnded = $medicalSchemeDateEnded;
        return $this;
    }
    /**
     * Get DependantId value
     * @return int|null
     */
    public function getDependantId()
    {
        return $this->DependantId;
    }
    /**
     * Set DependantId value
     * @param int $dependantId
     * @return \StructType\PreviousMedicalScheme
     */
    public function setDependantId($dependantId = null)
    {
        // validation for constraint: int
        if (!is_null($dependantId) && !(is_int($dependantId) || ctype_digit($dependantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dependantId, true), gettype($dependantId)), __LINE__);
        }
        $this->DependantId = $dependantId;
        return $this;
    }
}
