<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MedicalQuestionaire StructType
 * @subpackage Structs
 */
class MedicalQuestionaire extends AbstractStructBase
{
    /**
     * The QuestionNumber
     * @var int
     */
    public $QuestionNumber;
    /**
     * The ConditionDateDiagnosed
     * @var string
     */
    public $ConditionDateDiagnosed;
    /**
     * The ConditionDateLastConsult
     * @var string
     */
    public $ConditionDateLastConsult;
    /**
     * The ConditionName
     * @var string
     */
    public $ConditionName;
    /**
     * The ConditionTreatment
     * @var string
     */
    public $ConditionTreatment;
    /**
     * The DependantId
     * @var int
     */
    public $DependantId;
    /**
     * The DependantName
     * @var string
     */
    public $DependantName;
    /**
     * The MedicalAnswerOption
     * @var string
     */
    public $MedicalAnswerOption;
    /**
     * The PatientDOB
     * @var string
     */
    public $PatientDOB;
    /**
     * Constructor method for MedicalQuestionaire
     * @uses MedicalQuestionaire::setQuestionNumber()
     * @uses MedicalQuestionaire::setConditionDateDiagnosed()
     * @uses MedicalQuestionaire::setConditionDateLastConsult()
     * @uses MedicalQuestionaire::setConditionName()
     * @uses MedicalQuestionaire::setConditionTreatment()
     * @uses MedicalQuestionaire::setDependantId()
     * @uses MedicalQuestionaire::setDependantName()
     * @uses MedicalQuestionaire::setMedicalAnswerOption()
     * @uses MedicalQuestionaire::setPatientDOB()
     * @param int $questionNumber
     * @param string $conditionDateDiagnosed
     * @param string $conditionDateLastConsult
     * @param string $conditionName
     * @param string $conditionTreatment
     * @param int $dependantId
     * @param string $dependantName
     * @param string $medicalAnswerOption
     * @param string $patientDOB
     */
    public function __construct($questionNumber = null, $conditionDateDiagnosed = null, $conditionDateLastConsult = null, $conditionName = null, $conditionTreatment = null, $dependantId = null, $dependantName = null, $medicalAnswerOption = null, $patientDOB = null)
    {
        $this
            ->setQuestionNumber($questionNumber)
            ->setConditionDateDiagnosed($conditionDateDiagnosed)
            ->setConditionDateLastConsult($conditionDateLastConsult)
            ->setConditionName($conditionName)
            ->setConditionTreatment($conditionTreatment)
            ->setDependantId($dependantId)
            ->setDependantName($dependantName)
            ->setMedicalAnswerOption($medicalAnswerOption)
            ->setPatientDOB($patientDOB);
    }
    /**
     * Get QuestionNumber value
     * @return int|null
     */
    public function getQuestionNumber()
    {
        return $this->QuestionNumber;
    }
    /**
     * Set QuestionNumber value
     * @param int $questionNumber
     * @return \StructType\MedicalQuestionaire
     */
    public function setQuestionNumber($questionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($questionNumber) && !(is_int($questionNumber) || ctype_digit($questionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($questionNumber, true), gettype($questionNumber)), __LINE__);
        }
        $this->QuestionNumber = $questionNumber;
        return $this;
    }
    /**
     * Get ConditionDateDiagnosed value
     * @return string|null
     */
    public function getConditionDateDiagnosed()
    {
        return $this->ConditionDateDiagnosed;
    }
    /**
     * Set ConditionDateDiagnosed value
     * @param string $conditionDateDiagnosed
     * @return \StructType\MedicalQuestionaire
     */
    public function setConditionDateDiagnosed($conditionDateDiagnosed = null)
    {
        // validation for constraint: string
        if (!is_null($conditionDateDiagnosed) && !is_string($conditionDateDiagnosed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conditionDateDiagnosed, true), gettype($conditionDateDiagnosed)), __LINE__);
        }
        $this->ConditionDateDiagnosed = $conditionDateDiagnosed;
        return $this;
    }
    /**
     * Get ConditionDateLastConsult value
     * @return string|null
     */
    public function getConditionDateLastConsult()
    {
        return $this->ConditionDateLastConsult;
    }
    /**
     * Set ConditionDateLastConsult value
     * @param string $conditionDateLastConsult
     * @return \StructType\MedicalQuestionaire
     */
    public function setConditionDateLastConsult($conditionDateLastConsult = null)
    {
        // validation for constraint: string
        if (!is_null($conditionDateLastConsult) && !is_string($conditionDateLastConsult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conditionDateLastConsult, true), gettype($conditionDateLastConsult)), __LINE__);
        }
        $this->ConditionDateLastConsult = $conditionDateLastConsult;
        return $this;
    }
    /**
     * Get ConditionName value
     * @return string|null
     */
    public function getConditionName()
    {
        return $this->ConditionName;
    }
    /**
     * Set ConditionName value
     * @param string $conditionName
     * @return \StructType\MedicalQuestionaire
     */
    public function setConditionName($conditionName = null)
    {
        // validation for constraint: string
        if (!is_null($conditionName) && !is_string($conditionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conditionName, true), gettype($conditionName)), __LINE__);
        }
        $this->ConditionName = $conditionName;
        return $this;
    }
    /**
     * Get ConditionTreatment value
     * @return string|null
     */
    public function getConditionTreatment()
    {
        return $this->ConditionTreatment;
    }
    /**
     * Set ConditionTreatment value
     * @param string $conditionTreatment
     * @return \StructType\MedicalQuestionaire
     */
    public function setConditionTreatment($conditionTreatment = null)
    {
        // validation for constraint: string
        if (!is_null($conditionTreatment) && !is_string($conditionTreatment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conditionTreatment, true), gettype($conditionTreatment)), __LINE__);
        }
        $this->ConditionTreatment = $conditionTreatment;
        return $this;
    }
    /**
     * Get DependantId value
     * @return int|null
     */
    public function getDependantId()
    {
        return $this->DependantId;
    }
    /**
     * Set DependantId value
     * @param int $dependantId
     * @return \StructType\MedicalQuestionaire
     */
    public function setDependantId($dependantId = null)
    {
        // validation for constraint: int
        if (!is_null($dependantId) && !(is_int($dependantId) || ctype_digit($dependantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dependantId, true), gettype($dependantId)), __LINE__);
        }
        $this->DependantId = $dependantId;
        return $this;
    }
    /**
     * Get DependantName value
     * @return string|null
     */
    public function getDependantName()
    {
        return $this->DependantName;
    }
    /**
     * Set DependantName value
     * @param string $dependantName
     * @return \StructType\MedicalQuestionaire
     */
    public function setDependantName($dependantName = null)
    {
        // validation for constraint: string
        if (!is_null($dependantName) && !is_string($dependantName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dependantName, true), gettype($dependantName)), __LINE__);
        }
        $this->DependantName = $dependantName;
        return $this;
    }
    /**
     * Get MedicalAnswerOption value
     * @return string|null
     */
    public function getMedicalAnswerOption()
    {
        return $this->MedicalAnswerOption;
    }
    /**
     * Set MedicalAnswerOption value
     * @param string $medicalAnswerOption
     * @return \StructType\MedicalQuestionaire
     */
    public function setMedicalAnswerOption($medicalAnswerOption = null)
    {
        // validation for constraint: string
        if (!is_null($medicalAnswerOption) && !is_string($medicalAnswerOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($medicalAnswerOption, true), gettype($medicalAnswerOption)), __LINE__);
        }
        $this->MedicalAnswerOption = $medicalAnswerOption;
        return $this;
    }
    /**
     * Get PatientDOB value
     * @return string|null
     */
    public function getPatientDOB()
    {
        return $this->PatientDOB;
    }
    /**
     * Set PatientDOB value
     * @param string $patientDOB
     * @return \StructType\MedicalQuestionaire
     */
    public function setPatientDOB($patientDOB = null)
    {
        // validation for constraint: string
        if (!is_null($patientDOB) && !is_string($patientDOB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patientDOB, true), gettype($patientDOB)), __LINE__);
        }
        $this->PatientDOB = $patientDOB;
        return $this;
    }
}
