<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SysError StructType
 * @subpackage Structs
 */
class SysError extends AbstractStructBase
{
    /**
     * The sysmsg
     * @var string
     */
    public $sysmsg;
    /**
     * The retryinminutes
     * @var int
     */
    public $retryinminutes;
    /**
     * Constructor method for SysError
     * @uses SysError::setSysmsg()
     * @uses SysError::setRetryinminutes()
     * @param string $sysmsg
     * @param int $retryinminutes
     */
    public function __construct($sysmsg = null, $retryinminutes = null)
    {
        $this
            ->setSysmsg($sysmsg)
            ->setRetryinminutes($retryinminutes);
    }
    /**
     * Get sysmsg value
     * @return string|null
     */
    public function getSysmsg()
    {
        return $this->sysmsg;
    }
    /**
     * Set sysmsg value
     * @param string $sysmsg
     * @return \StructType\SysError
     */
    public function setSysmsg($sysmsg = null)
    {
        // validation for constraint: string
        if (!is_null($sysmsg) && !is_string($sysmsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sysmsg, true), gettype($sysmsg)), __LINE__);
        }
        $this->sysmsg = $sysmsg;
        return $this;
    }
    /**
     * Get retryinminutes value
     * @return int|null
     */
    public function getRetryinminutes()
    {
        return $this->retryinminutes;
    }
    /**
     * Set retryinminutes value
     * @param int $retryinminutes
     * @return \StructType\SysError
     */
    public function setRetryinminutes($retryinminutes = null)
    {
        // validation for constraint: int
        if (!is_null($retryinminutes) && !(is_int($retryinminutes) || ctype_digit($retryinminutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($retryinminutes, true), gettype($retryinminutes)), __LINE__);
        }
        $this->retryinminutes = $retryinminutes;
        return $this;
    }
}
