<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dependant StructType
 * @subpackage Structs
 */
class Dependant extends AbstractStructBase
{
    /**
     * The Citizenship
     * @var string
     */
    public $Citizenship;
    /**
     * The IdNumber
     * @var string
     */
    public $IdNumber;
    /**
     * The PassportNumber
     * @var string
     */
    public $PassportNumber;
    /**
     * The Surname
     * @var string
     */
    public $Surname;
    /**
     * The Initials
     * @var string
     */
    public $Initials;
    /**
     * The Firstname
     * @var string
     */
    public $Firstname;
    /**
     * The Nickname
     * @var string
     */
    public $Nickname;
    /**
     * The DateOfBirth
     * @var string
     */
    public $DateOfBirth;
    /**
     * The Relationship
     * @var string
     */
    public $Relationship;
    /**
     * The DateEffective
     * @var string
     */
    public $DateEffective;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * The DepRace
     * @var string
     */
    public $DepRace;
    /**
     * The DepMarried
     * @var string
     */
    public $DepMarried;
    /**
     * The DepFinDependant
     * @var string
     */
    public $DepFinDependant;
    /**
     * The DepEarnsIncome
     * @var string
     */
    public $DepEarnsIncome;
    /**
     * The DepIncome
     * @var string
     */
    public $DepIncome;
    /**
     * The Cellphone
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Cellphone;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The DependantResidentialStreet
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DependantResidentialStreet;
    /**
     * The DependantResidentialSuburb
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DependantResidentialSuburb;
    /**
     * The DependantResidentialCity
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DependantResidentialCity;
    /**
     * The DependantResidentialAddress4
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DependantResidentialAddress4;
    /**
     * The DependantResidentialCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DependantResidentialCode;
    /**
     * The HadPreviousScheme
     * @var bool
     */
    public $HadPreviousScheme;
    /**
     * The PreviousMedicalSchemes
     * @var \ArrayType\ArrayOfPreviousMedicalScheme
     */
    public $PreviousMedicalSchemes;
    /**
     * Constructor method for Dependant
     * @uses Dependant::setCitizenship()
     * @uses Dependant::setIdNumber()
     * @uses Dependant::setPassportNumber()
     * @uses Dependant::setSurname()
     * @uses Dependant::setInitials()
     * @uses Dependant::setFirstname()
     * @uses Dependant::setNickname()
     * @uses Dependant::setDateOfBirth()
     * @uses Dependant::setRelationship()
     * @uses Dependant::setDateEffective()
     * @uses Dependant::setGender()
     * @uses Dependant::setTitle()
     * @uses Dependant::setDepRace()
     * @uses Dependant::setDepMarried()
     * @uses Dependant::setDepFinDependant()
     * @uses Dependant::setDepEarnsIncome()
     * @uses Dependant::setDepIncome()
     * @uses Dependant::setCellphone()
     * @uses Dependant::setEmail()
     * @uses Dependant::setDependantResidentialStreet()
     * @uses Dependant::setDependantResidentialSuburb()
     * @uses Dependant::setDependantResidentialCity()
     * @uses Dependant::setDependantResidentialAddress4()
     * @uses Dependant::setDependantResidentialCode()
     * @uses Dependant::setHadPreviousScheme()
     * @uses Dependant::setPreviousMedicalSchemes()
     * @param string $citizenship
     * @param string $idNumber
     * @param string $passportNumber
     * @param string $surname
     * @param string $initials
     * @param string $firstname
     * @param string $nickname
     * @param string $dateOfBirth
     * @param string $relationship
     * @param string $dateEffective
     * @param string $gender
     * @param string $title
     * @param string $depRace
     * @param string $depMarried
     * @param string $depFinDependant
     * @param string $depEarnsIncome
     * @param string $depIncome
     * @param string $cellphone
     * @param string $email
     * @param string $dependantResidentialStreet
     * @param string $dependantResidentialSuburb
     * @param string $dependantResidentialCity
     * @param string $dependantResidentialAddress4
     * @param string $dependantResidentialCode
     * @param bool $hadPreviousScheme
     * @param \ArrayType\ArrayOfPreviousMedicalScheme $previousMedicalSchemes
     */
    public function __construct($citizenship = null, $idNumber = null, $passportNumber = null, $surname = null, $initials = null, $firstname = null, $nickname = null, $dateOfBirth = null, $relationship = null, $dateEffective = null, $gender = null, $title = null, $depRace = null, $depMarried = null, $depFinDependant = null, $depEarnsIncome = null, $depIncome = null, $cellphone = null, $email = null, $dependantResidentialStreet = null, $dependantResidentialSuburb = null, $dependantResidentialCity = null, $dependantResidentialAddress4 = null, $dependantResidentialCode = null, $hadPreviousScheme = null, \ArrayType\ArrayOfPreviousMedicalScheme $previousMedicalSchemes = null)
    {
        $this
            ->setCitizenship($citizenship)
            ->setIdNumber($idNumber)
            ->setPassportNumber($passportNumber)
            ->setSurname($surname)
            ->setInitials($initials)
            ->setFirstname($firstname)
            ->setNickname($nickname)
            ->setDateOfBirth($dateOfBirth)
            ->setRelationship($relationship)
            ->setDateEffective($dateEffective)
            ->setGender($gender)
            ->setTitle($title)
            ->setDepRace($depRace)
            ->setDepMarried($depMarried)
            ->setDepFinDependant($depFinDependant)
            ->setDepEarnsIncome($depEarnsIncome)
            ->setDepIncome($depIncome)
            ->setCellphone($cellphone)
            ->setEmail($email)
            ->setDependantResidentialStreet($dependantResidentialStreet)
            ->setDependantResidentialSuburb($dependantResidentialSuburb)
            ->setDependantResidentialCity($dependantResidentialCity)
            ->setDependantResidentialAddress4($dependantResidentialAddress4)
            ->setDependantResidentialCode($dependantResidentialCode)
            ->setHadPreviousScheme($hadPreviousScheme)
            ->setPreviousMedicalSchemes($previousMedicalSchemes);
    }
    /**
     * Get Citizenship value
     * @return string|null
     */
    public function getCitizenship()
    {
        return $this->Citizenship;
    }
    /**
     * Set Citizenship value
     * @param string $citizenship
     * @return \StructType\Dependant
     */
    public function setCitizenship($citizenship = null)
    {
        // validation for constraint: string
        if (!is_null($citizenship) && !is_string($citizenship)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($citizenship, true), gettype($citizenship)), __LINE__);
        }
        $this->Citizenship = $citizenship;
        return $this;
    }
    /**
     * Get IdNumber value
     * @return string|null
     */
    public function getIdNumber()
    {
        return $this->IdNumber;
    }
    /**
     * Set IdNumber value
     * @param string $idNumber
     * @return \StructType\Dependant
     */
    public function setIdNumber($idNumber = null)
    {
        // validation for constraint: string
        if (!is_null($idNumber) && !is_string($idNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idNumber, true), gettype($idNumber)), __LINE__);
        }
        $this->IdNumber = $idNumber;
        return $this;
    }
    /**
     * Get PassportNumber value
     * @return string|null
     */
    public function getPassportNumber()
    {
        return $this->PassportNumber;
    }
    /**
     * Set PassportNumber value
     * @param string $passportNumber
     * @return \StructType\Dependant
     */
    public function setPassportNumber($passportNumber = null)
    {
        // validation for constraint: string
        if (!is_null($passportNumber) && !is_string($passportNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passportNumber, true), gettype($passportNumber)), __LINE__);
        }
        $this->PassportNumber = $passportNumber;
        return $this;
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \StructType\Dependant
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get Initials value
     * @return string|null
     */
    public function getInitials()
    {
        return $this->Initials;
    }
    /**
     * Set Initials value
     * @param string $initials
     * @return \StructType\Dependant
     */
    public function setInitials($initials = null)
    {
        // validation for constraint: string
        if (!is_null($initials) && !is_string($initials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initials, true), gettype($initials)), __LINE__);
        }
        $this->Initials = $initials;
        return $this;
    }
    /**
     * Get Firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->Firstname;
    }
    /**
     * Set Firstname value
     * @param string $firstname
     * @return \StructType\Dependant
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstname, true), gettype($firstname)), __LINE__);
        }
        $this->Firstname = $firstname;
        return $this;
    }
    /**
     * Get Nickname value
     * @return string|null
     */
    public function getNickname()
    {
        return $this->Nickname;
    }
    /**
     * Set Nickname value
     * @param string $nickname
     * @return \StructType\Dependant
     */
    public function setNickname($nickname = null)
    {
        // validation for constraint: string
        if (!is_null($nickname) && !is_string($nickname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nickname, true), gettype($nickname)), __LINE__);
        }
        $this->Nickname = $nickname;
        return $this;
    }
    /**
     * Get DateOfBirth value
     * @return string|null
     */
    public function getDateOfBirth()
    {
        return $this->DateOfBirth;
    }
    /**
     * Set DateOfBirth value
     * @param string $dateOfBirth
     * @return \StructType\Dependant
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfBirth) && !is_string($dateOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfBirth, true), gettype($dateOfBirth)), __LINE__);
        }
        $this->DateOfBirth = $dateOfBirth;
        return $this;
    }
    /**
     * Get Relationship value
     * @return string|null
     */
    public function getRelationship()
    {
        return $this->Relationship;
    }
    /**
     * Set Relationship value
     * @param string $relationship
     * @return \StructType\Dependant
     */
    public function setRelationship($relationship = null)
    {
        // validation for constraint: string
        if (!is_null($relationship) && !is_string($relationship)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationship, true), gettype($relationship)), __LINE__);
        }
        $this->Relationship = $relationship;
        return $this;
    }
    /**
     * Get DateEffective value
     * @return string|null
     */
    public function getDateEffective()
    {
        return $this->DateEffective;
    }
    /**
     * Set DateEffective value
     * @param string $dateEffective
     * @return \StructType\Dependant
     */
    public function setDateEffective($dateEffective = null)
    {
        // validation for constraint: string
        if (!is_null($dateEffective) && !is_string($dateEffective)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateEffective, true), gettype($dateEffective)), __LINE__);
        }
        $this->DateEffective = $dateEffective;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \StructType\Dependant
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gender, true), gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\Dependant
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get DepRace value
     * @return string|null
     */
    public function getDepRace()
    {
        return $this->DepRace;
    }
    /**
     * Set DepRace value
     * @param string $depRace
     * @return \StructType\Dependant
     */
    public function setDepRace($depRace = null)
    {
        // validation for constraint: string
        if (!is_null($depRace) && !is_string($depRace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depRace, true), gettype($depRace)), __LINE__);
        }
        $this->DepRace = $depRace;
        return $this;
    }
    /**
     * Get DepMarried value
     * @return string|null
     */
    public function getDepMarried()
    {
        return $this->DepMarried;
    }
    /**
     * Set DepMarried value
     * @param string $depMarried
     * @return \StructType\Dependant
     */
    public function setDepMarried($depMarried = null)
    {
        // validation for constraint: string
        if (!is_null($depMarried) && !is_string($depMarried)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depMarried, true), gettype($depMarried)), __LINE__);
        }
        $this->DepMarried = $depMarried;
        return $this;
    }
    /**
     * Get DepFinDependant value
     * @return string|null
     */
    public function getDepFinDependant()
    {
        return $this->DepFinDependant;
    }
    /**
     * Set DepFinDependant value
     * @param string $depFinDependant
     * @return \StructType\Dependant
     */
    public function setDepFinDependant($depFinDependant = null)
    {
        // validation for constraint: string
        if (!is_null($depFinDependant) && !is_string($depFinDependant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depFinDependant, true), gettype($depFinDependant)), __LINE__);
        }
        $this->DepFinDependant = $depFinDependant;
        return $this;
    }
    /**
     * Get DepEarnsIncome value
     * @return string|null
     */
    public function getDepEarnsIncome()
    {
        return $this->DepEarnsIncome;
    }
    /**
     * Set DepEarnsIncome value
     * @param string $depEarnsIncome
     * @return \StructType\Dependant
     */
    public function setDepEarnsIncome($depEarnsIncome = null)
    {
        // validation for constraint: string
        if (!is_null($depEarnsIncome) && !is_string($depEarnsIncome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depEarnsIncome, true), gettype($depEarnsIncome)), __LINE__);
        }
        $this->DepEarnsIncome = $depEarnsIncome;
        return $this;
    }
    /**
     * Get DepIncome value
     * @return string|null
     */
    public function getDepIncome()
    {
        return $this->DepIncome;
    }
    /**
     * Set DepIncome value
     * @param string $depIncome
     * @return \StructType\Dependant
     */
    public function setDepIncome($depIncome = null)
    {
        // validation for constraint: string
        if (!is_null($depIncome) && !is_string($depIncome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depIncome, true), gettype($depIncome)), __LINE__);
        }
        $this->DepIncome = $depIncome;
        return $this;
    }
    /**
     * Get Cellphone value
     * @return string|null
     */
    public function getCellphone()
    {
        return $this->Cellphone;
    }
    /**
     * Set Cellphone value
     * @param string $cellphone
     * @return \StructType\Dependant
     */
    public function setCellphone($cellphone = null)
    {
        // validation for constraint: string
        if (!is_null($cellphone) && !is_string($cellphone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cellphone, true), gettype($cellphone)), __LINE__);
        }
        $this->Cellphone = $cellphone;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Dependant
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get DependantResidentialStreet value
     * @return string|null
     */
    public function getDependantResidentialStreet()
    {
        return $this->DependantResidentialStreet;
    }
    /**
     * Set DependantResidentialStreet value
     * @param string $dependantResidentialStreet
     * @return \StructType\Dependant
     */
    public function setDependantResidentialStreet($dependantResidentialStreet = null)
    {
        // validation for constraint: string
        if (!is_null($dependantResidentialStreet) && !is_string($dependantResidentialStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dependantResidentialStreet, true), gettype($dependantResidentialStreet)), __LINE__);
        }
        $this->DependantResidentialStreet = $dependantResidentialStreet;
        return $this;
    }
    /**
     * Get DependantResidentialSuburb value
     * @return string|null
     */
    public function getDependantResidentialSuburb()
    {
        return $this->DependantResidentialSuburb;
    }
    /**
     * Set DependantResidentialSuburb value
     * @param string $dependantResidentialSuburb
     * @return \StructType\Dependant
     */
    public function setDependantResidentialSuburb($dependantResidentialSuburb = null)
    {
        // validation for constraint: string
        if (!is_null($dependantResidentialSuburb) && !is_string($dependantResidentialSuburb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dependantResidentialSuburb, true), gettype($dependantResidentialSuburb)), __LINE__);
        }
        $this->DependantResidentialSuburb = $dependantResidentialSuburb;
        return $this;
    }
    /**
     * Get DependantResidentialCity value
     * @return string|null
     */
    public function getDependantResidentialCity()
    {
        return $this->DependantResidentialCity;
    }
    /**
     * Set DependantResidentialCity value
     * @param string $dependantResidentialCity
     * @return \StructType\Dependant
     */
    public function setDependantResidentialCity($dependantResidentialCity = null)
    {
        // validation for constraint: string
        if (!is_null($dependantResidentialCity) && !is_string($dependantResidentialCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dependantResidentialCity, true), gettype($dependantResidentialCity)), __LINE__);
        }
        $this->DependantResidentialCity = $dependantResidentialCity;
        return $this;
    }
    /**
     * Get DependantResidentialAddress4 value
     * @return string|null
     */
    public function getDependantResidentialAddress4()
    {
        return $this->DependantResidentialAddress4;
    }
    /**
     * Set DependantResidentialAddress4 value
     * @param string $dependantResidentialAddress4
     * @return \StructType\Dependant
     */
    public function setDependantResidentialAddress4($dependantResidentialAddress4 = null)
    {
        // validation for constraint: string
        if (!is_null($dependantResidentialAddress4) && !is_string($dependantResidentialAddress4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dependantResidentialAddress4, true), gettype($dependantResidentialAddress4)), __LINE__);
        }
        $this->DependantResidentialAddress4 = $dependantResidentialAddress4;
        return $this;
    }
    /**
     * Get DependantResidentialCode value
     * @return string|null
     */
    public function getDependantResidentialCode()
    {
        return $this->DependantResidentialCode;
    }
    /**
     * Set DependantResidentialCode value
     * @param string $dependantResidentialCode
     * @return \StructType\Dependant
     */
    public function setDependantResidentialCode($dependantResidentialCode = null)
    {
        // validation for constraint: string
        if (!is_null($dependantResidentialCode) && !is_string($dependantResidentialCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dependantResidentialCode, true), gettype($dependantResidentialCode)), __LINE__);
        }
        $this->DependantResidentialCode = $dependantResidentialCode;
        return $this;
    }
    /**
     * Get HadPreviousScheme value
     * @return bool|null
     */
    public function getHadPreviousScheme()
    {
        return $this->HadPreviousScheme;
    }
    /**
     * Set HadPreviousScheme value
     * @param bool $hadPreviousScheme
     * @return \StructType\Dependant
     */
    public function setHadPreviousScheme($hadPreviousScheme = null)
    {
        // validation for constraint: boolean
        if (!is_null($hadPreviousScheme) && !is_bool($hadPreviousScheme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hadPreviousScheme, true), gettype($hadPreviousScheme)), __LINE__);
        }
        $this->HadPreviousScheme = $hadPreviousScheme;
        return $this;
    }
    /**
     * Get PreviousMedicalSchemes value
     * @return \ArrayType\ArrayOfPreviousMedicalScheme|null
     */
    public function getPreviousMedicalSchemes()
    {
        return $this->PreviousMedicalSchemes;
    }
    /**
     * Set PreviousMedicalSchemes value
     * @param \ArrayType\ArrayOfPreviousMedicalScheme $previousMedicalSchemes
     * @return \StructType\Dependant
     */
    public function setPreviousMedicalSchemes(\ArrayType\ArrayOfPreviousMedicalScheme $previousMedicalSchemes = null)
    {
        $this->PreviousMedicalSchemes = $previousMedicalSchemes;
        return $this;
    }
}
