<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Corporate ServiceType
 * @subpackage Services
 */
class Corporate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CorporateMemberEApp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CorporateMemberEAppInput $input
     * @return \StructType\CorporateMemberEAppResponse|bool
     */
    public function CorporateMemberEApp(\StructType\CorporateMemberEAppInput $input)
    {
        try {
            $this->setResult($this->getSoapClient()->CorporateMemberEApp($input));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CorporateMemberEAppResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
