<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HealthCareProvider StructType
 * @subpackage Structs
 */
class HealthCareProvider extends AbstractStructBase
{
    /**
     * The HCPName
     * @var string
     */
    public $HCPName;
    /**
     * The HCPContactNr
     * @var string
     */
    public $HCPContactNr;
    /**
     * The HCPYears
     * @var string
     */
    public $HCPYears;
    /**
     * Constructor method for HealthCareProvider
     * @uses HealthCareProvider::setHCPName()
     * @uses HealthCareProvider::setHCPContactNr()
     * @uses HealthCareProvider::setHCPYears()
     * @param string $hCPName
     * @param string $hCPContactNr
     * @param string $hCPYears
     */
    public function __construct($hCPName = null, $hCPContactNr = null, $hCPYears = null)
    {
        $this
            ->setHCPName($hCPName)
            ->setHCPContactNr($hCPContactNr)
            ->setHCPYears($hCPYears);
    }
    /**
     * Get HCPName value
     * @return string|null
     */
    public function getHCPName()
    {
        return $this->HCPName;
    }
    /**
     * Set HCPName value
     * @param string $hCPName
     * @return \StructType\HealthCareProvider
     */
    public function setHCPName($hCPName = null)
    {
        // validation for constraint: string
        if (!is_null($hCPName) && !is_string($hCPName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hCPName, true), gettype($hCPName)), __LINE__);
        }
        $this->HCPName = $hCPName;
        return $this;
    }
    /**
     * Get HCPContactNr value
     * @return string|null
     */
    public function getHCPContactNr()
    {
        return $this->HCPContactNr;
    }
    /**
     * Set HCPContactNr value
     * @param string $hCPContactNr
     * @return \StructType\HealthCareProvider
     */
    public function setHCPContactNr($hCPContactNr = null)
    {
        // validation for constraint: string
        if (!is_null($hCPContactNr) && !is_string($hCPContactNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hCPContactNr, true), gettype($hCPContactNr)), __LINE__);
        }
        $this->HCPContactNr = $hCPContactNr;
        return $this;
    }
    /**
     * Get HCPYears value
     * @return string|null
     */
    public function getHCPYears()
    {
        return $this->HCPYears;
    }
    /**
     * Set HCPYears value
     * @param string $hCPYears
     * @return \StructType\HealthCareProvider
     */
    public function setHCPYears($hCPYears = null)
    {
        // validation for constraint: string
        if (!is_null($hCPYears) && !is_string($hCPYears)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hCPYears, true), gettype($hCPYears)), __LINE__);
        }
        $this->HCPYears = $hCPYears;
        return $this;
    }
}
