<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MedicalHistoryQuestionaire StructType
 * @subpackage Structs
 */
class MedicalHistoryQuestionaire extends AbstractStructBase
{
    /**
     * The QuestionNumber
     * @var string
     */
    public $QuestionNumber;
    /**
     * The MedicalAnswer
     * @var string
     */
    public $MedicalAnswer;
    /**
     * Constructor method for MedicalHistoryQuestionaire
     * @uses MedicalHistoryQuestionaire::setQuestionNumber()
     * @uses MedicalHistoryQuestionaire::setMedicalAnswer()
     * @param string $questionNumber
     * @param string $medicalAnswer
     */
    public function __construct($questionNumber = null, $medicalAnswer = null)
    {
        $this
            ->setQuestionNumber($questionNumber)
            ->setMedicalAnswer($medicalAnswer);
    }
    /**
     * Get QuestionNumber value
     * @return string|null
     */
    public function getQuestionNumber()
    {
        return $this->QuestionNumber;
    }
    /**
     * Set QuestionNumber value
     * @param string $questionNumber
     * @return \StructType\MedicalHistoryQuestionaire
     */
    public function setQuestionNumber($questionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($questionNumber) && !is_string($questionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionNumber, true), gettype($questionNumber)), __LINE__);
        }
        $this->QuestionNumber = $questionNumber;
        return $this;
    }
    /**
     * Get MedicalAnswer value
     * @return string|null
     */
    public function getMedicalAnswer()
    {
        return $this->MedicalAnswer;
    }
    /**
     * Set MedicalAnswer value
     * @param string $medicalAnswer
     * @return \StructType\MedicalHistoryQuestionaire
     */
    public function setMedicalAnswer($medicalAnswer = null)
    {
        // validation for constraint: string
        if (!is_null($medicalAnswer) && !is_string($medicalAnswer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($medicalAnswer, true), gettype($medicalAnswer)), __LINE__);
        }
        $this->MedicalAnswer = $medicalAnswer;
        return $this;
    }
}
