<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CorporateMemberEAppInput StructType
 * @subpackage Structs
 */
class CorporateMemberEAppInput extends AbstractStructBase
{
    /**
     * The Scheme
     * @var string
     */
    public $Scheme;
    /**
     * The IdNumber
     * @var string
     */
    public $IdNumber;
    /**
     * The PassportNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PassportNumber;
    /**
     * The Country
     * @var string
     */
    public $Country;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * The Initials
     * @var string
     */
    public $Initials;
    /**
     * The Surname
     * @var string
     */
    public $Surname;
    /**
     * The Firstname
     * @var string
     */
    public $Firstname;
    /**
     * The Nickname
     * @var string
     */
    public $Nickname;
    /**
     * The DateOfBirth
     * @var string
     */
    public $DateOfBirth;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * The IncomeTaxNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IncomeTaxNumber;
    /**
     * The Cellphone
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Cellphone;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Telephone;
    /**
     * The Workphone
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Workphone;
    /**
     * The FaxNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FaxNumber;
    /**
     * The DateApplied
     * @var string
     */
    public $DateApplied;
    /**
     * The PostStreet
     * @var string
     */
    public $PostStreet;
    /**
     * The PostSuburb
     * @var string
     */
    public $PostSuburb;
    /**
     * The PostCity
     * @var string
     */
    public $PostCity;
    /**
     * The PostAddress4
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PostAddress4;
    /**
     * The PostCode
     * @var string
     */
    public $PostCode;
    /**
     * The ResidentialStreet
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ResidentialStreet;
    /**
     * The ResidentialSuburb
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ResidentialSuburb;
    /**
     * The ResidentialCity
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ResidentialCity;
    /**
     * The ResidentialAddress4
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ResidentialAddress4;
    /**
     * The ResidentialCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ResidentialCode;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The EmployerCompanyName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EmployerCompanyName;
    /**
     * The EmployerTitle
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EmployerTitle;
    /**
     * The EmployerContactName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EmployerContactName;
    /**
     * The EmployerContactSurname
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EmployerContactSurname;
    /**
     * The EmployerPostalStreet
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EmployerPostalStreet;
    /**
     * The EmployerPostalSuburb
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EmployerPostalSuburb;
    /**
     * The EmployerPostalCity
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EmployerPostalCity;
    /**
     * The EmployerPostalAddress4
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EmployerPostalAddress4;
    /**
     * The EmployerPostalCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EmployerPostalCode;
    /**
     * The EmployerGroup
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EmployerGroup;
    /**
     * The EmployerEmail
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EmployerEmail;
    /**
     * The EmployerTelephone
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EmployerTelephone;
    /**
     * The EmployerPayrollNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EmployerPayrollNumber;
    /**
     * The EmployerPaymentArea
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EmployerPaymentArea;
    /**
     * The EmployerEmploymentDate
     * @var string
     */
    public $EmployerEmploymentDate;
    /**
     * The BankName
     * @var string
     */
    public $BankName;
    /**
     * The BankBranchName
     * @var string
     */
    public $BankBranchName;
    /**
     * The BankBranchCode
     * @var string
     */
    public $BankBranchCode;
    /**
     * The BankAccNumber
     * @var string
     */
    public $BankAccNumber;
    /**
     * The BankAccHolderName
     * @var string
     */
    public $BankAccHolderName;
    /**
     * The BankAccHolderSurname
     * @var string
     */
    public $BankAccHolderSurname;
    /**
     * The BankAccType
     * @var string
     */
    public $BankAccType;
    /**
     * The BankDepositName
     * @var string
     */
    public $BankDepositName;
    /**
     * The BankDepositBranchName
     * @var string
     */
    public $BankDepositBranchName;
    /**
     * The BankDepositBranchCode
     * @var string
     */
    public $BankDepositBranchCode;
    /**
     * The BankDepositAccNumber
     * @var string
     */
    public $BankDepositAccNumber;
    /**
     * The BankDepositAccHolderName
     * @var string
     */
    public $BankDepositAccHolderName;
    /**
     * The BankDepositAccHolderSurname
     * @var string
     */
    public $BankDepositAccHolderSurname;
    /**
     * The BankDepositAccType
     * @var string
     */
    public $BankDepositAccType;
    /**
     * The BenefitOption
     * @var string
     */
    public $BenefitOption;
    /**
     * The SavingsOption
     * @var string
     */
    public $SavingsOption;
    /**
     * The NetworkOption
     * @var string
     */
    public $NetworkOption;
    /**
     * The MonthlyIncomeApplicant
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $MonthlyIncomeApplicant;
    /**
     * The MonthlyIncomeSpouse
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $MonthlyIncomeSpouse;
    /**
     * The OccupationApplicant
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OccupationApplicant;
    /**
     * The OccupationSpouse
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OccupationSpouse;
    /**
     * The ReferenceNumber
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The MaritalStatus
     * @var string
     */
    public $MaritalStatus;
    /**
     * The MarriageDate
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $MarriageDate;
    /**
     * The AcceptedMembership
     * @var string
     */
    public $AcceptedMembership;
    /**
     * The BrokerHouseName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BrokerHouseName;
    /**
     * The BrokerHouseNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BrokerHouseNumber;
    /**
     * The BrokerName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BrokerName;
    /**
     * The BrokerCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BrokerCode;
    /**
     * The BrokerCell
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BrokerCell;
    /**
     * The BrokerTelCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BrokerTelCode;
    /**
     * The BrokerTelNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BrokerTelNumber;
    /**
     * The BrokerEmailAddress
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BrokerEmailAddress;
    /**
     * The GuardianCuratorIdNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $GuardianCuratorIdNumber;
    /**
     * The GuardianCuratorPassport
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $GuardianCuratorPassport;
    /**
     * The GuardianCuratorTitle
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $GuardianCuratorTitle;
    /**
     * The GuardianCuratorInits
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $GuardianCuratorInits;
    /**
     * The GuardianCuratorFullName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $GuardianCuratorFullName;
    /**
     * The GuardianCuratorSurname
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $GuardianCuratorSurname;
    /**
     * The GuardianCuratorCell
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $GuardianCuratorCell;
    /**
     * The GuardianCuratorTelCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $GuardianCuratorTelCode;
    /**
     * The GuardianCuratorTelNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $GuardianCuratorTelNumber;
    /**
     * The GuardianCuratorFaxCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $GuardianCuratorFaxCode;
    /**
     * The GuardianCuratorFaxNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $GuardianCuratorFaxNumber;
    /**
     * The GuardianCuratorEmailAddress
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $GuardianCuratorEmailAddress;
    /**
     * The ThirdPartyTitle
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ThirdPartyTitle;
    /**
     * The ThirdPartyInits
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ThirdPartyInits;
    /**
     * The ThirdPartySurname
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ThirdPartySurname;
    /**
     * The ThirdPartyRelationship
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ThirdPartyRelationship;
    /**
     * The ThirdPartyId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ThirdPartyId;
    /**
     * The ThirdPartyPassport
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ThirdPartyPassport;
    /**
     * The ThirdPartyCountry
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ThirdPartyCountry;
    /**
     * The ThirdPartyDialCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ThirdPartyDialCode;
    /**
     * The ThirdPartyPhoneNr
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ThirdPartyPhoneNr;
    /**
     * The ThirdPartyCellCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ThirdPartyCellCode;
    /**
     * The ThirdPartyCellNr
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ThirdPartyCellNr;
    /**
     * The ThirdPartyEmail
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ThirdPartyEmail;
    /**
     * The ThirdPartyAuthOption
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ThirdPartyAuthOption;
    /**
     * The ThirdPartyDocRecvdDate
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ThirdPartyDocRecvdDate;
    /**
     * The ThirdPartyAuthType
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ThirdPartyAuthType;
    /**
     * The ThirdPartyAuthSignature
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ThirdPartyAuthSignature;
    /**
     * The ThirdPartyAuthProofId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ThirdPartyAuthProofId;
    /**
     * The ThirdPartyPoaSignature
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ThirdPartyPoaSignature;
    /**
     * The ThirdPartyPoaProofId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ThirdPartyPoaProofId;
    /**
     * The LeadNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LeadNumber;
    /**
     * The DeductionDateInd
     * @var string
     */
    public $DeductionDateInd;
    /**
     * The VisuallyImpaired
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $VisuallyImpaired;
    /**
     * The HearingImpaired
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $HearingImpaired;
    /**
     * The PersonalInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $PersonalInfo;
    /**
     * The ApplicationType
     * @var string
     */
    public $ApplicationType;
    /**
     * The ApplicClass
     * @var string
     */
    public $ApplicClass;
    /**
     * The ReceiptType
     * @var string
     */
    public $ReceiptType;
    /**
     * The ApplicationVersion
     * @var string
     */
    public $ApplicationVersion;
    /**
     * The BankAccSignature
     * @var string
     */
    public $BankAccSignature;
    /**
     * The PreviousSchmMainMember
     * @var string
     */
    public $PreviousSchmMainMember;
    /**
     * The PreviousSchmCancellation
     * @var string
     */
    public $PreviousSchmCancellation;
    /**
     * The AdviserSignature
     * @var string
     */
    public $AdviserSignature;
    /**
     * The ApplicantSignature
     * @var string
     */
    public $ApplicantSignature;
    /**
     * The GuardianCountry
     * @var string
     */
    public $GuardianCountry;
    /**
     * The MbrRace
     * @var string
     */
    public $MbrRace;
    /**
     * The Password
     * @var string
     */
    public $Password;
    /**
     * The Userid
     * @var string
     */
    public $Userid;
    /**
     * The MbrPrevMedicalSchemes
     * @var \ArrayType\ArrayOfMbrPrevMedicalScheme
     */
    public $MbrPrevMedicalSchemes;
    /**
     * The Dependants
     * @var \ArrayType\ArrayOfDependant
     */
    public $Dependants;
    /**
     * The LateJoinerPenaltys
     * @var \ArrayType\ArrayOfLateJoinerPenalty
     */
    public $LateJoinerPenaltys;
    /**
     * The WaitingPeriods
     * @var \ArrayType\ArrayOfWaitingPeriod
     */
    public $WaitingPeriods;
    /**
     * The MedicalQuestionaires
     * @var \ArrayType\ArrayOfMedicalQuestionaire
     */
    public $MedicalQuestionaires;
    /**
     * The MedicalHistoryQuestionaires
     * @var \ArrayType\ArrayOfMedicalHistoryQuestionaire
     */
    public $MedicalHistoryQuestionaires;
    /**
     * The HealthCareProviders
     * @var \ArrayType\ArrayOfHealthCareProvider
     */
    public $HealthCareProviders;
    /**
     * Constructor method for CorporateMemberEAppInput
     * @uses CorporateMemberEAppInput::setScheme()
     * @uses CorporateMemberEAppInput::setIdNumber()
     * @uses CorporateMemberEAppInput::setPassportNumber()
     * @uses CorporateMemberEAppInput::setCountry()
     * @uses CorporateMemberEAppInput::setLanguage()
     * @uses CorporateMemberEAppInput::setTitle()
     * @uses CorporateMemberEAppInput::setInitials()
     * @uses CorporateMemberEAppInput::setSurname()
     * @uses CorporateMemberEAppInput::setFirstname()
     * @uses CorporateMemberEAppInput::setNickname()
     * @uses CorporateMemberEAppInput::setDateOfBirth()
     * @uses CorporateMemberEAppInput::setGender()
     * @uses CorporateMemberEAppInput::setIncomeTaxNumber()
     * @uses CorporateMemberEAppInput::setCellphone()
     * @uses CorporateMemberEAppInput::setTelephone()
     * @uses CorporateMemberEAppInput::setWorkphone()
     * @uses CorporateMemberEAppInput::setFaxNumber()
     * @uses CorporateMemberEAppInput::setDateApplied()
     * @uses CorporateMemberEAppInput::setPostStreet()
     * @uses CorporateMemberEAppInput::setPostSuburb()
     * @uses CorporateMemberEAppInput::setPostCity()
     * @uses CorporateMemberEAppInput::setPostAddress4()
     * @uses CorporateMemberEAppInput::setPostCode()
     * @uses CorporateMemberEAppInput::setResidentialStreet()
     * @uses CorporateMemberEAppInput::setResidentialSuburb()
     * @uses CorporateMemberEAppInput::setResidentialCity()
     * @uses CorporateMemberEAppInput::setResidentialAddress4()
     * @uses CorporateMemberEAppInput::setResidentialCode()
     * @uses CorporateMemberEAppInput::setEmail()
     * @uses CorporateMemberEAppInput::setEmployerCompanyName()
     * @uses CorporateMemberEAppInput::setEmployerTitle()
     * @uses CorporateMemberEAppInput::setEmployerContactName()
     * @uses CorporateMemberEAppInput::setEmployerContactSurname()
     * @uses CorporateMemberEAppInput::setEmployerPostalStreet()
     * @uses CorporateMemberEAppInput::setEmployerPostalSuburb()
     * @uses CorporateMemberEAppInput::setEmployerPostalCity()
     * @uses CorporateMemberEAppInput::setEmployerPostalAddress4()
     * @uses CorporateMemberEAppInput::setEmployerPostalCode()
     * @uses CorporateMemberEAppInput::setEmployerGroup()
     * @uses CorporateMemberEAppInput::setEmployerEmail()
     * @uses CorporateMemberEAppInput::setEmployerTelephone()
     * @uses CorporateMemberEAppInput::setEmployerPayrollNumber()
     * @uses CorporateMemberEAppInput::setEmployerPaymentArea()
     * @uses CorporateMemberEAppInput::setEmployerEmploymentDate()
     * @uses CorporateMemberEAppInput::setBankName()
     * @uses CorporateMemberEAppInput::setBankBranchName()
     * @uses CorporateMemberEAppInput::setBankBranchCode()
     * @uses CorporateMemberEAppInput::setBankAccNumber()
     * @uses CorporateMemberEAppInput::setBankAccHolderName()
     * @uses CorporateMemberEAppInput::setBankAccHolderSurname()
     * @uses CorporateMemberEAppInput::setBankAccType()
     * @uses CorporateMemberEAppInput::setBankDepositName()
     * @uses CorporateMemberEAppInput::setBankDepositBranchName()
     * @uses CorporateMemberEAppInput::setBankDepositBranchCode()
     * @uses CorporateMemberEAppInput::setBankDepositAccNumber()
     * @uses CorporateMemberEAppInput::setBankDepositAccHolderName()
     * @uses CorporateMemberEAppInput::setBankDepositAccHolderSurname()
     * @uses CorporateMemberEAppInput::setBankDepositAccType()
     * @uses CorporateMemberEAppInput::setBenefitOption()
     * @uses CorporateMemberEAppInput::setSavingsOption()
     * @uses CorporateMemberEAppInput::setNetworkOption()
     * @uses CorporateMemberEAppInput::setMonthlyIncomeApplicant()
     * @uses CorporateMemberEAppInput::setMonthlyIncomeSpouse()
     * @uses CorporateMemberEAppInput::setOccupationApplicant()
     * @uses CorporateMemberEAppInput::setOccupationSpouse()
     * @uses CorporateMemberEAppInput::setReferenceNumber()
     * @uses CorporateMemberEAppInput::setMaritalStatus()
     * @uses CorporateMemberEAppInput::setMarriageDate()
     * @uses CorporateMemberEAppInput::setAcceptedMembership()
     * @uses CorporateMemberEAppInput::setBrokerHouseName()
     * @uses CorporateMemberEAppInput::setBrokerHouseNumber()
     * @uses CorporateMemberEAppInput::setBrokerName()
     * @uses CorporateMemberEAppInput::setBrokerCode()
     * @uses CorporateMemberEAppInput::setBrokerCell()
     * @uses CorporateMemberEAppInput::setBrokerTelCode()
     * @uses CorporateMemberEAppInput::setBrokerTelNumber()
     * @uses CorporateMemberEAppInput::setBrokerEmailAddress()
     * @uses CorporateMemberEAppInput::setGuardianCuratorIdNumber()
     * @uses CorporateMemberEAppInput::setGuardianCuratorPassport()
     * @uses CorporateMemberEAppInput::setGuardianCuratorTitle()
     * @uses CorporateMemberEAppInput::setGuardianCuratorInits()
     * @uses CorporateMemberEAppInput::setGuardianCuratorFullName()
     * @uses CorporateMemberEAppInput::setGuardianCuratorSurname()
     * @uses CorporateMemberEAppInput::setGuardianCuratorCell()
     * @uses CorporateMemberEAppInput::setGuardianCuratorTelCode()
     * @uses CorporateMemberEAppInput::setGuardianCuratorTelNumber()
     * @uses CorporateMemberEAppInput::setGuardianCuratorFaxCode()
     * @uses CorporateMemberEAppInput::setGuardianCuratorFaxNumber()
     * @uses CorporateMemberEAppInput::setGuardianCuratorEmailAddress()
     * @uses CorporateMemberEAppInput::setThirdPartyTitle()
     * @uses CorporateMemberEAppInput::setThirdPartyInits()
     * @uses CorporateMemberEAppInput::setThirdPartySurname()
     * @uses CorporateMemberEAppInput::setThirdPartyRelationship()
     * @uses CorporateMemberEAppInput::setThirdPartyId()
     * @uses CorporateMemberEAppInput::setThirdPartyPassport()
     * @uses CorporateMemberEAppInput::setThirdPartyCountry()
     * @uses CorporateMemberEAppInput::setThirdPartyDialCode()
     * @uses CorporateMemberEAppInput::setThirdPartyPhoneNr()
     * @uses CorporateMemberEAppInput::setThirdPartyCellCode()
     * @uses CorporateMemberEAppInput::setThirdPartyCellNr()
     * @uses CorporateMemberEAppInput::setThirdPartyEmail()
     * @uses CorporateMemberEAppInput::setThirdPartyAuthOption()
     * @uses CorporateMemberEAppInput::setThirdPartyDocRecvdDate()
     * @uses CorporateMemberEAppInput::setThirdPartyAuthType()
     * @uses CorporateMemberEAppInput::setThirdPartyAuthSignature()
     * @uses CorporateMemberEAppInput::setThirdPartyAuthProofId()
     * @uses CorporateMemberEAppInput::setThirdPartyPoaSignature()
     * @uses CorporateMemberEAppInput::setThirdPartyPoaProofId()
     * @uses CorporateMemberEAppInput::setLeadNumber()
     * @uses CorporateMemberEAppInput::setDeductionDateInd()
     * @uses CorporateMemberEAppInput::setVisuallyImpaired()
     * @uses CorporateMemberEAppInput::setHearingImpaired()
     * @uses CorporateMemberEAppInput::setPersonalInfo()
     * @uses CorporateMemberEAppInput::setApplicationType()
     * @uses CorporateMemberEAppInput::setApplicClass()
     * @uses CorporateMemberEAppInput::setReceiptType()
     * @uses CorporateMemberEAppInput::setApplicationVersion()
     * @uses CorporateMemberEAppInput::setBankAccSignature()
     * @uses CorporateMemberEAppInput::setPreviousSchmMainMember()
     * @uses CorporateMemberEAppInput::setPreviousSchmCancellation()
     * @uses CorporateMemberEAppInput::setAdviserSignature()
     * @uses CorporateMemberEAppInput::setApplicantSignature()
     * @uses CorporateMemberEAppInput::setGuardianCountry()
     * @uses CorporateMemberEAppInput::setMbrRace()
     * @uses CorporateMemberEAppInput::setPassword()
     * @uses CorporateMemberEAppInput::setUserid()
     * @uses CorporateMemberEAppInput::setMbrPrevMedicalSchemes()
     * @uses CorporateMemberEAppInput::setDependants()
     * @uses CorporateMemberEAppInput::setLateJoinerPenaltys()
     * @uses CorporateMemberEAppInput::setWaitingPeriods()
     * @uses CorporateMemberEAppInput::setMedicalQuestionaires()
     * @uses CorporateMemberEAppInput::setMedicalHistoryQuestionaires()
     * @uses CorporateMemberEAppInput::setHealthCareProviders()
     * @param string $scheme
     * @param string $idNumber
     * @param string $passportNumber
     * @param string $country
     * @param string $language
     * @param string $title
     * @param string $initials
     * @param string $surname
     * @param string $firstname
     * @param string $nickname
     * @param string $dateOfBirth
     * @param string $gender
     * @param string $incomeTaxNumber
     * @param string $cellphone
     * @param string $telephone
     * @param string $workphone
     * @param string $faxNumber
     * @param string $dateApplied
     * @param string $postStreet
     * @param string $postSuburb
     * @param string $postCity
     * @param string $postAddress4
     * @param string $postCode
     * @param string $residentialStreet
     * @param string $residentialSuburb
     * @param string $residentialCity
     * @param string $residentialAddress4
     * @param string $residentialCode
     * @param string $email
     * @param string $employerCompanyName
     * @param string $employerTitle
     * @param string $employerContactName
     * @param string $employerContactSurname
     * @param string $employerPostalStreet
     * @param string $employerPostalSuburb
     * @param string $employerPostalCity
     * @param string $employerPostalAddress4
     * @param string $employerPostalCode
     * @param string $employerGroup
     * @param string $employerEmail
     * @param string $employerTelephone
     * @param string $employerPayrollNumber
     * @param string $employerPaymentArea
     * @param string $employerEmploymentDate
     * @param string $bankName
     * @param string $bankBranchName
     * @param string $bankBranchCode
     * @param string $bankAccNumber
     * @param string $bankAccHolderName
     * @param string $bankAccHolderSurname
     * @param string $bankAccType
     * @param string $bankDepositName
     * @param string $bankDepositBranchName
     * @param string $bankDepositBranchCode
     * @param string $bankDepositAccNumber
     * @param string $bankDepositAccHolderName
     * @param string $bankDepositAccHolderSurname
     * @param string $bankDepositAccType
     * @param string $benefitOption
     * @param string $savingsOption
     * @param string $networkOption
     * @param string $monthlyIncomeApplicant
     * @param string $monthlyIncomeSpouse
     * @param string $occupationApplicant
     * @param string $occupationSpouse
     * @param string $referenceNumber
     * @param string $maritalStatus
     * @param string $marriageDate
     * @param string $acceptedMembership
     * @param string $brokerHouseName
     * @param string $brokerHouseNumber
     * @param string $brokerName
     * @param string $brokerCode
     * @param string $brokerCell
     * @param string $brokerTelCode
     * @param string $brokerTelNumber
     * @param string $brokerEmailAddress
     * @param string $guardianCuratorIdNumber
     * @param string $guardianCuratorPassport
     * @param string $guardianCuratorTitle
     * @param string $guardianCuratorInits
     * @param string $guardianCuratorFullName
     * @param string $guardianCuratorSurname
     * @param string $guardianCuratorCell
     * @param string $guardianCuratorTelCode
     * @param string $guardianCuratorTelNumber
     * @param string $guardianCuratorFaxCode
     * @param string $guardianCuratorFaxNumber
     * @param string $guardianCuratorEmailAddress
     * @param string $thirdPartyTitle
     * @param string $thirdPartyInits
     * @param string $thirdPartySurname
     * @param string $thirdPartyRelationship
     * @param string $thirdPartyId
     * @param string $thirdPartyPassport
     * @param string $thirdPartyCountry
     * @param string $thirdPartyDialCode
     * @param string $thirdPartyPhoneNr
     * @param string $thirdPartyCellCode
     * @param string $thirdPartyCellNr
     * @param string $thirdPartyEmail
     * @param string $thirdPartyAuthOption
     * @param string $thirdPartyDocRecvdDate
     * @param string $thirdPartyAuthType
     * @param string $thirdPartyAuthSignature
     * @param string $thirdPartyAuthProofId
     * @param string $thirdPartyPoaSignature
     * @param string $thirdPartyPoaProofId
     * @param string $leadNumber
     * @param string $deductionDateInd
     * @param bool $visuallyImpaired
     * @param bool $hearingImpaired
     * @param bool $personalInfo
     * @param string $applicationType
     * @param string $applicClass
     * @param string $receiptType
     * @param string $applicationVersion
     * @param string $bankAccSignature
     * @param string $previousSchmMainMember
     * @param string $previousSchmCancellation
     * @param string $adviserSignature
     * @param string $applicantSignature
     * @param string $guardianCountry
     * @param string $mbrRace
     * @param string $password
     * @param string $userid
     * @param \ArrayType\ArrayOfMbrPrevMedicalScheme $mbrPrevMedicalSchemes
     * @param \ArrayType\ArrayOfDependant $dependants
     * @param \ArrayType\ArrayOfLateJoinerPenalty $lateJoinerPenaltys
     * @param \ArrayType\ArrayOfWaitingPeriod $waitingPeriods
     * @param \ArrayType\ArrayOfMedicalQuestionaire $medicalQuestionaires
     * @param \ArrayType\ArrayOfMedicalHistoryQuestionaire $medicalHistoryQuestionaires
     * @param \ArrayType\ArrayOfHealthCareProvider $healthCareProviders
     */
    public function __construct($scheme = null, $idNumber = null, $passportNumber = null, $country = null, $language = null, $title = null, $initials = null, $surname = null, $firstname = null, $nickname = null, $dateOfBirth = null, $gender = null, $incomeTaxNumber = null, $cellphone = null, $telephone = null, $workphone = null, $faxNumber = null, $dateApplied = null, $postStreet = null, $postSuburb = null, $postCity = null, $postAddress4 = null, $postCode = null, $residentialStreet = null, $residentialSuburb = null, $residentialCity = null, $residentialAddress4 = null, $residentialCode = null, $email = null, $employerCompanyName = null, $employerTitle = null, $employerContactName = null, $employerContactSurname = null, $employerPostalStreet = null, $employerPostalSuburb = null, $employerPostalCity = null, $employerPostalAddress4 = null, $employerPostalCode = null, $employerGroup = null, $employerEmail = null, $employerTelephone = null, $employerPayrollNumber = null, $employerPaymentArea = null, $employerEmploymentDate = null, $bankName = null, $bankBranchName = null, $bankBranchCode = null, $bankAccNumber = null, $bankAccHolderName = null, $bankAccHolderSurname = null, $bankAccType = null, $bankDepositName = null, $bankDepositBranchName = null, $bankDepositBranchCode = null, $bankDepositAccNumber = null, $bankDepositAccHolderName = null, $bankDepositAccHolderSurname = null, $bankDepositAccType = null, $benefitOption = null, $savingsOption = null, $networkOption = null, $monthlyIncomeApplicant = null, $monthlyIncomeSpouse = null, $occupationApplicant = null, $occupationSpouse = null, $referenceNumber = null, $maritalStatus = null, $marriageDate = null, $acceptedMembership = null, $brokerHouseName = null, $brokerHouseNumber = null, $brokerName = null, $brokerCode = null, $brokerCell = null, $brokerTelCode = null, $brokerTelNumber = null, $brokerEmailAddress = null, $guardianCuratorIdNumber = null, $guardianCuratorPassport = null, $guardianCuratorTitle = null, $guardianCuratorInits = null, $guardianCuratorFullName = null, $guardianCuratorSurname = null, $guardianCuratorCell = null, $guardianCuratorTelCode = null, $guardianCuratorTelNumber = null, $guardianCuratorFaxCode = null, $guardianCuratorFaxNumber = null, $guardianCuratorEmailAddress = null, $thirdPartyTitle = null, $thirdPartyInits = null, $thirdPartySurname = null, $thirdPartyRelationship = null, $thirdPartyId = null, $thirdPartyPassport = null, $thirdPartyCountry = null, $thirdPartyDialCode = null, $thirdPartyPhoneNr = null, $thirdPartyCellCode = null, $thirdPartyCellNr = null, $thirdPartyEmail = null, $thirdPartyAuthOption = null, $thirdPartyDocRecvdDate = null, $thirdPartyAuthType = null, $thirdPartyAuthSignature = null, $thirdPartyAuthProofId = null, $thirdPartyPoaSignature = null, $thirdPartyPoaProofId = null, $leadNumber = null, $deductionDateInd = null, $visuallyImpaired = null, $hearingImpaired = null, $personalInfo = null, $applicationType = null, $applicClass = null, $receiptType = null, $applicationVersion = null, $bankAccSignature = null, $previousSchmMainMember = null, $previousSchmCancellation = null, $adviserSignature = null, $applicantSignature = null, $guardianCountry = null, $mbrRace = null, $password = null, $userid = null, \ArrayType\ArrayOfMbrPrevMedicalScheme $mbrPrevMedicalSchemes = null, \ArrayType\ArrayOfDependant $dependants = null, \ArrayType\ArrayOfLateJoinerPenalty $lateJoinerPenaltys = null, \ArrayType\ArrayOfWaitingPeriod $waitingPeriods = null, \ArrayType\ArrayOfMedicalQuestionaire $medicalQuestionaires = null, \ArrayType\ArrayOfMedicalHistoryQuestionaire $medicalHistoryQuestionaires = null, \ArrayType\ArrayOfHealthCareProvider $healthCareProviders = null)
    {
        $this
            ->setScheme($scheme)
            ->setIdNumber($idNumber)
            ->setPassportNumber($passportNumber)
            ->setCountry($country)
            ->setLanguage($language)
            ->setTitle($title)
            ->setInitials($initials)
            ->setSurname($surname)
            ->setFirstname($firstname)
            ->setNickname($nickname)
            ->setDateOfBirth($dateOfBirth)
            ->setGender($gender)
            ->setIncomeTaxNumber($incomeTaxNumber)
            ->setCellphone($cellphone)
            ->setTelephone($telephone)
            ->setWorkphone($workphone)
            ->setFaxNumber($faxNumber)
            ->setDateApplied($dateApplied)
            ->setPostStreet($postStreet)
            ->setPostSuburb($postSuburb)
            ->setPostCity($postCity)
            ->setPostAddress4($postAddress4)
            ->setPostCode($postCode)
            ->setResidentialStreet($residentialStreet)
            ->setResidentialSuburb($residentialSuburb)
            ->setResidentialCity($residentialCity)
            ->setResidentialAddress4($residentialAddress4)
            ->setResidentialCode($residentialCode)
            ->setEmail($email)
            ->setEmployerCompanyName($employerCompanyName)
            ->setEmployerTitle($employerTitle)
            ->setEmployerContactName($employerContactName)
            ->setEmployerContactSurname($employerContactSurname)
            ->setEmployerPostalStreet($employerPostalStreet)
            ->setEmployerPostalSuburb($employerPostalSuburb)
            ->setEmployerPostalCity($employerPostalCity)
            ->setEmployerPostalAddress4($employerPostalAddress4)
            ->setEmployerPostalCode($employerPostalCode)
            ->setEmployerGroup($employerGroup)
            ->setEmployerEmail($employerEmail)
            ->setEmployerTelephone($employerTelephone)
            ->setEmployerPayrollNumber($employerPayrollNumber)
            ->setEmployerPaymentArea($employerPaymentArea)
            ->setEmployerEmploymentDate($employerEmploymentDate)
            ->setBankName($bankName)
            ->setBankBranchName($bankBranchName)
            ->setBankBranchCode($bankBranchCode)
            ->setBankAccNumber($bankAccNumber)
            ->setBankAccHolderName($bankAccHolderName)
            ->setBankAccHolderSurname($bankAccHolderSurname)
            ->setBankAccType($bankAccType)
            ->setBankDepositName($bankDepositName)
            ->setBankDepositBranchName($bankDepositBranchName)
            ->setBankDepositBranchCode($bankDepositBranchCode)
            ->setBankDepositAccNumber($bankDepositAccNumber)
            ->setBankDepositAccHolderName($bankDepositAccHolderName)
            ->setBankDepositAccHolderSurname($bankDepositAccHolderSurname)
            ->setBankDepositAccType($bankDepositAccType)
            ->setBenefitOption($benefitOption)
            ->setSavingsOption($savingsOption)
            ->setNetworkOption($networkOption)
            ->setMonthlyIncomeApplicant($monthlyIncomeApplicant)
            ->setMonthlyIncomeSpouse($monthlyIncomeSpouse)
            ->setOccupationApplicant($occupationApplicant)
            ->setOccupationSpouse($occupationSpouse)
            ->setReferenceNumber($referenceNumber)
            ->setMaritalStatus($maritalStatus)
            ->setMarriageDate($marriageDate)
            ->setAcceptedMembership($acceptedMembership)
            ->setBrokerHouseName($brokerHouseName)
            ->setBrokerHouseNumber($brokerHouseNumber)
            ->setBrokerName($brokerName)
            ->setBrokerCode($brokerCode)
            ->setBrokerCell($brokerCell)
            ->setBrokerTelCode($brokerTelCode)
            ->setBrokerTelNumber($brokerTelNumber)
            ->setBrokerEmailAddress($brokerEmailAddress)
            ->setGuardianCuratorIdNumber($guardianCuratorIdNumber)
            ->setGuardianCuratorPassport($guardianCuratorPassport)
            ->setGuardianCuratorTitle($guardianCuratorTitle)
            ->setGuardianCuratorInits($guardianCuratorInits)
            ->setGuardianCuratorFullName($guardianCuratorFullName)
            ->setGuardianCuratorSurname($guardianCuratorSurname)
            ->setGuardianCuratorCell($guardianCuratorCell)
            ->setGuardianCuratorTelCode($guardianCuratorTelCode)
            ->setGuardianCuratorTelNumber($guardianCuratorTelNumber)
            ->setGuardianCuratorFaxCode($guardianCuratorFaxCode)
            ->setGuardianCuratorFaxNumber($guardianCuratorFaxNumber)
            ->setGuardianCuratorEmailAddress($guardianCuratorEmailAddress)
            ->setThirdPartyTitle($thirdPartyTitle)
            ->setThirdPartyInits($thirdPartyInits)
            ->setThirdPartySurname($thirdPartySurname)
            ->setThirdPartyRelationship($thirdPartyRelationship)
            ->setThirdPartyId($thirdPartyId)
            ->setThirdPartyPassport($thirdPartyPassport)
            ->setThirdPartyCountry($thirdPartyCountry)
            ->setThirdPartyDialCode($thirdPartyDialCode)
            ->setThirdPartyPhoneNr($thirdPartyPhoneNr)
            ->setThirdPartyCellCode($thirdPartyCellCode)
            ->setThirdPartyCellNr($thirdPartyCellNr)
            ->setThirdPartyEmail($thirdPartyEmail)
            ->setThirdPartyAuthOption($thirdPartyAuthOption)
            ->setThirdPartyDocRecvdDate($thirdPartyDocRecvdDate)
            ->setThirdPartyAuthType($thirdPartyAuthType)
            ->setThirdPartyAuthSignature($thirdPartyAuthSignature)
            ->setThirdPartyAuthProofId($thirdPartyAuthProofId)
            ->setThirdPartyPoaSignature($thirdPartyPoaSignature)
            ->setThirdPartyPoaProofId($thirdPartyPoaProofId)
            ->setLeadNumber($leadNumber)
            ->setDeductionDateInd($deductionDateInd)
            ->setVisuallyImpaired($visuallyImpaired)
            ->setHearingImpaired($hearingImpaired)
            ->setPersonalInfo($personalInfo)
            ->setApplicationType($applicationType)
            ->setApplicClass($applicClass)
            ->setReceiptType($receiptType)
            ->setApplicationVersion($applicationVersion)
            ->setBankAccSignature($bankAccSignature)
            ->setPreviousSchmMainMember($previousSchmMainMember)
            ->setPreviousSchmCancellation($previousSchmCancellation)
            ->setAdviserSignature($adviserSignature)
            ->setApplicantSignature($applicantSignature)
            ->setGuardianCountry($guardianCountry)
            ->setMbrRace($mbrRace)
            ->setPassword($password)
            ->setUserid($userid)
            ->setMbrPrevMedicalSchemes($mbrPrevMedicalSchemes)
            ->setDependants($dependants)
            ->setLateJoinerPenaltys($lateJoinerPenaltys)
            ->setWaitingPeriods($waitingPeriods)
            ->setMedicalQuestionaires($medicalQuestionaires)
            ->setMedicalHistoryQuestionaires($medicalHistoryQuestionaires)
            ->setHealthCareProviders($healthCareProviders);
    }
    /**
     * Get Scheme value
     * @return string|null
     */
    public function getScheme()
    {
        return $this->Scheme;
    }
    /**
     * Set Scheme value
     * @param string $scheme
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setScheme($scheme = null)
    {
        // validation for constraint: string
        if (!is_null($scheme) && !is_string($scheme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheme, true), gettype($scheme)), __LINE__);
        }
        $this->Scheme = $scheme;
        return $this;
    }
    /**
     * Get IdNumber value
     * @return string|null
     */
    public function getIdNumber()
    {
        return $this->IdNumber;
    }
    /**
     * Set IdNumber value
     * @param string $idNumber
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setIdNumber($idNumber = null)
    {
        // validation for constraint: string
        if (!is_null($idNumber) && !is_string($idNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idNumber, true), gettype($idNumber)), __LINE__);
        }
        $this->IdNumber = $idNumber;
        return $this;
    }
    /**
     * Get PassportNumber value
     * @return string|null
     */
    public function getPassportNumber()
    {
        return $this->PassportNumber;
    }
    /**
     * Set PassportNumber value
     * @param string $passportNumber
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setPassportNumber($passportNumber = null)
    {
        // validation for constraint: string
        if (!is_null($passportNumber) && !is_string($passportNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passportNumber, true), gettype($passportNumber)), __LINE__);
        }
        $this->PassportNumber = $passportNumber;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Initials value
     * @return string|null
     */
    public function getInitials()
    {
        return $this->Initials;
    }
    /**
     * Set Initials value
     * @param string $initials
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setInitials($initials = null)
    {
        // validation for constraint: string
        if (!is_null($initials) && !is_string($initials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initials, true), gettype($initials)), __LINE__);
        }
        $this->Initials = $initials;
        return $this;
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get Firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->Firstname;
    }
    /**
     * Set Firstname value
     * @param string $firstname
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstname, true), gettype($firstname)), __LINE__);
        }
        $this->Firstname = $firstname;
        return $this;
    }
    /**
     * Get Nickname value
     * @return string|null
     */
    public function getNickname()
    {
        return $this->Nickname;
    }
    /**
     * Set Nickname value
     * @param string $nickname
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setNickname($nickname = null)
    {
        // validation for constraint: string
        if (!is_null($nickname) && !is_string($nickname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nickname, true), gettype($nickname)), __LINE__);
        }
        $this->Nickname = $nickname;
        return $this;
    }
    /**
     * Get DateOfBirth value
     * @return string|null
     */
    public function getDateOfBirth()
    {
        return $this->DateOfBirth;
    }
    /**
     * Set DateOfBirth value
     * @param string $dateOfBirth
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfBirth) && !is_string($dateOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfBirth, true), gettype($dateOfBirth)), __LINE__);
        }
        $this->DateOfBirth = $dateOfBirth;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gender, true), gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get IncomeTaxNumber value
     * @return string|null
     */
    public function getIncomeTaxNumber()
    {
        return $this->IncomeTaxNumber;
    }
    /**
     * Set IncomeTaxNumber value
     * @param string $incomeTaxNumber
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setIncomeTaxNumber($incomeTaxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($incomeTaxNumber) && !is_string($incomeTaxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($incomeTaxNumber, true), gettype($incomeTaxNumber)), __LINE__);
        }
        $this->IncomeTaxNumber = $incomeTaxNumber;
        return $this;
    }
    /**
     * Get Cellphone value
     * @return string|null
     */
    public function getCellphone()
    {
        return $this->Cellphone;
    }
    /**
     * Set Cellphone value
     * @param string $cellphone
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setCellphone($cellphone = null)
    {
        // validation for constraint: string
        if (!is_null($cellphone) && !is_string($cellphone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cellphone, true), gettype($cellphone)), __LINE__);
        }
        $this->Cellphone = $cellphone;
        return $this;
    }
    /**
     * Get Telephone value
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param string $telephone
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setTelephone($telephone = null)
    {
        // validation for constraint: string
        if (!is_null($telephone) && !is_string($telephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telephone, true), gettype($telephone)), __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get Workphone value
     * @return string|null
     */
    public function getWorkphone()
    {
        return $this->Workphone;
    }
    /**
     * Set Workphone value
     * @param string $workphone
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setWorkphone($workphone = null)
    {
        // validation for constraint: string
        if (!is_null($workphone) && !is_string($workphone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workphone, true), gettype($workphone)), __LINE__);
        }
        $this->Workphone = $workphone;
        return $this;
    }
    /**
     * Get FaxNumber value
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->FaxNumber;
    }
    /**
     * Set FaxNumber value
     * @param string $faxNumber
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setFaxNumber($faxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($faxNumber) && !is_string($faxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faxNumber, true), gettype($faxNumber)), __LINE__);
        }
        $this->FaxNumber = $faxNumber;
        return $this;
    }
    /**
     * Get DateApplied value
     * @return string|null
     */
    public function getDateApplied()
    {
        return $this->DateApplied;
    }
    /**
     * Set DateApplied value
     * @param string $dateApplied
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setDateApplied($dateApplied = null)
    {
        // validation for constraint: string
        if (!is_null($dateApplied) && !is_string($dateApplied)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateApplied, true), gettype($dateApplied)), __LINE__);
        }
        $this->DateApplied = $dateApplied;
        return $this;
    }
    /**
     * Get PostStreet value
     * @return string|null
     */
    public function getPostStreet()
    {
        return $this->PostStreet;
    }
    /**
     * Set PostStreet value
     * @param string $postStreet
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setPostStreet($postStreet = null)
    {
        // validation for constraint: string
        if (!is_null($postStreet) && !is_string($postStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postStreet, true), gettype($postStreet)), __LINE__);
        }
        $this->PostStreet = $postStreet;
        return $this;
    }
    /**
     * Get PostSuburb value
     * @return string|null
     */
    public function getPostSuburb()
    {
        return $this->PostSuburb;
    }
    /**
     * Set PostSuburb value
     * @param string $postSuburb
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setPostSuburb($postSuburb = null)
    {
        // validation for constraint: string
        if (!is_null($postSuburb) && !is_string($postSuburb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postSuburb, true), gettype($postSuburb)), __LINE__);
        }
        $this->PostSuburb = $postSuburb;
        return $this;
    }
    /**
     * Get PostCity value
     * @return string|null
     */
    public function getPostCity()
    {
        return $this->PostCity;
    }
    /**
     * Set PostCity value
     * @param string $postCity
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setPostCity($postCity = null)
    {
        // validation for constraint: string
        if (!is_null($postCity) && !is_string($postCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postCity, true), gettype($postCity)), __LINE__);
        }
        $this->PostCity = $postCity;
        return $this;
    }
    /**
     * Get PostAddress4 value
     * @return string|null
     */
    public function getPostAddress4()
    {
        return $this->PostAddress4;
    }
    /**
     * Set PostAddress4 value
     * @param string $postAddress4
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setPostAddress4($postAddress4 = null)
    {
        // validation for constraint: string
        if (!is_null($postAddress4) && !is_string($postAddress4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postAddress4, true), gettype($postAddress4)), __LINE__);
        }
        $this->PostAddress4 = $postAddress4;
        return $this;
    }
    /**
     * Get PostCode value
     * @return string|null
     */
    public function getPostCode()
    {
        return $this->PostCode;
    }
    /**
     * Set PostCode value
     * @param string $postCode
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postCode, true), gettype($postCode)), __LINE__);
        }
        $this->PostCode = $postCode;
        return $this;
    }
    /**
     * Get ResidentialStreet value
     * @return string|null
     */
    public function getResidentialStreet()
    {
        return $this->ResidentialStreet;
    }
    /**
     * Set ResidentialStreet value
     * @param string $residentialStreet
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setResidentialStreet($residentialStreet = null)
    {
        // validation for constraint: string
        if (!is_null($residentialStreet) && !is_string($residentialStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residentialStreet, true), gettype($residentialStreet)), __LINE__);
        }
        $this->ResidentialStreet = $residentialStreet;
        return $this;
    }
    /**
     * Get ResidentialSuburb value
     * @return string|null
     */
    public function getResidentialSuburb()
    {
        return $this->ResidentialSuburb;
    }
    /**
     * Set ResidentialSuburb value
     * @param string $residentialSuburb
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setResidentialSuburb($residentialSuburb = null)
    {
        // validation for constraint: string
        if (!is_null($residentialSuburb) && !is_string($residentialSuburb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residentialSuburb, true), gettype($residentialSuburb)), __LINE__);
        }
        $this->ResidentialSuburb = $residentialSuburb;
        return $this;
    }
    /**
     * Get ResidentialCity value
     * @return string|null
     */
    public function getResidentialCity()
    {
        return $this->ResidentialCity;
    }
    /**
     * Set ResidentialCity value
     * @param string $residentialCity
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setResidentialCity($residentialCity = null)
    {
        // validation for constraint: string
        if (!is_null($residentialCity) && !is_string($residentialCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residentialCity, true), gettype($residentialCity)), __LINE__);
        }
        $this->ResidentialCity = $residentialCity;
        return $this;
    }
    /**
     * Get ResidentialAddress4 value
     * @return string|null
     */
    public function getResidentialAddress4()
    {
        return $this->ResidentialAddress4;
    }
    /**
     * Set ResidentialAddress4 value
     * @param string $residentialAddress4
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setResidentialAddress4($residentialAddress4 = null)
    {
        // validation for constraint: string
        if (!is_null($residentialAddress4) && !is_string($residentialAddress4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residentialAddress4, true), gettype($residentialAddress4)), __LINE__);
        }
        $this->ResidentialAddress4 = $residentialAddress4;
        return $this;
    }
    /**
     * Get ResidentialCode value
     * @return string|null
     */
    public function getResidentialCode()
    {
        return $this->ResidentialCode;
    }
    /**
     * Set ResidentialCode value
     * @param string $residentialCode
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setResidentialCode($residentialCode = null)
    {
        // validation for constraint: string
        if (!is_null($residentialCode) && !is_string($residentialCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residentialCode, true), gettype($residentialCode)), __LINE__);
        }
        $this->ResidentialCode = $residentialCode;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get EmployerCompanyName value
     * @return string|null
     */
    public function getEmployerCompanyName()
    {
        return $this->EmployerCompanyName;
    }
    /**
     * Set EmployerCompanyName value
     * @param string $employerCompanyName
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setEmployerCompanyName($employerCompanyName = null)
    {
        // validation for constraint: string
        if (!is_null($employerCompanyName) && !is_string($employerCompanyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employerCompanyName, true), gettype($employerCompanyName)), __LINE__);
        }
        $this->EmployerCompanyName = $employerCompanyName;
        return $this;
    }
    /**
     * Get EmployerTitle value
     * @return string|null
     */
    public function getEmployerTitle()
    {
        return $this->EmployerTitle;
    }
    /**
     * Set EmployerTitle value
     * @param string $employerTitle
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setEmployerTitle($employerTitle = null)
    {
        // validation for constraint: string
        if (!is_null($employerTitle) && !is_string($employerTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employerTitle, true), gettype($employerTitle)), __LINE__);
        }
        $this->EmployerTitle = $employerTitle;
        return $this;
    }
    /**
     * Get EmployerContactName value
     * @return string|null
     */
    public function getEmployerContactName()
    {
        return $this->EmployerContactName;
    }
    /**
     * Set EmployerContactName value
     * @param string $employerContactName
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setEmployerContactName($employerContactName = null)
    {
        // validation for constraint: string
        if (!is_null($employerContactName) && !is_string($employerContactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employerContactName, true), gettype($employerContactName)), __LINE__);
        }
        $this->EmployerContactName = $employerContactName;
        return $this;
    }
    /**
     * Get EmployerContactSurname value
     * @return string|null
     */
    public function getEmployerContactSurname()
    {
        return $this->EmployerContactSurname;
    }
    /**
     * Set EmployerContactSurname value
     * @param string $employerContactSurname
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setEmployerContactSurname($employerContactSurname = null)
    {
        // validation for constraint: string
        if (!is_null($employerContactSurname) && !is_string($employerContactSurname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employerContactSurname, true), gettype($employerContactSurname)), __LINE__);
        }
        $this->EmployerContactSurname = $employerContactSurname;
        return $this;
    }
    /**
     * Get EmployerPostalStreet value
     * @return string|null
     */
    public function getEmployerPostalStreet()
    {
        return $this->EmployerPostalStreet;
    }
    /**
     * Set EmployerPostalStreet value
     * @param string $employerPostalStreet
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setEmployerPostalStreet($employerPostalStreet = null)
    {
        // validation for constraint: string
        if (!is_null($employerPostalStreet) && !is_string($employerPostalStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employerPostalStreet, true), gettype($employerPostalStreet)), __LINE__);
        }
        $this->EmployerPostalStreet = $employerPostalStreet;
        return $this;
    }
    /**
     * Get EmployerPostalSuburb value
     * @return string|null
     */
    public function getEmployerPostalSuburb()
    {
        return $this->EmployerPostalSuburb;
    }
    /**
     * Set EmployerPostalSuburb value
     * @param string $employerPostalSuburb
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setEmployerPostalSuburb($employerPostalSuburb = null)
    {
        // validation for constraint: string
        if (!is_null($employerPostalSuburb) && !is_string($employerPostalSuburb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employerPostalSuburb, true), gettype($employerPostalSuburb)), __LINE__);
        }
        $this->EmployerPostalSuburb = $employerPostalSuburb;
        return $this;
    }
    /**
     * Get EmployerPostalCity value
     * @return string|null
     */
    public function getEmployerPostalCity()
    {
        return $this->EmployerPostalCity;
    }
    /**
     * Set EmployerPostalCity value
     * @param string $employerPostalCity
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setEmployerPostalCity($employerPostalCity = null)
    {
        // validation for constraint: string
        if (!is_null($employerPostalCity) && !is_string($employerPostalCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employerPostalCity, true), gettype($employerPostalCity)), __LINE__);
        }
        $this->EmployerPostalCity = $employerPostalCity;
        return $this;
    }
    /**
     * Get EmployerPostalAddress4 value
     * @return string|null
     */
    public function getEmployerPostalAddress4()
    {
        return $this->EmployerPostalAddress4;
    }
    /**
     * Set EmployerPostalAddress4 value
     * @param string $employerPostalAddress4
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setEmployerPostalAddress4($employerPostalAddress4 = null)
    {
        // validation for constraint: string
        if (!is_null($employerPostalAddress4) && !is_string($employerPostalAddress4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employerPostalAddress4, true), gettype($employerPostalAddress4)), __LINE__);
        }
        $this->EmployerPostalAddress4 = $employerPostalAddress4;
        return $this;
    }
    /**
     * Get EmployerPostalCode value
     * @return string|null
     */
    public function getEmployerPostalCode()
    {
        return $this->EmployerPostalCode;
    }
    /**
     * Set EmployerPostalCode value
     * @param string $employerPostalCode
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setEmployerPostalCode($employerPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($employerPostalCode) && !is_string($employerPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employerPostalCode, true), gettype($employerPostalCode)), __LINE__);
        }
        $this->EmployerPostalCode = $employerPostalCode;
        return $this;
    }
    /**
     * Get EmployerGroup value
     * @return string|null
     */
    public function getEmployerGroup()
    {
        return $this->EmployerGroup;
    }
    /**
     * Set EmployerGroup value
     * @param string $employerGroup
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setEmployerGroup($employerGroup = null)
    {
        // validation for constraint: string
        if (!is_null($employerGroup) && !is_string($employerGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employerGroup, true), gettype($employerGroup)), __LINE__);
        }
        $this->EmployerGroup = $employerGroup;
        return $this;
    }
    /**
     * Get EmployerEmail value
     * @return string|null
     */
    public function getEmployerEmail()
    {
        return $this->EmployerEmail;
    }
    /**
     * Set EmployerEmail value
     * @param string $employerEmail
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setEmployerEmail($employerEmail = null)
    {
        // validation for constraint: string
        if (!is_null($employerEmail) && !is_string($employerEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employerEmail, true), gettype($employerEmail)), __LINE__);
        }
        $this->EmployerEmail = $employerEmail;
        return $this;
    }
    /**
     * Get EmployerTelephone value
     * @return string|null
     */
    public function getEmployerTelephone()
    {
        return $this->EmployerTelephone;
    }
    /**
     * Set EmployerTelephone value
     * @param string $employerTelephone
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setEmployerTelephone($employerTelephone = null)
    {
        // validation for constraint: string
        if (!is_null($employerTelephone) && !is_string($employerTelephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employerTelephone, true), gettype($employerTelephone)), __LINE__);
        }
        $this->EmployerTelephone = $employerTelephone;
        return $this;
    }
    /**
     * Get EmployerPayrollNumber value
     * @return string|null
     */
    public function getEmployerPayrollNumber()
    {
        return $this->EmployerPayrollNumber;
    }
    /**
     * Set EmployerPayrollNumber value
     * @param string $employerPayrollNumber
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setEmployerPayrollNumber($employerPayrollNumber = null)
    {
        // validation for constraint: string
        if (!is_null($employerPayrollNumber) && !is_string($employerPayrollNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employerPayrollNumber, true), gettype($employerPayrollNumber)), __LINE__);
        }
        $this->EmployerPayrollNumber = $employerPayrollNumber;
        return $this;
    }
    /**
     * Get EmployerPaymentArea value
     * @return string|null
     */
    public function getEmployerPaymentArea()
    {
        return $this->EmployerPaymentArea;
    }
    /**
     * Set EmployerPaymentArea value
     * @param string $employerPaymentArea
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setEmployerPaymentArea($employerPaymentArea = null)
    {
        // validation for constraint: string
        if (!is_null($employerPaymentArea) && !is_string($employerPaymentArea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employerPaymentArea, true), gettype($employerPaymentArea)), __LINE__);
        }
        $this->EmployerPaymentArea = $employerPaymentArea;
        return $this;
    }
    /**
     * Get EmployerEmploymentDate value
     * @return string|null
     */
    public function getEmployerEmploymentDate()
    {
        return $this->EmployerEmploymentDate;
    }
    /**
     * Set EmployerEmploymentDate value
     * @param string $employerEmploymentDate
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setEmployerEmploymentDate($employerEmploymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($employerEmploymentDate) && !is_string($employerEmploymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employerEmploymentDate, true), gettype($employerEmploymentDate)), __LINE__);
        }
        $this->EmployerEmploymentDate = $employerEmploymentDate;
        return $this;
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankName, true), gettype($bankName)), __LINE__);
        }
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Get BankBranchName value
     * @return string|null
     */
    public function getBankBranchName()
    {
        return $this->BankBranchName;
    }
    /**
     * Set BankBranchName value
     * @param string $bankBranchName
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBankBranchName($bankBranchName = null)
    {
        // validation for constraint: string
        if (!is_null($bankBranchName) && !is_string($bankBranchName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankBranchName, true), gettype($bankBranchName)), __LINE__);
        }
        $this->BankBranchName = $bankBranchName;
        return $this;
    }
    /**
     * Get BankBranchCode value
     * @return string|null
     */
    public function getBankBranchCode()
    {
        return $this->BankBranchCode;
    }
    /**
     * Set BankBranchCode value
     * @param string $bankBranchCode
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBankBranchCode($bankBranchCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankBranchCode) && !is_string($bankBranchCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankBranchCode, true), gettype($bankBranchCode)), __LINE__);
        }
        $this->BankBranchCode = $bankBranchCode;
        return $this;
    }
    /**
     * Get BankAccNumber value
     * @return string|null
     */
    public function getBankAccNumber()
    {
        return $this->BankAccNumber;
    }
    /**
     * Set BankAccNumber value
     * @param string $bankAccNumber
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBankAccNumber($bankAccNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccNumber) && !is_string($bankAccNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAccNumber, true), gettype($bankAccNumber)), __LINE__);
        }
        $this->BankAccNumber = $bankAccNumber;
        return $this;
    }
    /**
     * Get BankAccHolderName value
     * @return string|null
     */
    public function getBankAccHolderName()
    {
        return $this->BankAccHolderName;
    }
    /**
     * Set BankAccHolderName value
     * @param string $bankAccHolderName
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBankAccHolderName($bankAccHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccHolderName) && !is_string($bankAccHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAccHolderName, true), gettype($bankAccHolderName)), __LINE__);
        }
        $this->BankAccHolderName = $bankAccHolderName;
        return $this;
    }
    /**
     * Get BankAccHolderSurname value
     * @return string|null
     */
    public function getBankAccHolderSurname()
    {
        return $this->BankAccHolderSurname;
    }
    /**
     * Set BankAccHolderSurname value
     * @param string $bankAccHolderSurname
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBankAccHolderSurname($bankAccHolderSurname = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccHolderSurname) && !is_string($bankAccHolderSurname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAccHolderSurname, true), gettype($bankAccHolderSurname)), __LINE__);
        }
        $this->BankAccHolderSurname = $bankAccHolderSurname;
        return $this;
    }
    /**
     * Get BankAccType value
     * @return string|null
     */
    public function getBankAccType()
    {
        return $this->BankAccType;
    }
    /**
     * Set BankAccType value
     * @param string $bankAccType
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBankAccType($bankAccType = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccType) && !is_string($bankAccType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAccType, true), gettype($bankAccType)), __LINE__);
        }
        $this->BankAccType = $bankAccType;
        return $this;
    }
    /**
     * Get BankDepositName value
     * @return string|null
     */
    public function getBankDepositName()
    {
        return $this->BankDepositName;
    }
    /**
     * Set BankDepositName value
     * @param string $bankDepositName
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBankDepositName($bankDepositName = null)
    {
        // validation for constraint: string
        if (!is_null($bankDepositName) && !is_string($bankDepositName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankDepositName, true), gettype($bankDepositName)), __LINE__);
        }
        $this->BankDepositName = $bankDepositName;
        return $this;
    }
    /**
     * Get BankDepositBranchName value
     * @return string|null
     */
    public function getBankDepositBranchName()
    {
        return $this->BankDepositBranchName;
    }
    /**
     * Set BankDepositBranchName value
     * @param string $bankDepositBranchName
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBankDepositBranchName($bankDepositBranchName = null)
    {
        // validation for constraint: string
        if (!is_null($bankDepositBranchName) && !is_string($bankDepositBranchName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankDepositBranchName, true), gettype($bankDepositBranchName)), __LINE__);
        }
        $this->BankDepositBranchName = $bankDepositBranchName;
        return $this;
    }
    /**
     * Get BankDepositBranchCode value
     * @return string|null
     */
    public function getBankDepositBranchCode()
    {
        return $this->BankDepositBranchCode;
    }
    /**
     * Set BankDepositBranchCode value
     * @param string $bankDepositBranchCode
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBankDepositBranchCode($bankDepositBranchCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankDepositBranchCode) && !is_string($bankDepositBranchCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankDepositBranchCode, true), gettype($bankDepositBranchCode)), __LINE__);
        }
        $this->BankDepositBranchCode = $bankDepositBranchCode;
        return $this;
    }
    /**
     * Get BankDepositAccNumber value
     * @return string|null
     */
    public function getBankDepositAccNumber()
    {
        return $this->BankDepositAccNumber;
    }
    /**
     * Set BankDepositAccNumber value
     * @param string $bankDepositAccNumber
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBankDepositAccNumber($bankDepositAccNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankDepositAccNumber) && !is_string($bankDepositAccNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankDepositAccNumber, true), gettype($bankDepositAccNumber)), __LINE__);
        }
        $this->BankDepositAccNumber = $bankDepositAccNumber;
        return $this;
    }
    /**
     * Get BankDepositAccHolderName value
     * @return string|null
     */
    public function getBankDepositAccHolderName()
    {
        return $this->BankDepositAccHolderName;
    }
    /**
     * Set BankDepositAccHolderName value
     * @param string $bankDepositAccHolderName
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBankDepositAccHolderName($bankDepositAccHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($bankDepositAccHolderName) && !is_string($bankDepositAccHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankDepositAccHolderName, true), gettype($bankDepositAccHolderName)), __LINE__);
        }
        $this->BankDepositAccHolderName = $bankDepositAccHolderName;
        return $this;
    }
    /**
     * Get BankDepositAccHolderSurname value
     * @return string|null
     */
    public function getBankDepositAccHolderSurname()
    {
        return $this->BankDepositAccHolderSurname;
    }
    /**
     * Set BankDepositAccHolderSurname value
     * @param string $bankDepositAccHolderSurname
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBankDepositAccHolderSurname($bankDepositAccHolderSurname = null)
    {
        // validation for constraint: string
        if (!is_null($bankDepositAccHolderSurname) && !is_string($bankDepositAccHolderSurname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankDepositAccHolderSurname, true), gettype($bankDepositAccHolderSurname)), __LINE__);
        }
        $this->BankDepositAccHolderSurname = $bankDepositAccHolderSurname;
        return $this;
    }
    /**
     * Get BankDepositAccType value
     * @return string|null
     */
    public function getBankDepositAccType()
    {
        return $this->BankDepositAccType;
    }
    /**
     * Set BankDepositAccType value
     * @param string $bankDepositAccType
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBankDepositAccType($bankDepositAccType = null)
    {
        // validation for constraint: string
        if (!is_null($bankDepositAccType) && !is_string($bankDepositAccType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankDepositAccType, true), gettype($bankDepositAccType)), __LINE__);
        }
        $this->BankDepositAccType = $bankDepositAccType;
        return $this;
    }
    /**
     * Get BenefitOption value
     * @return string|null
     */
    public function getBenefitOption()
    {
        return $this->BenefitOption;
    }
    /**
     * Set BenefitOption value
     * @param string $benefitOption
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBenefitOption($benefitOption = null)
    {
        // validation for constraint: string
        if (!is_null($benefitOption) && !is_string($benefitOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($benefitOption, true), gettype($benefitOption)), __LINE__);
        }
        $this->BenefitOption = $benefitOption;
        return $this;
    }
    /**
     * Get SavingsOption value
     * @return string|null
     */
    public function getSavingsOption()
    {
        return $this->SavingsOption;
    }
    /**
     * Set SavingsOption value
     * @param string $savingsOption
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setSavingsOption($savingsOption = null)
    {
        // validation for constraint: string
        if (!is_null($savingsOption) && !is_string($savingsOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($savingsOption, true), gettype($savingsOption)), __LINE__);
        }
        $this->SavingsOption = $savingsOption;
        return $this;
    }
    /**
     * Get NetworkOption value
     * @return string|null
     */
    public function getNetworkOption()
    {
        return $this->NetworkOption;
    }
    /**
     * Set NetworkOption value
     * @param string $networkOption
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setNetworkOption($networkOption = null)
    {
        // validation for constraint: string
        if (!is_null($networkOption) && !is_string($networkOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($networkOption, true), gettype($networkOption)), __LINE__);
        }
        $this->NetworkOption = $networkOption;
        return $this;
    }
    /**
     * Get MonthlyIncomeApplicant value
     * @return string|null
     */
    public function getMonthlyIncomeApplicant()
    {
        return $this->MonthlyIncomeApplicant;
    }
    /**
     * Set MonthlyIncomeApplicant value
     * @param string $monthlyIncomeApplicant
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setMonthlyIncomeApplicant($monthlyIncomeApplicant = null)
    {
        // validation for constraint: string
        if (!is_null($monthlyIncomeApplicant) && !is_string($monthlyIncomeApplicant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monthlyIncomeApplicant, true), gettype($monthlyIncomeApplicant)), __LINE__);
        }
        $this->MonthlyIncomeApplicant = $monthlyIncomeApplicant;
        return $this;
    }
    /**
     * Get MonthlyIncomeSpouse value
     * @return string|null
     */
    public function getMonthlyIncomeSpouse()
    {
        return $this->MonthlyIncomeSpouse;
    }
    /**
     * Set MonthlyIncomeSpouse value
     * @param string $monthlyIncomeSpouse
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setMonthlyIncomeSpouse($monthlyIncomeSpouse = null)
    {
        // validation for constraint: string
        if (!is_null($monthlyIncomeSpouse) && !is_string($monthlyIncomeSpouse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monthlyIncomeSpouse, true), gettype($monthlyIncomeSpouse)), __LINE__);
        }
        $this->MonthlyIncomeSpouse = $monthlyIncomeSpouse;
        return $this;
    }
    /**
     * Get OccupationApplicant value
     * @return string|null
     */
    public function getOccupationApplicant()
    {
        return $this->OccupationApplicant;
    }
    /**
     * Set OccupationApplicant value
     * @param string $occupationApplicant
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setOccupationApplicant($occupationApplicant = null)
    {
        // validation for constraint: string
        if (!is_null($occupationApplicant) && !is_string($occupationApplicant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($occupationApplicant, true), gettype($occupationApplicant)), __LINE__);
        }
        $this->OccupationApplicant = $occupationApplicant;
        return $this;
    }
    /**
     * Get OccupationSpouse value
     * @return string|null
     */
    public function getOccupationSpouse()
    {
        return $this->OccupationSpouse;
    }
    /**
     * Set OccupationSpouse value
     * @param string $occupationSpouse
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setOccupationSpouse($occupationSpouse = null)
    {
        // validation for constraint: string
        if (!is_null($occupationSpouse) && !is_string($occupationSpouse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($occupationSpouse, true), gettype($occupationSpouse)), __LINE__);
        }
        $this->OccupationSpouse = $occupationSpouse;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get MaritalStatus value
     * @return string|null
     */
    public function getMaritalStatus()
    {
        return $this->MaritalStatus;
    }
    /**
     * Set MaritalStatus value
     * @param string $maritalStatus
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setMaritalStatus($maritalStatus = null)
    {
        // validation for constraint: string
        if (!is_null($maritalStatus) && !is_string($maritalStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maritalStatus, true), gettype($maritalStatus)), __LINE__);
        }
        $this->MaritalStatus = $maritalStatus;
        return $this;
    }
    /**
     * Get MarriageDate value
     * @return string|null
     */
    public function getMarriageDate()
    {
        return $this->MarriageDate;
    }
    /**
     * Set MarriageDate value
     * @param string $marriageDate
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setMarriageDate($marriageDate = null)
    {
        // validation for constraint: string
        if (!is_null($marriageDate) && !is_string($marriageDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marriageDate, true), gettype($marriageDate)), __LINE__);
        }
        $this->MarriageDate = $marriageDate;
        return $this;
    }
    /**
     * Get AcceptedMembership value
     * @return string|null
     */
    public function getAcceptedMembership()
    {
        return $this->AcceptedMembership;
    }
    /**
     * Set AcceptedMembership value
     * @param string $acceptedMembership
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setAcceptedMembership($acceptedMembership = null)
    {
        // validation for constraint: string
        if (!is_null($acceptedMembership) && !is_string($acceptedMembership)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptedMembership, true), gettype($acceptedMembership)), __LINE__);
        }
        $this->AcceptedMembership = $acceptedMembership;
        return $this;
    }
    /**
     * Get BrokerHouseName value
     * @return string|null
     */
    public function getBrokerHouseName()
    {
        return $this->BrokerHouseName;
    }
    /**
     * Set BrokerHouseName value
     * @param string $brokerHouseName
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBrokerHouseName($brokerHouseName = null)
    {
        // validation for constraint: string
        if (!is_null($brokerHouseName) && !is_string($brokerHouseName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brokerHouseName, true), gettype($brokerHouseName)), __LINE__);
        }
        $this->BrokerHouseName = $brokerHouseName;
        return $this;
    }
    /**
     * Get BrokerHouseNumber value
     * @return string|null
     */
    public function getBrokerHouseNumber()
    {
        return $this->BrokerHouseNumber;
    }
    /**
     * Set BrokerHouseNumber value
     * @param string $brokerHouseNumber
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBrokerHouseNumber($brokerHouseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($brokerHouseNumber) && !is_string($brokerHouseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brokerHouseNumber, true), gettype($brokerHouseNumber)), __LINE__);
        }
        $this->BrokerHouseNumber = $brokerHouseNumber;
        return $this;
    }
    /**
     * Get BrokerName value
     * @return string|null
     */
    public function getBrokerName()
    {
        return $this->BrokerName;
    }
    /**
     * Set BrokerName value
     * @param string $brokerName
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBrokerName($brokerName = null)
    {
        // validation for constraint: string
        if (!is_null($brokerName) && !is_string($brokerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brokerName, true), gettype($brokerName)), __LINE__);
        }
        $this->BrokerName = $brokerName;
        return $this;
    }
    /**
     * Get BrokerCode value
     * @return string|null
     */
    public function getBrokerCode()
    {
        return $this->BrokerCode;
    }
    /**
     * Set BrokerCode value
     * @param string $brokerCode
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBrokerCode($brokerCode = null)
    {
        // validation for constraint: string
        if (!is_null($brokerCode) && !is_string($brokerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brokerCode, true), gettype($brokerCode)), __LINE__);
        }
        $this->BrokerCode = $brokerCode;
        return $this;
    }
    /**
     * Get BrokerCell value
     * @return string|null
     */
    public function getBrokerCell()
    {
        return $this->BrokerCell;
    }
    /**
     * Set BrokerCell value
     * @param string $brokerCell
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBrokerCell($brokerCell = null)
    {
        // validation for constraint: string
        if (!is_null($brokerCell) && !is_string($brokerCell)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brokerCell, true), gettype($brokerCell)), __LINE__);
        }
        $this->BrokerCell = $brokerCell;
        return $this;
    }
    /**
     * Get BrokerTelCode value
     * @return string|null
     */
    public function getBrokerTelCode()
    {
        return $this->BrokerTelCode;
    }
    /**
     * Set BrokerTelCode value
     * @param string $brokerTelCode
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBrokerTelCode($brokerTelCode = null)
    {
        // validation for constraint: string
        if (!is_null($brokerTelCode) && !is_string($brokerTelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brokerTelCode, true), gettype($brokerTelCode)), __LINE__);
        }
        $this->BrokerTelCode = $brokerTelCode;
        return $this;
    }
    /**
     * Get BrokerTelNumber value
     * @return string|null
     */
    public function getBrokerTelNumber()
    {
        return $this->BrokerTelNumber;
    }
    /**
     * Set BrokerTelNumber value
     * @param string $brokerTelNumber
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBrokerTelNumber($brokerTelNumber = null)
    {
        // validation for constraint: string
        if (!is_null($brokerTelNumber) && !is_string($brokerTelNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brokerTelNumber, true), gettype($brokerTelNumber)), __LINE__);
        }
        $this->BrokerTelNumber = $brokerTelNumber;
        return $this;
    }
    /**
     * Get BrokerEmailAddress value
     * @return string|null
     */
    public function getBrokerEmailAddress()
    {
        return $this->BrokerEmailAddress;
    }
    /**
     * Set BrokerEmailAddress value
     * @param string $brokerEmailAddress
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBrokerEmailAddress($brokerEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($brokerEmailAddress) && !is_string($brokerEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brokerEmailAddress, true), gettype($brokerEmailAddress)), __LINE__);
        }
        $this->BrokerEmailAddress = $brokerEmailAddress;
        return $this;
    }
    /**
     * Get GuardianCuratorIdNumber value
     * @return string|null
     */
    public function getGuardianCuratorIdNumber()
    {
        return $this->GuardianCuratorIdNumber;
    }
    /**
     * Set GuardianCuratorIdNumber value
     * @param string $guardianCuratorIdNumber
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setGuardianCuratorIdNumber($guardianCuratorIdNumber = null)
    {
        // validation for constraint: string
        if (!is_null($guardianCuratorIdNumber) && !is_string($guardianCuratorIdNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guardianCuratorIdNumber, true), gettype($guardianCuratorIdNumber)), __LINE__);
        }
        $this->GuardianCuratorIdNumber = $guardianCuratorIdNumber;
        return $this;
    }
    /**
     * Get GuardianCuratorPassport value
     * @return string|null
     */
    public function getGuardianCuratorPassport()
    {
        return $this->GuardianCuratorPassport;
    }
    /**
     * Set GuardianCuratorPassport value
     * @param string $guardianCuratorPassport
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setGuardianCuratorPassport($guardianCuratorPassport = null)
    {
        // validation for constraint: string
        if (!is_null($guardianCuratorPassport) && !is_string($guardianCuratorPassport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guardianCuratorPassport, true), gettype($guardianCuratorPassport)), __LINE__);
        }
        $this->GuardianCuratorPassport = $guardianCuratorPassport;
        return $this;
    }
    /**
     * Get GuardianCuratorTitle value
     * @return string|null
     */
    public function getGuardianCuratorTitle()
    {
        return $this->GuardianCuratorTitle;
    }
    /**
     * Set GuardianCuratorTitle value
     * @param string $guardianCuratorTitle
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setGuardianCuratorTitle($guardianCuratorTitle = null)
    {
        // validation for constraint: string
        if (!is_null($guardianCuratorTitle) && !is_string($guardianCuratorTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guardianCuratorTitle, true), gettype($guardianCuratorTitle)), __LINE__);
        }
        $this->GuardianCuratorTitle = $guardianCuratorTitle;
        return $this;
    }
    /**
     * Get GuardianCuratorInits value
     * @return string|null
     */
    public function getGuardianCuratorInits()
    {
        return $this->GuardianCuratorInits;
    }
    /**
     * Set GuardianCuratorInits value
     * @param string $guardianCuratorInits
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setGuardianCuratorInits($guardianCuratorInits = null)
    {
        // validation for constraint: string
        if (!is_null($guardianCuratorInits) && !is_string($guardianCuratorInits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guardianCuratorInits, true), gettype($guardianCuratorInits)), __LINE__);
        }
        $this->GuardianCuratorInits = $guardianCuratorInits;
        return $this;
    }
    /**
     * Get GuardianCuratorFullName value
     * @return string|null
     */
    public function getGuardianCuratorFullName()
    {
        return $this->GuardianCuratorFullName;
    }
    /**
     * Set GuardianCuratorFullName value
     * @param string $guardianCuratorFullName
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setGuardianCuratorFullName($guardianCuratorFullName = null)
    {
        // validation for constraint: string
        if (!is_null($guardianCuratorFullName) && !is_string($guardianCuratorFullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guardianCuratorFullName, true), gettype($guardianCuratorFullName)), __LINE__);
        }
        $this->GuardianCuratorFullName = $guardianCuratorFullName;
        return $this;
    }
    /**
     * Get GuardianCuratorSurname value
     * @return string|null
     */
    public function getGuardianCuratorSurname()
    {
        return $this->GuardianCuratorSurname;
    }
    /**
     * Set GuardianCuratorSurname value
     * @param string $guardianCuratorSurname
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setGuardianCuratorSurname($guardianCuratorSurname = null)
    {
        // validation for constraint: string
        if (!is_null($guardianCuratorSurname) && !is_string($guardianCuratorSurname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guardianCuratorSurname, true), gettype($guardianCuratorSurname)), __LINE__);
        }
        $this->GuardianCuratorSurname = $guardianCuratorSurname;
        return $this;
    }
    /**
     * Get GuardianCuratorCell value
     * @return string|null
     */
    public function getGuardianCuratorCell()
    {
        return $this->GuardianCuratorCell;
    }
    /**
     * Set GuardianCuratorCell value
     * @param string $guardianCuratorCell
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setGuardianCuratorCell($guardianCuratorCell = null)
    {
        // validation for constraint: string
        if (!is_null($guardianCuratorCell) && !is_string($guardianCuratorCell)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guardianCuratorCell, true), gettype($guardianCuratorCell)), __LINE__);
        }
        $this->GuardianCuratorCell = $guardianCuratorCell;
        return $this;
    }
    /**
     * Get GuardianCuratorTelCode value
     * @return string|null
     */
    public function getGuardianCuratorTelCode()
    {
        return $this->GuardianCuratorTelCode;
    }
    /**
     * Set GuardianCuratorTelCode value
     * @param string $guardianCuratorTelCode
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setGuardianCuratorTelCode($guardianCuratorTelCode = null)
    {
        // validation for constraint: string
        if (!is_null($guardianCuratorTelCode) && !is_string($guardianCuratorTelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guardianCuratorTelCode, true), gettype($guardianCuratorTelCode)), __LINE__);
        }
        $this->GuardianCuratorTelCode = $guardianCuratorTelCode;
        return $this;
    }
    /**
     * Get GuardianCuratorTelNumber value
     * @return string|null
     */
    public function getGuardianCuratorTelNumber()
    {
        return $this->GuardianCuratorTelNumber;
    }
    /**
     * Set GuardianCuratorTelNumber value
     * @param string $guardianCuratorTelNumber
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setGuardianCuratorTelNumber($guardianCuratorTelNumber = null)
    {
        // validation for constraint: string
        if (!is_null($guardianCuratorTelNumber) && !is_string($guardianCuratorTelNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guardianCuratorTelNumber, true), gettype($guardianCuratorTelNumber)), __LINE__);
        }
        $this->GuardianCuratorTelNumber = $guardianCuratorTelNumber;
        return $this;
    }
    /**
     * Get GuardianCuratorFaxCode value
     * @return string|null
     */
    public function getGuardianCuratorFaxCode()
    {
        return $this->GuardianCuratorFaxCode;
    }
    /**
     * Set GuardianCuratorFaxCode value
     * @param string $guardianCuratorFaxCode
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setGuardianCuratorFaxCode($guardianCuratorFaxCode = null)
    {
        // validation for constraint: string
        if (!is_null($guardianCuratorFaxCode) && !is_string($guardianCuratorFaxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guardianCuratorFaxCode, true), gettype($guardianCuratorFaxCode)), __LINE__);
        }
        $this->GuardianCuratorFaxCode = $guardianCuratorFaxCode;
        return $this;
    }
    /**
     * Get GuardianCuratorFaxNumber value
     * @return string|null
     */
    public function getGuardianCuratorFaxNumber()
    {
        return $this->GuardianCuratorFaxNumber;
    }
    /**
     * Set GuardianCuratorFaxNumber value
     * @param string $guardianCuratorFaxNumber
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setGuardianCuratorFaxNumber($guardianCuratorFaxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($guardianCuratorFaxNumber) && !is_string($guardianCuratorFaxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guardianCuratorFaxNumber, true), gettype($guardianCuratorFaxNumber)), __LINE__);
        }
        $this->GuardianCuratorFaxNumber = $guardianCuratorFaxNumber;
        return $this;
    }
    /**
     * Get GuardianCuratorEmailAddress value
     * @return string|null
     */
    public function getGuardianCuratorEmailAddress()
    {
        return $this->GuardianCuratorEmailAddress;
    }
    /**
     * Set GuardianCuratorEmailAddress value
     * @param string $guardianCuratorEmailAddress
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setGuardianCuratorEmailAddress($guardianCuratorEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($guardianCuratorEmailAddress) && !is_string($guardianCuratorEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guardianCuratorEmailAddress, true), gettype($guardianCuratorEmailAddress)), __LINE__);
        }
        $this->GuardianCuratorEmailAddress = $guardianCuratorEmailAddress;
        return $this;
    }
    /**
     * Get ThirdPartyTitle value
     * @return string|null
     */
    public function getThirdPartyTitle()
    {
        return $this->ThirdPartyTitle;
    }
    /**
     * Set ThirdPartyTitle value
     * @param string $thirdPartyTitle
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setThirdPartyTitle($thirdPartyTitle = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyTitle) && !is_string($thirdPartyTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyTitle, true), gettype($thirdPartyTitle)), __LINE__);
        }
        $this->ThirdPartyTitle = $thirdPartyTitle;
        return $this;
    }
    /**
     * Get ThirdPartyInits value
     * @return string|null
     */
    public function getThirdPartyInits()
    {
        return $this->ThirdPartyInits;
    }
    /**
     * Set ThirdPartyInits value
     * @param string $thirdPartyInits
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setThirdPartyInits($thirdPartyInits = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyInits) && !is_string($thirdPartyInits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyInits, true), gettype($thirdPartyInits)), __LINE__);
        }
        $this->ThirdPartyInits = $thirdPartyInits;
        return $this;
    }
    /**
     * Get ThirdPartySurname value
     * @return string|null
     */
    public function getThirdPartySurname()
    {
        return $this->ThirdPartySurname;
    }
    /**
     * Set ThirdPartySurname value
     * @param string $thirdPartySurname
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setThirdPartySurname($thirdPartySurname = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartySurname) && !is_string($thirdPartySurname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartySurname, true), gettype($thirdPartySurname)), __LINE__);
        }
        $this->ThirdPartySurname = $thirdPartySurname;
        return $this;
    }
    /**
     * Get ThirdPartyRelationship value
     * @return string|null
     */
    public function getThirdPartyRelationship()
    {
        return $this->ThirdPartyRelationship;
    }
    /**
     * Set ThirdPartyRelationship value
     * @param string $thirdPartyRelationship
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setThirdPartyRelationship($thirdPartyRelationship = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyRelationship) && !is_string($thirdPartyRelationship)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyRelationship, true), gettype($thirdPartyRelationship)), __LINE__);
        }
        $this->ThirdPartyRelationship = $thirdPartyRelationship;
        return $this;
    }
    /**
     * Get ThirdPartyId value
     * @return string|null
     */
    public function getThirdPartyId()
    {
        return $this->ThirdPartyId;
    }
    /**
     * Set ThirdPartyId value
     * @param string $thirdPartyId
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setThirdPartyId($thirdPartyId = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyId) && !is_string($thirdPartyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyId, true), gettype($thirdPartyId)), __LINE__);
        }
        $this->ThirdPartyId = $thirdPartyId;
        return $this;
    }
    /**
     * Get ThirdPartyPassport value
     * @return string|null
     */
    public function getThirdPartyPassport()
    {
        return $this->ThirdPartyPassport;
    }
    /**
     * Set ThirdPartyPassport value
     * @param string $thirdPartyPassport
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setThirdPartyPassport($thirdPartyPassport = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyPassport) && !is_string($thirdPartyPassport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyPassport, true), gettype($thirdPartyPassport)), __LINE__);
        }
        $this->ThirdPartyPassport = $thirdPartyPassport;
        return $this;
    }
    /**
     * Get ThirdPartyCountry value
     * @return string|null
     */
    public function getThirdPartyCountry()
    {
        return $this->ThirdPartyCountry;
    }
    /**
     * Set ThirdPartyCountry value
     * @param string $thirdPartyCountry
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setThirdPartyCountry($thirdPartyCountry = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyCountry) && !is_string($thirdPartyCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyCountry, true), gettype($thirdPartyCountry)), __LINE__);
        }
        $this->ThirdPartyCountry = $thirdPartyCountry;
        return $this;
    }
    /**
     * Get ThirdPartyDialCode value
     * @return string|null
     */
    public function getThirdPartyDialCode()
    {
        return $this->ThirdPartyDialCode;
    }
    /**
     * Set ThirdPartyDialCode value
     * @param string $thirdPartyDialCode
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setThirdPartyDialCode($thirdPartyDialCode = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyDialCode) && !is_string($thirdPartyDialCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyDialCode, true), gettype($thirdPartyDialCode)), __LINE__);
        }
        $this->ThirdPartyDialCode = $thirdPartyDialCode;
        return $this;
    }
    /**
     * Get ThirdPartyPhoneNr value
     * @return string|null
     */
    public function getThirdPartyPhoneNr()
    {
        return $this->ThirdPartyPhoneNr;
    }
    /**
     * Set ThirdPartyPhoneNr value
     * @param string $thirdPartyPhoneNr
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setThirdPartyPhoneNr($thirdPartyPhoneNr = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyPhoneNr) && !is_string($thirdPartyPhoneNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyPhoneNr, true), gettype($thirdPartyPhoneNr)), __LINE__);
        }
        $this->ThirdPartyPhoneNr = $thirdPartyPhoneNr;
        return $this;
    }
    /**
     * Get ThirdPartyCellCode value
     * @return string|null
     */
    public function getThirdPartyCellCode()
    {
        return $this->ThirdPartyCellCode;
    }
    /**
     * Set ThirdPartyCellCode value
     * @param string $thirdPartyCellCode
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setThirdPartyCellCode($thirdPartyCellCode = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyCellCode) && !is_string($thirdPartyCellCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyCellCode, true), gettype($thirdPartyCellCode)), __LINE__);
        }
        $this->ThirdPartyCellCode = $thirdPartyCellCode;
        return $this;
    }
    /**
     * Get ThirdPartyCellNr value
     * @return string|null
     */
    public function getThirdPartyCellNr()
    {
        return $this->ThirdPartyCellNr;
    }
    /**
     * Set ThirdPartyCellNr value
     * @param string $thirdPartyCellNr
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setThirdPartyCellNr($thirdPartyCellNr = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyCellNr) && !is_string($thirdPartyCellNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyCellNr, true), gettype($thirdPartyCellNr)), __LINE__);
        }
        $this->ThirdPartyCellNr = $thirdPartyCellNr;
        return $this;
    }
    /**
     * Get ThirdPartyEmail value
     * @return string|null
     */
    public function getThirdPartyEmail()
    {
        return $this->ThirdPartyEmail;
    }
    /**
     * Set ThirdPartyEmail value
     * @param string $thirdPartyEmail
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setThirdPartyEmail($thirdPartyEmail = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyEmail) && !is_string($thirdPartyEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyEmail, true), gettype($thirdPartyEmail)), __LINE__);
        }
        $this->ThirdPartyEmail = $thirdPartyEmail;
        return $this;
    }
    /**
     * Get ThirdPartyAuthOption value
     * @return string|null
     */
    public function getThirdPartyAuthOption()
    {
        return $this->ThirdPartyAuthOption;
    }
    /**
     * Set ThirdPartyAuthOption value
     * @param string $thirdPartyAuthOption
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setThirdPartyAuthOption($thirdPartyAuthOption = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyAuthOption) && !is_string($thirdPartyAuthOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyAuthOption, true), gettype($thirdPartyAuthOption)), __LINE__);
        }
        $this->ThirdPartyAuthOption = $thirdPartyAuthOption;
        return $this;
    }
    /**
     * Get ThirdPartyDocRecvdDate value
     * @return string|null
     */
    public function getThirdPartyDocRecvdDate()
    {
        return $this->ThirdPartyDocRecvdDate;
    }
    /**
     * Set ThirdPartyDocRecvdDate value
     * @param string $thirdPartyDocRecvdDate
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setThirdPartyDocRecvdDate($thirdPartyDocRecvdDate = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyDocRecvdDate) && !is_string($thirdPartyDocRecvdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyDocRecvdDate, true), gettype($thirdPartyDocRecvdDate)), __LINE__);
        }
        $this->ThirdPartyDocRecvdDate = $thirdPartyDocRecvdDate;
        return $this;
    }
    /**
     * Get ThirdPartyAuthType value
     * @return string|null
     */
    public function getThirdPartyAuthType()
    {
        return $this->ThirdPartyAuthType;
    }
    /**
     * Set ThirdPartyAuthType value
     * @param string $thirdPartyAuthType
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setThirdPartyAuthType($thirdPartyAuthType = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyAuthType) && !is_string($thirdPartyAuthType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyAuthType, true), gettype($thirdPartyAuthType)), __LINE__);
        }
        $this->ThirdPartyAuthType = $thirdPartyAuthType;
        return $this;
    }
    /**
     * Get ThirdPartyAuthSignature value
     * @return string|null
     */
    public function getThirdPartyAuthSignature()
    {
        return $this->ThirdPartyAuthSignature;
    }
    /**
     * Set ThirdPartyAuthSignature value
     * @param string $thirdPartyAuthSignature
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setThirdPartyAuthSignature($thirdPartyAuthSignature = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyAuthSignature) && !is_string($thirdPartyAuthSignature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyAuthSignature, true), gettype($thirdPartyAuthSignature)), __LINE__);
        }
        $this->ThirdPartyAuthSignature = $thirdPartyAuthSignature;
        return $this;
    }
    /**
     * Get ThirdPartyAuthProofId value
     * @return string|null
     */
    public function getThirdPartyAuthProofId()
    {
        return $this->ThirdPartyAuthProofId;
    }
    /**
     * Set ThirdPartyAuthProofId value
     * @param string $thirdPartyAuthProofId
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setThirdPartyAuthProofId($thirdPartyAuthProofId = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyAuthProofId) && !is_string($thirdPartyAuthProofId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyAuthProofId, true), gettype($thirdPartyAuthProofId)), __LINE__);
        }
        $this->ThirdPartyAuthProofId = $thirdPartyAuthProofId;
        return $this;
    }
    /**
     * Get ThirdPartyPoaSignature value
     * @return string|null
     */
    public function getThirdPartyPoaSignature()
    {
        return $this->ThirdPartyPoaSignature;
    }
    /**
     * Set ThirdPartyPoaSignature value
     * @param string $thirdPartyPoaSignature
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setThirdPartyPoaSignature($thirdPartyPoaSignature = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyPoaSignature) && !is_string($thirdPartyPoaSignature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyPoaSignature, true), gettype($thirdPartyPoaSignature)), __LINE__);
        }
        $this->ThirdPartyPoaSignature = $thirdPartyPoaSignature;
        return $this;
    }
    /**
     * Get ThirdPartyPoaProofId value
     * @return string|null
     */
    public function getThirdPartyPoaProofId()
    {
        return $this->ThirdPartyPoaProofId;
    }
    /**
     * Set ThirdPartyPoaProofId value
     * @param string $thirdPartyPoaProofId
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setThirdPartyPoaProofId($thirdPartyPoaProofId = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyPoaProofId) && !is_string($thirdPartyPoaProofId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdPartyPoaProofId, true), gettype($thirdPartyPoaProofId)), __LINE__);
        }
        $this->ThirdPartyPoaProofId = $thirdPartyPoaProofId;
        return $this;
    }
    /**
     * Get LeadNumber value
     * @return string|null
     */
    public function getLeadNumber()
    {
        return $this->LeadNumber;
    }
    /**
     * Set LeadNumber value
     * @param string $leadNumber
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setLeadNumber($leadNumber = null)
    {
        // validation for constraint: string
        if (!is_null($leadNumber) && !is_string($leadNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leadNumber, true), gettype($leadNumber)), __LINE__);
        }
        $this->LeadNumber = $leadNumber;
        return $this;
    }
    /**
     * Get DeductionDateInd value
     * @return string|null
     */
    public function getDeductionDateInd()
    {
        return $this->DeductionDateInd;
    }
    /**
     * Set DeductionDateInd value
     * @param string $deductionDateInd
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setDeductionDateInd($deductionDateInd = null)
    {
        // validation for constraint: string
        if (!is_null($deductionDateInd) && !is_string($deductionDateInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deductionDateInd, true), gettype($deductionDateInd)), __LINE__);
        }
        $this->DeductionDateInd = $deductionDateInd;
        return $this;
    }
    /**
     * Get VisuallyImpaired value
     * @return bool|null
     */
    public function getVisuallyImpaired()
    {
        return $this->VisuallyImpaired;
    }
    /**
     * Set VisuallyImpaired value
     * @param bool $visuallyImpaired
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setVisuallyImpaired($visuallyImpaired = null)
    {
        // validation for constraint: boolean
        if (!is_null($visuallyImpaired) && !is_bool($visuallyImpaired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visuallyImpaired, true), gettype($visuallyImpaired)), __LINE__);
        }
        $this->VisuallyImpaired = $visuallyImpaired;
        return $this;
    }
    /**
     * Get HearingImpaired value
     * @return bool|null
     */
    public function getHearingImpaired()
    {
        return $this->HearingImpaired;
    }
    /**
     * Set HearingImpaired value
     * @param bool $hearingImpaired
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setHearingImpaired($hearingImpaired = null)
    {
        // validation for constraint: boolean
        if (!is_null($hearingImpaired) && !is_bool($hearingImpaired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hearingImpaired, true), gettype($hearingImpaired)), __LINE__);
        }
        $this->HearingImpaired = $hearingImpaired;
        return $this;
    }
    /**
     * Get PersonalInfo value
     * @return bool|null
     */
    public function getPersonalInfo()
    {
        return $this->PersonalInfo;
    }
    /**
     * Set PersonalInfo value
     * @param bool $personalInfo
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setPersonalInfo($personalInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($personalInfo) && !is_bool($personalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($personalInfo, true), gettype($personalInfo)), __LINE__);
        }
        $this->PersonalInfo = $personalInfo;
        return $this;
    }
    /**
     * Get ApplicationType value
     * @return string|null
     */
    public function getApplicationType()
    {
        return $this->ApplicationType;
    }
    /**
     * Set ApplicationType value
     * @param string $applicationType
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setApplicationType($applicationType = null)
    {
        // validation for constraint: string
        if (!is_null($applicationType) && !is_string($applicationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationType, true), gettype($applicationType)), __LINE__);
        }
        $this->ApplicationType = $applicationType;
        return $this;
    }
    /**
     * Get ApplicClass value
     * @return string|null
     */
    public function getApplicClass()
    {
        return $this->ApplicClass;
    }
    /**
     * Set ApplicClass value
     * @param string $applicClass
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setApplicClass($applicClass = null)
    {
        // validation for constraint: string
        if (!is_null($applicClass) && !is_string($applicClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicClass, true), gettype($applicClass)), __LINE__);
        }
        $this->ApplicClass = $applicClass;
        return $this;
    }
    /**
     * Get ReceiptType value
     * @return string|null
     */
    public function getReceiptType()
    {
        return $this->ReceiptType;
    }
    /**
     * Set ReceiptType value
     * @param string $receiptType
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setReceiptType($receiptType = null)
    {
        // validation for constraint: string
        if (!is_null($receiptType) && !is_string($receiptType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptType, true), gettype($receiptType)), __LINE__);
        }
        $this->ReceiptType = $receiptType;
        return $this;
    }
    /**
     * Get ApplicationVersion value
     * @return string|null
     */
    public function getApplicationVersion()
    {
        return $this->ApplicationVersion;
    }
    /**
     * Set ApplicationVersion value
     * @param string $applicationVersion
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setApplicationVersion($applicationVersion = null)
    {
        // validation for constraint: string
        if (!is_null($applicationVersion) && !is_string($applicationVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationVersion, true), gettype($applicationVersion)), __LINE__);
        }
        $this->ApplicationVersion = $applicationVersion;
        return $this;
    }
    /**
     * Get BankAccSignature value
     * @return string|null
     */
    public function getBankAccSignature()
    {
        return $this->BankAccSignature;
    }
    /**
     * Set BankAccSignature value
     * @param string $bankAccSignature
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setBankAccSignature($bankAccSignature = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccSignature) && !is_string($bankAccSignature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAccSignature, true), gettype($bankAccSignature)), __LINE__);
        }
        $this->BankAccSignature = $bankAccSignature;
        return $this;
    }
    /**
     * Get PreviousSchmMainMember value
     * @return string|null
     */
    public function getPreviousSchmMainMember()
    {
        return $this->PreviousSchmMainMember;
    }
    /**
     * Set PreviousSchmMainMember value
     * @param string $previousSchmMainMember
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setPreviousSchmMainMember($previousSchmMainMember = null)
    {
        // validation for constraint: string
        if (!is_null($previousSchmMainMember) && !is_string($previousSchmMainMember)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($previousSchmMainMember, true), gettype($previousSchmMainMember)), __LINE__);
        }
        $this->PreviousSchmMainMember = $previousSchmMainMember;
        return $this;
    }
    /**
     * Get PreviousSchmCancellation value
     * @return string|null
     */
    public function getPreviousSchmCancellation()
    {
        return $this->PreviousSchmCancellation;
    }
    /**
     * Set PreviousSchmCancellation value
     * @param string $previousSchmCancellation
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setPreviousSchmCancellation($previousSchmCancellation = null)
    {
        // validation for constraint: string
        if (!is_null($previousSchmCancellation) && !is_string($previousSchmCancellation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($previousSchmCancellation, true), gettype($previousSchmCancellation)), __LINE__);
        }
        $this->PreviousSchmCancellation = $previousSchmCancellation;
        return $this;
    }
    /**
     * Get AdviserSignature value
     * @return string|null
     */
    public function getAdviserSignature()
    {
        return $this->AdviserSignature;
    }
    /**
     * Set AdviserSignature value
     * @param string $adviserSignature
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setAdviserSignature($adviserSignature = null)
    {
        // validation for constraint: string
        if (!is_null($adviserSignature) && !is_string($adviserSignature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adviserSignature, true), gettype($adviserSignature)), __LINE__);
        }
        $this->AdviserSignature = $adviserSignature;
        return $this;
    }
    /**
     * Get ApplicantSignature value
     * @return string|null
     */
    public function getApplicantSignature()
    {
        return $this->ApplicantSignature;
    }
    /**
     * Set ApplicantSignature value
     * @param string $applicantSignature
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setApplicantSignature($applicantSignature = null)
    {
        // validation for constraint: string
        if (!is_null($applicantSignature) && !is_string($applicantSignature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicantSignature, true), gettype($applicantSignature)), __LINE__);
        }
        $this->ApplicantSignature = $applicantSignature;
        return $this;
    }
    /**
     * Get GuardianCountry value
     * @return string|null
     */
    public function getGuardianCountry()
    {
        return $this->GuardianCountry;
    }
    /**
     * Set GuardianCountry value
     * @param string $guardianCountry
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setGuardianCountry($guardianCountry = null)
    {
        // validation for constraint: string
        if (!is_null($guardianCountry) && !is_string($guardianCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guardianCountry, true), gettype($guardianCountry)), __LINE__);
        }
        $this->GuardianCountry = $guardianCountry;
        return $this;
    }
    /**
     * Get MbrRace value
     * @return string|null
     */
    public function getMbrRace()
    {
        return $this->MbrRace;
    }
    /**
     * Set MbrRace value
     * @param string $mbrRace
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setMbrRace($mbrRace = null)
    {
        // validation for constraint: string
        if (!is_null($mbrRace) && !is_string($mbrRace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mbrRace, true), gettype($mbrRace)), __LINE__);
        }
        $this->MbrRace = $mbrRace;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get Userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->Userid;
    }
    /**
     * Set Userid value
     * @param string $userid
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userid, true), gettype($userid)), __LINE__);
        }
        $this->Userid = $userid;
        return $this;
    }
    /**
     * Get MbrPrevMedicalSchemes value
     * @return \ArrayType\ArrayOfMbrPrevMedicalScheme|null
     */
    public function getMbrPrevMedicalSchemes()
    {
        return $this->MbrPrevMedicalSchemes;
    }
    /**
     * Set MbrPrevMedicalSchemes value
     * @param \ArrayType\ArrayOfMbrPrevMedicalScheme $mbrPrevMedicalSchemes
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setMbrPrevMedicalSchemes(\ArrayType\ArrayOfMbrPrevMedicalScheme $mbrPrevMedicalSchemes = null)
    {
        $this->MbrPrevMedicalSchemes = $mbrPrevMedicalSchemes;
        return $this;
    }
    /**
     * Get Dependants value
     * @return \ArrayType\ArrayOfDependant|null
     */
    public function getDependants()
    {
        return $this->Dependants;
    }
    /**
     * Set Dependants value
     * @param \ArrayType\ArrayOfDependant $dependants
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setDependants(\ArrayType\ArrayOfDependant $dependants = null)
    {
        $this->Dependants = $dependants;
        return $this;
    }
    /**
     * Get LateJoinerPenaltys value
     * @return \ArrayType\ArrayOfLateJoinerPenalty|null
     */
    public function getLateJoinerPenaltys()
    {
        return $this->LateJoinerPenaltys;
    }
    /**
     * Set LateJoinerPenaltys value
     * @param \ArrayType\ArrayOfLateJoinerPenalty $lateJoinerPenaltys
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setLateJoinerPenaltys(\ArrayType\ArrayOfLateJoinerPenalty $lateJoinerPenaltys = null)
    {
        $this->LateJoinerPenaltys = $lateJoinerPenaltys;
        return $this;
    }
    /**
     * Get WaitingPeriods value
     * @return \ArrayType\ArrayOfWaitingPeriod|null
     */
    public function getWaitingPeriods()
    {
        return $this->WaitingPeriods;
    }
    /**
     * Set WaitingPeriods value
     * @param \ArrayType\ArrayOfWaitingPeriod $waitingPeriods
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setWaitingPeriods(\ArrayType\ArrayOfWaitingPeriod $waitingPeriods = null)
    {
        $this->WaitingPeriods = $waitingPeriods;
        return $this;
    }
    /**
     * Get MedicalQuestionaires value
     * @return \ArrayType\ArrayOfMedicalQuestionaire|null
     */
    public function getMedicalQuestionaires()
    {
        return $this->MedicalQuestionaires;
    }
    /**
     * Set MedicalQuestionaires value
     * @param \ArrayType\ArrayOfMedicalQuestionaire $medicalQuestionaires
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setMedicalQuestionaires(\ArrayType\ArrayOfMedicalQuestionaire $medicalQuestionaires = null)
    {
        $this->MedicalQuestionaires = $medicalQuestionaires;
        return $this;
    }
    /**
     * Get MedicalHistoryQuestionaires value
     * @return \ArrayType\ArrayOfMedicalHistoryQuestionaire|null
     */
    public function getMedicalHistoryQuestionaires()
    {
        return $this->MedicalHistoryQuestionaires;
    }
    /**
     * Set MedicalHistoryQuestionaires value
     * @param \ArrayType\ArrayOfMedicalHistoryQuestionaire $medicalHistoryQuestionaires
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setMedicalHistoryQuestionaires(\ArrayType\ArrayOfMedicalHistoryQuestionaire $medicalHistoryQuestionaires = null)
    {
        $this->MedicalHistoryQuestionaires = $medicalHistoryQuestionaires;
        return $this;
    }
    /**
     * Get HealthCareProviders value
     * @return \ArrayType\ArrayOfHealthCareProvider|null
     */
    public function getHealthCareProviders()
    {
        return $this->HealthCareProviders;
    }
    /**
     * Set HealthCareProviders value
     * @param \ArrayType\ArrayOfHealthCareProvider $healthCareProviders
     * @return \StructType\CorporateMemberEAppInput
     */
    public function setHealthCareProviders(\ArrayType\ArrayOfHealthCareProvider $healthCareProviders = null)
    {
        $this->HealthCareProviders = $healthCareProviders;
        return $this;
    }
}
