<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Descarga ServiceType
 * @subpackage Services
 */
class Descarga extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DescargaXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DescargaXML $parameters
     * @return \StructType\DescargaXMLResponse|bool
     */
    public function DescargaXML(\StructType\DescargaXML $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DescargaXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DescargaPDF
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DescargaPDF $parameters
     * @return \StructType\DescargaPDFResponse|bool
     */
    public function DescargaPDF(\StructType\DescargaPDF $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DescargaPDF($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DescargaAppResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DescargaAppResponse $parameters
     * @return \StructType\DescargaAppResponseResponse|bool
     */
    public function DescargaAppResponse(\StructType\DescargaAppResponse $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DescargaAppResponse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DescargaAppResponseResponse|\StructType\DescargaPDFResponse|\StructType\DescargaXMLResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
