<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSindicato ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfSindicato
 * @subpackage Arrays
 */
class ArrayOfSindicato extends AbstractStructArrayBase
{
    /**
     * The Sindicato
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Sindicato[]
     */
    public $Sindicato;
    /**
     * Constructor method for ArrayOfSindicato
     * @uses ArrayOfSindicato::setSindicato()
     * @param \StructType\Sindicato[] $sindicato
     */
    public function __construct(array $sindicato = array())
    {
        $this
            ->setSindicato($sindicato);
    }
    /**
     * Get Sindicato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Sindicato[]|null
     */
    public function getSindicato()
    {
        return isset($this->Sindicato) ? $this->Sindicato : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSindicato method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSindicato method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSindicatoForArrayConstraintsFromSetSindicato(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSindicatoSindicatoItem) {
            // validation for constraint: itemType
            if (!$arrayOfSindicatoSindicatoItem instanceof \StructType\Sindicato) {
                $invalidValues[] = is_object($arrayOfSindicatoSindicatoItem) ? get_class($arrayOfSindicatoSindicatoItem) : sprintf('%s(%s)', gettype($arrayOfSindicatoSindicatoItem), var_export($arrayOfSindicatoSindicatoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Sindicato property can only contain items of type \StructType\Sindicato, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Sindicato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Sindicato[] $sindicato
     * @return \ArrayType\ArrayOfSindicato
     */
    public function setSindicato(array $sindicato = array())
    {
        // validation for constraint: array
        if ('' !== ($sindicatoArrayErrorMessage = self::validateSindicatoForArrayConstraintsFromSetSindicato($sindicato))) {
            throw new \InvalidArgumentException($sindicatoArrayErrorMessage, __LINE__);
        }
        if (is_null($sindicato) || (is_array($sindicato) && empty($sindicato))) {
            unset($this->Sindicato);
        } else {
            $this->Sindicato = $sindicato;
        }
        return $this;
    }
    /**
     * Add item to Sindicato value
     * @throws \InvalidArgumentException
     * @param \StructType\Sindicato $item
     * @return \ArrayType\ArrayOfSindicato
     */
    public function addToSindicato(\StructType\Sindicato $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Sindicato) {
            throw new \InvalidArgumentException(sprintf('The Sindicato property can only contain items of type \StructType\Sindicato, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Sindicato[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Sindicato|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Sindicato|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Sindicato|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Sindicato|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Sindicato|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Sindicato
     */
    public function getAttributeName()
    {
        return 'Sindicato';
    }
}
