<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLibranza ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfLibranza
 * @subpackage Arrays
 */
class ArrayOfLibranza extends AbstractStructArrayBase
{
    /**
     * The Libranza
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Libranza[]
     */
    public $Libranza;
    /**
     * Constructor method for ArrayOfLibranza
     * @uses ArrayOfLibranza::setLibranza()
     * @param \StructType\Libranza[] $libranza
     */
    public function __construct(array $libranza = array())
    {
        $this
            ->setLibranza($libranza);
    }
    /**
     * Get Libranza value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Libranza[]|null
     */
    public function getLibranza()
    {
        return isset($this->Libranza) ? $this->Libranza : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLibranza method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLibranza method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLibranzaForArrayConstraintsFromSetLibranza(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfLibranzaLibranzaItem) {
            // validation for constraint: itemType
            if (!$arrayOfLibranzaLibranzaItem instanceof \StructType\Libranza) {
                $invalidValues[] = is_object($arrayOfLibranzaLibranzaItem) ? get_class($arrayOfLibranzaLibranzaItem) : sprintf('%s(%s)', gettype($arrayOfLibranzaLibranzaItem), var_export($arrayOfLibranzaLibranzaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Libranza property can only contain items of type \StructType\Libranza, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Libranza value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Libranza[] $libranza
     * @return \ArrayType\ArrayOfLibranza
     */
    public function setLibranza(array $libranza = array())
    {
        // validation for constraint: array
        if ('' !== ($libranzaArrayErrorMessage = self::validateLibranzaForArrayConstraintsFromSetLibranza($libranza))) {
            throw new \InvalidArgumentException($libranzaArrayErrorMessage, __LINE__);
        }
        if (is_null($libranza) || (is_array($libranza) && empty($libranza))) {
            unset($this->Libranza);
        } else {
            $this->Libranza = $libranza;
        }
        return $this;
    }
    /**
     * Add item to Libranza value
     * @throws \InvalidArgumentException
     * @param \StructType\Libranza $item
     * @return \ArrayType\ArrayOfLibranza
     */
    public function addToLibranza(\StructType\Libranza $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Libranza) {
            throw new \InvalidArgumentException(sprintf('The Libranza property can only contain items of type \StructType\Libranza, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Libranza[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Libranza|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Libranza|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Libranza|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Libranza|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Libranza|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Libranza
     */
    public function getAttributeName()
    {
        return 'Libranza';
    }
}
