<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBasico ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfBasico
 * @subpackage Arrays
 */
class ArrayOfBasico extends AbstractStructArrayBase
{
    /**
     * The Basico
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Basico[]
     */
    public $Basico;
    /**
     * Constructor method for ArrayOfBasico
     * @uses ArrayOfBasico::setBasico()
     * @param \StructType\Basico[] $basico
     */
    public function __construct(array $basico = array())
    {
        $this
            ->setBasico($basico);
    }
    /**
     * Get Basico value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Basico[]|null
     */
    public function getBasico()
    {
        return isset($this->Basico) ? $this->Basico : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBasico method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBasico method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBasicoForArrayConstraintsFromSetBasico(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBasicoBasicoItem) {
            // validation for constraint: itemType
            if (!$arrayOfBasicoBasicoItem instanceof \StructType\Basico) {
                $invalidValues[] = is_object($arrayOfBasicoBasicoItem) ? get_class($arrayOfBasicoBasicoItem) : sprintf('%s(%s)', gettype($arrayOfBasicoBasicoItem), var_export($arrayOfBasicoBasicoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Basico property can only contain items of type \StructType\Basico, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Basico value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Basico[] $basico
     * @return \ArrayType\ArrayOfBasico
     */
    public function setBasico(array $basico = array())
    {
        // validation for constraint: array
        if ('' !== ($basicoArrayErrorMessage = self::validateBasicoForArrayConstraintsFromSetBasico($basico))) {
            throw new \InvalidArgumentException($basicoArrayErrorMessage, __LINE__);
        }
        if (is_null($basico) || (is_array($basico) && empty($basico))) {
            unset($this->Basico);
        } else {
            $this->Basico = $basico;
        }
        return $this;
    }
    /**
     * Add item to Basico value
     * @throws \InvalidArgumentException
     * @param \StructType\Basico $item
     * @return \ArrayType\ArrayOfBasico
     */
    public function addToBasico(\StructType\Basico $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Basico) {
            throw new \InvalidArgumentException(sprintf('The Basico property can only contain items of type \StructType\Basico, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Basico[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Basico|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Basico|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Basico|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Basico|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Basico|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Basico
     */
    public function getAttributeName()
    {
        return 'Basico';
    }
}
