<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://demo-nomina-soap.thefactoryhka.com.co/Service.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://demo-nomina-soap.thefactoryhka.com.co/Service.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Enviar ServiceType
 */
$enviar = new \ServiceType\Enviar($options);
/**
 * Sample call for Enviar operation/method
 */
if ($enviar->Enviar(new \StructType\Enviar()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Samples for Folios ServiceType
 */
$folios = new \ServiceType\Folios($options);
/**
 * Sample call for FoliosRestantes operation/method
 */
if ($folios->FoliosRestantes(new \StructType\FoliosRestantes()) !== false) {
    print_r($folios->getResult());
} else {
    print_r($folios->getLastError());
}
/**
 * Samples for Estado ServiceType
 */
$estado = new \ServiceType\Estado($options);
/**
 * Sample call for EstadoDocumento operation/method
 */
if ($estado->EstadoDocumento(new \StructType\EstadoDocumento()) !== false) {
    print_r($estado->getResult());
} else {
    print_r($estado->getLastError());
}
/**
 * Samples for Descarga ServiceType
 */
$descarga = new \ServiceType\Descarga($options);
/**
 * Sample call for DescargaXML operation/method
 */
if ($descarga->DescargaXML(new \StructType\DescargaXML()) !== false) {
    print_r($descarga->getResult());
} else {
    print_r($descarga->getLastError());
}
/**
 * Sample call for DescargaPDF operation/method
 */
if ($descarga->DescargaPDF(new \StructType\DescargaPDF()) !== false) {
    print_r($descarga->getResult());
} else {
    print_r($descarga->getLastError());
}
/**
 * Sample call for DescargaAppResponse operation/method
 */
if ($descarga->DescargaAppResponse(new \StructType\DescargaAppResponse()) !== false) {
    print_r($descarga->getResult());
} else {
    print_r($descarga->getLastError());
}
/**
 * Samples for Envio ServiceType
 */
$envio = new \ServiceType\Envio($options);
/**
 * Sample call for EnvioCorreo operation/method
 */
if ($envio->EnvioCorreo(new \StructType\EnvioCorreo()) !== false) {
    print_r($envio->getResult());
} else {
    print_r($envio->getLastError());
}
