<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Envio ServiceType
 * @subpackage Services
 */
class Envio extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EnvioCorreo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnvioCorreo $parameters
     * @return \StructType\EnvioCorreoResponse|bool
     */
    public function EnvioCorreo(\StructType\EnvioCorreo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnvioCorreo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EnvioCorreoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
