<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSalud ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfSalud
 * @subpackage Arrays
 */
class ArrayOfSalud extends AbstractStructArrayBase
{
    /**
     * The Salud
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Salud[]
     */
    public $Salud;
    /**
     * Constructor method for ArrayOfSalud
     * @uses ArrayOfSalud::setSalud()
     * @param \StructType\Salud[] $salud
     */
    public function __construct(array $salud = array())
    {
        $this
            ->setSalud($salud);
    }
    /**
     * Get Salud value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Salud[]|null
     */
    public function getSalud()
    {
        return isset($this->Salud) ? $this->Salud : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSalud method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalud method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSaludForArrayConstraintsFromSetSalud(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSaludSaludItem) {
            // validation for constraint: itemType
            if (!$arrayOfSaludSaludItem instanceof \StructType\Salud) {
                $invalidValues[] = is_object($arrayOfSaludSaludItem) ? get_class($arrayOfSaludSaludItem) : sprintf('%s(%s)', gettype($arrayOfSaludSaludItem), var_export($arrayOfSaludSaludItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Salud property can only contain items of type \StructType\Salud, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Salud value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Salud[] $salud
     * @return \ArrayType\ArrayOfSalud
     */
    public function setSalud(array $salud = array())
    {
        // validation for constraint: array
        if ('' !== ($saludArrayErrorMessage = self::validateSaludForArrayConstraintsFromSetSalud($salud))) {
            throw new \InvalidArgumentException($saludArrayErrorMessage, __LINE__);
        }
        if (is_null($salud) || (is_array($salud) && empty($salud))) {
            unset($this->Salud);
        } else {
            $this->Salud = $salud;
        }
        return $this;
    }
    /**
     * Add item to Salud value
     * @throws \InvalidArgumentException
     * @param \StructType\Salud $item
     * @return \ArrayType\ArrayOfSalud
     */
    public function addToSalud(\StructType\Salud $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Salud) {
            throw new \InvalidArgumentException(sprintf('The Salud property can only contain items of type \StructType\Salud, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Salud[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Salud|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Salud|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Salud|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Salud|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Salud|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Salud
     */
    public function getAttributeName()
    {
        return 'Salud';
    }
}
