<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPago ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPago
 * @subpackage Arrays
 */
class ArrayOfPago extends AbstractStructArrayBase
{
    /**
     * The Pago
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Pago[]
     */
    public $Pago;
    /**
     * Constructor method for ArrayOfPago
     * @uses ArrayOfPago::setPago()
     * @param \StructType\Pago[] $pago
     */
    public function __construct(array $pago = array())
    {
        $this
            ->setPago($pago);
    }
    /**
     * Get Pago value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Pago[]|null
     */
    public function getPago()
    {
        return isset($this->Pago) ? $this->Pago : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPago method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPago method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePagoForArrayConstraintsFromSetPago(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPagoPagoItem) {
            // validation for constraint: itemType
            if (!$arrayOfPagoPagoItem instanceof \StructType\Pago) {
                $invalidValues[] = is_object($arrayOfPagoPagoItem) ? get_class($arrayOfPagoPagoItem) : sprintf('%s(%s)', gettype($arrayOfPagoPagoItem), var_export($arrayOfPagoPagoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Pago property can only contain items of type \StructType\Pago, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Pago value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Pago[] $pago
     * @return \ArrayType\ArrayOfPago
     */
    public function setPago(array $pago = array())
    {
        // validation for constraint: array
        if ('' !== ($pagoArrayErrorMessage = self::validatePagoForArrayConstraintsFromSetPago($pago))) {
            throw new \InvalidArgumentException($pagoArrayErrorMessage, __LINE__);
        }
        if (is_null($pago) || (is_array($pago) && empty($pago))) {
            unset($this->Pago);
        } else {
            $this->Pago = $pago;
        }
        return $this;
    }
    /**
     * Add item to Pago value
     * @throws \InvalidArgumentException
     * @param \StructType\Pago $item
     * @return \ArrayType\ArrayOfPago
     */
    public function addToPago(\StructType\Pago $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Pago) {
            throw new \InvalidArgumentException(sprintf('The Pago property can only contain items of type \StructType\Pago, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Pago[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Pago|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Pago|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Pago|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Pago|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Pago|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Pago
     */
    public function getAttributeName()
    {
        return 'Pago';
    }
}
